/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.mixin.camera;

import com.llamalad7.mixinextras.sugar.Local;
import net.geforcemods.securitycraft.entity.camera.SecurityCamera;
import net.minecraft.server.level.ChunkMap;
import net.minecraft.server.level.ChunkTrackingView;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.chunk.LevelChunk;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={ChunkMap.class}, priority=1100)
public abstract class ChunkMapMixin {
    @Shadow
    protected abstract void markChunkPendingToSend(ServerPlayer var1, ChunkPos var2);

    @Shadow
    private static void markChunkPendingToSend(ServerPlayer player, LevelChunk chunk) {
    }

    @Inject(method={"updateChunkTracking"}, at={@At(value="HEAD")})
    private void securitycraft$onUpdateChunkTracking(ServerPlayer player, CallbackInfo callback) {
        Entity entity = player.getCamera();
        if (entity instanceof SecurityCamera) {
            SecurityCamera camera = (SecurityCamera)entity;
            if (!camera.hasSentChunks()) {
                ChunkTrackingView.difference((ChunkTrackingView)player.getChunkTrackingView(), (ChunkTrackingView)camera.getCameraChunks(), chunkPos -> this.markChunkPendingToSend(player, (ChunkPos)chunkPos), chunkPos -> {});
                camera.setHasSentChunks(true);
            }
        } else if (SecurityCamera.hasRecentlyDismounted((Player)player)) {
            player.getChunkTrackingView().forEach(chunkPos -> this.markChunkPendingToSend(player, (ChunkPos)chunkPos));
        }
    }

    @Inject(method={"onChunkReadyToSend"}, at={@At(value="INVOKE", target="Lnet/minecraft/server/level/ServerPlayer;getChunkTrackingView()Lnet/minecraft/server/level/ChunkTrackingView;")})
    private void securitycraft$sendChunksToCameras(LevelChunk chunk, CallbackInfo callback, @Local ServerPlayer player) {
        SecurityCamera camera;
        Entity entity = player.getCamera();
        if (entity instanceof SecurityCamera && (camera = (SecurityCamera)entity).getCameraChunks().contains(chunk.getPos())) {
            ChunkMapMixin.markChunkPendingToSend(player, chunk);
        }
    }

    @Inject(method={"isChunkTracked"}, at={@At(value="HEAD")}, cancellable=true)
    private void securitycraft$onIsChunkTracked(ServerPlayer player, int x, int z, CallbackInfoReturnable<Boolean> callback) {
        SecurityCamera camera;
        Entity entity = player.getCamera();
        if (entity instanceof SecurityCamera && (camera = (SecurityCamera)entity).getCameraChunks().contains(x, z) && !player.connection.chunkSender.isPending(ChunkPos.asLong((int)x, (int)z))) {
            callback.setReturnValue((Object)true);
        }
    }
}

