/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.items;

import net.geforcemods.securitycraft.SCContent;
import net.geforcemods.securitycraft.api.IModuleInventory;
import net.geforcemods.securitycraft.api.IOwnable;
import net.geforcemods.securitycraft.api.IReinforcedBlock;
import net.geforcemods.securitycraft.inventory.BlockReinforcerMenu;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.Container;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.item.enchantment.ItemEnchantments;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.LecternBlockEntity;
import net.minecraft.world.level.block.state.BlockState;

public class UniversalBlockReinforcerItem
extends Item {
    public UniversalBlockReinforcerItem(Item.Properties properties) {
        super(properties);
    }

    public InteractionResultHolder<ItemStack> use(Level level, Player player, InteractionHand hand) {
        final ItemStack heldItem = player.getItemInHand(hand);
        if (!level.isClientSide) {
            UniversalBlockReinforcerItem.maybeRemoveMending((HolderLookup.Provider)level.registryAccess(), heldItem);
            player.openMenu(new MenuProvider(){

                public AbstractContainerMenu createMenu(int windowId, Inventory inv, Player player) {
                    return new BlockReinforcerMenu(windowId, inv, UniversalBlockReinforcerItem.this == SCContent.UNIVERSAL_BLOCK_REINFORCER_LVL_1.get());
                }

                public Component getDisplayName() {
                    return heldItem.getHoverName();
                }
            }, data -> data.writeBoolean(this == SCContent.UNIVERSAL_BLOCK_REINFORCER_LVL_1.get()));
        }
        return InteractionResultHolder.consume((Object)heldItem);
    }

    public static boolean convertBlock(BlockState state, Level level, ItemStack stack, BlockPos pos, Player player) {
        if (!player.isCreative()) {
            boolean isReinforcing = UniversalBlockReinforcerItem.isReinforcing(stack);
            Block block = state.getBlock();
            Block convertedBlock = (isReinforcing ? IReinforcedBlock.VANILLA_TO_SECURITYCRAFT : IReinforcedBlock.SECURITYCRAFT_TO_VANILLA).get(block);
            BlockState convertedState = null;
            if (isReinforcing && convertedBlock instanceof IReinforcedBlock) {
                IReinforcedBlock rb = (IReinforcedBlock)convertedBlock;
                convertedState = rb.convertToReinforced(level, pos, state);
            } else if (!isReinforcing && block instanceof IReinforcedBlock) {
                IReinforcedBlock rb = (IReinforcedBlock)block;
                convertedState = rb.convertToVanilla(level, pos, state);
            }
            if (convertedState != null) {
                IOwnable ownable;
                BlockEntity be = level.getBlockEntity(pos);
                CompoundTag tag = null;
                if (be instanceof IOwnable && !(ownable = (IOwnable)be).isOwnedBy((Entity)player) || !level.mayInteract(player, pos)) {
                    return false;
                }
                if (!level.isClientSide) {
                    if (be != null) {
                        tag = be.saveWithoutMetadata((HolderLookup.Provider)level.registryAccess());
                        if (be instanceof IModuleInventory) {
                            IModuleInventory inv = (IModuleInventory)be;
                            inv.dropAllModules();
                        }
                        if (be instanceof Container) {
                            Container container = (Container)be;
                            container.clearContent();
                        } else if (be instanceof LecternBlockEntity) {
                            LecternBlockEntity lectern = (LecternBlockEntity)be;
                            lectern.clearContent();
                        }
                    }
                    level.setBlockAndUpdate(pos, convertedState);
                    be = level.getBlockEntity(pos);
                    if (be != null) {
                        if (tag != null) {
                            be.loadWithComponents(tag, (HolderLookup.Provider)level.registryAccess());
                        }
                        if (isReinforcing) {
                            ((IOwnable)be).setOwner(player.getGameProfile().getId().toString(), player.getName().getString());
                        }
                    }
                    stack.hurtAndBreak(1, (LivingEntity)player, LivingEntity.getSlotForHand((InteractionHand)player.getUsedItemHand()));
                }
                return true;
            }
        }
        return false;
    }

    public static boolean isReinforcing(ItemStack stack) {
        return stack.is((Item)SCContent.UNIVERSAL_BLOCK_REINFORCER_LVL_1.get()) || !stack.has(SCContent.UNREINFORCING);
    }

    public static void maybeRemoveMending(HolderLookup.Provider lookupProvider, ItemStack stack) {
        ItemEnchantments enchantments = (ItemEnchantments)stack.get(DataComponents.ENCHANTMENTS);
        Holder.Reference mending = ((HolderLookup.RegistryLookup)lookupProvider.lookup(Registries.ENCHANTMENT).get()).getOrThrow(Enchantments.MENDING);
        if (enchantments != null && enchantments.getLevel((Holder)mending) > 0) {
            ItemEnchantments.Mutable mutable = new ItemEnchantments.Mutable(enchantments);
            mutable.set((Holder)mending, 0);
            stack.set(DataComponents.ENCHANTMENTS, (Object)mutable.toImmutable());
        }
    }

    public boolean isBookEnchantable(ItemStack stack, ItemStack book) {
        return ((ItemEnchantments)book.getOrDefault(DataComponents.STORED_ENCHANTMENTS, (Object)ItemEnchantments.EMPTY)).keySet().stream().noneMatch(e -> e.is(Enchantments.MENDING));
    }
}

