/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.items;

import java.util.List;
import java.util.Objects;
import java.util.Optional;
import net.geforcemods.securitycraft.ClientHandler;
import net.geforcemods.securitycraft.SCContent;
import net.geforcemods.securitycraft.blockentities.SecurityCameraBlockEntity;
import net.geforcemods.securitycraft.components.NamedPositions;
import net.geforcemods.securitycraft.util.PlayerUtils;
import net.geforcemods.securitycraft.util.Utils;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.GlobalPos;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;

public class CameraMonitorItem
extends Item {
    public static final int MAX_CAMERAS = 30;
    public static final NamedPositions DEFAULT_NAMED_POSITIONS = NamedPositions.sized(30);

    public CameraMonitorItem(Item.Properties properties) {
        super(properties);
    }

    public InteractionResult useOn(UseOnContext ctx) {
        BlockPos pos;
        Player player = ctx.getPlayer();
        Level level = ctx.getLevel();
        if (level.getBlockState(pos = ctx.getClickedPos()).getBlock() == SCContent.SECURITY_CAMERA.get() && !PlayerUtils.isPlayerMountedOnCamera((LivingEntity)player)) {
            SecurityCameraBlockEntity be = (SecurityCameraBlockEntity)level.getBlockEntity(pos);
            if (!be.isOwnedBy((Entity)player) && !be.isAllowed((Entity)player)) {
                PlayerUtils.sendMessageToPlayer(player, Utils.localize(((CameraMonitorItem)((Object)SCContent.CAMERA_MONITOR.get())).getDescriptionId(), new Object[0]), Utils.localize("messages.securitycraft:cameraMonitor.cannotView", new Object[0]), ChatFormatting.RED);
                return InteractionResult.FAIL;
            }
            ItemStack stack = ctx.getItemInHand();
            GlobalPos view = GlobalPos.of((ResourceKey)player.level().dimension(), (BlockPos)pos);
            NamedPositions cameras = (NamedPositions)stack.get(SCContent.BOUND_CAMERAS);
            if (cameras != null) {
                if (cameras.remove(SCContent.BOUND_CAMERAS, stack, view)) {
                    PlayerUtils.sendMessageToPlayer(player, Utils.localize(((CameraMonitorItem)((Object)SCContent.CAMERA_MONITOR.get())).getDescriptionId(), new Object[0]), Utils.localize("messages.securitycraft:cameraMonitor.unbound", Utils.getFormattedCoordinates(pos)), ChatFormatting.RED);
                } else if (cameras.add(SCContent.BOUND_CAMERAS, stack, view, be.hasCustomName() ? Optional.of(be.getCustomName().getString()) : Optional.empty())) {
                    PlayerUtils.sendMessageToPlayer(player, Utils.localize(((CameraMonitorItem)((Object)SCContent.CAMERA_MONITOR.get())).getDescriptionId(), new Object[0]), Utils.localize("messages.securitycraft:cameraMonitor.bound", Utils.getFormattedCoordinates(pos)), ChatFormatting.GREEN);
                }
                return InteractionResult.SUCCESS;
            }
        }
        return InteractionResult.PASS;
    }

    public InteractionResultHolder<ItemStack> use(Level level, Player player, InteractionHand hand) {
        ItemStack stack = player.getItemInHand(hand);
        NamedPositions cameras = (NamedPositions)stack.get(SCContent.BOUND_CAMERAS);
        if (cameras != null) {
            if (cameras.isEmpty()) {
                PlayerUtils.sendMessageToPlayer(player, Utils.localize(((CameraMonitorItem)((Object)SCContent.CAMERA_MONITOR.get())).getDescriptionId(), new Object[0]), Utils.localize("messages.securitycraft:cameraMonitor.rightclickToView", new Object[0]), ChatFormatting.RED);
                return InteractionResultHolder.pass((Object)stack);
            }
            CameraMonitorItem.updateComponentWithNames(stack, level);
        }
        if (level.isClientSide && stack.getItem() == SCContent.CAMERA_MONITOR.get()) {
            ClientHandler.displayCameraMonitorScreen(player.getInventory(), stack);
        }
        return InteractionResultHolder.consume((Object)stack);
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext ctx, List<Component> tooltip, TooltipFlag flag) {
        NamedPositions cameras = (NamedPositions)stack.get(SCContent.BOUND_CAMERAS);
        if (cameras != null) {
            tooltip.add((Component)Utils.localize("tooltip.securitycraft:cameraMonitor", cameras.positions().stream().filter(Objects::nonNull).count() + "/30").setStyle(Utils.GRAY_STYLE));
        }
    }

    public static void updateComponentWithNames(ItemStack stack, Level level) {
        NamedPositions.updateComponentWithNames(SCContent.BOUND_CAMERAS, stack, entry -> {
            BlockEntity be;
            GlobalPos globalPos = entry.globalPos();
            if (level.dimension().equals(globalPos.dimension()) && level.isLoaded(globalPos.pos()) && (be = level.getBlockEntity(globalPos.pos())) instanceof SecurityCameraBlockEntity) {
                SecurityCameraBlockEntity camera = (SecurityCameraBlockEntity)be;
                return camera;
            }
            return null;
        });
    }
}

