/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.entity.sentry;

import java.util.Collections;
import java.util.List;
import net.geforcemods.securitycraft.ConfigHandler;
import net.geforcemods.securitycraft.api.SecurityCraftAPI;
import net.geforcemods.securitycraft.entity.sentry.Sentry;
import net.geforcemods.securitycraft.util.Utils;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.FlyingMob;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.boss.enderdragon.EnderDragon;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.monster.Shulker;
import net.minecraft.world.entity.monster.Slime;
import net.minecraft.world.entity.player.Player;

public class TargetNearestPlayerOrMobGoal
extends NearestAttackableTargetGoal<LivingEntity> {
    private Sentry sentry;

    public TargetNearestPlayerOrMobGoal(Sentry sentry) {
        super((Mob)sentry, LivingEntity.class, true);
        this.sentry = sentry;
    }

    public boolean canUse() {
        if (this.sentry.isShutDown()) {
            return false;
        }
        List list = this.mob.level().getEntitiesOfClass(this.targetType, this.getTargetSearchArea(this.getFollowDistance()), e -> this.sentry.getSensing().hasLineOfSight((Entity)e) && !e.hasEffect(MobEffects.INVISIBILITY));
        if (!list.isEmpty()) {
            Player player;
            LivingEntity potentialTarget;
            int i;
            Sentry.SentryMode sentryMode = this.sentry.getMode();
            Collections.sort(list, (e1, e2) -> {
                double distTo2;
                double distTo1 = this.mob.distanceToSqr((Entity)e1);
                if (distTo1 < (distTo2 = this.mob.distanceToSqr((Entity)e2))) {
                    return -1;
                }
                return distTo1 > distTo2 ? 1 : 0;
            });
            for (i = 0; !(i >= list.size() || !(potentialTarget = (LivingEntity)list.get(i)).isInvulnerable() && (sentryMode.attacksPlayers() && potentialTarget instanceof Player && !(player = (Player)potentialTarget).isSpectator() && !player.isCreative() && !((Sentry)this.mob).isOwnedBy((Entity)player) && !this.sentry.isTargetingAllowedPlayer(potentialTarget) || sentryMode.attacksHostile() && this.isSupportedTarget(potentialTarget))); ++i) {
            }
            if (i < list.size() && this.isCloseEnough((Entity)list.get(i))) {
                this.target = (LivingEntity)list.get(i);
                this.mob.setTarget(this.target);
                return true;
            }
        }
        return false;
    }

    public boolean canContinueToUse() {
        return (this.isSupportedTarget(this.target) || this.target instanceof Player) && this.isCloseEnough((Entity)this.target) && this.canUse() && !this.sentry.isTargetingAllowedPlayer(this.targetMob) && super.canContinueToUse();
    }

    public boolean isCloseEnough(Entity entity) {
        return entity != null && this.mob.distanceToSqr(entity) <= this.getFollowDistance() * this.getFollowDistance();
    }

    public boolean isSupportedTarget(LivingEntity potentialTarget) {
        return potentialTarget.deathTime == 0 && !((List)ConfigHandler.SERVER.sentryAttackableEntitiesDenylist.get()).contains(Utils.getRegistryName(potentialTarget.getType()).toString()) && (potentialTarget instanceof Monster || potentialTarget instanceof FlyingMob || potentialTarget instanceof Slime || potentialTarget instanceof Shulker || potentialTarget instanceof EnderDragon || SecurityCraftAPI.getRegisteredSentryAttackTargetChecks().stream().anyMatch(check -> check.canAttack((Entity)potentialTarget)));
    }

    protected double getFollowDistance() {
        return 20.0;
    }
}

