/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.entity.camera;

import java.util.function.Consumer;
import net.geforcemods.securitycraft.ClientHandler;
import net.geforcemods.securitycraft.ConfigHandler;
import net.geforcemods.securitycraft.api.IModuleInventory;
import net.geforcemods.securitycraft.blockentities.SecurityCameraBlockEntity;
import net.geforcemods.securitycraft.blocks.SecurityCameraBlock;
import net.geforcemods.securitycraft.entity.camera.SecurityCamera;
import net.geforcemods.securitycraft.misc.KeyBindings;
import net.geforcemods.securitycraft.misc.LayerToggleHandler;
import net.geforcemods.securitycraft.misc.ModuleType;
import net.geforcemods.securitycraft.misc.SCSounds;
import net.geforcemods.securitycraft.network.server.DismountCamera;
import net.geforcemods.securitycraft.network.server.SetCameraPowered;
import net.geforcemods.securitycraft.network.server.SetDefaultCameraViewingDirection;
import net.geforcemods.securitycraft.network.server.ToggleNightVision;
import net.geforcemods.securitycraft.util.PlayerUtils;
import net.minecraft.Util;
import net.minecraft.client.CameraType;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.client.Options;
import net.minecraft.client.multiplayer.ClientChunkCache;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.SectionPos;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.network.protocol.game.ServerboundMovePlayerPacket;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.entity.EntityAccess;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.client.event.ClientTickEvent;
import net.neoforged.neoforge.client.event.ScreenshotEvent;
import net.neoforged.neoforge.client.gui.VanillaGuiLayers;
import net.neoforged.neoforge.network.PacketDistributor;

@EventBusSubscriber(modid="securitycraft", value={Dist.CLIENT})
public class CameraController {
    public static CameraType previousCameraType;
    public static boolean resetOverlaysAfterDismount;
    private static ClientChunkCache.Storage cameraStorage;
    private static final ViewMovementKeyHandler[] MOVE_KEY_HANDLERS;
    private static int screenshotSoundCooldown;

    private CameraController() {
    }

    @SubscribeEvent
    public static void onClientTickPre(ClientTickEvent.Pre event) {
        Entity cameraEntity = Minecraft.getInstance().cameraEntity;
        if (cameraEntity instanceof SecurityCamera) {
            Options options = Minecraft.getInstance().options;
            for (ViewMovementKeyHandler handler : MOVE_KEY_HANDLERS) {
                handler.tickStart();
            }
            if (options.keyShift.isDown()) {
                CameraController.dismount();
                options.keyShift.setDown(false);
            }
        }
    }

    @SubscribeEvent
    public static void onClientTickPost(ClientTickEvent.Post event) {
        Entity cameraEntity = Minecraft.getInstance().cameraEntity;
        if (cameraEntity instanceof SecurityCamera) {
            SecurityCamera cam = (SecurityCamera)cameraEntity;
            for (ViewMovementKeyHandler handler : MOVE_KEY_HANDLERS) {
                handler.tickEnd(cam);
            }
            if (KeyBindings.cameraZoomIn.isDown()) {
                CameraController.zoomIn(cam);
            } else if (KeyBindings.cameraZoomOut.isDown()) {
                CameraController.zoomOut(cam);
            } else {
                cam.zooming = false;
            }
            KeyBindings.cameraEmitRedstone.tick(cam);
            KeyBindings.cameraActivateNightVision.tick(cam);
            KeyBindings.setDefaultViewingDirection.tick(cam);
            --screenshotSoundCooldown;
            LocalPlayer player = Minecraft.getInstance().player;
            double yRotChange = player.getYRot() - player.yRotLast;
            double xRotChange = player.getXRot() - player.xRotLast;
            if (yRotChange != 0.0 || xRotChange != 0.0) {
                player.connection.send((Packet)new ServerboundMovePlayerPacket.Rot(player.getYRot(), player.getXRot(), player.onGround()));
            }
        }
        if (resetOverlaysAfterDismount) {
            resetOverlaysAfterDismount = false;
            LayerToggleHandler.disable(ClientHandler.CAMERA_LAYER);
            LayerToggleHandler.enable(VanillaGuiLayers.JUMP_METER);
            LayerToggleHandler.enable(VanillaGuiLayers.EXPERIENCE_BAR);
            LayerToggleHandler.enable(VanillaGuiLayers.EFFECTS);
        }
    }

    @SubscribeEvent
    public static void onScreenshot(ScreenshotEvent event) {
        LocalPlayer player = Minecraft.getInstance().player;
        if (PlayerUtils.isPlayerMountedOnCamera((LivingEntity)player) && screenshotSoundCooldown <= 0) {
            screenshotSoundCooldown = 7;
            Minecraft.getInstance().level.playLocalSound(player.blockPosition(), SCSounds.CAMERASNAP.event, SoundSource.BLOCKS, 1.0f, 1.0f, true);
        }
    }

    private static void dismount() {
        PacketDistributor.sendToServer((CustomPacketPayload)new DismountCamera(), (CustomPacketPayload[])new CustomPacketPayload[0]);
    }

    public static void moveViewUp(SecurityCamera cam) {
        float next = cam.getXRot() - CameraController.getMovementSpeed(cam) * cam.getZoomAmount();
        if (cam.isCameraDown()) {
            if (next > 40.0f) {
                cam.setRotation(cam.getYRot(), next);
            }
        } else if (next > -25.0f) {
            cam.setRotation(cam.getYRot(), next);
        }
    }

    public static void moveViewDown(SecurityCamera cam) {
        float next = cam.getXRot() + CameraController.getMovementSpeed(cam) * cam.getZoomAmount();
        if (cam.isCameraDown()) {
            if (next < 90.0f) {
                cam.setRotation(cam.getYRot(), next);
            }
        } else if (next < 60.0f) {
            cam.setRotation(cam.getYRot(), next);
        }
    }

    public static void moveViewHorizontally(SecurityCamera cam, float next) {
        BlockState state = cam.level().getBlockState(cam.blockPosition());
        if (state.hasProperty((Property)SecurityCameraBlock.FACING)) {
            boolean shouldSetRotation;
            float checkNext = next;
            if (checkNext < 0.0f) {
                checkNext += 360.0f;
            }
            switch ((Direction)state.getValue((Property)SecurityCameraBlock.FACING)) {
                case NORTH: {
                    boolean bl;
                    if (checkNext > 90.0f && checkNext < 270.0f) {
                        bl = true;
                        break;
                    }
                    bl = false;
                    break;
                }
                case SOUTH: {
                    boolean bl;
                    if (checkNext > 270.0f || checkNext < 90.0f) {
                        bl = true;
                        break;
                    }
                    bl = false;
                    break;
                }
                case EAST: {
                    boolean bl;
                    if (checkNext > 180.0f && checkNext < 360.0f) {
                        bl = true;
                        break;
                    }
                    bl = false;
                    break;
                }
                case WEST: {
                    boolean bl;
                    if (checkNext > 0.0f && checkNext < 180.0f) {
                        bl = true;
                        break;
                    }
                    bl = false;
                    break;
                }
                case DOWN: {
                    boolean bl = true;
                    break;
                }
                default: {
                    boolean bl = shouldSetRotation = false;
                }
            }
            if (shouldSetRotation) {
                cam.setYRot(next);
            }
        }
    }

    public static void zoomIn(SecurityCamera cam) {
        if (!cam.zooming) {
            Minecraft.getInstance().level.playLocalSound(cam.blockPosition(), SCSounds.CAMERAZOOMIN.event, SoundSource.BLOCKS, 1.0f, 1.0f, true);
        }
        cam.zooming = true;
        cam.setZoomAmount(Math.max(cam.getZoomAmount() - 0.1f, 0.1f));
    }

    public static void zoomOut(SecurityCamera cam) {
        if (!cam.zooming) {
            Minecraft.getInstance().level.playLocalSound(cam.blockPosition(), SCSounds.CAMERAZOOMIN.event, SoundSource.BLOCKS, 1.0f, 1.0f, true);
        }
        cam.zooming = true;
        cam.setZoomAmount(Math.min(cam.getZoomAmount() + 0.1f, 1.4f));
    }

    public static void toggleRedstone(SecurityCamera cam) {
        IModuleInventory be;
        BlockPos pos = cam.blockPosition();
        Level level = cam.level();
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (blockEntity instanceof IModuleInventory && (be = (IModuleInventory)blockEntity).isModuleEnabled(ModuleType.REDSTONE)) {
            PacketDistributor.sendToServer((CustomPacketPayload)new SetCameraPowered(pos, (Boolean)level.getBlockState(pos).getValue((Property)SecurityCameraBlock.POWERED) == false), (CustomPacketPayload[])new CustomPacketPayload[0]);
        }
    }

    public static void toggleNightVision(SecurityCamera cam) {
        if (((Boolean)ConfigHandler.SERVER.allowCameraNightVision.get()).booleanValue()) {
            PacketDistributor.sendToServer((CustomPacketPayload)new ToggleNightVision(), (CustomPacketPayload[])new CustomPacketPayload[0]);
        }
    }

    public static void setDefaultViewingDirection(SecurityCamera cam) {
        PacketDistributor.sendToServer((CustomPacketPayload)new SetDefaultCameraViewingDirection(cam.getId(), cam.getXRot(), cam.getYRot(), cam.getZoomAmount()), (CustomPacketPayload[])new CustomPacketPayload[0]);
    }

    public static ClientChunkCache.Storage getCameraStorage() {
        return cameraStorage;
    }

    public static void setCameraStorage(ClientChunkCache.Storage newStorage) {
        cameraStorage = newStorage;
    }

    public static void setRenderPosition(Entity entity) {
        if (entity instanceof SecurityCamera) {
            SectionPos cameraPos = SectionPos.of((EntityAccess)entity);
            CameraController.cameraStorage.viewCenterX = cameraPos.x();
            CameraController.cameraStorage.viewCenterZ = cameraPos.z();
        }
    }

    public static float getMovementSpeed(SecurityCamera cam) {
        SecurityCameraBlockEntity be = cam.getBlockEntity();
        if (be != null) {
            return (float)be.getMovementSpeed();
        }
        return 0.0f;
    }

    static {
        resetOverlaysAfterDismount = false;
        MOVE_KEY_HANDLERS = (ViewMovementKeyHandler[])Util.make(() -> {
            Minecraft mc = Minecraft.getInstance();
            if (mc != null) {
                return new ViewMovementKeyHandler[]{new ViewMovementKeyHandler(mc.options.keyUp, CameraController::moveViewUp), new ViewMovementKeyHandler(mc.options.keyDown, CameraController::moveViewDown), new ViewMovementKeyHandler(mc.options.keyLeft, cam -> CameraController.moveViewHorizontally(cam, cam.getYRot() - CameraController.getMovementSpeed(cam) * cam.getZoomAmount())), new ViewMovementKeyHandler(mc.options.keyRight, cam -> CameraController.moveViewHorizontally(cam, cam.getYRot() + CameraController.getMovementSpeed(cam) * cam.getZoomAmount()))};
            }
            return new ViewMovementKeyHandler[0];
        });
        screenshotSoundCooldown = 0;
    }

    public static class ViewMovementKeyHandler {
        private final KeyMapping key;
        private final Consumer<SecurityCamera> action;
        private boolean wasPressed;

        public ViewMovementKeyHandler(KeyMapping key, Consumer<SecurityCamera> action) {
            this.key = key;
            this.action = action;
        }

        public void tickStart() {
            this.wasPressed = this.key.isDown();
            if (this.wasPressed) {
                this.key.setDown(false);
            }
        }

        public void tickEnd(SecurityCamera cam) {
            if (this.wasPressed) {
                this.action.accept(cam);
                this.key.setDown(true);
            }
        }
    }
}

