/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.components;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Supplier;
import net.geforcemods.securitycraft.components.GlobalPositionComponent;
import net.minecraft.core.GlobalPos;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.Nameable;
import net.minecraft.world.item.ItemStack;

public record NamedPositions(List<Entry> positions) implements GlobalPositionComponent<NamedPositions, Entry, Optional<String>>
{
    public static final Codec<NamedPositions> codec(int size) {
        return Codec.withAlternative((Codec)RecordCodecBuilder.create(instance -> instance.group((App)GlobalPositionComponent.nullableSizedCodec(Entry.CODEC, size).fieldOf("positions").forGetter(NamedPositions::positions)).apply((Applicative)instance, NamedPositions::new)), (Codec)RecordCodecBuilder.create(instance -> instance.group((App)GlobalPositionComponent.nullableSizedCodec(GlobalPos.CODEC, size).fieldOf("positions").forGetter(namedPositions -> namedPositions.positions().stream().map(Entry::globalPos).toList())).apply((Applicative)instance, list -> new NamedPositions(list.stream().map(gp -> gp == null ? null : new Entry((GlobalPos)gp, Optional.empty())).toList()))));
    }

    public static final StreamCodec<ByteBuf, NamedPositions> streamCodec(int size) {
        return StreamCodec.composite(GlobalPositionComponent.nullableSizedStreamCodec(Entry.STREAM_CODEC, size, new Entry(DUMMY_GLOBAL_POS, Optional.empty())), NamedPositions::positions, NamedPositions::new);
    }

    public static NamedPositions sized(int size) {
        return new NamedPositions(Arrays.asList(new Entry[size]));
    }

    @Override
    public boolean isPositionAdded(GlobalPos pos) {
        return this.positions().stream().filter(Objects::nonNull).map(Entry::globalPos).anyMatch(arg_0 -> ((GlobalPos)pos).equals(arg_0));
    }

    @Override
    public GlobalPos getGlobalPos(Entry entry) {
        return entry == null ? null : entry.globalPos;
    }

    @Override
    public Entry createEntry(GlobalPos globalPos, Optional<String> sentryName) {
        return new Entry(globalPos, sentryName);
    }

    @Override
    public void setOnStack(Supplier<DataComponentType<NamedPositions>> dataComponentType, ItemStack stack, List<Entry> newPositionList) {
        stack.set(dataComponentType, (Object)new NamedPositions(newPositionList));
    }

    public static void updateComponentWithNames(Supplier<DataComponentType<NamedPositions>> dataComponentType, ItemStack stack, Function<Entry, Nameable> nameableGetter) {
        NamedPositions positions = (NamedPositions)stack.get(dataComponentType);
        if (positions != null && !positions.isEmpty()) {
            ArrayList<Entry> newEntries = new ArrayList<Entry>(positions.positions());
            boolean changed = false;
            for (int i = 0; i < newEntries.size(); ++i) {
                Optional<Object> optional;
                Nameable nameable;
                Entry entry = (Entry)newEntries.get(i);
                if (entry == null || (nameable = nameableGetter.apply(entry)) == null) continue;
                String name = null;
                if (nameable.hasCustomName()) {
                    name = nameable.getCustomName().getString();
                }
                if ((optional = Optional.ofNullable(name)).equals(entry.name)) continue;
                newEntries.set(i, new Entry(entry.globalPos, optional));
                changed = true;
            }
            if (changed) {
                stack.set(dataComponentType, (Object)new NamedPositions(newEntries));
            }
        }
    }

    public record Entry(GlobalPos globalPos, Optional<String> name) {
        public static final Codec<Entry> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)GlobalPos.CODEC.fieldOf("global_pos").forGetter(Entry::globalPos), (App)Codec.STRING.optionalFieldOf("name").forGetter(Entry::name)).apply((Applicative)instance, Entry::new));
        public static final StreamCodec<ByteBuf, Entry> STREAM_CODEC = StreamCodec.composite((StreamCodec)GlobalPos.STREAM_CODEC, Entry::globalPos, (StreamCodec)ByteBufCodecs.STRING_UTF8.apply(ByteBufCodecs::optional), Entry::name, Entry::new);
    }
}

