/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.compat.ium;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.function.Supplier;
import net.geforcemods.securitycraft.SecurityCraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.neoforged.fml.ModList;

public enum IumCompat {
    EMBEDDIUM(() -> IumCompat.getClass("org.embeddedt.embeddium.impl.render.chunk.map.ChunkTrackerHolder"), () -> IumCompat.getClass("org.embeddedt.embeddium.impl.render.chunk.map.ChunkTracker")),
    SODIUM(() -> IumCompat.getClass("net.caffeinemc.mods.sodium.client.render.chunk.map.ChunkTrackerHolder"), () -> IumCompat.getClass("net.caffeinemc.mods.sodium.client.render.chunk.map.ChunkTracker")),
    NONE(null, null);

    private static final int FLAG_HAS_BLOCK_DATA = 1;
    private final Supplier<Class<?>> chunkTrackerHolder;
    private final Supplier<Class<?>> chunkTracker;
    private Method getChunkTracker;
    private Method onChunkStatusAdded;
    private Method onChunkStatusRemoved;

    private IumCompat(Supplier<Class<?>> chunkTrackerHolder, Supplier<Class<?>> chunkTracker) {
        this.chunkTrackerHolder = chunkTrackerHolder;
        this.chunkTracker = chunkTracker;
    }

    public void onChunkStatusAdded(ClientLevel level, int x, int z) {
        if (this == NONE) {
            return;
        }
        try {
            this.onChunkStatusAdded.invoke(this.getChunkTracker.invoke(null, level), x, z, 1);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            e.printStackTrace();
        }
    }

    public void onChunkStatusRemoved(ClientLevel level, int x, int z) {
        if (this == NONE) {
            return;
        }
        try {
            this.onChunkStatusRemoved.invoke(this.getChunkTracker.invoke(null, level), x, z, 1);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            e.printStackTrace();
        }
    }

    public void resolve() {
        if (this == NONE) {
            return;
        }
        try {
            Class<?> chunkTrackerClass = this.chunkTracker.get();
            this.getChunkTracker = this.chunkTrackerHolder.get().getDeclaredMethod("get", ClientLevel.class);
            this.onChunkStatusAdded = chunkTrackerClass.getDeclaredMethod("onChunkStatusAdded", Integer.TYPE, Integer.TYPE, Integer.TYPE);
            this.onChunkStatusRemoved = chunkTrackerClass.getDeclaredMethod("onChunkStatusRemoved", Integer.TYPE, Integer.TYPE, Integer.TYPE);
        }
        catch (NoSuchMethodException | SecurityException e) {
            e.printStackTrace();
        }
    }

    public static IumCompat getInstalledIumMod() {
        if (ModList.get().isLoaded("embeddium")) {
            return EMBEDDIUM;
        }
        if (ModList.get().isLoaded("sodium")) {
            return SODIUM;
        }
        return NONE;
    }

    private static Class<?> getClass(String name) {
        try {
            return Class.forName(name, false, SecurityCraft.class.getClassLoader());
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
            return null;
        }
    }
}

