/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.blocks.reinforced;

import net.geforcemods.securitycraft.SCContent;
import net.geforcemods.securitycraft.api.IReinforcedBlock;
import net.geforcemods.securitycraft.api.OwnableBlockEntity;
import net.geforcemods.securitycraft.misc.OwnershipEvent;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.piston.PistonBaseBlock;
import net.minecraft.world.level.block.piston.PistonHeadBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.PistonType;
import net.minecraft.world.level.block.state.properties.Property;
import net.neoforged.bus.api.Event;
import net.neoforged.neoforge.common.NeoForge;

public class ReinforcedPistonHeadBlock
extends PistonHeadBlock
implements EntityBlock,
IReinforcedBlock {
    public ReinforcedPistonHeadBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    public void setPlacedBy(Level level, BlockPos pos, BlockState state, LivingEntity placer, ItemStack stack) {
        if (placer instanceof Player) {
            Player player = (Player)placer;
            NeoForge.EVENT_BUS.post((Event)new OwnershipEvent(level, pos, player));
        }
        super.setPlacedBy(level, pos, state, placer, stack);
    }

    public boolean isFittingBase(BlockState baseState, BlockState extendedState) {
        Block block = baseState.getValue((Property)TYPE) == PistonType.DEFAULT ? (Block)SCContent.REINFORCED_PISTON.get() : (Block)SCContent.REINFORCED_STICKY_PISTON.get();
        return extendedState.is(block) && (Boolean)extendedState.getValue((Property)PistonBaseBlock.EXTENDED) != false && extendedState.getValue((Property)FACING) == baseState.getValue((Property)FACING);
    }

    public boolean canSurvive(BlockState state, LevelReader level, BlockPos pos) {
        BlockState oppositeState = level.getBlockState(pos.relative(((Direction)state.getValue((Property)FACING)).getOpposite()));
        return this.isFittingBase(state, oppositeState) || oppositeState.is((Block)SCContent.REINFORCED_MOVING_PISTON.get()) && oppositeState.getValue((Property)FACING) == state.getValue((Property)FACING);
    }

    public ItemStack getCloneItemStack(LevelReader level, BlockPos pos, BlockState state) {
        return new ItemStack(state.getValue((Property)TYPE) == PistonType.STICKY ? (ItemLike)SCContent.REINFORCED_STICKY_PISTON.get() : (ItemLike)SCContent.REINFORCED_PISTON.get());
    }

    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return new OwnableBlockEntity(pos, state);
    }

    @Override
    public Block getVanillaBlock() {
        return Blocks.PISTON_HEAD;
    }
}

