/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.blocks.reinforced;

import net.geforcemods.securitycraft.api.IReinforcedBlock;
import net.geforcemods.securitycraft.api.OwnableBlockEntity;
import net.geforcemods.securitycraft.misc.OwnershipEvent;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.IronBarsBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.neoforged.bus.api.Event;
import net.neoforged.neoforge.common.NeoForge;

public class ReinforcedPaneBlock
extends IronBarsBlock
implements IReinforcedBlock,
EntityBlock {
    private final Block vanillaBlock;

    public ReinforcedPaneBlock(BlockBehaviour.Properties properties, Block vB) {
        super(properties);
        this.vanillaBlock = vB;
    }

    public BlockState getStateForPlacement(BlockPlaceContext context) {
        return this.getStateForPlacement((BlockGetter)context.getLevel(), context.getClickedPos());
    }

    public BlockState getStateForPlacement(BlockGetter level, BlockPos pos) {
        FluidState fluidState = level.getFluidState(pos);
        BlockPos northPos = pos.north();
        BlockPos southPos = pos.south();
        BlockPos westPos = pos.west();
        BlockPos eastPos = pos.east();
        BlockState northState = level.getBlockState(northPos);
        BlockState southState = level.getBlockState(southPos);
        BlockState westState = level.getBlockState(westPos);
        BlockState eastState = level.getBlockState(eastPos);
        return (BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.defaultBlockState().setValue((Property)NORTH, (Comparable)Boolean.valueOf(this.attachsTo(northState, northState.isFaceSturdy(level, northPos, Direction.SOUTH))))).setValue((Property)SOUTH, (Comparable)Boolean.valueOf(this.attachsTo(southState, southState.isFaceSturdy(level, southPos, Direction.NORTH))))).setValue((Property)WEST, (Comparable)Boolean.valueOf(this.attachsTo(westState, westState.isFaceSturdy(level, westPos, Direction.EAST))))).setValue((Property)EAST, (Comparable)Boolean.valueOf(this.attachsTo(eastState, eastState.isFaceSturdy(level, eastPos, Direction.WEST))))).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(fluidState.getType() == Fluids.WATER));
    }

    @Override
    public Block getVanillaBlock() {
        return this.vanillaBlock;
    }

    public void setPlacedBy(Level level, BlockPos pos, BlockState state, LivingEntity placer, ItemStack stack) {
        if (placer instanceof Player) {
            Player player = (Player)placer;
            NeoForge.EVENT_BUS.post((Event)new OwnershipEvent(level, pos, player));
        }
    }

    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return new OwnableBlockEntity(pos, state);
    }
}

