/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.blocks.reinforced;

import net.geforcemods.securitycraft.api.IReinforcedBlock;
import net.geforcemods.securitycraft.blockentities.ReinforcedLecternBlockEntity;
import net.geforcemods.securitycraft.misc.OwnershipEvent;
import net.minecraft.core.BlockPos;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.LecternBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.neoforged.bus.api.Event;
import net.neoforged.neoforge.common.NeoForge;

public class ReinforcedLecternBlock
extends LecternBlock
implements IReinforcedBlock {
    public ReinforcedLecternBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    public void setPlacedBy(Level level, BlockPos pos, BlockState state, LivingEntity placer, ItemStack stack) {
        if (placer instanceof Player) {
            Player player = (Player)placer;
            NeoForge.EVENT_BUS.post((Event)new OwnershipEvent(level, pos, player));
        }
        super.setPlacedBy(level, pos, state, placer, stack);
    }

    public ItemInteractionResult useItemOn(ItemStack stack, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        ReinforcedLecternBlockEntity be;
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (blockEntity instanceof ReinforcedLecternBlockEntity && ((be = (ReinforcedLecternBlockEntity)blockEntity).isOwnedBy((Entity)player) || be.isAllowed((Entity)player))) {
            return super.useItemOn(stack, state, level, pos, player, hand, hit);
        }
        return ItemInteractionResult.SUCCESS;
    }

    public InteractionResult useWithoutItem(BlockState state, Level level, BlockPos pos, Player player, BlockHitResult hit) {
        ReinforcedLecternBlockEntity be;
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (blockEntity instanceof ReinforcedLecternBlockEntity && ((be = (ReinforcedLecternBlockEntity)blockEntity).isOwnedBy((Entity)player) || be.isAllowed((Entity)player))) {
            return super.useWithoutItem(state, level, pos, player, hit);
        }
        return InteractionResult.SUCCESS;
    }

    public void onRemove(BlockState state, Level level, BlockPos pos, BlockState newState, boolean isMoving) {
        BlockEntity blockEntity;
        if (!state.is(newState.getBlock()) && (blockEntity = level.getBlockEntity(pos)) instanceof ReinforcedLecternBlockEntity) {
            ReinforcedLecternBlockEntity be = (ReinforcedLecternBlockEntity)blockEntity;
            if (isMoving) {
                be.clearContent();
            }
            level.updateNeighbourForOutputSignal(pos, (Block)this);
        }
        super.onRemove(state, level, pos, newState, isMoving);
    }

    public void openScreen(Level level, BlockPos pos, Player player) {
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (blockEntity instanceof ReinforcedLecternBlockEntity) {
            ReinforcedLecternBlockEntity be = (ReinforcedLecternBlockEntity)blockEntity;
            player.openMenu((MenuProvider)be, pos);
            player.awardStat(Stats.INTERACT_WITH_LECTERN);
        }
    }

    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return new ReinforcedLecternBlockEntity(pos, state);
    }

    @Override
    public Block getVanillaBlock() {
        return Blocks.LECTERN;
    }
}

