/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.blocks.reinforced;

import net.geforcemods.securitycraft.api.IReinforcedBlock;
import net.geforcemods.securitycraft.api.OwnableBlockEntity;
import net.geforcemods.securitycraft.misc.OwnershipEvent;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.FenceBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.bus.api.Event;
import net.neoforged.neoforge.common.NeoForge;

public class ReinforcedFenceBlock
extends FenceBlock
implements IReinforcedBlock,
EntityBlock {
    private final Block vanillaBlock;

    public ReinforcedFenceBlock(BlockBehaviour.Properties properties, Block vanillaBlock) {
        super(properties);
        this.vanillaBlock = vanillaBlock;
    }

    public void setPlacedBy(Level level, BlockPos pos, BlockState state, LivingEntity placer, ItemStack stack) {
        if (placer instanceof Player) {
            Player player = (Player)placer;
            NeoForge.EVENT_BUS.post((Event)new OwnershipEvent(level, pos, player));
        }
    }

    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return new OwnableBlockEntity(pos, state);
    }

    @Override
    public Block getVanillaBlock() {
        return this.vanillaBlock;
    }
}

