/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.blocks.mines;

import net.geforcemods.securitycraft.ConfigHandler;
import net.geforcemods.securitycraft.SCContent;
import net.geforcemods.securitycraft.api.IExtractionBlock;
import net.geforcemods.securitycraft.api.IModuleInventory;
import net.geforcemods.securitycraft.api.IOwnable;
import net.geforcemods.securitycraft.blockentities.IMSBlockEntity;
import net.geforcemods.securitycraft.blocks.OwnableBlock;
import net.geforcemods.securitycraft.blocks.mines.BouncingBettyBlock;
import net.geforcemods.securitycraft.util.LevelUtils;
import net.geforcemods.securitycraft.util.Utils;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.chat.Component;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class IMSBlock
extends OwnableBlock
implements SimpleWaterloggedBlock {
    public static final IntegerProperty MINES = IntegerProperty.create((String)"mines", (int)0, (int)4);
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.WATERLOGGED;
    private static final VoxelShape SHAPE = Block.box((double)4.0, (double)0.0, (double)5.0, (double)12.0, (double)7.0, (double)11.0);
    private static final VoxelShape SHAPE_1_MINE = Shapes.or((VoxelShape)SHAPE, (VoxelShape)Block.box((double)0.0, (double)0.0, (double)0.0, (double)5.0, (double)5.0, (double)5.0));
    private static final VoxelShape SHAPE_2_MINES = Shapes.or((VoxelShape)SHAPE_1_MINE, (VoxelShape)Block.box((double)0.0, (double)0.0, (double)11.0, (double)5.0, (double)5.0, (double)16.0));
    private static final VoxelShape SHAPE_3_MINES = Shapes.or((VoxelShape)SHAPE_2_MINES, (VoxelShape)Block.box((double)11.0, (double)0.0, (double)0.0, (double)16.0, (double)5.0, (double)5.0));
    private static final VoxelShape SHAPE_4_MINES = Shapes.or((VoxelShape)SHAPE_3_MINES, (VoxelShape)Block.box((double)11.0, (double)0.0, (double)11.0, (double)16.0, (double)5.0, (double)16.0));

    public IMSBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)MINES, (Comparable)Integer.valueOf(4))).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    public float getDestroyProgress(BlockState state, Player player, BlockGetter level, BlockPos pos) {
        return (Boolean)ConfigHandler.SERVER.ableToBreakMines.get() == false ? -1.0f : super.getDestroyProgress(state, player, level, pos);
    }

    public VoxelShape getShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext ctx) {
        return switch ((Integer)state.getValue((Property)MINES)) {
            case 4 -> SHAPE_4_MINES;
            case 3 -> SHAPE_3_MINES;
            case 2 -> SHAPE_2_MINES;
            case 1 -> SHAPE_1_MINE;
            default -> SHAPE;
        };
    }

    public void neighborChanged(BlockState state, Level level, BlockPos pos, Block blockIn, BlockPos fromPos, boolean flag) {
        if (level.getBlockState(pos.below()).isAir()) {
            level.destroyBlock(pos, true);
        }
    }

    public BlockState playerWillDestroy(Level level, BlockPos pos, BlockState state, Player player) {
        BlockEntity blockEntity;
        if (player.isCreative() && (blockEntity = level.getBlockEntity(pos)) instanceof IModuleInventory) {
            IModuleInventory inv = (IModuleInventory)blockEntity;
            inv.getInventory().clear();
        }
        return super.playerWillDestroy(level, pos, state, player);
    }

    public void onRemove(BlockState state, Level level, BlockPos pos, BlockState newState, boolean isMoving) {
        BlockEntity blockEntity;
        if (!state.is(newState.getBlock()) && (blockEntity = level.getBlockEntity(pos)) instanceof IModuleInventory) {
            IModuleInventory inv = (IModuleInventory)blockEntity;
            inv.dropAllModules();
        }
        super.onRemove(state, level, pos, newState, isMoving);
    }

    public ItemInteractionResult useItemOn(ItemStack stack, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (blockEntity instanceof IMSBlockEntity) {
            IMSBlockEntity be = (IMSBlockEntity)blockEntity;
            if (be.isDisabled()) {
                player.displayClientMessage((Component)Utils.localize("gui.securitycraft:scManual.disabled", new Object[0]), true);
            } else if (be.isOwnedBy((Entity)player)) {
                int mines = (Integer)state.getValue((Property)MINES);
                if (stack.getItem() == ((BouncingBettyBlock)SCContent.BOUNCING_BETTY.get()).asItem() && mines < 4) {
                    if (!player.isCreative()) {
                        stack.shrink(1);
                    }
                    level.setBlockAndUpdate(pos, (BlockState)state.setValue((Property)MINES, (Comparable)Integer.valueOf(mines + 1)));
                    be.setBombsRemaining(mines + 1);
                    return ItemInteractionResult.sidedSuccess((boolean)level.isClientSide);
                }
            }
        }
        return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
    }

    public void animateTick(BlockState state, Level level, BlockPos pos, RandomSource random) {
        if ((Integer)state.getValue((Property)MINES) == 0) {
            double x = (double)((float)pos.getX() + 0.5f) + (double)(random.nextFloat() - 0.5f) * 0.2;
            double y = (double)((float)pos.getY() + 0.4f) + (double)(random.nextFloat() - 0.5f) * 0.2;
            double z = (double)((float)pos.getZ() + 0.5f) + (double)(random.nextFloat() - 0.5f) * 0.2;
            double magicNumber1 = 0.22f;
            double magicNumber2 = 0.27f;
            level.addParticle((ParticleOptions)ParticleTypes.SMOKE, false, x - magicNumber2, y + magicNumber1, z, 0.0, 0.0, 0.0);
            level.addParticle((ParticleOptions)ParticleTypes.SMOKE, false, x + magicNumber2, y + magicNumber1, z, 0.0, 0.0, 0.0);
            level.addParticle((ParticleOptions)ParticleTypes.SMOKE, false, x, y + magicNumber1, z - magicNumber2, 0.0, 0.0, 0.0);
            level.addParticle((ParticleOptions)ParticleTypes.SMOKE, false, x, y + magicNumber1, z + magicNumber2, 0.0, 0.0, 0.0);
            level.addParticle((ParticleOptions)ParticleTypes.SMOKE, false, x, y, z, 0.0, 0.0, 0.0);
            level.addParticle((ParticleOptions)ParticleTypes.FLAME, false, x - magicNumber2, y + magicNumber1, z, 0.0, 0.0, 0.0);
            level.addParticle((ParticleOptions)ParticleTypes.FLAME, false, x + magicNumber2, y + magicNumber1, z, 0.0, 0.0, 0.0);
        }
    }

    public BlockState getStateForPlacement(BlockPlaceContext ctx) {
        return (BlockState)((BlockState)this.defaultBlockState().setValue((Property)MINES, (Comparable)Integer.valueOf(4))).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(ctx.getLevel().getFluidState(ctx.getClickedPos()).getType() == Fluids.WATER));
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{MINES, WATERLOGGED});
    }

    public BlockState updateShape(BlockState state, Direction facing, BlockState facingState, LevelAccessor level, BlockPos currentPos, BlockPos facingPos) {
        if (((Boolean)state.getValue((Property)WATERLOGGED)).booleanValue()) {
            level.scheduleTick(currentPos, (Fluid)Fluids.WATER, Fluids.WATER.getTickDelay((LevelReader)level));
        }
        return super.updateShape(state, facing, facingState, level, currentPos, facingPos);
    }

    public FluidState getFluidState(BlockState state) {
        return (Boolean)state.getValue((Property)WATERLOGGED) != false ? Fluids.WATER.getSource(false) : super.getFluidState(state);
    }

    @Override
    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return new IMSBlockEntity(pos, state);
    }

    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(Level level, BlockState state, BlockEntityType<T> type) {
        return IMSBlock.createTickerHelper(type, (BlockEntityType)((BlockEntityType)SCContent.IMS_BLOCK_ENTITY.get()), LevelUtils::blockEntityTicker);
    }

    public static class ExtractionBlock
    implements IExtractionBlock {
        @Override
        public boolean canExtract(IOwnable ownable, Level level, BlockPos pos, BlockState state) {
            return ownable.getOwner().owns((IMSBlockEntity)level.getBlockEntity(pos));
        }

        @Override
        public Block getBlock() {
            return (Block)SCContent.IMS.get();
        }
    }
}

