/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.blocks;

import net.geforcemods.securitycraft.SCContent;
import net.geforcemods.securitycraft.api.IDisguisable;
import net.geforcemods.securitycraft.blockentities.RiftStabilizerBlockEntity;
import net.geforcemods.securitycraft.blocks.DisguisableBlock;
import net.geforcemods.securitycraft.misc.ModuleType;
import net.geforcemods.securitycraft.misc.OwnershipEvent;
import net.geforcemods.securitycraft.network.client.OpenScreen;
import net.geforcemods.securitycraft.util.BlockUtils;
import net.geforcemods.securitycraft.util.LevelUtils;
import net.geforcemods.securitycraft.util.Utils;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.SignalGetter;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.DoublePlantBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.DoubleBlockHalf;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.neoforged.bus.api.Event;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.network.PacketDistributor;

public class RiftStabilizerBlock
extends DisguisableBlock {
    public static final DirectionProperty FACING = BlockStateProperties.HORIZONTAL_FACING;
    public static final EnumProperty<DoubleBlockHalf> HALF = BlockStateProperties.DOUBLE_BLOCK_HALF;
    public static final BooleanProperty POWERED = BlockStateProperties.POWERED;
    private static final VoxelShape SHAPE_LOWER = Shapes.or((VoxelShape)Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)12.0, (double)16.0), (VoxelShape)Block.box((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)16.0, (double)14.0));
    private static final VoxelShape SHAPE_UPPER = Shapes.or((VoxelShape)Block.box((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)5.0, (double)14.0), (VoxelShape)Block.box((double)4.0, (double)0.0, (double)4.0, (double)12.0, (double)8.0, (double)12.0));

    public RiftStabilizerBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)FACING, (Comparable)Direction.NORTH)).setValue(HALF, (Comparable)DoubleBlockHalf.LOWER)).setValue((Property)POWERED, (Comparable)Boolean.valueOf(false))).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    public void tick(BlockState state, ServerLevel level, BlockPos pos, RandomSource random) {
        if (((Boolean)state.getValue((Property)POWERED)).booleanValue()) {
            level.setBlockAndUpdate(pos, (BlockState)state.setValue((Property)POWERED, (Comparable)Boolean.valueOf(false)));
            BlockUtils.updateIndirectNeighbors((Level)level, pos, (Block)this);
        }
    }

    public InteractionResult useWithoutItem(BlockState state, Level level, BlockPos pos, Player player, BlockHitResult hit) {
        RiftStabilizerBlockEntity be;
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (blockEntity instanceof RiftStabilizerBlockEntity && (be = (RiftStabilizerBlockEntity)blockEntity).isOwnedBy((Entity)player)) {
            if (!level.isClientSide) {
                if (be.isDisabled()) {
                    player.displayClientMessage((Component)Utils.localize("gui.securitycraft:scManual.disabled", new Object[0]), true);
                } else {
                    PacketDistributor.sendToPlayer((ServerPlayer)((ServerPlayer)player), (CustomPacketPayload)new OpenScreen(OpenScreen.DataType.RIFT_STABILIZER, pos), (CustomPacketPayload[])new CustomPacketPayload[0]);
                }
            }
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    @Override
    public BlockState getStateForPlacement(BlockPlaceContext ctx) {
        BlockPos pos = ctx.getClickedPos();
        Level level = ctx.getLevel();
        return pos.getY() < level.getMaxBuildHeight() - 1 && level.getBlockState(pos.above()).canBeReplaced(ctx) ? (BlockState)super.getStateForPlacement(ctx).setValue((Property)FACING, (Comparable)ctx.getHorizontalDirection().getOpposite()) : null;
    }

    @Override
    public void setPlacedBy(Level level, BlockPos pos, BlockState state, LivingEntity placer, ItemStack stack) {
        RiftStabilizerBlockEntity bottom;
        BlockPos posAbove = pos.above();
        level.setBlockAndUpdate(posAbove, DoublePlantBlock.copyWaterloggedFrom((LevelReader)level, (BlockPos)posAbove, (BlockState)((BlockState)this.defaultBlockState().setValue(HALF, (Comparable)DoubleBlockHalf.UPPER))));
        if (placer instanceof Player) {
            Player player = (Player)placer;
            NeoForge.EVENT_BUS.post((Event)new OwnershipEvent(level, posAbove, player));
        }
        super.setPlacedBy(level, pos, state, placer, stack);
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (blockEntity instanceof RiftStabilizerBlockEntity && (bottom = (RiftStabilizerBlockEntity)blockEntity).hasCustomName() && (blockEntity = level.getBlockEntity(posAbove)) instanceof RiftStabilizerBlockEntity) {
            RiftStabilizerBlockEntity above = (RiftStabilizerBlockEntity)blockEntity;
            above.setCustomName(bottom.getCustomName());
        }
    }

    @Override
    public BlockState updateShape(BlockState state, Direction facing, BlockState facingState, LevelAccessor level, BlockPos currentPos, BlockPos facingPos) {
        DoubleBlockHalf half = (DoubleBlockHalf)state.getValue(HALF);
        if (facing.getAxis() == Direction.Axis.Y && half == DoubleBlockHalf.LOWER == (facing == Direction.UP)) {
            return facingState.is((Block)this) && facingState.getValue(HALF) != half ? (BlockState)state.setValue((Property)POWERED, (Comparable)((Boolean)facingState.getValue((Property)POWERED))) : Blocks.AIR.defaultBlockState();
        }
        return half == DoubleBlockHalf.LOWER && facing == Direction.DOWN && !state.canSurvive((LevelReader)level, currentPos) ? Blocks.AIR.defaultBlockState() : super.updateShape(state, facing, facingState, level, currentPos, facingPos);
    }

    @Override
    public VoxelShape getShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext ctx) {
        BlockState disguisedState = IDisguisable.getDisguisedStateOrDefault(state, level, pos);
        if (disguisedState.getBlock() != this) {
            return disguisedState.getShape(level, pos, ctx);
        }
        return state.getValue(HALF) == DoubleBlockHalf.LOWER ? SHAPE_LOWER : SHAPE_UPPER;
    }

    public BlockState playerWillDestroy(Level level, BlockPos pos, BlockState state, Player player) {
        if (!level.isClientSide) {
            if (player.isCreative()) {
                DoublePlantBlock.preventDropFromBottomPart((Level)level, (BlockPos)pos, (BlockState)state, (Player)player);
            } else {
                RiftStabilizerBlock.dropResources((BlockState)state, (Level)level, (BlockPos)pos, null, (Entity)player, (ItemStack)player.getMainHandItem());
            }
        }
        return super.playerWillDestroy(level, pos, state, player);
    }

    public void playerDestroy(Level level, Player player, BlockPos pos, BlockState state, BlockEntity be, ItemStack stack) {
        super.playerDestroy(level, player, pos, Blocks.AIR.defaultBlockState(), be, stack);
    }

    public boolean isSignalSource(BlockState state) {
        return true;
    }

    public boolean shouldCheckWeakPower(BlockState state, SignalGetter level, BlockPos pos, Direction side) {
        return false;
    }

    public int getSignal(BlockState state, BlockGetter level, BlockPos pos, Direction side) {
        int n;
        BlockEntity blockEntity;
        if (((Boolean)state.getValue((Property)POWERED)).booleanValue() && state.getValue(HALF) == DoubleBlockHalf.LOWER && (blockEntity = level.getBlockEntity(pos)) instanceof RiftStabilizerBlockEntity) {
            RiftStabilizerBlockEntity be = (RiftStabilizerBlockEntity)blockEntity;
            n = 15 - (int)be.getLastTeleportDistance();
        } else {
            n = 0;
        }
        return n;
    }

    public int getDirectSignal(BlockState state, BlockGetter level, BlockPos pos, Direction side) {
        return this.getSignal(state, level, pos, side);
    }

    public boolean hasAnalogOutputSignal(BlockState state) {
        return true;
    }

    public int getAnalogOutputSignal(BlockState state, Level level, BlockPos pos) {
        RiftStabilizerBlockEntity be;
        BlockEntity blockEntity;
        return state.getValue(HALF) == DoubleBlockHalf.LOWER && (blockEntity = level.getBlockEntity(pos)) instanceof RiftStabilizerBlockEntity && (be = (RiftStabilizerBlockEntity)blockEntity).isModuleEnabled(ModuleType.REDSTONE) && be.getLastTeleportationType() != null ? be.getComparatorOutputFunction().applyAsInt(be.getLastTeleportationType()) : 0;
    }

    public static RiftStabilizerBlockEntity getConnectedBlockEntity(Level level, BlockPos pos) {
        RiftStabilizerBlockEntity be;
        BlockState state = level.getBlockState(pos);
        BlockPos connectedPos = state.getValue(HALF) == DoubleBlockHalf.LOWER ? pos.above() : pos.below();
        BlockEntity blockEntity = level.getBlockEntity(connectedPos);
        return blockEntity instanceof RiftStabilizerBlockEntity ? (be = (RiftStabilizerBlockEntity)blockEntity) : null;
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{FACING, HALF, POWERED, WATERLOGGED});
    }

    public boolean canSurvive(BlockState state, LevelReader level, BlockPos pos) {
        BlockPos lowerPos = pos.below();
        BlockState lowerState = level.getBlockState(lowerPos);
        return state.getValue(HALF) == DoubleBlockHalf.LOWER || lowerState.is((Block)this);
    }

    @Override
    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return new RiftStabilizerBlockEntity(pos, state);
    }

    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(Level level, BlockState state, BlockEntityType<T> type) {
        return state.getValue(HALF) == DoubleBlockHalf.LOWER ? RiftStabilizerBlock.createTickerHelper(type, (BlockEntityType)((BlockEntityType)SCContent.RIFT_STABILIZER_BLOCK_ENTITY.get()), LevelUtils::blockEntityTicker) : null;
    }
}

