/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.blocks;

import net.geforcemods.securitycraft.blockentities.PanicButtonBlockEntity;
import net.geforcemods.securitycraft.misc.OwnershipEvent;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.ButtonBlock;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.AttachFace;
import net.minecraft.world.level.block.state.properties.BlockSetType;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.neoforged.bus.api.Event;
import net.neoforged.neoforge.common.NeoForge;

public class PanicButtonBlock
extends ButtonBlock
implements EntityBlock,
SimpleWaterloggedBlock {
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.WATERLOGGED;
    private static final VoxelShape FLOOR_NS_POWERED = Block.box((double)3.0, (double)0.0, (double)5.0, (double)13.0, (double)1.0, (double)11.0);
    private static final VoxelShape FLOOR_NS_UNPOWERED = Block.box((double)3.0, (double)0.0, (double)5.0, (double)13.0, (double)2.0, (double)11.0);
    private static final VoxelShape FLOOR_EW_POWERED = Block.box((double)5.0, (double)0.0, (double)3.0, (double)11.0, (double)1.0, (double)13.0);
    private static final VoxelShape FLOOR_EW_UNPOWERED = Block.box((double)5.0, (double)0.0, (double)3.0, (double)11.0, (double)2.0, (double)13.0);
    private static final VoxelShape WALL_N_POWERED = Block.box((double)3.0, (double)5.0, (double)15.0, (double)13.0, (double)11.0, (double)16.0);
    private static final VoxelShape WALL_N_UNPOWERED = Block.box((double)3.0, (double)5.0, (double)14.0, (double)13.0, (double)11.0, (double)16.0);
    private static final VoxelShape WALL_S_POWERED = Block.box((double)3.0, (double)5.0, (double)0.0, (double)13.0, (double)11.0, (double)1.0);
    private static final VoxelShape WALL_S_UNPOWERED = Block.box((double)3.0, (double)5.0, (double)0.0, (double)13.0, (double)11.0, (double)2.0);
    private static final VoxelShape WALL_E_POWERED = Block.box((double)0.0, (double)5.0, (double)3.0, (double)1.0, (double)11.0, (double)13.0);
    private static final VoxelShape WALL_E_UNPOWERED = Block.box((double)0.0, (double)5.0, (double)3.0, (double)2.0, (double)11.0, (double)13.0);
    private static final VoxelShape WALL_W_POWERED = Block.box((double)15.0, (double)5.0, (double)3.0, (double)16.0, (double)11.0, (double)13.0);
    private static final VoxelShape WALL_W_UNPOWERED = Block.box((double)14.0, (double)5.0, (double)3.0, (double)16.0, (double)11.0, (double)13.0);
    private static final VoxelShape CEILING_NS_POWERED = Block.box((double)3.0, (double)15.0, (double)5.0, (double)13.0, (double)16.0, (double)11.0);
    private static final VoxelShape CEILING_NS_UNPOWERED = Block.box((double)3.0, (double)14.0, (double)5.0, (double)13.0, (double)16.0, (double)11.0);
    private static final VoxelShape CEILING_EW_POWERED = Block.box((double)5.0, (double)15.0, (double)3.0, (double)11.0, (double)16.0, (double)13.0);
    private static final VoxelShape CEILING_EW_UNPOWERED = Block.box((double)5.0, (double)14.0, (double)3.0, (double)11.0, (double)16.0, (double)13.0);

    public PanicButtonBlock(BlockBehaviour.Properties properties, BlockSetType blockSetType, int ticksToStayPressed) {
        super(blockSetType, ticksToStayPressed, properties);
        this.registerDefaultState((BlockState)this.defaultBlockState().setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    public BlockState getStateForPlacement(BlockPlaceContext ctx) {
        BlockState superState = super.getStateForPlacement(ctx);
        if (superState != null) {
            return (BlockState)superState.setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(ctx.getLevel().getFluidState(ctx.getClickedPos()).getType() == Fluids.WATER));
        }
        return null;
    }

    public void setPlacedBy(Level level, BlockPos pos, BlockState state, LivingEntity placer, ItemStack stack) {
        if (placer instanceof Player) {
            Player player = (Player)placer;
            NeoForge.EVENT_BUS.post((Event)new OwnershipEvent(level, pos, player));
        }
    }

    public InteractionResult useWithoutItem(BlockState state, Level level, BlockPos pos, Player player, BlockHitResult hit) {
        PanicButtonBlockEntity be;
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (blockEntity instanceof PanicButtonBlockEntity && ((be = (PanicButtonBlockEntity)blockEntity).isOwnedBy((Entity)player) || be.isAllowed((Entity)player))) {
            boolean newPowered = (Boolean)state.getValue((Property)POWERED) == false;
            level.setBlockAndUpdate(pos, (BlockState)state.setValue((Property)POWERED, (Comparable)Boolean.valueOf(newPowered)));
            this.playSound(player, (LevelAccessor)level, pos, newPowered);
            this.notifyNeighbors(level, pos, switch ((AttachFace)state.getValue((Property)FACE)) {
                default -> throw new MatchException(null, null);
                case AttachFace.WALL -> (Direction)state.getValue((Property)FACING);
                case AttachFace.CEILING -> Direction.DOWN;
                case AttachFace.FLOOR -> Direction.UP;
            });
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.FAIL;
    }

    private void notifyNeighbors(Level level, BlockPos pos, Direction facing) {
        level.updateNeighborsAt(pos, (Block)this);
        level.updateNeighborsAt(pos.relative(facing.getOpposite()), (Block)this);
    }

    public boolean triggerEvent(BlockState state, Level level, BlockPos pos, int id, int param) {
        BlockEntity be = level.getBlockEntity(pos);
        return be != null && be.triggerEvent(id, param);
    }

    public BlockState updateShape(BlockState state, Direction facing, BlockState facingState, LevelAccessor level, BlockPos currentPos, BlockPos facingPos) {
        if (((Boolean)state.getValue((Property)WATERLOGGED)).booleanValue()) {
            level.scheduleTick(currentPos, (Fluid)Fluids.WATER, Fluids.WATER.getTickDelay((LevelReader)level));
        }
        return super.updateShape(state, facing, facingState, level, currentPos, facingPos);
    }

    public FluidState getFluidState(BlockState state) {
        return (Boolean)state.getValue((Property)WATERLOGGED) != false ? Fluids.WATER.getSource(false) : super.getFluidState(state);
    }

    public VoxelShape getShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext ctx) {
        return switch ((AttachFace)state.getValue((Property)FACE)) {
            case AttachFace.FLOOR -> {
                switch ((Direction)state.getValue((Property)FACING)) {
                    case NORTH: 
                    case SOUTH: {
                        if (((Boolean)state.getValue((Property)POWERED)).booleanValue()) {
                            yield FLOOR_NS_POWERED;
                        }
                        yield FLOOR_NS_UNPOWERED;
                    }
                    case EAST: 
                    case WEST: {
                        if (((Boolean)state.getValue((Property)POWERED)).booleanValue()) {
                            yield FLOOR_EW_POWERED;
                        }
                        yield FLOOR_EW_UNPOWERED;
                    }
                }
                yield Shapes.block();
            }
            case AttachFace.WALL -> {
                switch ((Direction)state.getValue((Property)FACING)) {
                    case NORTH: {
                        if (((Boolean)state.getValue((Property)POWERED)).booleanValue()) {
                            yield WALL_N_POWERED;
                        }
                        yield WALL_N_UNPOWERED;
                    }
                    case SOUTH: {
                        if (((Boolean)state.getValue((Property)POWERED)).booleanValue()) {
                            yield WALL_S_POWERED;
                        }
                        yield WALL_S_UNPOWERED;
                    }
                    case EAST: {
                        if (((Boolean)state.getValue((Property)POWERED)).booleanValue()) {
                            yield WALL_E_POWERED;
                        }
                        yield WALL_E_UNPOWERED;
                    }
                    case WEST: {
                        if (((Boolean)state.getValue((Property)POWERED)).booleanValue()) {
                            yield WALL_W_POWERED;
                        }
                        yield WALL_W_UNPOWERED;
                    }
                }
                yield Shapes.block();
            }
            case AttachFace.CEILING -> {
                switch ((Direction)state.getValue((Property)FACING)) {
                    case NORTH: 
                    case SOUTH: {
                        if (((Boolean)state.getValue((Property)POWERED)).booleanValue()) {
                            yield CEILING_NS_POWERED;
                        }
                        yield CEILING_NS_UNPOWERED;
                    }
                    case EAST: 
                    case WEST: {
                        if (((Boolean)state.getValue((Property)POWERED)).booleanValue()) {
                            yield CEILING_EW_POWERED;
                        }
                        yield CEILING_EW_UNPOWERED;
                    }
                }
                yield Shapes.block();
            }
            default -> Shapes.block();
        };
    }

    public VoxelShape getCollisionShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext ctx) {
        return Shapes.empty();
    }

    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return new PanicButtonBlockEntity(pos, state);
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder);
        builder.add(new Property[]{WATERLOGGED});
    }
}

