/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.blocks;

import net.geforcemods.securitycraft.ConfigHandler;
import net.geforcemods.securitycraft.SCContent;
import net.geforcemods.securitycraft.api.IOwnable;
import net.geforcemods.securitycraft.blockentities.LaserBlockBlockEntity;
import net.geforcemods.securitycraft.blocks.DisguisableBlock;
import net.geforcemods.securitycraft.blocks.LaserFieldBlock;
import net.geforcemods.securitycraft.inventory.LensContainer;
import net.geforcemods.securitycraft.misc.ModuleType;
import net.geforcemods.securitycraft.util.BlockUtils;
import net.geforcemods.securitycraft.util.LevelUtils;
import net.geforcemods.securitycraft.util.PlayerUtils;
import net.geforcemods.securitycraft.util.Utils;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.DustParticleOptions;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Container;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.SignalGetter;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import org.joml.Vector3f;

public class LaserBlock
extends DisguisableBlock {
    public static final BooleanProperty POWERED = BlockStateProperties.POWERED;

    public LaserBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)POWERED, (Comparable)Boolean.valueOf(false))).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    @Override
    public void setPlacedBy(Level level, BlockPos pos, BlockState state, LivingEntity entity, ItemStack stack) {
        Player player;
        super.setPlacedBy(level, pos, state, entity, stack);
        this.setLaser(level, pos, entity instanceof Player ? (player = (Player)entity) : null);
    }

    public InteractionResult useWithoutItem(BlockState state, Level level, BlockPos pos, Player player, BlockHitResult hit) {
        LaserBlockBlockEntity be = (LaserBlockBlockEntity)level.getBlockEntity(pos);
        if (be.isOwnedBy((Entity)player)) {
            if (!level.isClientSide) {
                if (!be.isEnabled()) {
                    player.displayClientMessage((Component)Utils.localize("gui.securitycraft:scManual.disabled", new Object[0]), true);
                } else {
                    player.openMenu((MenuProvider)be, buf -> {
                        buf.writeBlockPos(pos);
                        buf.writeNbt((Tag)LaserBlockBlockEntity.saveSideConfig(be.getSideConfig()));
                    });
                }
            }
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    public void setLaser(Level level, BlockPos pos, Player player) {
        for (Direction facing : Direction.values()) {
            this.setLaser(level, pos, facing, player);
        }
    }

    public void setLaser(Level level, BlockPos pos, Direction facing, Player player) {
        LaserBlockBlockEntity thisBe = (LaserBlockBlockEntity)level.getBlockEntity(pos);
        if (!thisBe.isEnabled() || !thisBe.isSideEnabled(facing)) {
            return;
        }
        int boundType = LaserFieldBlock.getBoundType(facing);
        for (int i = 1; i <= (Integer)ConfigHandler.SERVER.laserBlockRange.get(); ++i) {
            BlockPos offsetPos = pos.relative(facing, i);
            BlockState offsetState = level.getBlockState(offsetPos);
            Block offsetBlock = offsetState.getBlock();
            if (!offsetState.isAir() && !offsetState.canBeReplaced() && offsetBlock != SCContent.LASER_BLOCK.get()) {
                return;
            }
            if (offsetBlock != SCContent.LASER_BLOCK.get()) continue;
            LaserBlockBlockEntity thatBe = (LaserBlockBlockEntity)level.getBlockEntity(offsetPos);
            if (thisBe.getOwner().owns(thatBe) && thatBe.isEnabled()) {
                if (!thatBe.isSideEnabled(facing.getOpposite())) {
                    thisBe.setSideEnabled(facing, false, null);
                    return;
                }
                ModuleType failedType = thisBe.synchronizeWith(thatBe);
                if (failedType != null) {
                    if (player != null) {
                        PlayerUtils.sendMessageToPlayer(player, Utils.localize(this.getDescriptionId(), new Object[0]), Utils.localize("messages.securitycraft:laser.sync_failed", Utils.getFormattedCoordinates(thatBe.getBlockPos()), Utils.localize(failedType.getTranslationKey(), new Object[0])), ChatFormatting.RED);
                        thisBe.setSideEnabled(facing, false, null);
                        thatBe.setSideEnabled(facing.getOpposite(), false, null);
                        player.closeContainer();
                    }
                    return;
                }
                for (int j = 1; j < i; ++j) {
                    offsetPos = pos.relative(facing, j);
                    offsetState = level.getBlockState(offsetPos);
                    if (!offsetState.isAir() && !offsetState.canBeReplaced()) continue;
                    level.setBlockAndUpdate(offsetPos, ((LaserFieldBlock)SCContent.LASER_FIELD.get()).getPotentiallyWaterloggedState(boundType, level, offsetPos));
                    BlockEntity blockEntity = level.getBlockEntity(offsetPos);
                    if (!(blockEntity instanceof IOwnable)) continue;
                    IOwnable ownable = (IOwnable)blockEntity;
                    ownable.setOwner(thisBe.getOwner().getUUID(), thisBe.getOwner().getName());
                }
                thatBe.getLensContainer().setChanged();
            }
            return;
        }
    }

    public void destroy(LevelAccessor level, BlockPos pos, BlockState state) {
        if (!level.isClientSide()) {
            LaserBlock.destroyAdjacentLasers(level, pos);
        }
    }

    public void onRemove(BlockState state, Level level, BlockPos pos, BlockState newState, boolean isMoving) {
        BlockEntity blockEntity;
        if (!state.is(newState.getBlock()) && (blockEntity = level.getBlockEntity(pos)) instanceof LaserBlockBlockEntity) {
            LaserBlockBlockEntity be = (LaserBlockBlockEntity)blockEntity;
            LensContainer lensContainer = be.getLensContainer();
            Containers.dropContents((Level)level, (BlockPos)pos, (Container)lensContainer);
            lensContainer.clearContent();
            level.updateNeighbourForOutputSignal(pos, (Block)this);
        }
        super.onRemove(state, level, pos, newState, isMoving);
    }

    public static void destroyAdjacentLasers(LevelAccessor level, BlockPos pos) {
        BlockUtils.removeInSequence((direction, state) -> {
            if (state.getBlock() != SCContent.LASER_FIELD.get()) {
                return false;
            }
            return (Integer)state.getValue((Property)LaserFieldBlock.BOUNDTYPE) == LaserFieldBlock.getBoundType(direction);
        }, level, pos, Direction.values());
    }

    public void neighborChanged(BlockState state, Level level, BlockPos pos, Block block, BlockPos fromPos, boolean flag) {
        this.setLaser(level, pos, null);
    }

    public boolean isSignalSource(BlockState state) {
        return true;
    }

    public boolean shouldCheckWeakPower(BlockState state, SignalGetter level, BlockPos pos, Direction side) {
        return false;
    }

    public int getSignal(BlockState state, BlockGetter level, BlockPos pos, Direction side) {
        LaserBlockBlockEntity be;
        BlockEntity blockEntity;
        return (Boolean)state.getValue((Property)POWERED) != false && (blockEntity = level.getBlockEntity(pos)) instanceof LaserBlockBlockEntity && (be = (LaserBlockBlockEntity)blockEntity).isModuleEnabled(ModuleType.REDSTONE) ? 15 : 0;
    }

    public int getDirectSignal(BlockState state, BlockGetter level, BlockPos pos, Direction side) {
        return this.getSignal(state, level, pos, side);
    }

    public void tick(BlockState state, ServerLevel level, BlockPos pos, RandomSource random) {
        if (!level.isClientSide && ((Boolean)state.getValue((Property)POWERED)).booleanValue()) {
            level.setBlockAndUpdate(pos, (BlockState)state.setValue((Property)POWERED, (Comparable)Boolean.valueOf(false)));
            BlockUtils.updateIndirectNeighbors((Level)level, pos, (Block)SCContent.LASER_BLOCK.get());
        }
    }

    public void animateTick(BlockState state, Level level, BlockPos pos, RandomSource rand) {
        if (((Boolean)state.getValue((Property)POWERED)).booleanValue()) {
            double x = (double)((float)pos.getX() + 0.5f) + (double)(rand.nextFloat() - 0.5f) * 0.2;
            double y = (double)((float)pos.getY() + 0.7f) + (double)(rand.nextFloat() - 0.5f) * 0.2;
            double z = (double)((float)pos.getZ() + 0.5f) + (double)(rand.nextFloat() - 0.5f) * 0.2;
            double magicNumber1 = 0.22f;
            double magicNumber2 = 0.27f;
            float r = 1.0f;
            float g = Math.max(0.0f, 0.19999999f);
            float b = Math.max(0.0f, -0.099999964f);
            Vector3f vec = new Vector3f(r, g, b);
            level.addParticle((ParticleOptions)new DustParticleOptions(vec, 1.0f), false, x - magicNumber2, y + magicNumber1, z, 0.0, 0.0, 0.0);
            level.addParticle((ParticleOptions)new DustParticleOptions(vec, 1.0f), false, x + magicNumber2, y + magicNumber1, z, 0.0, 0.0, 0.0);
            level.addParticle((ParticleOptions)new DustParticleOptions(vec, 1.0f), false, x, y + magicNumber1, z - magicNumber2, 0.0, 0.0, 0.0);
            level.addParticle((ParticleOptions)new DustParticleOptions(vec, 1.0f), false, x, y + magicNumber1, z + magicNumber2, 0.0, 0.0, 0.0);
            level.addParticle((ParticleOptions)new DustParticleOptions(vec, 1.0f), false, x, y, z, 0.0, 0.0, 0.0);
        }
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{POWERED, WATERLOGGED});
    }

    @Override
    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return new LaserBlockBlockEntity(pos, state);
    }

    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(Level level, BlockState state, BlockEntityType<T> type) {
        return BaseEntityBlock.createTickerHelper(type, (BlockEntityType)((BlockEntityType)SCContent.LASER_BLOCK_BLOCK_ENTITY.get()), LevelUtils::blockEntityTicker);
    }
}

