/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.blocks;

import java.util.function.Consumer;
import net.geforcemods.securitycraft.SCContent;
import net.geforcemods.securitycraft.api.IOwnable;
import net.geforcemods.securitycraft.api.Owner;
import net.geforcemods.securitycraft.blockentities.CageTrapBlockEntity;
import net.geforcemods.securitycraft.blockentities.DisguisableBlockEntity;
import net.geforcemods.securitycraft.blockentities.ReinforcedIronBarsBlockEntity;
import net.geforcemods.securitycraft.blocks.DisguisableBlock;
import net.geforcemods.securitycraft.blocks.reinforced.HorizontalReinforcedIronBars;
import net.geforcemods.securitycraft.blocks.reinforced.ReinforcedIronBarsBlock;
import net.geforcemods.securitycraft.items.ModuleItem;
import net.geforcemods.securitycraft.misc.ModuleType;
import net.geforcemods.securitycraft.util.PlayerUtils;
import net.geforcemods.securitycraft.util.Utils;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.OwnableEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.EntityCollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class CageTrapBlock
extends DisguisableBlock {
    public static final BooleanProperty DEACTIVATED = BooleanProperty.create((String)"deactivated");

    public CageTrapBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)DEACTIVATED, (Comparable)Boolean.valueOf(false))).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    @Override
    public VoxelShape getCollisionShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext collisionContext) {
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (blockEntity instanceof CageTrapBlockEntity) {
            EntityCollisionContext ctx;
            CageTrapBlockEntity be = (CageTrapBlockEntity)blockEntity;
            if (collisionContext instanceof EntityCollisionContext && (ctx = (EntityCollisionContext)collisionContext).getEntity() != null) {
                OwnableEntity ownableEntity;
                Player player;
                Entity entity = ctx.getEntity();
                if (be.isDisabled()) {
                    return this.getCorrectShape(state, level, pos, (CollisionContext)ctx, be);
                }
                if (entity instanceof Player && (be.isOwnedBy((Entity)(player = (Player)entity)) && be.ignoresOwner() || be.isAllowed((Entity)player)) || entity instanceof OwnableEntity && be.allowsOwnableEntity(ownableEntity = (OwnableEntity)entity)) {
                    return this.getCorrectShape(state, level, pos, collisionContext, be);
                }
                if (entity instanceof Mob && !((Boolean)state.getValue((Property)DEACTIVATED)).booleanValue()) {
                    return be.capturesMobs() ? Shapes.empty() : this.getCorrectShape(state, level, pos, collisionContext, be);
                }
                if (entity instanceof ItemEntity) {
                    return this.getCorrectShape(state, level, pos, collisionContext, be);
                }
            }
            return (Boolean)state.getValue((Property)DEACTIVATED) != false ? this.getCorrectShape(state, level, pos, collisionContext, be) : Shapes.empty();
        }
        return Shapes.empty();
    }

    private VoxelShape getCorrectShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext ctx, DisguisableBlockEntity disguisableTe) {
        ItemStack moduleStack;
        if (disguisableTe.isModuleEnabled(ModuleType.DISGUISE) && !(moduleStack = disguisableTe.getModule(ModuleType.DISGUISE)).isEmpty() && ModuleItem.getBlockAddon(moduleStack) != null) {
            return super.getCollisionShape(state, level, pos, ctx);
        }
        return Shapes.block();
    }

    public void entityInside(BlockState state, Level level, BlockPos pos, Entity entity) {
        if (!level.isClientSide) {
            CageTrapBlockEntity cageTrap = (CageTrapBlockEntity)level.getBlockEntity(pos);
            if (cageTrap.isDisabled()) {
                return;
            }
            boolean isPlayer = entity instanceof Player;
            if (isPlayer || entity instanceof Mob && cageTrap.capturesMobs()) {
                OwnableEntity ownableEntity;
                if (!this.getShape(state, (BlockGetter)level, pos, CollisionContext.of((Entity)entity)).bounds().move(pos).intersects(entity.getBoundingBox())) {
                    return;
                }
                if (isPlayer && cageTrap.isOwnedBy(entity) && cageTrap.ignoresOwner() || entity instanceof OwnableEntity && cageTrap.allowsOwnableEntity(ownableEntity = (OwnableEntity)entity)) {
                    return;
                }
                if (((Boolean)state.getValue((Property)DEACTIVATED)).booleanValue()) {
                    return;
                }
                BlockPos topMiddle = pos.above(4);
                Owner owner = cageTrap.getOwner();
                String ownerUUID = owner.getUUID();
                String ownerName = owner.getName();
                CageTrapBlock.loopIronBarPositions(pos.mutable(), barPos -> {
                    BlockEntity barBe;
                    if (level.isEmptyBlock((BlockPos)barPos) || level.getBlockState((BlockPos)barPos).canBeReplaced()) {
                        if (barPos.equals((Object)topMiddle)) {
                            level.setBlockAndUpdate((BlockPos)barPos, ((HorizontalReinforcedIronBars)SCContent.HORIZONTAL_REINFORCED_IRON_BARS.get()).defaultBlockState());
                        } else {
                            level.setBlockAndUpdate((BlockPos)barPos, ((ReinforcedIronBarsBlock)SCContent.REINFORCED_IRON_BARS.get()).getStateForPlacement((BlockGetter)level, (BlockPos)barPos));
                        }
                    }
                    if ((barBe = level.getBlockEntity((BlockPos)barPos)) instanceof IOwnable) {
                        IOwnable ownable = (IOwnable)barBe;
                        ownable.setOwner(ownerUUID, ownerName);
                    }
                    if (barBe instanceof ReinforcedIronBarsBlockEntity) {
                        ReinforcedIronBarsBlockEntity ironBarsBe = (ReinforcedIronBarsBlockEntity)barBe;
                        ironBarsBe.setCanDrop(false);
                    }
                });
                level.setBlockAndUpdate(pos, (BlockState)state.setValue((Property)DEACTIVATED, (Comparable)Boolean.valueOf(true)));
                level.playSound(null, pos, SoundEvents.ANVIL_USE, SoundSource.BLOCKS, 3.0f, 1.0f);
                level.gameEvent(null, (Holder)GameEvent.BLOCK_PLACE, pos);
                if (isPlayer && PlayerUtils.isPlayerOnline(ownerName)) {
                    PlayerUtils.sendMessageToPlayer(ownerName, Utils.localize(((CageTrapBlock)SCContent.CAGE_TRAP.get()).getDescriptionId(), new Object[0]), Utils.localize("messages.securitycraft:cageTrap.captured", ((Player)entity).getName(), Utils.getFormattedCoordinates(pos)), ChatFormatting.BLACK);
                }
            }
        }
    }

    public ItemInteractionResult useItemOn(ItemStack stack, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        if (stack.getItem() == SCContent.WIRE_CUTTERS.get()) {
            if (!((Boolean)state.getValue((Property)DEACTIVATED)).booleanValue()) {
                level.setBlockAndUpdate(pos, (BlockState)state.setValue((Property)DEACTIVATED, (Comparable)Boolean.valueOf(true)));
                if (!player.isCreative()) {
                    stack.hurtAndBreak(1, (LivingEntity)player, LivingEntity.getSlotForHand((InteractionHand)hand));
                }
                level.playSound(null, pos, SoundEvents.SHEEP_SHEAR, SoundSource.BLOCKS, 1.0f, 1.0f);
                return ItemInteractionResult.SUCCESS;
            }
        } else if (stack.getItem() == Items.REDSTONE && ((Boolean)state.getValue((Property)DEACTIVATED)).booleanValue()) {
            level.setBlockAndUpdate(pos, (BlockState)state.setValue((Property)DEACTIVATED, (Comparable)Boolean.valueOf(false)));
            if (!player.isCreative()) {
                stack.shrink(1);
            }
            level.playSound(null, pos, SoundEvents.TRIPWIRE_CLICK_ON, SoundSource.BLOCKS, 1.0f, 1.0f);
            return ItemInteractionResult.SUCCESS;
        }
        return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
    }

    @Override
    public BlockState getStateForPlacement(BlockPlaceContext ctx) {
        return (BlockState)super.getStateForPlacement(ctx).setValue((Property)DEACTIVATED, (Comparable)Boolean.valueOf(false));
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{DEACTIVATED, WATERLOGGED});
    }

    @Override
    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return new CageTrapBlockEntity(pos, state);
    }

    public static void loopIronBarPositions(BlockPos.MutableBlockPos pos, Consumer<BlockPos.MutableBlockPos> positionAction) {
        pos.move(-1, 1, -1);
        for (int y = 0; y < 4; ++y) {
            for (int x = 0; x < 3; ++x) {
                for (int z = 0; z < 3; ++z) {
                    if (x != 1 || z != 1 || y == 3) {
                        positionAction.accept(pos);
                    }
                    pos.move(0, 0, 1);
                }
                pos.move(1, 0, -3);
            }
            pos.move(-3, 1, 0);
        }
    }
}

