/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.blockentities;

import net.geforcemods.securitycraft.SCContent;
import net.geforcemods.securitycraft.SecurityCraft;
import net.geforcemods.securitycraft.api.IEMPAffectedBE;
import net.geforcemods.securitycraft.api.Option;
import net.geforcemods.securitycraft.blockentities.DisguisableBlockEntity;
import net.geforcemods.securitycraft.blocks.SecurityCameraBlock;
import net.geforcemods.securitycraft.entity.camera.SecurityCamera;
import net.geforcemods.securitycraft.inventory.InsertOnlyInvWrapper;
import net.geforcemods.securitycraft.inventory.LensContainer;
import net.geforcemods.securitycraft.inventory.SingleLensMenu;
import net.geforcemods.securitycraft.misc.ModuleType;
import net.geforcemods.securitycraft.util.BlockUtils;
import net.geforcemods.securitycraft.util.ITickingBlockEntity;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.ContainerListener;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.wrapper.InvWrapper;

public class SecurityCameraBlockEntity
extends DisguisableBlockEntity
implements ITickingBlockEntity,
IEMPAffectedBE,
MenuProvider,
ContainerListener,
SingleLensMenu.SingleLensContainer {
    private double cameraRotation = 0.0;
    private double oCameraRotation = 0.0;
    private boolean addToRotation = SecurityCraft.RANDOM.nextBoolean();
    private boolean down = false;
    private boolean initialized = false;
    private int playersViewing = 0;
    private boolean shutDown = false;
    private float initialXRotation;
    private float initialYRotation;
    private float initialZoom = 1.0f;
    private Option.DoubleOption rotationSpeedOption = new Option.DoubleOption("rotationSpeed", 0.018, 0.01, 0.025, 0.001);
    private Option.DoubleOption movementSpeedOption = new Option.DoubleOption("movementSpeed", 2.0, 0.0, 20.0, 0.1);
    private Option.BooleanOption shouldRotateOption = new Option.BooleanOption("shouldRotate", true);
    private Option.DoubleOption customRotationOption = new Option.DoubleOption("customRotation", this.getCameraRotation(), 1.55, -1.55, (Double)this.rotationSpeedOption.get());
    private Option.DisabledOption disabled = new Option.DisabledOption(false);
    private Option.IntOption opacity = new Option.IntOption("opacity", 100, 0, 255, 1);
    private LensContainer lens = new LensContainer(1);

    public SecurityCameraBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)SCContent.SECURITY_CAMERA_BLOCK_ENTITY.get(), pos, state);
        this.lens.addListener(this);
    }

    @Override
    public void tick(Level level, BlockPos pos, BlockState state) {
        if (!this.initialized) {
            Direction facing = (Direction)state.getValue((Property)SecurityCameraBlock.FACING);
            this.initialized = true;
            boolean bl = this.down = facing == Direction.DOWN;
            if (!this.isModuleEnabled(ModuleType.SMART)) {
                this.setDefaultViewingDirection(facing, this.initialZoom);
            }
        }
        this.oCameraRotation = this.getCameraRotation();
        if (!this.shutDown && !((Boolean)this.disabled.get()).booleanValue()) {
            if (!((Boolean)this.shouldRotateOption.get()).booleanValue()) {
                this.cameraRotation = (Double)this.customRotationOption.get();
                return;
            }
            if (this.addToRotation && this.getCameraRotation() <= (double)1.55f) {
                this.cameraRotation = this.getCameraRotation() + (Double)this.rotationSpeedOption.get();
            } else {
                this.addToRotation = false;
            }
            if (!this.addToRotation && this.getCameraRotation() >= (double)-1.55f) {
                this.cameraRotation = this.getCameraRotation() - (Double)this.rotationSpeedOption.get();
            } else {
                this.addToRotation = true;
            }
        }
    }

    @Override
    public void saveAdditional(CompoundTag tag, HolderLookup.Provider lookupProvider) {
        super.saveAdditional(tag, lookupProvider);
        tag.putBoolean("shutDown", this.shutDown);
        tag.put("lens", (Tag)this.lens.createTag(lookupProvider));
        tag.putFloat("initial_x_rotation", this.initialXRotation);
        tag.putFloat("initial_y_rotation", this.initialYRotation);
        tag.putFloat("initial_zoom", this.initialZoom);
    }

    @Override
    public void loadAdditional(CompoundTag tag, HolderLookup.Provider lookupProvider) {
        super.loadAdditional(tag, lookupProvider);
        this.shutDown = tag.getBoolean("shutDown");
        this.lens.fromTag(tag.getList("lens", 10), lookupProvider);
        this.initialXRotation = tag.getFloat("initial_x_rotation");
        this.initialYRotation = tag.getFloat("initial_y_rotation");
        if (tag.contains("initial_zoom")) {
            this.initialZoom = tag.getFloat("initial_zoom");
        }
    }

    public static IItemHandler getCapability(SecurityCameraBlockEntity be, Direction side) {
        return BlockUtils.isAllowedToExtractFromProtectedObject(side, be) ? new InvWrapper((Container)be.lens) : new InsertOnlyInvWrapper((Container)be.lens);
    }

    public void containerChanged(Container container) {
        if (this.level == null) {
            return;
        }
        this.level.sendBlockUpdated(this.worldPosition, this.getBlockState(), this.getBlockState(), 2);
    }

    public AbstractContainerMenu createMenu(int id, Inventory inventory, Player player) {
        return new SingleLensMenu(id, this.level, this.worldPosition, inventory);
    }

    public Component getDisplayName() {
        return super.getDisplayName();
    }

    @Override
    public Container getLensContainer() {
        return this.lens;
    }

    @Override
    public ModuleType[] acceptedModules() {
        return new ModuleType[]{ModuleType.REDSTONE, ModuleType.ALLOWLIST, ModuleType.SMART, ModuleType.DISGUISE};
    }

    @Override
    public Option<?>[] customOptions() {
        return new Option[]{this.rotationSpeedOption, this.shouldRotateOption, this.customRotationOption, this.disabled, this.opacity, this.movementSpeedOption};
    }

    @Override
    public void onModuleRemoved(ItemStack stack, ModuleType module, boolean toggled) {
        super.onModuleRemoved(stack, module, toggled);
        if (module == ModuleType.REDSTONE) {
            this.level.setBlockAndUpdate(this.worldPosition, (BlockState)this.getBlockState().setValue((Property)SecurityCameraBlock.POWERED, (Comparable)Boolean.valueOf(false)));
        } else if (module == ModuleType.SMART) {
            this.setDefaultViewingDirection((Direction)this.getBlockState().getValue((Property)SecurityCameraBlock.FACING), this.initialZoom);
        }
    }

    @Override
    public <T> void onOptionChanged(Option<T> option) {
        if (option.getName().equals("disabled") && !this.level.isClientSide && ((Boolean)((Option.BooleanOption)option).get()).booleanValue()) {
            for (ServerPlayer player : ((ServerLevel)this.level).players()) {
                SecurityCamera camera;
                Entity entity = player.getCamera();
                if (!(entity instanceof SecurityCamera) || !(camera = (SecurityCamera)entity).blockPosition().equals((Object)this.worldPosition)) continue;
                camera.stopViewing(player);
            }
        }
        super.onOptionChanged(option);
    }

    @Override
    public void shutDown() {
        BlockState state = this.level.getBlockState(this.worldPosition);
        IEMPAffectedBE.super.shutDown();
        if (state.getBlock() == SCContent.SECURITY_CAMERA.get() && ((Boolean)state.getValue((Property)SecurityCameraBlock.POWERED)).booleanValue()) {
            this.level.setBlockAndUpdate(this.worldPosition, (BlockState)state.setValue((Property)SecurityCameraBlock.POWERED, (Comparable)Boolean.valueOf(false)));
        }
    }

    @Override
    public boolean isShutDown() {
        return this.shutDown;
    }

    @Override
    public void setShutDown(boolean shutDown) {
        this.shutDown = shutDown;
    }

    public void startViewing() {
        if (this.playersViewing++ == 0) {
            this.level.setBlockAndUpdate(this.worldPosition, (BlockState)this.getBlockState().setValue((Property)SecurityCameraBlock.BEING_VIEWED, (Comparable)Boolean.valueOf(true)));
        }
    }

    public void stopViewing() {
        if (--this.playersViewing == 0) {
            this.level.setBlockAndUpdate(this.worldPosition, (BlockState)this.getBlockState().setValue((Property)SecurityCameraBlock.BEING_VIEWED, (Comparable)Boolean.valueOf(false)));
        }
    }

    public boolean isDisabled() {
        return (Boolean)this.disabled.get();
    }

    public double getCameraRotation() {
        return this.cameraRotation;
    }

    public double getOriginalCameraRotation() {
        return this.oCameraRotation;
    }

    public boolean isDown() {
        return this.down;
    }

    public int getOpacity() {
        return (Integer)this.opacity.get();
    }

    public double getMovementSpeed() {
        return (Double)this.movementSpeedOption.get();
    }

    public void setDefaultViewingDirection(Direction facing, float zoom) {
        float f = this.down ? 75.0f : 30.0f;
        this.setDefaultViewingDirection(f, switch (facing) {
            default -> throw new MatchException(null, null);
            case Direction.NORTH -> 180.0f;
            case Direction.WEST -> 90.0f;
            case Direction.SOUTH -> 0.0f;
            case Direction.EAST -> 270.0f;
            case Direction.DOWN, Direction.UP -> 0.0f;
        }, zoom);
    }

    public void setDefaultViewingDirection(float initialXRotation, float initialYRotation, float initialZoom) {
        this.initialXRotation = initialXRotation;
        this.initialYRotation = initialYRotation;
        this.initialZoom = initialZoom;
        this.setChanged();
    }

    public float getInitialXRotation() {
        return this.initialXRotation;
    }

    public float getInitialYRotation() {
        return this.initialYRotation;
    }

    public float getInitialZoom() {
        return this.initialZoom;
    }
}

