/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.blockentities;

import net.geforcemods.securitycraft.ConfigHandler;
import net.geforcemods.securitycraft.SCContent;
import net.geforcemods.securitycraft.api.IViewActivated;
import net.geforcemods.securitycraft.api.Option;
import net.geforcemods.securitycraft.api.Owner;
import net.geforcemods.securitycraft.blockentities.SpecialDoorBlockEntity;
import net.geforcemods.securitycraft.blocks.ScannerDoorBlock;
import net.geforcemods.securitycraft.misc.ModuleType;
import net.geforcemods.securitycraft.util.ITickingBlockEntity;
import net.geforcemods.securitycraft.util.PlayerUtils;
import net.geforcemods.securitycraft.util.Utils;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DoubleHighBlockItem;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.DoorBlock;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.DoubleBlockHalf;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.BlockHitResult;

public class ScannerDoorBlockEntity
extends SpecialDoorBlockEntity
implements IViewActivated,
ITickingBlockEntity {
    private Option.BooleanOption sendMessage = new Option.BooleanOption("sendMessage", true);
    private Option.DoubleOption maximumDistance = new Option.DoubleOption(this, "maximumDistance", 5.0, 0.1, 25.0, 0.1){

        @Override
        public String getKey(String denotation) {
            return "option.generic.viewActivated.maximumDistance";
        }
    };
    private Option.RespectInvisibilityOption respectInvisibility = new Option.RespectInvisibilityOption();
    private int viewCooldown = 0;

    public ScannerDoorBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)SCContent.SCANNER_DOOR_BLOCK_ENTITY.get(), pos, state);
    }

    @Override
    public void tick(Level level, BlockPos pos, BlockState state) {
        super.tick(level, pos, state);
        this.checkView(level, pos);
    }

    @Override
    public boolean onEntityViewed(LivingEntity entity, BlockHitResult hitResult) {
        block13: {
            Player player;
            BlockState lowerState;
            BlockState upperState;
            block15: {
                block14: {
                    upperState = this.level.getBlockState(this.worldPosition);
                    lowerState = this.level.getBlockState(this.worldPosition.below());
                    Direction.Axis facingAxis = ScannerDoorBlock.getFacingAxis(upperState);
                    if (upperState.getValue((Property)DoorBlock.HALF) != DoubleBlockHalf.UPPER || this.isConsideredInvisible(entity)) break block13;
                    if (!(entity instanceof Player)) break block14;
                    player = (Player)entity;
                    if (this.isModuleEnabled(ModuleType.DISGUISE) || facingAxis == hitResult.getDirection().getAxis()) break block15;
                }
                return false;
            }
            if (!this.isLocked() && !this.isDisabled()) {
                Owner viewingPlayer = new Owner(player);
                if (((Boolean)ConfigHandler.SERVER.trickScannersWithPlayerHeads.get()).booleanValue() && player.getItemBySlot(EquipmentSlot.HEAD).getItem() == Items.PLAYER_HEAD) {
                    viewingPlayer = PlayerUtils.getSkullOwner(player);
                }
                if (!this.isOwnedBy(viewingPlayer) && !this.isAllowed(viewingPlayer.getName())) {
                    PlayerUtils.sendMessageToPlayer(player, Utils.localize(((DoubleHighBlockItem)SCContent.SCANNER_DOOR_ITEM.get()).getDescriptionId(), new Object[0]), Utils.localize("messages.securitycraft:retinalScanner.notOwner", PlayerUtils.getOwnerComponent(this.getOwner())), ChatFormatting.RED);
                    return true;
                }
                boolean open = (Boolean)lowerState.getValue((Property)DoorBlock.OPEN) == false;
                int length = this.getSignalLength();
                this.level.setBlock(this.worldPosition, (BlockState)upperState.setValue((Property)DoorBlock.OPEN, (Comparable)Boolean.valueOf((Boolean)upperState.getValue((Property)DoorBlock.OPEN) == false)), 3);
                this.level.setBlock(this.worldPosition.below(), (BlockState)lowerState.setValue((Property)DoorBlock.OPEN, (Comparable)Boolean.valueOf((Boolean)lowerState.getValue((Property)DoorBlock.OPEN) == false)), 3);
                ((DoorBlock)upperState.getBlock()).playSound(null, this.level, this.worldPosition, open);
                this.level.gameEvent(null, (Holder)(open ? GameEvent.BLOCK_OPEN : GameEvent.BLOCK_CLOSE), this.worldPosition);
                if (open && length > 0) {
                    this.level.scheduleTick(this.worldPosition, (Block)SCContent.SCANNER_DOOR.get(), length);
                }
                if (open && this.sendsMessages()) {
                    PlayerUtils.sendMessageToPlayer(player, Utils.localize(((DoubleHighBlockItem)SCContent.SCANNER_DOOR_ITEM.get()).getDescriptionId(), new Object[0]), Utils.localize("messages.securitycraft:retinalScanner.hello", viewingPlayer.getName()), ChatFormatting.GREEN);
                }
            } else if (this.isLocked() && this.sendsMessages()) {
                MutableComponent blockName = Utils.localize(((DoubleHighBlockItem)SCContent.SCANNER_DOOR_ITEM.get()).getDescriptionId(), new Object[0]);
                PlayerUtils.sendMessageToPlayer(player, blockName, Utils.localize("messages.securitycraft:sonic_security_system.locked", blockName), ChatFormatting.DARK_RED, false);
            } else if (this.isDisabled()) {
                player.displayClientMessage((Component)Utils.localize("gui.securitycraft:scManual.disabled", new Object[0]), true);
            }
            return true;
        }
        return false;
    }

    @Override
    public int getViewCooldown() {
        return this.viewCooldown;
    }

    @Override
    public void setViewCooldown(int viewCooldown) {
        this.viewCooldown = viewCooldown;
        this.setChanged();
    }

    @Override
    public ModuleType[] acceptedModules() {
        return new ModuleType[]{ModuleType.ALLOWLIST, ModuleType.DISGUISE};
    }

    @Override
    public Option<?>[] customOptions() {
        return new Option[]{this.sendMessage, this.signalLength, this.disabled, this.maximumDistance, this.respectInvisibility};
    }

    public boolean sendsMessages() {
        return (Boolean)this.sendMessage.get();
    }

    @Override
    public int defaultSignalLength() {
        return 0;
    }

    @Override
    public double getMaximumDistance() {
        return (Double)this.maximumDistance.get();
    }

    @Override
    public boolean isConsideredInvisible(LivingEntity entity) {
        return this.respectInvisibility.isConsideredInvisible(entity);
    }
}

