/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.blockentities;

import net.geforcemods.securitycraft.ClientHandler;
import net.geforcemods.securitycraft.SCContent;
import net.geforcemods.securitycraft.api.ILockable;
import net.geforcemods.securitycraft.api.Option;
import net.geforcemods.securitycraft.blockentities.DisguisableBlockEntity;
import net.geforcemods.securitycraft.inventory.ProjectorMenu;
import net.geforcemods.securitycraft.misc.ModuleType;
import net.geforcemods.securitycraft.util.StandingOrWallType;
import net.geforcemods.securitycraft.util.Utils;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.Container;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.StandingAndWallBlockItem;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;

public class ProjectorBlockEntity
extends DisguisableBlockEntity
implements Container,
MenuProvider,
ILockable {
    public static final int MIN_WIDTH = 1;
    public static final int MAX_WIDTH = 10;
    public static final int MIN_RANGE = 1;
    public static final int MAX_RANGE = 30;
    public static final int MIN_OFFSET = -10;
    public static final int MAX_OFFSET = 10;
    private int projectionWidth = 1;
    private int projectionHeight = 1;
    private int projectionRange = 5;
    private int projectionOffset = 0;
    private boolean activatedByRedstone = false;
    private boolean active = false;
    private boolean horizontal = false;
    private boolean overridingBlocks = false;
    private ItemStack projectedBlock = ItemStack.EMPTY;
    private BlockState projectedState = Blocks.AIR.defaultBlockState();

    public ProjectorBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)SCContent.PROJECTOR_BLOCK_ENTITY.get(), pos, state);
    }

    @Override
    public void saveAdditional(CompoundTag tag, HolderLookup.Provider lookupProvider) {
        super.saveAdditional(tag, lookupProvider);
        tag.putInt("width", this.projectionWidth);
        tag.putInt("height", this.projectionHeight);
        tag.putInt("range", this.projectionRange);
        tag.putInt("offset", this.projectionOffset);
        tag.putBoolean("active", this.active);
        tag.putBoolean("horizontal", this.horizontal);
        tag.putBoolean("overriding_blocks", this.overridingBlocks);
        if (!this.projectedBlock.isEmpty()) {
            tag.put("storedItem", this.projectedBlock.saveOptional(lookupProvider));
        }
        tag.put("SavedState", (Tag)NbtUtils.writeBlockState((BlockState)this.projectedState));
    }

    @Override
    public void loadAdditional(CompoundTag tag, HolderLookup.Provider lookupProvider) {
        super.loadAdditional(tag, lookupProvider);
        this.projectionWidth = tag.getInt("width");
        this.projectionHeight = tag.getInt("height");
        this.projectionRange = tag.getInt("range");
        this.projectionOffset = tag.getInt("offset");
        this.activatedByRedstone = this.isModuleEnabled(ModuleType.REDSTONE);
        this.active = tag.getBoolean("active");
        this.horizontal = tag.getBoolean("horizontal");
        this.overridingBlocks = tag.getBoolean("overriding_blocks");
        this.projectedBlock = Utils.parseOptional(lookupProvider, tag.getCompound("storedItem"));
        if (!tag.contains("SavedState")) {
            this.resetSavedState();
        } else {
            this.setProjectedState(NbtUtils.readBlockState((HolderGetter)(this.level != null ? this.level.holderLookup(Registries.BLOCK) : BuiltInRegistries.BLOCK.asLookup()), (CompoundTag)tag.getCompound("SavedState")));
        }
    }

    public int getProjectionWidth() {
        return this.projectionWidth;
    }

    public void setProjectionWidth(int width) {
        this.projectionWidth = width;
        this.setChanged();
    }

    public int getProjectionHeight() {
        return this.projectionHeight;
    }

    public void setProjectionHeight(int projectionHeight) {
        this.projectionHeight = projectionHeight;
        this.setChanged();
    }

    public int getProjectionRange() {
        return this.projectionRange;
    }

    public void setProjectionRange(int range) {
        this.projectionRange = range;
        this.setChanged();
    }

    public int getProjectionOffset() {
        return this.projectionOffset;
    }

    public void setProjectionOffset(int offset) {
        this.projectionOffset = offset;
        this.setChanged();
    }

    public boolean isActivatedByRedstone() {
        return this.activatedByRedstone;
    }

    public void setActivatedByRedstone(boolean redstone) {
        this.activatedByRedstone = redstone;
        this.setChanged();
    }

    public boolean isHorizontal() {
        return this.horizontal;
    }

    public void setHorizontal(boolean horizontal) {
        this.horizontal = horizontal;
        this.setChanged();
    }

    public boolean isOverridingBlocks() {
        return this.overridingBlocks;
    }

    public void setOverridingBlocks(boolean overridingBlocks) {
        this.overridingBlocks = overridingBlocks;
    }

    public boolean isActive() {
        return !this.activatedByRedstone || this.active;
    }

    public void setActive(boolean isOn) {
        this.active = isOn;
        this.setChanged();
    }

    public BlockState getProjectedState() {
        return this.projectedState;
    }

    @Override
    public void onModuleInserted(ItemStack stack, ModuleType module, boolean toggled) {
        super.onModuleInserted(stack, module, toggled);
        if (module == ModuleType.REDSTONE) {
            this.setActivatedByRedstone(true);
        }
    }

    @Override
    public void onModuleRemoved(ItemStack stack, ModuleType module, boolean toggled) {
        super.onModuleRemoved(stack, module, toggled);
        if (module == ModuleType.REDSTONE) {
            this.setActivatedByRedstone(false);
        }
    }

    @Override
    public ModuleType[] acceptedModules() {
        return new ModuleType[]{ModuleType.DISGUISE, ModuleType.REDSTONE};
    }

    @Override
    public Option<?>[] customOptions() {
        return new Option[0];
    }

    public AbstractContainerMenu createMenu(int windowId, Inventory inv, Player player) {
        return new ProjectorMenu(windowId, this.level, this.worldPosition, inv);
    }

    public Component getDisplayName() {
        return super.getDisplayName();
    }

    public void clearContent() {
        this.projectedBlock = ItemStack.EMPTY;
        this.resetSavedState();
    }

    public ItemStack removeItem(int index, int count) {
        ItemStack stack = this.projectedBlock;
        if (count >= 1) {
            this.projectedBlock = ItemStack.EMPTY;
            this.resetSavedState();
            return stack;
        }
        return ItemStack.EMPTY;
    }

    public int getContainerSize() {
        return 1;
    }

    public int getMaxStackSize() {
        return 1;
    }

    @Override
    public ItemStack getStackInSlot(int slot) {
        return slot >= 100 ? this.getModuleInSlot(slot) : (slot == 36 ? this.projectedBlock : ItemStack.EMPTY);
    }

    public ItemStack getItem(int slot) {
        return this.getStackInSlot(slot);
    }

    public boolean isEmpty() {
        return this.projectedBlock.isEmpty();
    }

    public boolean stillValid(Player player) {
        return true;
    }

    public ItemStack removeItemNoUpdate(int index) {
        ItemStack stack = this.projectedBlock;
        this.projectedBlock = ItemStack.EMPTY;
        this.resetSavedState();
        return stack;
    }

    public void setItem(int index, ItemStack stack) {
        if (!stack.isEmpty() && stack.getCount() > this.getMaxStackSize()) {
            stack = new ItemStack((ItemLike)stack.getItem(), this.getMaxStackSize());
        }
        ItemStack old = this.projectedBlock;
        this.projectedBlock = stack;
        if (old.getItem() != this.projectedBlock.getItem()) {
            this.resetSavedState();
        }
    }

    @Override
    public boolean enableHack() {
        return true;
    }

    public void onLoad() {
        super.onLoad();
        if (this.level.isClientSide) {
            ClientHandler.PROJECTOR_RENDER_DELEGATE.putDelegateFor(this, this.projectedState);
        }
    }

    @Override
    public void setRemoved() {
        super.setRemoved();
        if (this.level.isClientSide) {
            ClientHandler.PROJECTOR_RENDER_DELEGATE.removeDelegateOf(this);
        }
    }

    public void setProjectedState(BlockState projectedState) {
        if (this.level != null && this.level.isClientSide) {
            if (this.projectedState.getBlock() != projectedState.getBlock()) {
                ClientHandler.PROJECTOR_RENDER_DELEGATE.removeDelegateOf(this);
            }
            ClientHandler.PROJECTOR_RENDER_DELEGATE.putDelegateFor(this, projectedState);
        }
        this.projectedState = projectedState;
        this.setChanged();
    }

    public void resetSavedState() {
        Item item = this.projectedBlock.getItem();
        if (item instanceof BlockItem) {
            BlockItem blockItem = (BlockItem)item;
            this.setProjectedState(blockItem.getBlock().defaultBlockState());
        } else {
            this.projectedState = Blocks.AIR.defaultBlockState();
            if (this.level != null && this.level.isClientSide) {
                ClientHandler.PROJECTOR_RENDER_DELEGATE.removeDelegateOf(this);
            }
            this.setChanged();
        }
    }

    public StandingOrWallType getStandingOrWallType() {
        Item item;
        if (this.projectedState != null && this.projectedBlock != null && (item = this.projectedBlock.getItem()) instanceof StandingAndWallBlockItem) {
            StandingAndWallBlockItem sawbi = (StandingAndWallBlockItem)item;
            if (this.projectedState.getBlock() == sawbi.getBlock()) {
                return StandingOrWallType.STANDING;
            }
            if (this.projectedState.getBlock() == sawbi.wallBlock) {
                return StandingOrWallType.WALL;
            }
        }
        return StandingOrWallType.NONE;
    }
}

