/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.blockentities;

import java.util.UUID;
import net.geforcemods.securitycraft.SCContent;
import net.geforcemods.securitycraft.api.ILockable;
import net.geforcemods.securitycraft.api.IPasscodeProtected;
import net.geforcemods.securitycraft.api.Option;
import net.geforcemods.securitycraft.blockentities.DisguisableBlockEntity;
import net.geforcemods.securitycraft.blocks.KeypadTrapDoorBlock;
import net.geforcemods.securitycraft.misc.ModuleType;
import net.geforcemods.securitycraft.util.PasscodeUtils;
import net.geforcemods.securitycraft.util.Utils;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.TrapDoorBlock;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;

public class KeypadTrapdoorBlockEntity
extends DisguisableBlockEntity
implements IPasscodeProtected,
ILockable {
    private Option.BooleanOption sendAllowlistMessage = new Option.SendAllowlistMessageOption(false);
    private Option.BooleanOption sendDenylistMessage = new Option.SendDenylistMessageOption(true);
    private Option.IntOption signalLength = new Option.IntOption("signalLength", 60, 0, 400, 5);
    private Option.DisabledOption disabled = new Option.DisabledOption(false);
    private Option.SmartModuleCooldownOption smartModuleCooldown = new Option.SmartModuleCooldownOption();
    private long cooldownEnd = 0L;
    private byte[] passcode;
    private UUID saltKey;

    public KeypadTrapdoorBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)SCContent.KEYPAD_TRAPDOOR_BLOCK_ENTITY.get(), pos, state);
    }

    @Override
    public void saveAdditional(CompoundTag tag, HolderLookup.Provider lookupProvider) {
        long cooldownLeft;
        super.saveAdditional(tag, lookupProvider);
        if (this.saltKey != null) {
            tag.putUUID("saltKey", this.saltKey);
        }
        if (this.passcode != null) {
            tag.putString("passcode", PasscodeUtils.bytesToString(this.passcode));
        }
        tag.putLong("cooldownLeft", (cooldownLeft = this.getCooldownEnd() - System.currentTimeMillis()) <= 0L ? -1L : cooldownLeft);
    }

    @Override
    public void loadAdditional(CompoundTag tag, HolderLookup.Provider lookupProvider) {
        super.loadAdditional(tag, lookupProvider);
        this.loadSaltKey(tag);
        this.loadPasscode(tag);
        this.cooldownEnd = System.currentTimeMillis() + tag.getLong("cooldownLeft");
        if (tag.contains("sendMessage") && !tag.getBoolean("sendMessage")) {
            this.sendAllowlistMessage.setValue(false);
            this.sendDenylistMessage.setValue(false);
        }
    }

    @Override
    public void activate(Player player) {
        Block block;
        if (!this.level.isClientSide && (block = this.getBlockState().getBlock()) instanceof KeypadTrapDoorBlock) {
            KeypadTrapDoorBlock block2 = (KeypadTrapDoorBlock)block;
            block2.activate(this.getBlockState(), this.level, this.worldPosition, (Integer)this.signalLength.get());
        }
    }

    @Override
    public boolean shouldAttemptCodebreak(Player player) {
        if (this.isDisabled()) {
            player.displayClientMessage((Component)Utils.localize("gui.securitycraft:scManual.disabled", new Object[0]), true);
            return false;
        }
        return (Boolean)this.getBlockState().getValue((Property)TrapDoorBlock.OPEN) == false && IPasscodeProtected.super.shouldAttemptCodebreak(player);
    }

    @Override
    public <T> void onOptionChanged(Option<T> option) {
        if ((option == this.disabled && ((Boolean)((Option.BooleanOption)option).get()).booleanValue() || option == this.signalLength) && ((Boolean)this.getBlockState().getValue((Property)TrapDoorBlock.OPEN)).booleanValue()) {
            this.level.setBlockAndUpdate(this.worldPosition, (BlockState)this.getBlockState().setValue((Property)TrapDoorBlock.OPEN, (Comparable)Boolean.valueOf(false)));
            ((KeypadTrapDoorBlock)SCContent.KEYPAD_TRAPDOOR.get()).playSound(null, this.level, this.worldPosition, false);
        }
        super.onOptionChanged(option);
    }

    @Override
    public byte[] getPasscode() {
        return this.passcode == null || this.passcode.length == 0 ? null : this.passcode;
    }

    @Override
    public void setPasscode(byte[] passcode) {
        this.passcode = passcode;
        this.setChanged();
    }

    @Override
    public UUID getSaltKey() {
        return this.saltKey;
    }

    @Override
    public void setSaltKey(UUID saltKey) {
        this.saltKey = saltKey;
    }

    @Override
    public void startCooldown() {
        if (!this.isOnCooldown()) {
            this.cooldownEnd = System.currentTimeMillis() + (long)((Integer)this.smartModuleCooldown.get() * 50);
            this.level.sendBlockUpdated(this.worldPosition, this.getBlockState(), this.getBlockState(), 2);
            this.setChanged();
        }
    }

    @Override
    public long getCooldownEnd() {
        return this.cooldownEnd;
    }

    @Override
    public boolean isOnCooldown() {
        return System.currentTimeMillis() < this.getCooldownEnd();
    }

    @Override
    public ModuleType[] acceptedModules() {
        return new ModuleType[]{ModuleType.ALLOWLIST, ModuleType.DENYLIST, ModuleType.SMART, ModuleType.HARMING, ModuleType.DISGUISE};
    }

    @Override
    public Option<?>[] customOptions() {
        return new Option[]{this.sendAllowlistMessage, this.sendDenylistMessage, this.signalLength, this.disabled, this.smartModuleCooldown};
    }

    public boolean sendsAllowlistMessage() {
        return (Boolean)this.sendAllowlistMessage.get();
    }

    public boolean sendsDenylistMessage() {
        return (Boolean)this.sendDenylistMessage.get();
    }

    public int getSignalLength() {
        return (Integer)this.signalLength.get();
    }

    public boolean isDisabled() {
        return (Boolean)this.disabled.get();
    }
}

