/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.blockentities;

import java.lang.runtime.SwitchBootstraps;
import java.util.EnumMap;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import net.geforcemods.securitycraft.SCContent;
import net.geforcemods.securitycraft.api.ICustomizable;
import net.geforcemods.securitycraft.api.ILockable;
import net.geforcemods.securitycraft.api.IModuleInventory;
import net.geforcemods.securitycraft.api.IOwnable;
import net.geforcemods.securitycraft.api.IPasscodeProtected;
import net.geforcemods.securitycraft.api.Option;
import net.geforcemods.securitycraft.api.Owner;
import net.geforcemods.securitycraft.blockentities.DisguisableBlockEntity;
import net.geforcemods.securitycraft.blocks.KeypadChestBlock;
import net.geforcemods.securitycraft.entity.sentry.ISentryBulletContainer;
import net.geforcemods.securitycraft.entity.sentry.Sentry;
import net.geforcemods.securitycraft.inventory.InsertOnlyInvWrapper;
import net.geforcemods.securitycraft.items.ModuleItem;
import net.geforcemods.securitycraft.misc.ModuleType;
import net.geforcemods.securitycraft.util.BlockUtils;
import net.geforcemods.securitycraft.util.PasscodeUtils;
import net.geforcemods.securitycraft.util.Utils;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.ChestBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.entity.ChestBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.ChestType;
import net.minecraft.world.level.block.state.properties.Property;
import net.neoforged.neoforge.client.model.data.ModelData;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.wrapper.InvWrapper;

public class KeypadChestBlockEntity
extends ChestBlockEntity
implements IPasscodeProtected,
IOwnable,
IModuleInventory,
ICustomizable,
ILockable,
ISentryBulletContainer {
    private byte[] passcode;
    private UUID saltKey;
    private Owner owner = new Owner();
    private NonNullList<ItemStack> modules = NonNullList.withSize((int)this.getMaxNumberOfModules(), (Object)ItemStack.EMPTY);
    private Option.BooleanOption sendAllowlistMessage = new Option.SendAllowlistMessageOption(false);
    private Option.BooleanOption sendDenylistMessage = new Option.SendDenylistMessageOption(true);
    private Option.SmartModuleCooldownOption smartModuleCooldown = new Option.SmartModuleCooldownOption();
    private long cooldownEnd = 0L;
    private Map<ModuleType, Boolean> moduleStates = new EnumMap<ModuleType, Boolean>(ModuleType.class);
    private ResourceLocation previousChest;

    public KeypadChestBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)SCContent.KEYPAD_CHEST_BLOCK_ENTITY.get(), pos, state);
    }

    public void saveAdditional(CompoundTag tag, HolderLookup.Provider lookupProvider) {
        super.saveAdditional(tag, lookupProvider);
        this.writeModuleInventory(tag, lookupProvider);
        this.writeModuleStates(tag);
        this.writeOptions(tag);
        long cooldownLeft = this.getCooldownEnd() - System.currentTimeMillis();
        tag.putLong("cooldownLeft", cooldownLeft <= 0L ? -1L : cooldownLeft);
        if (this.saltKey != null) {
            tag.putUUID("saltKey", this.saltKey);
        }
        if (this.passcode != null) {
            tag.putString("passcode", PasscodeUtils.bytesToString(this.passcode));
        }
        if (this.owner != null) {
            this.owner.save(tag, this.needsValidation());
        }
        if (this.previousChest != null) {
            tag.putString("previous_chest", this.previousChest.toString());
        }
    }

    public void loadAdditional(CompoundTag tag, HolderLookup.Provider lookupProvider) {
        ResourceLocation parsedPreviousChest;
        String savedPreviousChest;
        super.loadAdditional(tag, lookupProvider);
        this.modules = this.readModuleInventory(tag, lookupProvider);
        this.moduleStates = this.readModuleStates(tag);
        this.readOptions(tag);
        this.cooldownEnd = System.currentTimeMillis() + tag.getLong("cooldownLeft");
        this.loadSaltKey(tag);
        this.loadPasscode(tag);
        this.owner.load(tag);
        if (tag.contains("previous_chest") && !(savedPreviousChest = tag.getString("previous_chest")).isBlank() && (parsedPreviousChest = ResourceLocation.parse((String)savedPreviousChest)).getPath() != null && !parsedPreviousChest.getPath().isBlank()) {
            this.previousChest = parsedPreviousChest;
        }
        if (tag.contains("sendMessage") && !tag.getBoolean("sendMessage")) {
            this.sendAllowlistMessage.setValue(false);
            this.sendDenylistMessage.setValue(false);
        }
    }

    public CompoundTag getUpdateTag(HolderLookup.Provider lookupProvider) {
        return PasscodeUtils.filterPasscodeAndSaltFromTag(this.saveCustomOnly(lookupProvider));
    }

    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.create((BlockEntity)this);
    }

    public void handleUpdateTag(CompoundTag tag, HolderLookup.Provider lookupProvider) {
        super.handleUpdateTag(tag, lookupProvider);
        DisguisableBlockEntity.onHandleUpdateTag(this);
    }

    public Component getDefaultName() {
        return Utils.localize(((KeypadChestBlock)SCContent.KEYPAD_CHEST.get()).getDescriptionId(), new Object[0]);
    }

    protected void signalOpenCount(Level level, BlockPos pos, BlockState state, int i, int j) {
        super.signalOpenCount(level, pos, state, i, j);
        if (this.isModuleEnabled(ModuleType.REDSTONE)) {
            BlockUtils.updateIndirectNeighbors(level, pos, state.getBlock(), Direction.DOWN);
        }
    }

    public int getNumPlayersUsing() {
        return this.openersCounter.getOpenerCount();
    }

    public static IItemHandler getCapability(KeypadChestBlockEntity be, Direction side) {
        if (BlockUtils.isAllowedToExtractFromProtectedObject(side, be)) {
            return new InvWrapper(ChestBlock.getContainer((ChestBlock)((ChestBlock)be.getBlockState().getBlock()), (BlockState)be.getBlockState(), (Level)be.getLevel(), (BlockPos)be.getBlockPos(), (boolean)true));
        }
        return new InsertOnlyInvWrapper((Container)be);
    }

    @Override
    public IItemHandler getHandlerForSentry(Sentry entity) {
        if (entity.getOwner().owns(this)) {
            return new InvWrapper((Container)this);
        }
        return null;
    }

    @Override
    public boolean enableHack() {
        return true;
    }

    public ItemStack getItem(int slot) {
        return slot >= 100 ? this.getModuleInSlot(slot) : super.getItem(slot);
    }

    @Override
    public void activate(Player player) {
        Block block;
        if (!this.level.isClientSide && (block = this.getBlockState().getBlock()) instanceof KeypadChestBlock) {
            KeypadChestBlock block2 = (KeypadChestBlock)block;
            if (!this.isBlocked()) {
                block2.activate(this.getBlockState(), this.level, this.worldPosition, player);
            }
        }
    }

    @Override
    public void openPasscodeGUI(Level level, BlockPos pos, Player player) {
        if (!level.isClientSide && !this.isBlocked()) {
            IPasscodeProtected.super.openPasscodeGUI(level, pos, player);
        }
    }

    @Override
    public void onModuleInserted(ItemStack stack, ModuleType module, boolean toggled) {
        IModuleInventory.super.onModuleInserted(stack, module, toggled);
        this.addOrRemoveModuleFromAttached(stack, false, toggled);
        if (module == ModuleType.DISGUISE) {
            DisguisableBlockEntity.onDisguiseModuleInserted((BlockEntity)this, stack, toggled);
        }
    }

    @Override
    public void onModuleRemoved(ItemStack stack, ModuleType module, boolean toggled) {
        IModuleInventory.super.onModuleRemoved(stack, module, toggled);
        this.addOrRemoveModuleFromAttached(stack, true, toggled);
        if (module == ModuleType.DISGUISE) {
            DisguisableBlockEntity.onDisguiseModuleRemoved((BlockEntity)this, stack, toggled);
        }
    }

    @Override
    public <T> void onOptionChanged(Option<T> option) {
        KeypadChestBlockEntity otherBe = this.findOther();
        if (otherBe != null) {
            Option<T> option2 = option;
            Objects.requireNonNull(option2);
            Option<T> option3 = option2;
            int n = 0;
            block5: while (true) {
                switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Option.BooleanOption.class, Option.BooleanOption.class, Option.IntOption.class}, option3, n)) {
                    case 0: {
                        Option.BooleanOption bo = (Option.BooleanOption)option3;
                        if (option != this.sendAllowlistMessage) {
                            n = 1;
                            continue block5;
                        }
                        otherBe.setSendsAllowlistMessage((Boolean)bo.get());
                        break block5;
                    }
                    case 1: {
                        Option.BooleanOption bo = (Option.BooleanOption)option3;
                        if (option != this.sendDenylistMessage) {
                            n = 2;
                            continue block5;
                        }
                        otherBe.setSendsAllowlistMessage((Boolean)bo.get());
                        break block5;
                    }
                    case 2: {
                        Option.IntOption io = (Option.IntOption)option3;
                        if (option != this.smartModuleCooldown) {
                            n = 3;
                            continue block5;
                        }
                        otherBe.smartModuleCooldown.copy(option);
                        break block5;
                    }
                    default: {
                        throw new UnsupportedOperationException("Unhandled option synchronization in keypad chest! " + option.getName());
                    }
                }
                break;
            }
        }
        ICustomizable.super.onOptionChanged(option);
    }

    @Override
    public void dropAllModules() {
        KeypadChestBlockEntity offsetBe = this.findOther();
        for (ItemStack module : this.getInventory()) {
            Item item = module.getItem();
            if (!(item instanceof ModuleItem)) continue;
            ModuleItem item2 = (ModuleItem)item;
            if (offsetBe != null) {
                offsetBe.removeModule(item2.getModuleType(), false);
            }
            Block.popResource((Level)this.level, (BlockPos)this.worldPosition, (ItemStack)module);
        }
        this.getInventory().clear();
    }

    public void addOrRemoveModuleFromAttached(ItemStack module, boolean remove, boolean toggled) {
        Item item;
        if (module.isEmpty() || !((item = module.getItem()) instanceof ModuleItem)) {
            return;
        }
        ModuleItem moduleItem = (ModuleItem)item;
        KeypadChestBlockEntity offsetBe = this.findOther();
        if (offsetBe != null) {
            if (toggled ? offsetBe.isModuleEnabled(moduleItem.getModuleType()) != remove : offsetBe.hasModule(moduleItem.getModuleType()) != remove) {
                return;
            }
            if (remove) {
                offsetBe.removeModule(moduleItem.getModuleType(), toggled);
            } else {
                offsetBe.insertModule(module, toggled);
            }
        }
    }

    public KeypadChestBlockEntity findOther() {
        BlockState state = this.getBlockState();
        ChestType type = (ChestType)state.getValue((Property)ChestBlock.TYPE);
        if (type != ChestType.SINGLE) {
            BlockEntity blockEntity;
            ChestType offsetType;
            BlockPos offsetPos = this.worldPosition.relative(ChestBlock.getConnectedDirection((BlockState)state));
            BlockState offsetState = this.level.getBlockState(offsetPos);
            if (state.getBlock() == offsetState.getBlock() && (offsetType = (ChestType)offsetState.getValue((Property)ChestBlock.TYPE)) != ChestType.SINGLE && type != offsetType && state.getValue((Property)ChestBlock.FACING) == offsetState.getValue((Property)ChestBlock.FACING) && (blockEntity = this.level.getBlockEntity(offsetPos)) instanceof KeypadChestBlockEntity) {
                KeypadChestBlockEntity be = (KeypadChestBlockEntity)blockEntity;
                return be;
            }
        }
        return null;
    }

    @Override
    public void onOwnerChanged(BlockState state, Level level, BlockPos pos, Player player, Owner oldOwner, Owner newOwner) {
        KeypadChestBlockEntity otherHalf = this.findOther();
        if (otherHalf != null) {
            otherHalf.setOwner(this.getOwner().getUUID(), this.getOwner().getName());
        }
        IOwnable.super.onOwnerChanged(state, level, pos, player, oldOwner, newOwner);
    }

    public void setRemoved() {
        super.setRemoved();
        DisguisableBlockEntity.onSetRemoved((BlockEntity)this);
    }

    @Override
    public byte[] getPasscode() {
        return this.passcode == null || this.passcode.length == 0 ? null : this.passcode;
    }

    @Override
    public void setPasscode(byte[] passcode) {
        this.passcode = passcode;
        this.setChanged();
    }

    @Override
    public UUID getSaltKey() {
        return this.saltKey;
    }

    @Override
    public void setSaltKey(UUID saltKey) {
        this.saltKey = saltKey;
    }

    @Override
    public void setPasscodeInAdjacentBlock(String codeToSet) {
        KeypadChestBlockEntity chestBe = this.findOther();
        if (chestBe != null && this.getOwner().owns(chestBe)) {
            chestBe.hashAndSetPasscode(codeToSet, this.getSalt());
            this.level.sendBlockUpdated(chestBe.worldPosition, chestBe.getBlockState(), chestBe.getBlockState(), 2);
        }
    }

    @Override
    public Owner getOwner() {
        return this.owner;
    }

    @Override
    public void setOwner(String uuid, String name) {
        this.owner.set(uuid, name);
        this.setChanged();
    }

    public boolean isBlocked() {
        for (Direction dir : Direction.Plane.HORIZONTAL) {
            BlockPos pos = this.getBlockPos().relative(dir);
            if (!(this.level.getBlockState(pos).getBlock() instanceof KeypadChestBlock) || !KeypadChestBlock.isBlocked(this.level, pos)) continue;
            return true;
        }
        return this.isSingleBlocked();
    }

    public boolean isSingleBlocked() {
        return KeypadChestBlock.isBlocked(this.getLevel(), this.getBlockPos());
    }

    @Override
    public NonNullList<ItemStack> getInventory() {
        return this.modules;
    }

    @Override
    public void startCooldown() {
        KeypadChestBlockEntity otherHalf = this.findOther();
        long start = System.currentTimeMillis();
        this.startCooldown(start);
        if (otherHalf != null) {
            otherHalf.startCooldown(start);
        }
    }

    public void startCooldown(long start) {
        if (!this.isOnCooldown()) {
            this.cooldownEnd = start + (long)((Integer)this.smartModuleCooldown.get() * 50);
            this.level.sendBlockUpdated(this.worldPosition, this.getBlockState(), this.getBlockState(), 2);
            this.setChanged();
        }
    }

    @Override
    public long getCooldownEnd() {
        return this.cooldownEnd;
    }

    @Override
    public boolean isOnCooldown() {
        return System.currentTimeMillis() < this.getCooldownEnd();
    }

    @Override
    public boolean shouldDropModules() {
        return this.getBlockState().getValue((Property)ChestBlock.TYPE) == ChestType.SINGLE;
    }

    @Override
    public ModuleType[] acceptedModules() {
        return new ModuleType[]{ModuleType.ALLOWLIST, ModuleType.DENYLIST, ModuleType.REDSTONE, ModuleType.SMART, ModuleType.HARMING, ModuleType.DISGUISE};
    }

    @Override
    public Option<?>[] customOptions() {
        return new Option[]{this.sendAllowlistMessage, this.sendDenylistMessage, this.smartModuleCooldown};
    }

    @Override
    public boolean isModuleEnabled(ModuleType module) {
        return this.hasModule(module) && this.moduleStates.get((Object)module) == Boolean.TRUE;
    }

    @Override
    public void toggleModuleState(ModuleType module, boolean shouldBeEnabled) {
        this.moduleStates.put(module, shouldBeEnabled);
    }

    public ModelData getModelData() {
        return DisguisableBlockEntity.getModelData((BlockEntity)this);
    }

    public boolean sendsAllowlistMessage() {
        return (Boolean)this.sendAllowlistMessage.get();
    }

    public void setSendsAllowlistMessage(boolean value) {
        this.sendAllowlistMessage.setValue(value);
        this.level.sendBlockUpdated(this.worldPosition, this.getBlockState(), this.getBlockState(), 3);
        this.setChanged();
    }

    public boolean sendsDenylistMessage() {
        return (Boolean)this.sendDenylistMessage.get();
    }

    public void setSendsDenylistMessage(boolean value) {
        this.sendDenylistMessage.setValue(value);
        this.level.sendBlockUpdated(this.worldPosition, this.getBlockState(), this.getBlockState(), 3);
        this.setChanged();
    }

    public void setPreviousChest(Block previousChest) {
        this.previousChest = Utils.getRegistryName(previousChest);
    }

    public ResourceLocation getPreviousChest() {
        return this.previousChest;
    }

    @Override
    public Level myLevel() {
        return this.level;
    }

    @Override
    public BlockPos myPos() {
        return this.worldPosition;
    }
}

