/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.api;

import java.util.Optional;
import net.geforcemods.securitycraft.SCContent;
import net.geforcemods.securitycraft.api.IModuleInventory;
import net.geforcemods.securitycraft.components.SavedBlockState;
import net.geforcemods.securitycraft.items.ModuleItem;
import net.geforcemods.securitycraft.misc.ModuleType;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.registries.Registries;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;

public interface IDisguisable {
    default public ItemStack getDisguisedStack(BlockGetter level, BlockPos pos) {
        BlockEntity blockEntity;
        if (level != null && (blockEntity = level.getBlockEntity(pos)) instanceof IModuleInventory) {
            Block block;
            ItemStack stack;
            IModuleInventory be = (IModuleInventory)blockEntity;
            ItemStack itemStack = stack = be.isModuleEnabled(ModuleType.DISGUISE) ? be.getModule(ModuleType.DISGUISE) : ItemStack.EMPTY;
            if (!stack.isEmpty() && (block = ModuleItem.getBlockAddon(stack)) != null) {
                return new ItemStack((ItemLike)block);
            }
        }
        return this.getDefaultStack();
    }

    default public ItemStack getDefaultStack() {
        return new ItemStack((ItemLike)((Block)this));
    }

    public static BlockState getDisguisedStateOrDefault(BlockState state, BlockGetter level, BlockPos pos) {
        if (level instanceof LevelReader) {
            LevelReader reader = (LevelReader)level;
            return IDisguisable.getDisguisedBlockState(reader, pos).orElse(state);
        }
        return state;
    }

    public static Optional<BlockState> getDisguisedBlockState(LevelReader level, BlockPos pos) {
        IModuleInventory be;
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (blockEntity instanceof IModuleInventory && (be = (IModuleInventory)blockEntity).isModuleEnabled(ModuleType.DISGUISE)) {
            return IDisguisable.getDisguisedBlockStateFromStack((HolderGetter<Block>)level.holderLookup(Registries.BLOCK), be.getModule(ModuleType.DISGUISE));
        }
        return Optional.empty();
    }

    public static Optional<BlockState> getDisguisedBlockStateFromStack(Level level, ItemStack module) {
        return IDisguisable.getDisguisedBlockStateFromStack((HolderGetter<Block>)level.holderLookup(Registries.BLOCK), module);
    }

    public static Optional<BlockState> getDisguisedBlockStateFromStack(HolderGetter<Block> holderGetter, ItemStack module) {
        SavedBlockState savedBlockState = (SavedBlockState)module.get(SCContent.SAVED_BLOCK_STATE);
        if (savedBlockState != null) {
            BlockState disguisedState = savedBlockState.state();
            if (disguisedState != null && disguisedState.getBlock() != Blocks.AIR) {
                return Optional.of(disguisedState);
            }
            Block block = ModuleItem.getBlockAddon(module);
            if (block != null) {
                return Optional.of(block.defaultBlockState());
            }
        }
        return Optional.empty();
    }
}

