/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft;

import com.google.common.base.Suppliers;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexFormat;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.Map;
import java.util.OptionalDouble;
import java.util.function.BiPredicate;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import net.geforcemods.securitycraft.ConfigHandler;
import net.geforcemods.securitycraft.SCClientEventHandler;
import net.geforcemods.securitycraft.SCContent;
import net.geforcemods.securitycraft.SecurityCraft;
import net.geforcemods.securitycraft.api.ICodebreakable;
import net.geforcemods.securitycraft.api.IDisguisable;
import net.geforcemods.securitycraft.api.IExplosive;
import net.geforcemods.securitycraft.api.ILockable;
import net.geforcemods.securitycraft.api.IOwnable;
import net.geforcemods.securitycraft.api.IPasscodeProtected;
import net.geforcemods.securitycraft.api.IReinforcedBlock;
import net.geforcemods.securitycraft.blockentities.AlarmBlockEntity;
import net.geforcemods.securitycraft.blockentities.InventoryScannerBlockEntity;
import net.geforcemods.securitycraft.blockentities.LaserBlockBlockEntity;
import net.geforcemods.securitycraft.blockentities.RiftStabilizerBlockEntity;
import net.geforcemods.securitycraft.blockentities.SecretHangingSignBlockEntity;
import net.geforcemods.securitycraft.blockentities.SecretSignBlockEntity;
import net.geforcemods.securitycraft.blockentities.SecureRedstoneInterfaceBlockEntity;
import net.geforcemods.securitycraft.blockentities.SecurityCameraBlockEntity;
import net.geforcemods.securitycraft.blockentities.SonicSecuritySystemBlockEntity;
import net.geforcemods.securitycraft.blockentities.UsernameLoggerBlockEntity;
import net.geforcemods.securitycraft.blocks.InventoryScannerFieldBlock;
import net.geforcemods.securitycraft.blocks.LaserFieldBlock;
import net.geforcemods.securitycraft.components.CodebreakerData;
import net.geforcemods.securitycraft.components.GlobalPositionComponent;
import net.geforcemods.securitycraft.components.GlobalPositions;
import net.geforcemods.securitycraft.components.NamedPositions;
import net.geforcemods.securitycraft.components.SavedBlockState;
import net.geforcemods.securitycraft.entity.camera.SecurityCamera;
import net.geforcemods.securitycraft.entity.sentry.Sentry;
import net.geforcemods.securitycraft.items.CodebreakerItem;
import net.geforcemods.securitycraft.items.KeycardHolderItem;
import net.geforcemods.securitycraft.items.LensItem;
import net.geforcemods.securitycraft.misc.LayerToggleHandler;
import net.geforcemods.securitycraft.models.BlockMineModel;
import net.geforcemods.securitycraft.models.BulletModel;
import net.geforcemods.securitycraft.models.DisguisableDynamicBakedModel;
import net.geforcemods.securitycraft.models.IMSBombModel;
import net.geforcemods.securitycraft.models.SecureRedstoneInterfaceDishModel;
import net.geforcemods.securitycraft.models.SecurityCameraModel;
import net.geforcemods.securitycraft.models.SentryModel;
import net.geforcemods.securitycraft.models.SonicSecuritySystemModel;
import net.geforcemods.securitycraft.particle.FloorTrapCloudParticle;
import net.geforcemods.securitycraft.particle.InterfaceHighlightParticle;
import net.geforcemods.securitycraft.renderers.BlockPocketManagerRenderer;
import net.geforcemods.securitycraft.renderers.BouncingBettyRenderer;
import net.geforcemods.securitycraft.renderers.BulletRenderer;
import net.geforcemods.securitycraft.renderers.ClaymoreRenderer;
import net.geforcemods.securitycraft.renderers.DisguisableBlockEntityRenderer;
import net.geforcemods.securitycraft.renderers.DisplayCaseItemRenderer;
import net.geforcemods.securitycraft.renderers.DisplayCaseRenderer;
import net.geforcemods.securitycraft.renderers.IMSBombRenderer;
import net.geforcemods.securitycraft.renderers.KeypadChestItemRenderer;
import net.geforcemods.securitycraft.renderers.KeypadChestRenderer;
import net.geforcemods.securitycraft.renderers.OwnableBlockEntityRenderer;
import net.geforcemods.securitycraft.renderers.ProjectorRenderer;
import net.geforcemods.securitycraft.renderers.ReinforcedPistonHeadRenderer;
import net.geforcemods.securitycraft.renderers.RetinalScannerRenderer;
import net.geforcemods.securitycraft.renderers.SecretHangingSignRenderer;
import net.geforcemods.securitycraft.renderers.SecretSignRenderer;
import net.geforcemods.securitycraft.renderers.SecureRedstoneInterfaceRenderer;
import net.geforcemods.securitycraft.renderers.SecurityCameraRenderer;
import net.geforcemods.securitycraft.renderers.SecuritySeaBoatRenderer;
import net.geforcemods.securitycraft.renderers.SentryRenderer;
import net.geforcemods.securitycraft.renderers.SonicSecuritySystemRenderer;
import net.geforcemods.securitycraft.renderers.TrophySystemRenderer;
import net.geforcemods.securitycraft.screen.AlarmScreen;
import net.geforcemods.securitycraft.screen.BlockChangeDetectorScreen;
import net.geforcemods.securitycraft.screen.BlockPocketManagerScreen;
import net.geforcemods.securitycraft.screen.BlockReinforcerScreen;
import net.geforcemods.securitycraft.screen.BriefcasePasscodeScreen;
import net.geforcemods.securitycraft.screen.CameraMonitorScreen;
import net.geforcemods.securitycraft.screen.CheckPasscodeScreen;
import net.geforcemods.securitycraft.screen.CustomizeBlockScreen;
import net.geforcemods.securitycraft.screen.DisguiseModuleScreen;
import net.geforcemods.securitycraft.screen.EditModuleScreen;
import net.geforcemods.securitycraft.screen.InventoryScannerScreen;
import net.geforcemods.securitycraft.screen.ItemInventoryScreen;
import net.geforcemods.securitycraft.screen.KeyChangerScreen;
import net.geforcemods.securitycraft.screen.KeycardReaderScreen;
import net.geforcemods.securitycraft.screen.KeypadBlastFurnaceScreen;
import net.geforcemods.securitycraft.screen.KeypadFurnaceScreen;
import net.geforcemods.securitycraft.screen.KeypadSmokerScreen;
import net.geforcemods.securitycraft.screen.LaserBlockScreen;
import net.geforcemods.securitycraft.screen.MineRemoteAccessToolScreen;
import net.geforcemods.securitycraft.screen.ProjectorScreen;
import net.geforcemods.securitycraft.screen.ReinforcedLecternScreen;
import net.geforcemods.securitycraft.screen.RiftStabilizerScreen;
import net.geforcemods.securitycraft.screen.SCManualScreen;
import net.geforcemods.securitycraft.screen.SSSItemScreen;
import net.geforcemods.securitycraft.screen.SecureRedstoneInterfaceScreen;
import net.geforcemods.securitycraft.screen.SentryRemoteAccessToolScreen;
import net.geforcemods.securitycraft.screen.SetPasscodeScreen;
import net.geforcemods.securitycraft.screen.SingleLensScreen;
import net.geforcemods.securitycraft.screen.SonicSecuritySystemScreen;
import net.geforcemods.securitycraft.screen.TrophySystemScreen;
import net.geforcemods.securitycraft.screen.UsernameLoggerScreen;
import net.geforcemods.securitycraft.util.BlockEntityRenderDelegate;
import net.geforcemods.securitycraft.util.Reinforced;
import net.geforcemods.securitycraft.util.Utils;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.HangingSignEditScreen;
import net.minecraft.client.gui.screens.inventory.SignEditScreen;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.BiomeColors;
import net.minecraft.client.renderer.BlockEntityWithoutLevelRenderer;
import net.minecraft.client.renderer.ItemBlockRenderTypes;
import net.minecraft.client.renderer.RenderStateShard;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.LecternRenderer;
import net.minecraft.client.renderer.entity.NoopRenderer;
import net.minecraft.client.renderer.item.ItemProperties;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.ModelResourceLocation;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.GlobalPos;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FastColor;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.Nameable;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.DyedItemColor;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.GrassColor;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SnowyDirtBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.entity.SignBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateHolder;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.fml.common.asm.enumextension.EnumProxy;
import net.neoforged.fml.event.lifecycle.FMLClientSetupEvent;
import net.neoforged.neoforge.client.event.EntityRenderersEvent;
import net.neoforged.neoforge.client.event.ModelEvent;
import net.neoforged.neoforge.client.event.RegisterColorHandlersEvent;
import net.neoforged.neoforge.client.event.RegisterGuiLayersEvent;
import net.neoforged.neoforge.client.event.RegisterMenuScreensEvent;
import net.neoforged.neoforge.client.event.RegisterParticleProvidersEvent;
import net.neoforged.neoforge.client.extensions.common.IClientItemExtensions;
import net.neoforged.neoforge.client.extensions.common.RegisterClientExtensionsEvent;
import net.neoforged.neoforge.registries.DeferredBlock;

@EventBusSubscriber(modid="securitycraft", bus=EventBusSubscriber.Bus.MOD, value={Dist.CLIENT})
public class ClientHandler {
    public static final float EMPTY_STATE = 0.0f;
    public static final float UNKNOWN_STATE = 0.25f;
    public static final float NOT_LINKED_STATE = 0.5f;
    public static final float LINKED_STATE = 0.75f;
    public static final ModelLayerLocation BULLET_LOCATION = new ModelLayerLocation(SecurityCraft.resLoc("bullet"), "main");
    public static final ModelLayerLocation IMS_BOMB_LOCATION = new ModelLayerLocation(SecurityCraft.resLoc("ims_bomb"), "main");
    public static final ModelLayerLocation DISPLAY_CASE_LOCATION = new ModelLayerLocation(SecurityCraft.resLoc("display_case"), "main");
    public static final ModelLayerLocation GLOW_DISPLAY_CASE_LOCATION = new ModelLayerLocation(SecurityCraft.resLoc("glow_display_case"), "main");
    public static final ModelLayerLocation SENTRY_LOCATION = new ModelLayerLocation(SecurityCraft.resLoc("sentry"), "main");
    public static final ModelLayerLocation SECURE_REDSTONE_INTERFACE_DISH_LAYER_LOCATION = new ModelLayerLocation(SecurityCraft.resLoc("secure_redstone_interface_dish"), "main");
    public static final ModelLayerLocation SECURITY_CAMERA_LOCATION = new ModelLayerLocation(SecurityCraft.resLoc("security_camera"), "main");
    public static final ModelLayerLocation SONIC_SECURITY_SYSTEM_LOCATION = new ModelLayerLocation(SecurityCraft.resLoc("sonic_security_system"), "main");
    public static final BlockEntityRenderDelegate DISGUISED_BLOCK_RENDER_DELEGATE = new BlockEntityRenderDelegate();
    public static final BlockEntityRenderDelegate PROJECTOR_RENDER_DELEGATE = new BlockEntityRenderDelegate();
    public static final ResourceLocation CAMERA_LAYER = SecurityCraft.resLoc("camera_overlay");
    private static Map<Block, Integer> blocksWithReinforcedTint = new HashMap<Block, Integer>();
    private static Map<Block, Integer> blocksWithCustomTint = new HashMap<Block, Integer>();
    private static Supplier<Block[]> disguisableBlocks = Suppliers.memoize(() -> new Block[]{(Block)SCContent.BLOCK_CHANGE_DETECTOR.get(), (Block)SCContent.CAGE_TRAP.get(), (Block)SCContent.FLOOR_TRAP.get(), (Block)SCContent.INVENTORY_SCANNER.get(), (Block)SCContent.KEYCARD_READER.get(), (Block)SCContent.KEYPAD.get(), (Block)SCContent.KEYPAD_BARREL.get(), (Block)SCContent.KEYPAD_BLAST_FURNACE.get(), (Block)SCContent.KEYPAD_CHEST.get(), (Block)SCContent.KEYPAD_DOOR.get(), (Block)SCContent.KEYPAD_FURNACE.get(), (Block)SCContent.KEYPAD_SMOKER.get(), (Block)SCContent.KEYPAD_TRAPDOOR.get(), (Block)SCContent.LASER_BLOCK.get(), (Block)SCContent.PROJECTOR.get(), (Block)SCContent.PROTECTO.get(), (Block)SCContent.REINFORCED_DISPENSER.get(), (Block)SCContent.REINFORCED_DROPPER.get(), (Block)SCContent.REINFORCED_HOPPER.get(), (Block)SCContent.REINFORCED_OBSERVER.get(), (Block)SCContent.RETINAL_SCANNER.get(), (Block)SCContent.RIFT_STABILIZER.get(), (Block)SCContent.SCANNER_DOOR.get(), (Block)SCContent.SCANNER_TRAPDOOR.get(), (Block)SCContent.SECURITY_CAMERA.get(), (Block)SCContent.SECURE_REDSTONE_INTERFACE.get(), (Block)SCContent.SENTRY_DISGUISE.get(), (Block)SCContent.SONIC_SECURITY_SYSTEM.get(), (Block)SCContent.TROPHY_SYSTEM.get(), (Block)SCContent.USERNAME_LOGGER.get()});
    public static final RenderType.CompositeRenderType OVERLAY_LINES = RenderType.create((String)"overlay_lines", (VertexFormat)DefaultVertexFormat.POSITION_COLOR_NORMAL, (VertexFormat.Mode)VertexFormat.Mode.LINES, (int)1536, (RenderType.CompositeState)RenderType.CompositeState.builder().setShaderState(RenderStateShard.RENDERTYPE_LINES_SHADER).setLineState(new RenderStateShard.LineStateShard(OptionalDouble.empty())).setLayeringState(RenderStateShard.VIEW_OFFSET_Z_LAYERING).setTransparencyState(RenderStateShard.TRANSLUCENT_TRANSPARENCY).setOutputState(RenderStateShard.OUTLINE_TARGET).setWriteMaskState(RenderStateShard.COLOR_DEPTH_WRITE).setCullState(RenderStateShard.NO_CULL).createCompositeState(false));
    public static final EnumProxy<HumanoidModel.ArmPose> TASER_ARM_POSE_PARAMS = new EnumProxy(HumanoidModel.ArmPose.class, new Object[]{true, (model, entity, arm) -> {
        ModelPart leftArm = model.leftArm;
        ModelPart rightArm = model.rightArm;
        leftArm.yRot = 0.5f;
        rightArm.yRot = -0.5f;
        rightArm.xRot = -1.5f;
        leftArm.xRot = -1.5f;
    }});
    public static final ResourceLocation LINKING_STATE_PROPERTY = SecurityCraft.resLoc("linking_state");

    private ClientHandler() {
    }

    @SubscribeEvent
    public static void onModelBakingCompleted(ModelEvent.ModifyBakingResult event) {
        String[] mines = new String[]{"ancient_debris", "blast_furnace", "coal_ore", "cobbled_deepslate", "cobblestone", "copper_ore", "deepslate", "deepslate_coal_ore", "deepslate_copper_ore", "deepslate_diamond_ore", "deepslate_emerald_ore", "deepslate_gold_ore", "deepslate_iron_ore", "deepslate_lapis_ore", "deepslate_redstone_ore", "diamond_ore", "dirt", "emerald_ore", "gravel", "gold_ore", "gilded_blackstone", "furnace", "iron_ore", "lapis_ore", "nether_gold_ore", "redstone_ore", "sand", "smoker", "stone", "suspicious_gravel", "suspicious_sand"};
        Map modelRegistry = event.getModels();
        for (Block block : disguisableBlocks.get()) {
            for (BlockState state : block.getStateDefinition().getPossibleStates()) {
                ClientHandler.registerDisguisedModel(modelRegistry, Utils.getRegistryName(block), state.getValues().entrySet().stream().map(StateHolder.PROPERTY_ENTRY_TO_STRING_FUNCTION).collect(Collectors.joining(",")));
            }
        }
        for (String string : mines) {
            ClientHandler.registerBlockMineModel(event, SecurityCraft.resLoc(string.replace("_ore", "") + "_mine"), SecurityCraft.mcResLoc(string));
        }
        ClientHandler.registerBlockMineModel(event, SecurityCraft.resLoc("quartz_mine"), SecurityCraft.mcResLoc("nether_quartz_ore"));
    }

    private static void registerDisguisedModel(Map<ModelResourceLocation, BakedModel> modelRegistry, ResourceLocation rl, String stateString) {
        ModelResourceLocation mrl = new ModelResourceLocation(rl, stateString);
        modelRegistry.put(mrl, (BakedModel)new DisguisableDynamicBakedModel(modelRegistry.get(mrl)));
    }

    private static void registerBlockMineModel(ModelEvent.ModifyBakingResult event, ResourceLocation mineRl, ResourceLocation realBlockRl) {
        ModelResourceLocation mineMrl = new ModelResourceLocation(mineRl, "inventory");
        event.getModels().put(mineMrl, new BlockMineModel((BakedModel)event.getModels().get(new ModelResourceLocation(realBlockRl, "inventory")), (BakedModel)event.getModels().get(mineMrl)));
    }

    @SubscribeEvent
    public static void onFMLClientSetup(FMLClientSetupEvent event) {
        RenderType translucent = RenderType.translucent();
        ItemBlockRenderTypes.setRenderLayer((Fluid)((Fluid)SCContent.FAKE_WATER.get()), (RenderType)translucent);
        ItemBlockRenderTypes.setRenderLayer((Fluid)((Fluid)SCContent.FLOWING_FAKE_WATER.get()), (RenderType)translucent);
        event.enqueueWork(() -> {
            ItemProperties.register((Item)((Item)SCContent.KEYCARD_HOLDER.get()), (ResourceLocation)KeycardHolderItem.COUNT_PROPERTY, (stack, level, entity, id) -> (float)KeycardHolderItem.getCardCount(stack) / 5.0f);
            ItemProperties.register((Item)((Item)SCContent.LENS.get()), (ResourceLocation)LensItem.COLOR_PROPERTY, (stack, level, entity, id) -> stack.has(DataComponents.DYED_COLOR) ? 1.0f : 0.0f);
            ItemProperties.register((Item)((Item)SCContent.CAMERA_MONITOR.get()), (ResourceLocation)LINKING_STATE_PROPERTY, (stack, level, entity, id) -> {
                if (!(entity instanceof Player)) {
                    return 0.0f;
                }
                Player player = (Player)entity;
                float linkingState = ClientHandler.getLinkingState((Level)level, player, stack, bhr -> level.getBlockEntity(bhr.getBlockPos()) instanceof SecurityCameraBlockEntity, (DataComponentType)SCContent.BOUND_CAMERAS.get());
                NamedPositions positions = (NamedPositions)stack.get(SCContent.BOUND_CAMERAS);
                if (positions != null && positions.isEmpty()) {
                    if (linkingState == 0.5f) {
                        return 0.5f;
                    }
                    return 0.0f;
                }
                return linkingState;
            });
            ItemProperties.register((Item)((Item)SCContent.MINE_REMOTE_ACCESS_TOOL.get()), (ResourceLocation)LINKING_STATE_PROPERTY, (stack, level, entity, id) -> {
                if (!(entity instanceof Player)) {
                    return 0.0f;
                }
                Player player = (Player)entity;
                float linkingState = ClientHandler.getLinkingState((Level)level, player, stack, bhr -> level.getBlockState(bhr.getBlockPos()).getBlock() instanceof IExplosive, (DataComponentType)SCContent.BOUND_MINES.get());
                GlobalPositions positions = (GlobalPositions)stack.get(SCContent.BOUND_MINES);
                if (positions != null && positions.isEmpty()) {
                    if (linkingState == 0.5f) {
                        return 0.5f;
                    }
                    return 0.0f;
                }
                return linkingState;
            });
            ItemProperties.register((Item)((Item)SCContent.SENTRY_REMOTE_ACCESS_TOOL.get()), (ResourceLocation)LINKING_STATE_PROPERTY, (stack, level, entity, id) -> {
                Entity patt0$temp;
                if (!(entity instanceof Player)) {
                    return 0.0f;
                }
                NamedPositions positions = (NamedPositions)stack.get(SCContent.BOUND_SENTRIES);
                if (positions != null && (patt0$temp = Minecraft.getInstance().crosshairPickEntity) instanceof Sentry) {
                    float linkingState;
                    Sentry sentry = (Sentry)patt0$temp;
                    float f = linkingState = positions.isPositionAdded(new GlobalPos(level.dimension(), sentry.blockPosition())) ? 0.75f : 0.5f;
                    if (positions.isEmpty()) {
                        if (linkingState == 0.5f) {
                            return 0.5f;
                        }
                        return 0.0f;
                    }
                    return linkingState;
                }
                return positions != null && !positions.isEmpty() ? 0.25f : 0.0f;
            });
            ItemProperties.register((Item)((Item)SCContent.SONIC_SECURITY_SYSTEM_ITEM.get()), (ResourceLocation)LINKING_STATE_PROPERTY, (stack, level, entity, id) -> {
                if (!(entity instanceof Player)) {
                    return 0.0f;
                }
                Player player = (Player)entity;
                float linkingState = ClientHandler.getLinkingState((Level)level, player, stack, bhr -> {
                    IOwnable ownable;
                    BlockEntity patt0$temp = level.getBlockEntity(bhr.getBlockPos());
                    if (!(patt0$temp instanceof ILockable)) {
                        return false;
                    }
                    ILockable lockable = (ILockable)patt0$temp;
                    return lockable instanceof IOwnable && (ownable = (IOwnable)((Object)lockable)).isOwnedBy((Entity)player) || !IDisguisable.getDisguisedBlockState((LevelReader)level, bhr.getBlockPos()).isPresent();
                }, (DataComponentType)SCContent.SSS_LINKED_BLOCKS.get(), GlobalPositionComponent::isPositionAdded);
                GlobalPositions positions = (GlobalPositions)stack.get(SCContent.SSS_LINKED_BLOCKS);
                if (positions != null && positions.isEmpty()) {
                    if (linkingState == 0.5f) {
                        return 0.5f;
                    }
                    return 0.0f;
                }
                return linkingState;
            });
            ItemProperties.register((Item)((Item)SCContent.CODEBREAKER.get()), (ResourceLocation)CodebreakerItem.STATE_PROPERTY, (stack, level, entity, id) -> {
                CodebreakerData codebreakerData = (CodebreakerData)stack.getOrDefault(SCContent.CODEBREAKER_DATA, (Object)CodebreakerData.DEFAULT);
                boolean isPlayer = entity instanceof Player;
                if ((!isPlayer || !((Player)entity).isCreative() && !((Player)entity).isSpectator()) && codebreakerData.wasRecentlyUsed()) {
                    return codebreakerData.wasSuccessful() ? 0.75f : 0.5f;
                }
                if (!isPlayer) {
                    return 0.0f;
                }
                float state = ClientHandler.getLinkingState((Level)level, (Player)entity, stack, bhr -> level.getBlockEntity(bhr.getBlockPos()) instanceof ICodebreakable);
                if (state == 0.75f || state == 0.5f) {
                    return 0.25f;
                }
                return 0.0f;
            });
        });
    }

    @SubscribeEvent
    public static void registerMenuScreens(RegisterMenuScreensEvent event) {
        event.register((MenuType)SCContent.BLOCK_REINFORCER_MENU.get(), BlockReinforcerScreen::new);
        event.register((MenuType)SCContent.BRIEFCASE_INVENTORY_MENU.get(), ItemInventoryScreen.Briefcase::new);
        event.register((MenuType)SCContent.CUSTOMIZE_BLOCK_MENU.get(), CustomizeBlockScreen::new);
        event.register((MenuType)SCContent.CUSTOMIZE_ENTITY_MENU.get(), CustomizeBlockScreen::new);
        event.register((MenuType)SCContent.DISGUISE_MODULE_MENU.get(), DisguiseModuleScreen::new);
        event.register((MenuType)SCContent.INVENTORY_SCANNER_MENU.get(), InventoryScannerScreen::new);
        event.register((MenuType)SCContent.KEYPAD_FURNACE_MENU.get(), KeypadFurnaceScreen::new);
        event.register((MenuType)SCContent.KEYPAD_SMOKER_MENU.get(), KeypadSmokerScreen::new);
        event.register((MenuType)SCContent.KEYPAD_BLAST_FURNACE_MENU.get(), KeypadBlastFurnaceScreen::new);
        event.register((MenuType)SCContent.KEYCARD_READER_MENU.get(), KeycardReaderScreen::new);
        event.register((MenuType)SCContent.BLOCK_POCKET_MANAGER_MENU.get(), BlockPocketManagerScreen::new);
        event.register((MenuType)SCContent.PROJECTOR_MENU.get(), ProjectorScreen::new);
        event.register((MenuType)SCContent.BLOCK_CHANGE_DETECTOR_MENU.get(), BlockChangeDetectorScreen::new);
        event.register((MenuType)SCContent.KEYCARD_HOLDER_MENU.get(), ItemInventoryScreen.KeycardHolder::new);
        event.register((MenuType)SCContent.TROPHY_SYSTEM_MENU.get(), TrophySystemScreen::new);
        event.register((MenuType)SCContent.SINGLE_LENS_MENU.get(), SingleLensScreen::new);
        event.register((MenuType)SCContent.LASER_BLOCK_MENU.get(), LaserBlockScreen::new);
        event.register((MenuType)SCContent.REINFORCED_LECTERN_MENU.get(), ReinforcedLecternScreen::new);
    }

    @SubscribeEvent
    public static void registerGuiLayers(RegisterGuiLayersEvent event) {
        event.registerAboveAll(CAMERA_LAYER, SCClientEventHandler::cameraOverlay);
        LayerToggleHandler.disable(CAMERA_LAYER);
    }

    @SubscribeEvent
    public static void registerEntityRenderers(EntityRenderersEvent.RegisterRenderers event) {
        event.registerEntityRenderer((EntityType)SCContent.BOUNCING_BETTY_ENTITY.get(), BouncingBettyRenderer::new);
        event.registerEntityRenderer((EntityType)SCContent.IMS_BOMB_ENTITY.get(), IMSBombRenderer::new);
        event.registerEntityRenderer((EntityType)SCContent.SECURITY_CAMERA_ENTITY.get(), NoopRenderer::new);
        event.registerEntityRenderer((EntityType)SCContent.SENTRY_ENTITY.get(), SentryRenderer::new);
        event.registerEntityRenderer((EntityType)SCContent.BULLET_ENTITY.get(), BulletRenderer::new);
        event.registerEntityRenderer((EntityType)SCContent.SECURITY_SEA_BOAT_ENTITY.get(), SecuritySeaBoatRenderer::new);
        event.registerBlockEntityRenderer((BlockEntityType)SCContent.BLOCK_POCKET_MANAGER_BLOCK_ENTITY.get(), BlockPocketManagerRenderer::new);
        event.registerBlockEntityRenderer((BlockEntityType)SCContent.CLAYMORE_BLOCK_ENTITY.get(), ClaymoreRenderer::new);
        event.registerBlockEntityRenderer((BlockEntityType)SCContent.KEYPAD_CHEST_BLOCK_ENTITY.get(), KeypadChestRenderer::new);
        event.registerBlockEntityRenderer((BlockEntityType)SCContent.DISPLAY_CASE_BLOCK_ENTITY.get(), ctx -> new DisplayCaseRenderer(ctx, false));
        event.registerBlockEntityRenderer((BlockEntityType)SCContent.GLOW_DISPLAY_CASE_BLOCK_ENTITY.get(), ctx -> new DisplayCaseRenderer(ctx, true));
        event.registerBlockEntityRenderer((BlockEntityType)SCContent.OWNABLE_BLOCK_ENTITY.get(), OwnableBlockEntityRenderer::new);
        event.registerBlockEntityRenderer((BlockEntityType)SCContent.REINFORCED_LECTERN_BLOCK_ENTITY.get(), LecternRenderer::new);
        event.registerBlockEntityRenderer((BlockEntityType)SCContent.PROJECTOR_BLOCK_ENTITY.get(), ProjectorRenderer::new);
        event.registerBlockEntityRenderer((BlockEntityType)SCContent.REINFORCED_PISTON_BLOCK_ENTITY.get(), ReinforcedPistonHeadRenderer::new);
        event.registerBlockEntityRenderer((BlockEntityType)SCContent.RETINAL_SCANNER_BLOCK_ENTITY.get(), RetinalScannerRenderer::new);
        event.registerBlockEntityRenderer((BlockEntityType)SCContent.SECURE_REDSTONE_INTERFACE_BLOCK_ENTITY.get(), SecureRedstoneInterfaceRenderer::new);
        event.registerBlockEntityRenderer((BlockEntityType)SCContent.SECURITY_CAMERA_BLOCK_ENTITY.get(), SecurityCameraRenderer::new);
        event.registerBlockEntityRenderer((BlockEntityType)SCContent.SECRET_HANGING_SIGN_BLOCK_ENTITY.get(), SecretHangingSignRenderer::new);
        event.registerBlockEntityRenderer((BlockEntityType)SCContent.SECRET_SIGN_BLOCK_ENTITY.get(), SecretSignRenderer::new);
        event.registerBlockEntityRenderer((BlockEntityType)SCContent.SONIC_SECURITY_SYSTEM_BLOCK_ENTITY.get(), SonicSecuritySystemRenderer::new);
        event.registerBlockEntityRenderer((BlockEntityType)SCContent.TROPHY_SYSTEM_BLOCK_ENTITY.get(), TrophySystemRenderer::new);
        event.registerBlockEntityRenderer((BlockEntityType)SCContent.BLOCK_CHANGE_DETECTOR_BLOCK_ENTITY.get(), DisguisableBlockEntityRenderer::new);
        event.registerBlockEntityRenderer((BlockEntityType)SCContent.CAGE_TRAP_BLOCK_ENTITY.get(), DisguisableBlockEntityRenderer::new);
        event.registerBlockEntityRenderer((BlockEntityType)SCContent.DISGUISABLE_BLOCK_ENTITY.get(), DisguisableBlockEntityRenderer::new);
        event.registerBlockEntityRenderer((BlockEntityType)SCContent.FLOOR_TRAP_BLOCK_ENTITY.get(), DisguisableBlockEntityRenderer::new);
        event.registerBlockEntityRenderer((BlockEntityType)SCContent.INVENTORY_SCANNER_BLOCK_ENTITY.get(), DisguisableBlockEntityRenderer::new);
        event.registerBlockEntityRenderer((BlockEntityType)SCContent.KEYCARD_READER_BLOCK_ENTITY.get(), DisguisableBlockEntityRenderer::new);
        event.registerBlockEntityRenderer((BlockEntityType)SCContent.KEYPAD_BLOCK_ENTITY.get(), DisguisableBlockEntityRenderer::new);
        event.registerBlockEntityRenderer((BlockEntityType)SCContent.KEYPAD_BARREL_BLOCK_ENTITY.get(), DisguisableBlockEntityRenderer::new);
        event.registerBlockEntityRenderer((BlockEntityType)SCContent.KEYPAD_BLAST_FURNACE_BLOCK_ENTITY.get(), DisguisableBlockEntityRenderer::new);
        event.registerBlockEntityRenderer((BlockEntityType)SCContent.KEYPAD_DOOR_BLOCK_ENTITY.get(), DisguisableBlockEntityRenderer::new);
        event.registerBlockEntityRenderer((BlockEntityType)SCContent.KEYPAD_TRAPDOOR_BLOCK_ENTITY.get(), DisguisableBlockEntityRenderer::new);
        event.registerBlockEntityRenderer((BlockEntityType)SCContent.KEYPAD_FURNACE_BLOCK_ENTITY.get(), DisguisableBlockEntityRenderer::new);
        event.registerBlockEntityRenderer((BlockEntityType)SCContent.KEYPAD_SMOKER_BLOCK_ENTITY.get(), DisguisableBlockEntityRenderer::new);
        event.registerBlockEntityRenderer((BlockEntityType)SCContent.LASER_BLOCK_BLOCK_ENTITY.get(), DisguisableBlockEntityRenderer::new);
        event.registerBlockEntityRenderer((BlockEntityType)SCContent.PROTECTO_BLOCK_ENTITY.get(), DisguisableBlockEntityRenderer::new);
        event.registerBlockEntityRenderer((BlockEntityType)SCContent.REINFORCED_DISPENSER_BLOCK_ENTITY.get(), DisguisableBlockEntityRenderer::new);
        event.registerBlockEntityRenderer((BlockEntityType)SCContent.REINFORCED_DROPPER_BLOCK_ENTITY.get(), DisguisableBlockEntityRenderer::new);
        event.registerBlockEntityRenderer((BlockEntityType)SCContent.REINFORCED_HOPPER_BLOCK_ENTITY.get(), DisguisableBlockEntityRenderer::new);
        event.registerBlockEntityRenderer((BlockEntityType)SCContent.RIFT_STABILIZER_BLOCK_ENTITY.get(), DisguisableBlockEntityRenderer::new);
        event.registerBlockEntityRenderer((BlockEntityType)SCContent.SCANNER_DOOR_BLOCK_ENTITY.get(), DisguisableBlockEntityRenderer::new);
        event.registerBlockEntityRenderer((BlockEntityType)SCContent.SCANNER_TRAPDOOR_BLOCK_ENTITY.get(), DisguisableBlockEntityRenderer::new);
        event.registerBlockEntityRenderer((BlockEntityType)SCContent.USERNAME_LOGGER_BLOCK_ENTITY.get(), DisguisableBlockEntityRenderer::new);
    }

    @SubscribeEvent
    public static void registerEntityRenderers(EntityRenderersEvent.RegisterLayerDefinitions event) {
        event.registerLayerDefinition(BULLET_LOCATION, BulletModel::createLayer);
        event.registerLayerDefinition(IMS_BOMB_LOCATION, IMSBombModel::createLayer);
        event.registerLayerDefinition(DISPLAY_CASE_LOCATION, DisplayCaseRenderer::createModelLayer);
        event.registerLayerDefinition(GLOW_DISPLAY_CASE_LOCATION, DisplayCaseRenderer::createModelLayer);
        event.registerLayerDefinition(SENTRY_LOCATION, SentryModel::createLayer);
        event.registerLayerDefinition(SECURITY_CAMERA_LOCATION, SecurityCameraModel::createLayer);
        event.registerLayerDefinition(SONIC_SECURITY_SYSTEM_LOCATION, SonicSecuritySystemModel::createLayer);
        event.registerLayerDefinition(SECURE_REDSTONE_INTERFACE_DISH_LAYER_LOCATION, SecureRedstoneInterfaceDishModel::createLayer);
    }

    @SubscribeEvent
    public static void registerParticleProviders(RegisterParticleProvidersEvent event) {
        event.registerSpriteSet((ParticleType)SCContent.FLOOR_TRAP_CLOUD.get(), FloorTrapCloudParticle.Provider::new);
        event.registerSpriteSet((ParticleType)SCContent.INTERFACE_HIGHLIGHT.get(), InterfaceHighlightParticle.Provider::new);
    }

    @SubscribeEvent
    public static void onRegisterClientExtensions(RegisterClientExtensionsEvent event) {
        final DisplayCaseItemRenderer displayCaseItemRenderer = new DisplayCaseItemRenderer(false);
        final DisplayCaseItemRenderer glowDisplayCaseItemRenderer = new DisplayCaseItemRenderer(true);
        final KeypadChestItemRenderer keypadChestItemRenderer = new KeypadChestItemRenderer();
        event.registerItem(new IClientItemExtensions(){

            public BlockEntityWithoutLevelRenderer getCustomRenderer() {
                return displayCaseItemRenderer;
            }
        }, new Item[]{(Item)SCContent.DISPLAY_CASE_ITEM.get()});
        event.registerItem(new IClientItemExtensions(){

            public BlockEntityWithoutLevelRenderer getCustomRenderer() {
                return glowDisplayCaseItemRenderer;
            }
        }, new Item[]{(Item)SCContent.GLOW_DISPLAY_CASE_ITEM.get()});
        event.registerItem(new IClientItemExtensions(){

            public BlockEntityWithoutLevelRenderer getCustomRenderer() {
                return keypadChestItemRenderer;
            }
        }, new Item[]{(Item)SCContent.KEYPAD_CHEST_ITEM.get()});
        event.registerItem(new IClientItemExtensions(){
            private static final HumanoidModel.ArmPose TASER_ARM_POSE = (HumanoidModel.ArmPose)TASER_ARM_POSE_PARAMS.getValue();

            public boolean applyForgeHandTransform(PoseStack pose, LocalPlayer player, HumanoidArm arm, ItemStack stack, float partialTick, float equippedProgress, float swingProgress) {
                if (swingProgress < 0.001f) {
                    pose.translate(0.02f, -0.4f, -0.5f);
                    return true;
                }
                return false;
            }

            public HumanoidModel.ArmPose getArmPose(LivingEntity entity, InteractionHand hand, ItemStack stack) {
                return TASER_ARM_POSE;
            }
        }, new Item[]{(Item)SCContent.TASER.get(), (Item)SCContent.TASER_POWERED.get()});
    }

    private static void initTint() {
        for (Field field : SCContent.class.getFields()) {
            if (!field.isAnnotationPresent(Reinforced.class)) continue;
            try {
                Block block = (Block)((DeferredBlock)field.get(null)).get();
                int customTint = field.getAnnotation(Reinforced.class).customTint();
                if (field.getAnnotation(Reinforced.class).hasReinforcedTint()) {
                    blocksWithReinforcedTint.put(block, customTint);
                    continue;
                }
                if (customTint == -1) continue;
                blocksWithCustomTint.put(block, customTint);
            }
            catch (IllegalAccessException | IllegalArgumentException e) {
                e.printStackTrace();
            }
        }
        blocksWithReinforcedTint.put((Block)SCContent.BLOCK_POCKET_MANAGER.get(), -15354974);
        blocksWithReinforcedTint.put((Block)SCContent.BLOCK_POCKET_WALL.get(), -15354974);
        blocksWithCustomTint.put((Block)SCContent.CRYSTAL_QUARTZ_SLAB.get(), -15354974);
        blocksWithCustomTint.put((Block)SCContent.SMOOTH_CRYSTAL_QUARTZ.get(), -15354974);
        blocksWithCustomTint.put((Block)SCContent.CHISELED_CRYSTAL_QUARTZ.get(), -15354974);
        blocksWithCustomTint.put((Block)SCContent.CRYSTAL_QUARTZ_BLOCK.get(), -15354974);
        blocksWithCustomTint.put((Block)SCContent.CRYSTAL_QUARTZ_BRICKS.get(), -15354974);
        blocksWithCustomTint.put((Block)SCContent.CRYSTAL_QUARTZ_PILLAR.get(), -15354974);
        blocksWithCustomTint.put((Block)SCContent.CRYSTAL_QUARTZ_STAIRS.get(), -15354974);
        blocksWithCustomTint.put((Block)SCContent.SMOOTH_CRYSTAL_QUARTZ_SLAB.get(), -15354974);
        blocksWithCustomTint.put((Block)SCContent.SMOOTH_CRYSTAL_QUARTZ_STAIRS.get(), -15354974);
    }

    @SubscribeEvent
    public static void onRegisterColorHandlersBlock(RegisterColorHandlersEvent.Block event) {
        ClientHandler.initTint();
        blocksWithReinforcedTint.forEach((block, tint) -> event.register((state, level, pos, tintIndex) -> {
            if (tintIndex == 0) {
                return ClientHandler.mixWithReinforcedTintIfEnabled(tint);
            }
            return -1;
        }, new Block[]{block}));
        blocksWithCustomTint.forEach((block, tint) -> event.register((state, level, pos, tintIndex) -> {
            if (tintIndex == 0) {
                return tint;
            }
            return -1;
        }, new Block[]{block}));
        event.register((state, level, pos, tintIndex) -> {
            IDisguisable disguisedBlock;
            Block blockFromItem;
            BlockState defaultBlockState;
            Block block = state.getBlock();
            if (block instanceof IDisguisable && !(defaultBlockState = (blockFromItem = Block.byItem((Item)(disguisedBlock = (IDisguisable)block).getDisguisedStack((BlockGetter)level, pos).getItem())).defaultBlockState()).isAir() && !(blockFromItem instanceof IDisguisable)) {
                return Minecraft.getInstance().getBlockColors().getColor(defaultBlockState, level, pos, tintIndex);
            }
            if (block instanceof IReinforcedBlock) {
                return ClientHandler.mixWithReinforcedTintIfEnabled(-1);
            }
            return -1;
        }, disguisableBlocks.get());
        event.register((state, level, pos, tintIndex) -> {
            if (tintIndex == 1 && !((Boolean)state.getValue((Property)SnowyDirtBlock.SNOWY)).booleanValue()) {
                int grassTint = level != null && pos != null ? BiomeColors.getAverageGrassColor((BlockAndTintGetter)level, (BlockPos)pos) : GrassColor.get((double)0.5, (double)1.0);
                return ClientHandler.mixWithReinforcedTintIfEnabled(grassTint);
            }
            return (Integer)ConfigHandler.CLIENT.reinforcedBlockTintColor.get();
        }, new Block[]{(Block)SCContent.REINFORCED_GRASS_BLOCK.get()});
        event.register((state, level, pos, tintIndex) -> {
            if (tintIndex == 1) {
                return level != null && pos != null ? BiomeColors.getAverageWaterColor((BlockAndTintGetter)level, (BlockPos)pos) : -1;
            }
            return (Integer)ConfigHandler.CLIENT.reinforcedBlockTintColor.get();
        }, new Block[]{(Block)SCContent.REINFORCED_WATER_CAULDRON.get()});
        event.register((state, level, pos, tintIndex) -> {
            Direction direction = LaserFieldBlock.getFieldDirection(state);
            return ClientHandler.iterateFields(level, pos, direction, (Integer)ConfigHandler.SERVER.laserBlockRange.get(), (Block)SCContent.LASER_BLOCK.get(), LaserBlockBlockEntity.class::isInstance, be -> ((LaserBlockBlockEntity)be).getLensContainer().getItem(direction.getOpposite().ordinal()));
        }, new Block[]{(Block)SCContent.LASER_FIELD.get()});
        event.register((state, level, pos, tintIndex) -> {
            Direction direction = (Direction)state.getValue((Property)InventoryScannerFieldBlock.FACING);
            return ClientHandler.iterateFields(level, pos, direction, (Integer)ConfigHandler.SERVER.inventoryScannerRange.get(), (Block)SCContent.INVENTORY_SCANNER.get(), InventoryScannerBlockEntity.class::isInstance, be -> ((InventoryScannerBlockEntity)be).getLensContainer().getItem(0));
        }, new Block[]{(Block)SCContent.INVENTORY_SCANNER_FIELD.get()});
    }

    public static int iterateFields(BlockAndTintGetter level, BlockPos pos, Direction direction, int range, Block block, Predicate<BlockEntity> beTest, Function<BlockEntity, ItemStack> lensGetter) {
        try {
            return ClientHandler.iterateFieldsInternal(level, pos, direction, range, block, beTest, lensGetter);
        }
        catch (Exception e1) {
            direction = direction.getOpposite();
            try {
                return ClientHandler.iterateFieldsInternal(level, pos, direction, range, block, beTest, lensGetter);
            }
            catch (Exception exception) {
                return -1;
            }
        }
    }

    private static int iterateFieldsInternal(BlockAndTintGetter level, BlockPos pos, Direction direction, int range, Block block, Predicate<BlockEntity> beTest, Function<BlockEntity, ItemStack> lensGetter) throws ArrayIndexOutOfBoundsException {
        BlockPos.MutableBlockPos mutablePos = new BlockPos.MutableBlockPos(pos.getX(), pos.getY(), pos.getZ());
        for (int i = 0; i < range; ++i) {
            BlockEntity be;
            if (level.getBlockState((BlockPos)mutablePos).is(block) && beTest.test(be = level.getBlockEntity((BlockPos)mutablePos))) {
                ItemStack stack = lensGetter.apply(be);
                if (!stack.has(DataComponents.DYED_COLOR)) break;
                return ((DyedItemColor)stack.get(DataComponents.DYED_COLOR)).rgb();
            }
            mutablePos.move(direction);
        }
        return -1;
    }

    @SubscribeEvent
    public static void onRegisterColorHandlersItem(RegisterColorHandlersEvent.Item event) {
        blocksWithReinforcedTint.forEach((item, tint) -> event.register((stack, tintIndex) -> {
            if (tintIndex == 0) {
                return ClientHandler.mixWithReinforcedTintIfEnabled(tint);
            }
            return -1;
        }, new ItemLike[]{item}));
        blocksWithCustomTint.forEach((item, tint) -> event.register((stack, tintIndex) -> {
            if (tintIndex == 0) {
                return tint;
            }
            return -1;
        }, new ItemLike[]{item}));
        event.register((stack, tintIndex) -> tintIndex > 0 ? -1 : DyedItemColor.getOrDefault((ItemStack)stack, (int)-13421773), new ItemLike[]{(ItemLike)SCContent.BRIEFCASE.get()});
        event.register((stack, tintIndex) -> tintIndex > 0 ? -1 : DyedItemColor.getOrDefault((ItemStack)stack, (int)-1), new ItemLike[]{(ItemLike)SCContent.LENS.get()});
        event.register((stack, tintIndex) -> {
            if (tintIndex == 1) {
                int grassTint = GrassColor.get((double)0.5, (double)1.0);
                return ClientHandler.mixWithReinforcedTintIfEnabled(grassTint);
            }
            return (Integer)ConfigHandler.CLIENT.reinforcedBlockTintColor.get();
        }, new ItemLike[]{(ItemLike)SCContent.REINFORCED_GRASS_BLOCK.get()});
        blocksWithReinforcedTint = null;
        blocksWithCustomTint = null;
    }

    public static int mixWithReinforcedTintIfEnabled(int tint) {
        boolean tintReinforcedBlocks = Minecraft.getInstance().level == null ? ((Boolean)ConfigHandler.CLIENT.reinforcedBlockTint.get()).booleanValue() : ((Boolean)ConfigHandler.SERVER.forceReinforcedBlockTint.get() != false ? (Boolean)ConfigHandler.SERVER.reinforcedBlockTint.get() : (Boolean)ConfigHandler.CLIENT.reinforcedBlockTint.get()).booleanValue();
        return tintReinforcedBlocks ? FastColor.ARGB32.multiply((int)tint, (int)(0xFF000000 | (Integer)ConfigHandler.CLIENT.reinforcedBlockTintColor.get())) : tint;
    }

    public static Player getClientPlayer() {
        return Minecraft.getInstance().player;
    }

    public static Level getClientLevel() {
        return Minecraft.getInstance().level;
    }

    public static void displayMRATScreen(ItemStack stack) {
        Minecraft.getInstance().setScreen((Screen)new MineRemoteAccessToolScreen(stack));
    }

    public static void displaySRATScreen(ItemStack stack) {
        Minecraft.getInstance().setScreen((Screen)new SentryRemoteAccessToolScreen(stack));
    }

    public static void displayEditModuleScreen(ItemStack stack) {
        Minecraft.getInstance().setScreen((Screen)new EditModuleScreen(stack));
    }

    public static void displayCameraMonitorScreen(Inventory inv, ItemStack stack) {
        Minecraft.getInstance().setScreen((Screen)new CameraMonitorScreen(inv, stack));
    }

    public static void displaySCManualScreen() {
        Minecraft.getInstance().setScreen((Screen)new SCManualScreen());
    }

    public static void displayEditSecretSignScreen(SecretSignBlockEntity be, boolean isFront) {
        Minecraft.getInstance().setScreen((Screen)new SignEditScreen((SignBlockEntity)be, isFront, Minecraft.getInstance().isTextFilteringEnabled()));
    }

    public static void displayEditSecretHangingSignScreen(SecretHangingSignBlockEntity be, boolean isFront) {
        Minecraft.getInstance().setScreen((Screen)new HangingSignEditScreen((SignBlockEntity)be, isFront, Minecraft.getInstance().isTextFilteringEnabled()));
    }

    public static void displaySonicSecuritySystemScreen(SonicSecuritySystemBlockEntity be) {
        Minecraft.getInstance().setScreen((Screen)new SonicSecuritySystemScreen(be));
    }

    public static void displayBriefcasePasscodeScreen(Component title) {
        Minecraft.getInstance().setScreen((Screen)new BriefcasePasscodeScreen(title, false));
    }

    public static void displayBriefcaseSetupScreen(Component title) {
        Minecraft.getInstance().setScreen((Screen)new BriefcasePasscodeScreen(title, true));
    }

    public static void displayUsernameLoggerScreen(UsernameLoggerBlockEntity be) {
        Minecraft.getInstance().setScreen((Screen)new UsernameLoggerScreen(be));
    }

    public static void displayUniversalKeyChangerScreen(BlockEntity be) {
        Minecraft.getInstance().setScreen((Screen)new KeyChangerScreen((IPasscodeProtected)be));
    }

    public static void displayUniversalKeyChangerScreen(Entity entity) {
        Minecraft.getInstance().setScreen((Screen)new KeyChangerScreen((IPasscodeProtected)entity));
    }

    public static void displayCheckPasscodeScreen(BlockEntity be) {
        Component component;
        if (be instanceof Nameable) {
            Nameable nameable = (Nameable)be;
            component = nameable.getDisplayName();
        } else {
            component = Component.translatable((String)be.getBlockState().getBlock().getDescriptionId());
        }
        Component displayName = component;
        Minecraft.getInstance().setScreen((Screen)new CheckPasscodeScreen((IPasscodeProtected)be, displayName));
    }

    public static void displayCheckPasscodeScreen(Entity entity) {
        Minecraft.getInstance().setScreen((Screen)new CheckPasscodeScreen((IPasscodeProtected)entity, entity.getDisplayName()));
    }

    public static void displaySetPasscodeScreen(BlockEntity be) {
        Component component;
        if (be instanceof Nameable) {
            Nameable nameable = (Nameable)be;
            component = nameable.getDisplayName();
        } else {
            component = Component.translatable((String)be.getBlockState().getBlock().getDescriptionId());
        }
        Component displayName = component;
        Minecraft.getInstance().setScreen((Screen)new SetPasscodeScreen((IPasscodeProtected)be, displayName));
    }

    public static void displaySetPasscodeScreen(Entity entity) {
        Minecraft.getInstance().setScreen((Screen)new SetPasscodeScreen((IPasscodeProtected)entity, entity.getDisplayName()));
    }

    public static void displaySSSItemScreen(ItemStack stack) {
        Minecraft.getInstance().setScreen((Screen)new SSSItemScreen(stack));
    }

    public static void displayRiftStabilizerScreen(RiftStabilizerBlockEntity be) {
        Minecraft.getInstance().setScreen((Screen)new RiftStabilizerScreen(be));
    }

    public static void displaySecureRedstoneInterfaceScreen(SecureRedstoneInterfaceBlockEntity be) {
        Minecraft.getInstance().setScreen((Screen)new SecureRedstoneInterfaceScreen(be));
    }

    public static void displayAlarmScreen(AlarmBlockEntity be) {
        Minecraft.getInstance().setScreen((Screen)new AlarmScreen(be, be.getSound().getLocation()));
    }

    public static void refreshModelData(BlockEntity be) {
        BlockPos pos = be.getBlockPos();
        Minecraft.getInstance().level.getModelDataManager().requestRefresh(be);
        Minecraft.getInstance().levelRenderer.setBlocksDirty(pos.getX(), pos.getY(), pos.getZ(), pos.getX(), pos.getY(), pos.getZ());
    }

    public static boolean isPlayerMountedOnCamera() {
        return Minecraft.getInstance().cameraEntity instanceof SecurityCamera;
    }

    public static void putDisguisedBeRenderer(BlockEntity disguisableBlockEntity, ItemStack stack) {
        DISGUISED_BLOCK_RENDER_DELEGATE.putDelegateFor(disguisableBlockEntity, ((SavedBlockState)stack.getOrDefault(SCContent.SAVED_BLOCK_STATE, (Object)SavedBlockState.EMPTY)).state());
    }

    public static void updateBlockColorAroundPosition(BlockPos pos) {
        Minecraft.getInstance().levelRenderer.blockChanged((BlockGetter)Minecraft.getInstance().level, pos, null, null, 0);
    }

    private static float getLinkingState(Level level, Player player, ItemStack stackInHand, Predicate<BlockHitResult> isValidHitResult) {
        return ClientHandler.getLinkingState(level, player, stackInHand, isValidHitResult, null, (u1, u2) -> true);
    }

    private static float getLinkingState(Level level, Player player, ItemStack stackInHand, Predicate<BlockHitResult> isValidHitResult, DataComponentType<? extends GlobalPositionComponent<?, ?, ?>> positionComponent) {
        return ClientHandler.getLinkingState(level, player, stackInHand, isValidHitResult, positionComponent, GlobalPositionComponent::isPositionAdded);
    }

    private static float getLinkingState(Level level, Player player, ItemStack stackInHand, Predicate<BlockHitResult> isValidHitResult, DataComponentType<? extends GlobalPositionComponent<?, ?, ?>> positionComponent, BiPredicate<GlobalPositionComponent<?, ?, ?>, GlobalPos> isLinked) {
        BlockHitResult hitResult;
        double reachDistance = player.blockInteractionRange();
        double eyeHeight = player.getEyeHeight();
        Vec3 lookVec = new Vec3(player.getX() + player.getLookAngle().x * reachDistance, eyeHeight + player.getY() + player.getLookAngle().y * reachDistance, player.getZ() + player.getLookAngle().z * reachDistance);
        if (level != null && (hitResult = level.clip(new ClipContext(new Vec3(player.getX(), player.getY() + (double)player.getEyeHeight(), player.getZ()), lookVec, ClipContext.Block.OUTLINE, ClipContext.Fluid.NONE, (Entity)player))) != null && hitResult.getType() == HitResult.Type.BLOCK && isValidHitResult.test(hitResult)) {
            GlobalPositionComponent positions = positionComponent == null ? null : (GlobalPositionComponent)stackInHand.get(positionComponent);
            GlobalPos globalPos = new GlobalPos(level.dimension(), hitResult.getBlockPos());
            return isLinked.test(positions, globalPos) ? 0.75f : 0.5f;
        }
        return 0.25f;
    }
}

