/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.animal;

import com.mojang.serialization.DynamicOps;
import java.util.Optional;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.Tag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.ItemTags;
import net.minecraft.util.RandomSource;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LightningBolt;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.Shearable;
import net.minecraft.world.entity.VariantHolder;
import net.minecraft.world.entity.animal.Cow;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ItemUtils;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.component.SuspiciousStewEffects;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.SuspiciousEffectHolder;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;

public class MushroomCow
extends Cow
implements Shearable,
VariantHolder<MushroomType> {
    private static final EntityDataAccessor<String> DATA_TYPE = SynchedEntityData.defineId(MushroomCow.class, EntityDataSerializers.STRING);
    private static final int MUTATE_CHANCE = 1024;
    private static final String TAG_STEW_EFFECTS = "stew_effects";
    @Nullable
    private SuspiciousStewEffects stewEffects;
    @Nullable
    private UUID lastLightningBoltUUID;

    public MushroomCow(EntityType<? extends MushroomCow> p_28914_, Level p_28915_) {
        super((EntityType<? extends Cow>)p_28914_, p_28915_);
    }

    @Override
    public float getWalkTargetValue(BlockPos p_28933_, LevelReader p_28934_) {
        if (p_28934_.getBlockState(p_28933_.below()).is(Blocks.MYCELIUM)) {
            return 10.0f;
        }
        return p_28934_.getPathfindingCostFromLightLevels(p_28933_);
    }

    public static boolean checkMushroomSpawnRules(EntityType<MushroomCow> p_218201_, LevelAccessor p_218202_, MobSpawnType p_218203_, BlockPos p_218204_, RandomSource p_218205_) {
        return p_218202_.getBlockState(p_218204_.below()).is(BlockTags.MOOSHROOMS_SPAWNABLE_ON) && MushroomCow.isBrightEnoughToSpawn(p_218202_, p_218204_);
    }

    @Override
    public void thunderHit(ServerLevel p_28921_, LightningBolt p_28922_) {
        UUID $$2 = p_28922_.getUUID();
        if (!$$2.equals(this.lastLightningBoltUUID)) {
            this.setVariant(this.getVariant() == MushroomType.RED ? MushroomType.BROWN : MushroomType.RED);
            this.lastLightningBoltUUID = $$2;
            this.playSound(SoundEvents.MOOSHROOM_CONVERT, 2.0f, 1.0f);
        }
    }

    @Override
    protected void defineSynchedData(SynchedEntityData.Builder p_326279_) {
        super.defineSynchedData(p_326279_);
        p_326279_.define(DATA_TYPE, MushroomType.RED.type);
    }

    @Override
    public InteractionResult mobInteract(Player p_28941_, InteractionHand p_28942_) {
        ItemStack $$2 = p_28941_.getItemInHand(p_28942_);
        if ($$2.is(Items.BOWL) && !this.isBaby()) {
            SoundEvent $$8;
            ItemStack $$5;
            boolean $$3 = false;
            if (this.stewEffects != null) {
                $$3 = true;
                ItemStack $$4 = new ItemStack(Items.SUSPICIOUS_STEW);
                $$4.set(DataComponents.SUSPICIOUS_STEW_EFFECTS, this.stewEffects);
                this.stewEffects = null;
            } else {
                $$5 = new ItemStack(Items.MUSHROOM_STEW);
            }
            ItemStack $$6 = ItemUtils.createFilledResult($$2, p_28941_, $$5, false);
            p_28941_.setItemInHand(p_28942_, $$6);
            if ($$3) {
                SoundEvent $$7 = SoundEvents.MOOSHROOM_MILK_SUSPICIOUSLY;
            } else {
                $$8 = SoundEvents.MOOSHROOM_MILK;
            }
            this.playSound($$8, 1.0f, 1.0f);
            return InteractionResult.sidedSuccess(this.level().isClientSide);
        }
        if ($$2.is(Items.SHEARS) && this.readyForShearing()) {
            this.shear(SoundSource.PLAYERS);
            this.gameEvent(GameEvent.SHEAR, p_28941_);
            if (!this.level().isClientSide) {
                $$2.hurtAndBreak(1, p_28941_, MushroomCow.getSlotForHand(p_28942_));
            }
            return InteractionResult.sidedSuccess(this.level().isClientSide);
        }
        if (this.getVariant() == MushroomType.BROWN && $$2.is(ItemTags.SMALL_FLOWERS)) {
            if (this.stewEffects != null) {
                for (int $$9 = 0; $$9 < 2; ++$$9) {
                    this.level().addParticle(ParticleTypes.SMOKE, this.getX() + this.random.nextDouble() / 2.0, this.getY(0.5), this.getZ() + this.random.nextDouble() / 2.0, 0.0, this.random.nextDouble() / 5.0, 0.0);
                }
            } else {
                Optional<SuspiciousStewEffects> $$10 = this.getEffectsFromItemStack($$2);
                if ($$10.isEmpty()) {
                    return InteractionResult.PASS;
                }
                $$2.consume(1, p_28941_);
                for (int $$11 = 0; $$11 < 4; ++$$11) {
                    this.level().addParticle(ParticleTypes.EFFECT, this.getX() + this.random.nextDouble() / 2.0, this.getY(0.5), this.getZ() + this.random.nextDouble() / 2.0, 0.0, this.random.nextDouble() / 5.0, 0.0);
                }
                this.stewEffects = $$10.get();
                this.playSound(SoundEvents.MOOSHROOM_EAT, 2.0f, 1.0f);
            }
            return InteractionResult.sidedSuccess(this.level().isClientSide);
        }
        return super.mobInteract(p_28941_, p_28942_);
    }

    @Override
    public void shear(SoundSource p_28924_) {
        Cow $$1;
        this.level().playSound(null, this, SoundEvents.MOOSHROOM_SHEAR, p_28924_, 1.0f, 1.0f);
        if (!this.level().isClientSide() && ($$1 = EntityType.COW.create(this.level())) != null) {
            ((ServerLevel)this.level()).sendParticles(ParticleTypes.EXPLOSION, this.getX(), this.getY(0.5), this.getZ(), 1, 0.0, 0.0, 0.0, 0.0);
            this.discard();
            $$1.moveTo(this.getX(), this.getY(), this.getZ(), this.getYRot(), this.getXRot());
            $$1.setHealth(this.getHealth());
            $$1.yBodyRot = this.yBodyRot;
            if (this.hasCustomName()) {
                $$1.setCustomName(this.getCustomName());
                $$1.setCustomNameVisible(this.isCustomNameVisible());
            }
            if (this.isPersistenceRequired()) {
                $$1.setPersistenceRequired();
            }
            $$1.setInvulnerable(this.isInvulnerable());
            this.level().addFreshEntity($$1);
            for (int $$2 = 0; $$2 < 5; ++$$2) {
                this.level().addFreshEntity(new ItemEntity(this.level(), this.getX(), this.getY(1.0), this.getZ(), new ItemStack(this.getVariant().blockState.getBlock())));
            }
        }
    }

    @Override
    public boolean readyForShearing() {
        return this.isAlive() && !this.isBaby();
    }

    @Override
    public void addAdditionalSaveData(CompoundTag p_28944_) {
        super.addAdditionalSaveData(p_28944_);
        p_28944_.putString("Type", this.getVariant().getSerializedName());
        if (this.stewEffects != null) {
            SuspiciousStewEffects.CODEC.encodeStart((DynamicOps)NbtOps.INSTANCE, (Object)this.stewEffects).ifSuccess(p_297973_ -> p_28944_.put(TAG_STEW_EFFECTS, (Tag)p_297973_));
        }
    }

    @Override
    public void readAdditionalSaveData(CompoundTag p_28936_) {
        super.readAdditionalSaveData(p_28936_);
        this.setVariant(MushroomType.byType(p_28936_.getString("Type")));
        if (p_28936_.contains(TAG_STEW_EFFECTS, 9)) {
            SuspiciousStewEffects.CODEC.parse((DynamicOps)NbtOps.INSTANCE, (Object)p_28936_.get(TAG_STEW_EFFECTS)).ifSuccess(p_330058_ -> {
                this.stewEffects = p_330058_;
            });
        }
    }

    private Optional<SuspiciousStewEffects> getEffectsFromItemStack(ItemStack p_298333_) {
        SuspiciousEffectHolder $$1 = SuspiciousEffectHolder.tryGet(p_298333_.getItem());
        if ($$1 != null) {
            return Optional.of($$1.getSuspiciousEffects());
        }
        return Optional.empty();
    }

    @Override
    public void setVariant(MushroomType p_28929_) {
        this.entityData.set(DATA_TYPE, p_28929_.type);
    }

    @Override
    public MushroomType getVariant() {
        return MushroomType.byType(this.entityData.get(DATA_TYPE));
    }

    @Override
    @Nullable
    public MushroomCow getBreedOffspring(ServerLevel p_148942_, AgeableMob p_148943_) {
        MushroomCow $$2 = EntityType.MOOSHROOM.create(p_148942_);
        if ($$2 != null) {
            $$2.setVariant(this.getOffspringType((MushroomCow)p_148943_));
        }
        return $$2;
    }

    private MushroomType getOffspringType(MushroomCow p_28931_) {
        MushroomType $$4;
        MushroomType $$2;
        MushroomType $$1 = this.getVariant();
        if ($$1 == ($$2 = p_28931_.getVariant()) && this.random.nextInt(1024) == 0) {
            MushroomType $$3 = $$1 == MushroomType.BROWN ? MushroomType.RED : MushroomType.BROWN;
        } else {
            $$4 = this.random.nextBoolean() ? $$1 : $$2;
        }
        return $$4;
    }

    @Override
    @Nullable
    public /* synthetic */ Cow getBreedOffspring(ServerLevel serverLevel, AgeableMob ageableMob) {
        return this.getBreedOffspring(serverLevel, ageableMob);
    }

    @Override
    @Nullable
    public /* synthetic */ AgeableMob getBreedOffspring(ServerLevel serverLevel, AgeableMob ageableMob) {
        return this.getBreedOffspring(serverLevel, ageableMob);
    }

    @Override
    public /* synthetic */ Object getVariant() {
        return this.getVariant();
    }

    public static enum MushroomType implements StringRepresentable
    {
        RED("red", Blocks.RED_MUSHROOM.defaultBlockState()),
        BROWN("brown", Blocks.BROWN_MUSHROOM.defaultBlockState());

        public static final StringRepresentable.EnumCodec<MushroomType> CODEC;
        final String type;
        final BlockState blockState;

        private MushroomType(String p_28967_, BlockState p_28968_) {
            this.type = p_28967_;
            this.blockState = p_28968_;
        }

        public BlockState getBlockState() {
            return this.blockState;
        }

        @Override
        public String getSerializedName() {
            return this.type;
        }

        static MushroomType byType(String p_28977_) {
            return CODEC.byName(p_28977_, RED);
        }

        static {
            CODEC = StringRepresentable.fromEnum(MushroomType::values);
        }
    }
}

