/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.resources.server;

import com.google.common.hash.HashCode;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.client.resources.server.PackDownloader;
import net.minecraft.client.resources.server.PackLoadFeedback;
import net.minecraft.client.resources.server.PackReloadConfig;
import net.minecraft.server.packs.DownloadQueue;

public class ServerPackManager {
    private final PackDownloader downloader;
    final PackLoadFeedback packLoadFeedback;
    private final PackReloadConfig reloadConfig;
    private final Runnable updateRequest;
    private PackPromptStatus packPromptStatus;
    final List<ServerPackData> packs = new ArrayList<ServerPackData>();

    public ServerPackManager(PackDownloader p_314651_, PackLoadFeedback p_314441_, PackReloadConfig p_314471_, Runnable p_314453_, PackPromptStatus p_314476_) {
        this.downloader = p_314651_;
        this.packLoadFeedback = p_314441_;
        this.reloadConfig = p_314471_;
        this.updateRequest = p_314453_;
        this.packPromptStatus = p_314476_;
    }

    void registerForUpdate() {
        this.updateRequest.run();
    }

    private void markExistingPacksAsRemoved(UUID p_314529_) {
        for (ServerPackData $$1 : this.packs) {
            if (!$$1.id.equals(p_314529_)) continue;
            $$1.setRemovalReasonIfNotSet(RemovalReason.SERVER_REPLACED);
        }
    }

    public void pushPack(UUID p_314641_, URL p_314493_, @Nullable HashCode p_314571_) {
        if (this.packPromptStatus == PackPromptStatus.DECLINED) {
            this.packLoadFeedback.reportFinalResult(p_314641_, PackLoadFeedback.FinalResult.DECLINED);
            return;
        }
        this.pushNewPack(p_314641_, new ServerPackData(p_314641_, p_314493_, p_314571_));
    }

    /*
     * WARNING - void declaration
     */
    public void pushLocalPack(UUID p_314448_, Path p_314520_) {
        void $$4;
        if (this.packPromptStatus == PackPromptStatus.DECLINED) {
            this.packLoadFeedback.reportFinalResult(p_314448_, PackLoadFeedback.FinalResult.DECLINED);
            return;
        }
        try {
            URL $$2 = p_314520_.toUri().toURL();
        }
        catch (MalformedURLException $$3) {
            throw new IllegalStateException("Can't convert path to URL " + String.valueOf(p_314520_), $$3);
        }
        ServerPackData $$5 = new ServerPackData(p_314448_, (URL)$$4, null);
        $$5.downloadStatus = PackDownloadStatus.DONE;
        $$5.path = p_314520_;
        this.pushNewPack(p_314448_, $$5);
    }

    private void pushNewPack(UUID p_314541_, ServerPackData p_314473_) {
        this.markExistingPacksAsRemoved(p_314541_);
        this.packs.add(p_314473_);
        if (this.packPromptStatus == PackPromptStatus.ALLOWED) {
            this.acceptPack(p_314473_);
        }
        this.registerForUpdate();
    }

    private void acceptPack(ServerPackData p_314599_) {
        this.packLoadFeedback.reportUpdate(p_314599_.id, PackLoadFeedback.Update.ACCEPTED);
        p_314599_.promptAccepted = true;
    }

    @Nullable
    private ServerPackData findPackInfo(UUID p_314517_) {
        for (ServerPackData $$1 : this.packs) {
            if ($$1.isRemoved() || !$$1.id.equals(p_314517_)) continue;
            return $$1;
        }
        return null;
    }

    public void popPack(UUID p_314547_) {
        ServerPackData $$1 = this.findPackInfo(p_314547_);
        if ($$1 != null) {
            $$1.setRemovalReasonIfNotSet(RemovalReason.SERVER_REMOVED);
            this.registerForUpdate();
        }
    }

    public void popAll() {
        for (ServerPackData $$0 : this.packs) {
            $$0.setRemovalReasonIfNotSet(RemovalReason.SERVER_REMOVED);
        }
        this.registerForUpdate();
    }

    public void allowServerPacks() {
        this.packPromptStatus = PackPromptStatus.ALLOWED;
        for (ServerPackData $$0 : this.packs) {
            if ($$0.promptAccepted || $$0.isRemoved()) continue;
            this.acceptPack($$0);
        }
        this.registerForUpdate();
    }

    public void rejectServerPacks() {
        this.packPromptStatus = PackPromptStatus.DECLINED;
        for (ServerPackData $$0 : this.packs) {
            if ($$0.promptAccepted) continue;
            $$0.setRemovalReasonIfNotSet(RemovalReason.DECLINED);
        }
        this.registerForUpdate();
    }

    public void resetPromptStatus() {
        this.packPromptStatus = PackPromptStatus.PENDING;
    }

    public void tick() {
        boolean $$0 = this.updateDownloads();
        if (!$$0) {
            this.triggerReloadIfNeeded();
        }
        this.cleanupRemovedPacks();
    }

    private void cleanupRemovedPacks() {
        this.packs.removeIf(p_314901_ -> {
            if (p_314901_.activationStatus != ActivationStatus.INACTIVE) {
                return false;
            }
            if (p_314901_.removalReason != null) {
                PackLoadFeedback.FinalResult $$1 = p_314901_.removalReason.serverResponse;
                if ($$1 != null) {
                    this.packLoadFeedback.reportFinalResult(p_314901_.id, $$1);
                }
                return true;
            }
            return false;
        });
    }

    private void onDownload(Collection<ServerPackData> p_314562_, DownloadQueue.BatchResult p_314549_) {
        if (!p_314549_.failed().isEmpty()) {
            for (ServerPackData $$2 : this.packs) {
                if ($$2.activationStatus == ActivationStatus.ACTIVE) continue;
                if (p_314549_.failed().contains($$2.id)) {
                    $$2.setRemovalReasonIfNotSet(RemovalReason.DOWNLOAD_FAILED);
                    continue;
                }
                $$2.setRemovalReasonIfNotSet(RemovalReason.DISCARDED);
            }
        }
        for (ServerPackData $$3 : p_314562_) {
            Path $$4 = p_314549_.downloaded().get($$3.id);
            if ($$4 == null) continue;
            $$3.downloadStatus = PackDownloadStatus.DONE;
            $$3.path = $$4;
            if ($$3.isRemoved()) continue;
            this.packLoadFeedback.reportUpdate($$3.id, PackLoadFeedback.Update.DOWNLOADED);
        }
        this.registerForUpdate();
    }

    private boolean updateDownloads() {
        ArrayList<ServerPackData> $$0 = new ArrayList<ServerPackData>();
        boolean $$1 = false;
        for (ServerPackData $$2 : this.packs) {
            if ($$2.isRemoved() || !$$2.promptAccepted) continue;
            if ($$2.downloadStatus != PackDownloadStatus.DONE) {
                $$1 = true;
            }
            if ($$2.downloadStatus != PackDownloadStatus.REQUESTED) continue;
            $$2.downloadStatus = PackDownloadStatus.PENDING;
            $$0.add($$2);
        }
        if (!$$0.isEmpty()) {
            HashMap<UUID, DownloadQueue.DownloadRequest> $$3 = new HashMap<UUID, DownloadQueue.DownloadRequest>();
            for (ServerPackData $$4 : $$0) {
                $$3.put($$4.id, new DownloadQueue.DownloadRequest($$4.url, $$4.hash));
            }
            this.downloader.download($$3, p_314466_ -> this.onDownload((Collection<ServerPackData>)$$0, (DownloadQueue.BatchResult)p_314466_));
        }
        return $$1;
    }

    private void triggerReloadIfNeeded() {
        boolean $$0 = false;
        final ArrayList<ServerPackData> $$1 = new ArrayList<ServerPackData>();
        final ArrayList<ServerPackData> $$2 = new ArrayList<ServerPackData>();
        for (ServerPackData $$3 : this.packs) {
            boolean $$4;
            if ($$3.activationStatus == ActivationStatus.PENDING) {
                return;
            }
            boolean bl = $$4 = $$3.promptAccepted && $$3.downloadStatus == PackDownloadStatus.DONE && !$$3.isRemoved();
            if ($$4 && $$3.activationStatus == ActivationStatus.INACTIVE) {
                $$1.add($$3);
                $$0 = true;
            }
            if ($$3.activationStatus != ActivationStatus.ACTIVE) continue;
            if (!$$4) {
                $$0 = true;
                $$2.add($$3);
                continue;
            }
            $$1.add($$3);
        }
        if ($$0) {
            for (ServerPackData $$5 : $$1) {
                if ($$5.activationStatus == ActivationStatus.ACTIVE) continue;
                $$5.activationStatus = ActivationStatus.PENDING;
            }
            for (ServerPackData $$6 : $$2) {
                $$6.activationStatus = ActivationStatus.PENDING;
            }
            this.reloadConfig.scheduleReload(new PackReloadConfig.Callbacks(){

                @Override
                public void onSuccess() {
                    for (ServerPackData $$0 : $$1) {
                        $$0.activationStatus = ActivationStatus.ACTIVE;
                        if ($$0.removalReason != null) continue;
                        ServerPackManager.this.packLoadFeedback.reportFinalResult($$0.id, PackLoadFeedback.FinalResult.APPLIED);
                    }
                    for (ServerPackData $$12 : $$2) {
                        $$12.activationStatus = ActivationStatus.INACTIVE;
                    }
                    ServerPackManager.this.registerForUpdate();
                }

                @Override
                public void onFailure(boolean p_314558_) {
                    if (!p_314558_) {
                        $$1.clear();
                        for (ServerPackData $$12 : ServerPackManager.this.packs) {
                            switch ($$12.activationStatus.ordinal()) {
                                case 2: {
                                    $$1.add($$12);
                                    break;
                                }
                                case 1: {
                                    $$12.activationStatus = ActivationStatus.INACTIVE;
                                    $$12.setRemovalReasonIfNotSet(RemovalReason.ACTIVATION_FAILED);
                                    break;
                                }
                                case 0: {
                                    $$12.setRemovalReasonIfNotSet(RemovalReason.DISCARDED);
                                }
                            }
                        }
                        ServerPackManager.this.registerForUpdate();
                    } else {
                        for (ServerPackData $$22 : ServerPackManager.this.packs) {
                            if ($$22.activationStatus != ActivationStatus.PENDING) continue;
                            $$22.activationStatus = ActivationStatus.INACTIVE;
                        }
                    }
                }

                @Override
                public List<PackReloadConfig.IdAndPath> packsToLoad() {
                    return $$1.stream().map(p_314577_ -> new PackReloadConfig.IdAndPath(p_314577_.id, p_314577_.path)).toList();
                }
            });
        }
    }

    public static enum PackPromptStatus {
        PENDING,
        ALLOWED,
        DECLINED;

    }

    static class ServerPackData {
        final UUID id;
        final URL url;
        @Nullable
        final HashCode hash;
        @Nullable
        Path path;
        @Nullable
        RemovalReason removalReason;
        PackDownloadStatus downloadStatus = PackDownloadStatus.REQUESTED;
        ActivationStatus activationStatus = ActivationStatus.INACTIVE;
        boolean promptAccepted;

        ServerPackData(UUID p_314450_, URL p_314542_, @Nullable HashCode p_314445_) {
            this.id = p_314450_;
            this.url = p_314542_;
            this.hash = p_314445_;
        }

        public void setRemovalReasonIfNotSet(RemovalReason p_314504_) {
            if (this.removalReason == null) {
                this.removalReason = p_314504_;
            }
        }

        public boolean isRemoved() {
            return this.removalReason != null;
        }
    }

    static enum RemovalReason {
        DOWNLOAD_FAILED(PackLoadFeedback.FinalResult.DOWNLOAD_FAILED),
        ACTIVATION_FAILED(PackLoadFeedback.FinalResult.ACTIVATION_FAILED),
        DECLINED(PackLoadFeedback.FinalResult.DECLINED),
        DISCARDED(PackLoadFeedback.FinalResult.DISCARDED),
        SERVER_REMOVED(null),
        SERVER_REPLACED(null);

        @Nullable
        final PackLoadFeedback.FinalResult serverResponse;

        private RemovalReason(PackLoadFeedback.FinalResult p_314987_) {
            this.serverResponse = p_314987_;
        }
    }

    static enum PackDownloadStatus {
        REQUESTED,
        PENDING,
        DONE;

    }

    static enum ActivationStatus {
        INACTIVE,
        PENDING,
        ACTIVE;

    }
}

