/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.renderer.entity;

import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.model.StriderModel;
import net.minecraft.client.model.geom.ModelLayers;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.MobRenderer;
import net.minecraft.client.renderer.entity.layers.SaddleLayer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.monster.Strider;

public class StriderRenderer
extends MobRenderer<Strider, StriderModel<Strider>> {
    private static final ResourceLocation STRIDER_LOCATION = ResourceLocation.withDefaultNamespace("textures/entity/strider/strider.png");
    private static final ResourceLocation COLD_LOCATION = ResourceLocation.withDefaultNamespace("textures/entity/strider/strider_cold.png");
    private static final float SHADOW_RADIUS = 0.5f;

    public StriderRenderer(EntityRendererProvider.Context p_174411_) {
        super(p_174411_, new StriderModel(p_174411_.bakeLayer(ModelLayers.STRIDER)), 0.5f);
        this.addLayer(new SaddleLayer(this, new StriderModel(p_174411_.bakeLayer(ModelLayers.STRIDER_SADDLE)), ResourceLocation.withDefaultNamespace("textures/entity/strider/strider_saddle.png")));
    }

    @Override
    public ResourceLocation getTextureLocation(Strider p_116064_) {
        return p_116064_.isSuffocating() ? COLD_LOCATION : STRIDER_LOCATION;
    }

    @Override
    protected float getShadowRadius(Strider p_316706_) {
        float $$1 = super.getShadowRadius(p_316706_);
        if (p_316706_.isBaby()) {
            return $$1 * 0.5f;
        }
        return $$1;
    }

    @Override
    protected void scale(Strider p_320685_, PoseStack p_319790_, float p_319907_) {
        float $$3 = p_320685_.getAgeScale();
        p_319790_.scale($$3, $$3, $$3);
    }

    @Override
    protected boolean isShaking(Strider p_116070_) {
        return super.isShaking(p_116070_) || p_116070_.isSuffocating();
    }

    @Override
    protected /* synthetic */ float getShadowRadius(LivingEntity livingEntity) {
        return this.getShadowRadius((Strider)livingEntity);
    }

    @Override
    protected /* synthetic */ boolean isShaking(LivingEntity livingEntity) {
        return this.isShaking((Strider)livingEntity);
    }

    @Override
    protected /* synthetic */ float getShadowRadius(Entity entity) {
        return this.getShadowRadius((Strider)entity);
    }
}

