/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.renderer.entity;

import com.google.common.annotations.VisibleForTesting;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;

public class ItemEntityRenderer
extends EntityRenderer<ItemEntity> {
    private static final float ITEM_BUNDLE_OFFSET_SCALE = 0.15f;
    private static final float FLAT_ITEM_BUNDLE_OFFSET_X = 0.0f;
    private static final float FLAT_ITEM_BUNDLE_OFFSET_Y = 0.0f;
    private static final float FLAT_ITEM_BUNDLE_OFFSET_Z = 0.09375f;
    private final ItemRenderer itemRenderer;
    private final RandomSource random = RandomSource.create();

    public ItemEntityRenderer(EntityRendererProvider.Context p_174198_) {
        super(p_174198_);
        this.itemRenderer = p_174198_.getItemRenderer();
        this.shadowRadius = 0.15f;
        this.shadowStrength = 0.75f;
    }

    @Override
    public ResourceLocation getTextureLocation(ItemEntity p_115034_) {
        return TextureAtlas.LOCATION_BLOCKS;
    }

    @Override
    public void render(ItemEntity p_115036_, float p_115037_, float p_115038_, PoseStack p_115039_, MultiBufferSource p_115040_, int p_115041_) {
        p_115039_.pushPose();
        ItemStack $$6 = p_115036_.getItem();
        this.random.setSeed(ItemEntityRenderer.getSeedForItemStack($$6));
        BakedModel $$7 = this.itemRenderer.getModel($$6, p_115036_.level(), null, p_115036_.getId());
        boolean $$8 = $$7.isGui3d();
        float $$9 = 0.25f;
        float $$10 = Mth.sin(((float)p_115036_.getAge() + p_115038_) / 10.0f + p_115036_.bobOffs) * 0.1f + 0.1f;
        float $$11 = $$7.getTransforms().getTransform((ItemDisplayContext)ItemDisplayContext.GROUND).scale.y();
        p_115039_.translate(0.0f, $$10 + 0.25f * $$11, 0.0f);
        float $$12 = p_115036_.getSpin(p_115038_);
        p_115039_.mulPose(Axis.YP.rotation($$12));
        ItemEntityRenderer.renderMultipleFromCount(this.itemRenderer, p_115039_, p_115040_, p_115041_, $$6, $$7, $$8, this.random);
        p_115039_.popPose();
        super.render(p_115036_, p_115037_, p_115038_, p_115039_, p_115040_, p_115041_);
    }

    public static int getSeedForItemStack(ItemStack p_324105_) {
        return p_324105_.isEmpty() ? 187 : Item.getId(p_324105_.getItem()) + p_324105_.getDamageValue();
    }

    @VisibleForTesting
    static int getRenderedAmount(int p_324603_) {
        if (p_324603_ <= 1) {
            return 1;
        }
        if (p_324603_ <= 16) {
            return 2;
        }
        if (p_324603_ <= 32) {
            return 3;
        }
        if (p_324603_ <= 48) {
            return 4;
        }
        return 5;
    }

    public static void renderMultipleFromCount(ItemRenderer p_323875_, PoseStack p_323763_, MultiBufferSource p_324606_, int p_323603_, ItemStack p_323969_, RandomSource p_324507_, Level p_323902_) {
        BakedModel $$7 = p_323875_.getModel(p_323969_, p_323902_, null, 0);
        ItemEntityRenderer.renderMultipleFromCount(p_323875_, p_323763_, p_324606_, p_323603_, p_323969_, $$7, $$7.isGui3d(), p_324507_);
    }

    public static void renderMultipleFromCount(ItemRenderer p_324541_, PoseStack p_323733_, MultiBufferSource p_324107_, int p_323740_, ItemStack p_323718_, BakedModel p_324183_, boolean p_324462_, RandomSource p_324565_) {
        int $$8 = ItemEntityRenderer.getRenderedAmount(p_323718_.getCount());
        float $$9 = p_324183_.getTransforms().ground.scale.x();
        float $$10 = p_324183_.getTransforms().ground.scale.y();
        float $$11 = p_324183_.getTransforms().ground.scale.z();
        if (!p_324462_) {
            float $$12 = -0.0f * (float)($$8 - 1) * 0.5f * $$9;
            float $$13 = -0.0f * (float)($$8 - 1) * 0.5f * $$10;
            float $$14 = -0.09375f * (float)($$8 - 1) * 0.5f * $$11;
            p_323733_.translate($$12, $$13, $$14);
        }
        for (int $$15 = 0; $$15 < $$8; ++$$15) {
            p_323733_.pushPose();
            if ($$15 > 0) {
                if (p_324462_) {
                    float $$16 = (p_324565_.nextFloat() * 2.0f - 1.0f) * 0.15f;
                    float $$17 = (p_324565_.nextFloat() * 2.0f - 1.0f) * 0.15f;
                    float $$18 = (p_324565_.nextFloat() * 2.0f - 1.0f) * 0.15f;
                    p_323733_.translate($$16, $$17, $$18);
                } else {
                    float $$19 = (p_324565_.nextFloat() * 2.0f - 1.0f) * 0.15f * 0.5f;
                    float $$20 = (p_324565_.nextFloat() * 2.0f - 1.0f) * 0.15f * 0.5f;
                    p_323733_.translate($$19, $$20, 0.0f);
                }
            }
            p_324541_.render(p_323718_, ItemDisplayContext.GROUND, false, p_323733_, p_324107_, p_323740_, OverlayTexture.NO_OVERLAY, p_324183_);
            p_323733_.popPose();
            if (p_324462_) continue;
            p_323733_.translate(0.0f * $$9, 0.0f * $$10, 0.09375f * $$11);
        }
    }
}

