/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.renderer.chunk;

import com.google.common.collect.Lists;
import com.google.common.collect.Queues;
import com.google.common.collect.Sets;
import com.google.common.primitives.Doubles;
import com.mojang.blaze3d.vertex.ByteBufferBuilder;
import com.mojang.blaze3d.vertex.MeshData;
import com.mojang.blaze3d.vertex.VertexBuffer;
import com.mojang.blaze3d.vertex.VertexSorting;
import it.unimi.dsi.fastutil.objects.ObjectArraySet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Executor;
import java.util.concurrent.PriorityBlockingQueue;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.CrashReport;
import net.minecraft.Util;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.client.renderer.RenderBuffers;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.SectionBufferBuilderPack;
import net.minecraft.client.renderer.SectionBufferBuilderPool;
import net.minecraft.client.renderer.block.BlockRenderDispatcher;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderDispatcher;
import net.minecraft.client.renderer.chunk.RenderChunkRegion;
import net.minecraft.client.renderer.chunk.RenderRegionCache;
import net.minecraft.client.renderer.chunk.SectionCompiler;
import net.minecraft.client.renderer.chunk.VisibilitySet;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.SectionPos;
import net.minecraft.util.thread.ProcessorMailbox;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.chunk.status.ChunkStatus;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public class SectionRenderDispatcher {
    private static final int MAX_HIGH_PRIORITY_QUOTA = 2;
    private final PriorityBlockingQueue<RenderSection.CompileTask> toBatchHighPriority = Queues.newPriorityBlockingQueue();
    private final Queue<RenderSection.CompileTask> toBatchLowPriority = Queues.newLinkedBlockingDeque();
    private int highPriorityQuota = 2;
    private final Queue<Runnable> toUpload = Queues.newConcurrentLinkedQueue();
    final SectionBufferBuilderPack fixedBuffers;
    private final SectionBufferBuilderPool bufferPool;
    private volatile int toBatchCount;
    private volatile boolean closed;
    private final ProcessorMailbox<Runnable> mailbox;
    private final Executor executor;
    ClientLevel level;
    final LevelRenderer renderer;
    private Vec3 camera = Vec3.ZERO;
    final SectionCompiler sectionCompiler;

    public SectionRenderDispatcher(ClientLevel p_295274_, LevelRenderer p_295323_, Executor p_295234_, RenderBuffers p_307511_, BlockRenderDispatcher p_350514_, BlockEntityRenderDispatcher p_350550_) {
        this.level = p_295274_;
        this.renderer = p_295323_;
        this.fixedBuffers = p_307511_.fixedBufferPack();
        this.bufferPool = p_307511_.sectionBufferPool();
        this.executor = p_295234_;
        this.mailbox = ProcessorMailbox.create(p_295234_, "Section Renderer");
        this.mailbox.tell(this::runTask);
        this.sectionCompiler = new SectionCompiler(p_350514_, p_350550_);
    }

    public void setLevel(ClientLevel p_295112_) {
        this.level = p_295112_;
    }

    private void runTask() {
        if (this.closed || this.bufferPool.isEmpty()) {
            return;
        }
        RenderSection.CompileTask $$0 = this.pollTask();
        if ($$0 == null) {
            return;
        }
        SectionBufferBuilderPack $$1 = Objects.requireNonNull(this.bufferPool.acquire());
        this.toBatchCount = this.toBatchHighPriority.size() + this.toBatchLowPriority.size();
        ((CompletableFuture)CompletableFuture.supplyAsync(Util.wrapThreadWithTaskName($$0.name(), () -> $$0.doTask($$1)), this.executor).thenCompose(p_296185_ -> p_296185_)).whenComplete((p_296170_, p_294818_) -> {
            if (p_294818_ != null) {
                Minecraft.getInstance().delayCrash(CrashReport.forThrowable(p_294818_, "Batching sections"));
                return;
            }
            this.mailbox.tell(() -> {
                if (p_296170_ == SectionTaskResult.SUCCESSFUL) {
                    $$1.clearAll();
                } else {
                    $$1.discardAll();
                }
                this.bufferPool.release($$1);
                this.runTask();
            });
        });
    }

    @Nullable
    private RenderSection.CompileTask pollTask() {
        RenderSection.CompileTask $$0;
        if (this.highPriorityQuota <= 0 && ($$0 = this.toBatchLowPriority.poll()) != null) {
            this.highPriorityQuota = 2;
            return $$0;
        }
        RenderSection.CompileTask $$1 = this.toBatchHighPriority.poll();
        if ($$1 != null) {
            --this.highPriorityQuota;
            return $$1;
        }
        this.highPriorityQuota = 2;
        return this.toBatchLowPriority.poll();
    }

    public String getStats() {
        return String.format(Locale.ROOT, "pC: %03d, pU: %02d, aB: %02d", this.toBatchCount, this.toUpload.size(), this.bufferPool.getFreeBufferCount());
    }

    public int getToBatchCount() {
        return this.toBatchCount;
    }

    public int getToUpload() {
        return this.toUpload.size();
    }

    public int getFreeBufferCount() {
        return this.bufferPool.getFreeBufferCount();
    }

    public void setCamera(Vec3 p_296331_) {
        this.camera = p_296331_;
    }

    public Vec3 getCameraPosition() {
        return this.camera;
    }

    public void uploadAllPendingUploads() {
        Runnable $$0;
        while (($$0 = this.toUpload.poll()) != null) {
            $$0.run();
        }
    }

    public void rebuildSectionSync(RenderSection p_296309_, RenderRegionCache p_294139_) {
        p_296309_.compileSync(p_294139_);
    }

    public void blockUntilClear() {
        this.clearBatchQueue();
    }

    public void schedule(RenderSection.CompileTask p_295825_) {
        if (this.closed) {
            return;
        }
        this.mailbox.tell(() -> {
            if (this.closed) {
                return;
            }
            if (p_307117_.isHighPriority) {
                this.toBatchHighPriority.offer(p_295825_);
            } else {
                this.toBatchLowPriority.offer(p_295825_);
            }
            this.toBatchCount = this.toBatchHighPriority.size() + this.toBatchLowPriority.size();
            this.runTask();
        });
    }

    public CompletableFuture<Void> uploadSectionLayer(MeshData p_350732_, VertexBuffer p_294163_) {
        if (this.closed) {
            return CompletableFuture.completedFuture(null);
        }
        return CompletableFuture.runAsync(() -> {
            if (p_294163_.isInvalid()) {
                p_350732_.close();
                return;
            }
            p_294163_.bind();
            p_294163_.upload(p_350732_);
            VertexBuffer.unbind();
        }, this.toUpload::add);
    }

    public CompletableFuture<Void> uploadSectionIndexBuffer(ByteBufferBuilder.Result p_350933_, VertexBuffer p_350643_) {
        if (this.closed) {
            return CompletableFuture.completedFuture(null);
        }
        return CompletableFuture.runAsync(() -> {
            if (p_350643_.isInvalid()) {
                p_350933_.close();
                return;
            }
            p_350643_.bind();
            p_350643_.uploadIndexBuffer(p_350933_);
            VertexBuffer.unbind();
        }, this.toUpload::add);
    }

    private void clearBatchQueue() {
        while (!this.toBatchHighPriority.isEmpty()) {
            RenderSection.CompileTask $$0 = this.toBatchHighPriority.poll();
            if ($$0 == null) continue;
            $$0.cancel();
        }
        while (!this.toBatchLowPriority.isEmpty()) {
            RenderSection.CompileTask $$1 = this.toBatchLowPriority.poll();
            if ($$1 == null) continue;
            $$1.cancel();
        }
        this.toBatchCount = 0;
    }

    public boolean isQueueEmpty() {
        return this.toBatchCount == 0 && this.toUpload.isEmpty();
    }

    public void dispose() {
        this.closed = true;
        this.clearBatchQueue();
        this.uploadAllPendingUploads();
    }

    public class RenderSection {
        public static final int SIZE = 16;
        public final int index;
        public final AtomicReference<CompiledSection> compiled = new AtomicReference<CompiledSection>(CompiledSection.UNCOMPILED);
        private final AtomicInteger initialCompilationCancelCount = new AtomicInteger(0);
        @Nullable
        private RebuildTask lastRebuildTask;
        @Nullable
        private ResortTransparencyTask lastResortTransparencyTask;
        private final Set<BlockEntity> globalBlockEntities = Sets.newHashSet();
        private final Map<RenderType, VertexBuffer> buffers = RenderType.chunkBufferLayers().stream().collect(Collectors.toMap(p_295245_ -> p_295245_, p_295640_ -> new VertexBuffer(VertexBuffer.Usage.STATIC)));
        private AABB bb;
        private boolean dirty = true;
        final BlockPos.MutableBlockPos origin = new BlockPos.MutableBlockPos(-1, -1, -1);
        private final BlockPos.MutableBlockPos[] relativeOrigins = Util.make(new BlockPos.MutableBlockPos[6], p_294717_ -> {
            for (int $$1 = 0; $$1 < ((BlockPos.MutableBlockPos[])p_294717_).length; ++$$1) {
                p_294717_[$$1] = new BlockPos.MutableBlockPos();
            }
        });
        private boolean playerChanged;

        public RenderSection(int p_295197_, int p_295159_, int p_294506_, int p_294392_) {
            this.index = p_295197_;
            this.setOrigin(p_295159_, p_294506_, p_294392_);
        }

        private boolean doesChunkExistAt(BlockPos p_295253_) {
            return SectionRenderDispatcher.this.level.getChunk(SectionPos.blockToSectionCoord(p_295253_.getX()), SectionPos.blockToSectionCoord(p_295253_.getZ()), ChunkStatus.FULL, false) != null;
        }

        public boolean hasAllNeighbors() {
            int $$0 = 24;
            if (this.getDistToPlayerSqr() > 576.0) {
                return this.doesChunkExistAt(this.relativeOrigins[Direction.WEST.ordinal()]) && this.doesChunkExistAt(this.relativeOrigins[Direction.NORTH.ordinal()]) && this.doesChunkExistAt(this.relativeOrigins[Direction.EAST.ordinal()]) && this.doesChunkExistAt(this.relativeOrigins[Direction.SOUTH.ordinal()]);
            }
            return true;
        }

        public AABB getBoundingBox() {
            return this.bb;
        }

        public VertexBuffer getBuffer(RenderType p_294497_) {
            return this.buffers.get(p_294497_);
        }

        public void setOrigin(int p_294148_, int p_295137_, int p_295706_) {
            this.reset();
            this.origin.set(p_294148_, p_295137_, p_295706_);
            this.bb = new AABB(p_294148_, p_295137_, p_295706_, p_294148_ + 16, p_295137_ + 16, p_295706_ + 16);
            for (Direction $$3 : Direction.values()) {
                this.relativeOrigins[$$3.ordinal()].set(this.origin).move($$3, 16);
            }
        }

        protected double getDistToPlayerSqr() {
            Camera $$0 = Minecraft.getInstance().gameRenderer.getMainCamera();
            double $$1 = this.bb.minX + 8.0 - $$0.getPosition().x;
            double $$2 = this.bb.minY + 8.0 - $$0.getPosition().y;
            double $$3 = this.bb.minZ + 8.0 - $$0.getPosition().z;
            return $$1 * $$1 + $$2 * $$2 + $$3 * $$3;
        }

        public CompiledSection getCompiled() {
            return this.compiled.get();
        }

        private void reset() {
            this.cancelTasks();
            this.compiled.set(CompiledSection.UNCOMPILED);
            this.dirty = true;
        }

        public void releaseBuffers() {
            this.reset();
            this.buffers.values().forEach(VertexBuffer::close);
        }

        public BlockPos getOrigin() {
            return this.origin;
        }

        public void setDirty(boolean p_295417_) {
            boolean $$1 = this.dirty;
            this.dirty = true;
            this.playerChanged = p_295417_ | ($$1 && this.playerChanged);
        }

        public void setNotDirty() {
            this.dirty = false;
            this.playerChanged = false;
        }

        public boolean isDirty() {
            return this.dirty;
        }

        public boolean isDirtyFromPlayer() {
            return this.dirty && this.playerChanged;
        }

        public BlockPos getRelativeOrigin(Direction p_296100_) {
            return this.relativeOrigins[p_296100_.ordinal()];
        }

        public boolean resortTransparency(RenderType p_295679_, SectionRenderDispatcher p_294363_) {
            CompiledSection $$2 = this.getCompiled();
            if (this.lastResortTransparencyTask != null) {
                this.lastResortTransparencyTask.cancel();
            }
            if (!$$2.hasBlocks.contains(p_295679_)) {
                return false;
            }
            this.lastResortTransparencyTask = new ResortTransparencyTask(this.getDistToPlayerSqr(), $$2);
            p_294363_.schedule(this.lastResortTransparencyTask);
            return true;
        }

        protected boolean cancelTasks() {
            boolean $$0 = false;
            if (this.lastRebuildTask != null) {
                this.lastRebuildTask.cancel();
                this.lastRebuildTask = null;
                $$0 = true;
            }
            if (this.lastResortTransparencyTask != null) {
                this.lastResortTransparencyTask.cancel();
                this.lastResortTransparencyTask = null;
            }
            return $$0;
        }

        public CompileTask createCompileTask(RenderRegionCache p_295324_) {
            boolean $$3;
            boolean $$1 = this.cancelTasks();
            RenderChunkRegion $$2 = p_295324_.createRegion(SectionRenderDispatcher.this.level, SectionPos.of(this.origin));
            boolean bl = $$3 = this.compiled.get() == CompiledSection.UNCOMPILED;
            if ($$3 && $$1) {
                this.initialCompilationCancelCount.incrementAndGet();
            }
            this.lastRebuildTask = new RebuildTask(this.getDistToPlayerSqr(), $$2, !$$3 || this.initialCompilationCancelCount.get() > 2);
            return this.lastRebuildTask;
        }

        public void rebuildSectionAsync(SectionRenderDispatcher p_295901_, RenderRegionCache p_294660_) {
            CompileTask $$2 = this.createCompileTask(p_294660_);
            p_295901_.schedule($$2);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * WARNING - void declaration
         */
        void updateGlobalBlockEntities(Collection<BlockEntity> p_296155_) {
            void $$3;
            HashSet $$1 = Sets.newHashSet(p_296155_);
            Set<BlockEntity> set = this.globalBlockEntities;
            synchronized (set) {
                HashSet $$2 = Sets.newHashSet(this.globalBlockEntities);
                $$1.removeAll(this.globalBlockEntities);
                $$2.removeAll(p_296155_);
                this.globalBlockEntities.clear();
                this.globalBlockEntities.addAll(p_296155_);
            }
            SectionRenderDispatcher.this.renderer.updateGlobalBlockEntities((Collection<BlockEntity>)$$3, $$1);
        }

        public void compileSync(RenderRegionCache p_296018_) {
            CompileTask $$1 = this.createCompileTask(p_296018_);
            $$1.doTask(SectionRenderDispatcher.this.fixedBuffers);
        }

        public boolean isAxisAlignedWith(int p_295743_, int p_295344_, int p_295518_) {
            BlockPos $$3 = this.getOrigin();
            return p_295743_ == SectionPos.blockToSectionCoord($$3.getX()) || p_295518_ == SectionPos.blockToSectionCoord($$3.getZ()) || p_295344_ == SectionPos.blockToSectionCoord($$3.getY());
        }

        void setCompiled(CompiledSection p_350692_) {
            this.compiled.set(p_350692_);
            this.initialCompilationCancelCount.set(0);
            SectionRenderDispatcher.this.renderer.addRecentlyCompiledSection(this);
        }

        VertexSorting createVertexSorting() {
            Vec3 $$0 = SectionRenderDispatcher.this.getCameraPosition();
            return VertexSorting.byDistance((float)($$0.x - (double)this.origin.getX()), (float)($$0.y - (double)this.origin.getY()), (float)($$0.z - (double)this.origin.getZ()));
        }

        class ResortTransparencyTask
        extends CompileTask {
            private final CompiledSection compiledSection;

            public ResortTransparencyTask(double p_294102_, CompiledSection p_294601_) {
                super(RenderSection.this, p_294102_, true);
                this.compiledSection = p_294601_;
            }

            @Override
            protected String name() {
                return "rend_chk_sort";
            }

            @Override
            public CompletableFuture<SectionTaskResult> doTask(SectionBufferBuilderPack p_295160_) {
                if (this.isCancelled.get()) {
                    return CompletableFuture.completedFuture(SectionTaskResult.CANCELLED);
                }
                if (!RenderSection.this.hasAllNeighbors()) {
                    this.isCancelled.set(true);
                    return CompletableFuture.completedFuture(SectionTaskResult.CANCELLED);
                }
                if (this.isCancelled.get()) {
                    return CompletableFuture.completedFuture(SectionTaskResult.CANCELLED);
                }
                MeshData.SortState $$1 = this.compiledSection.transparencyState;
                if ($$1 == null || this.compiledSection.isEmpty(RenderType.translucent())) {
                    return CompletableFuture.completedFuture(SectionTaskResult.CANCELLED);
                }
                VertexSorting $$2 = RenderSection.this.createVertexSorting();
                ByteBufferBuilder.Result $$3 = $$1.buildSortedIndexBuffer(p_295160_.buffer(RenderType.translucent()), $$2);
                if ($$3 == null) {
                    return CompletableFuture.completedFuture(SectionTaskResult.CANCELLED);
                }
                if (this.isCancelled.get()) {
                    $$3.close();
                    return CompletableFuture.completedFuture(SectionTaskResult.CANCELLED);
                }
                CompletionStage $$4 = SectionRenderDispatcher.this.uploadSectionIndexBuffer($$3, RenderSection.this.getBuffer(RenderType.translucent())).thenApply(p_294714_ -> SectionTaskResult.CANCELLED);
                return ((CompletableFuture)$$4).handle((p_295896_, p_295826_) -> {
                    if (p_295826_ != null && !(p_295826_ instanceof CancellationException) && !(p_295826_ instanceof InterruptedException)) {
                        Minecraft.getInstance().delayCrash(CrashReport.forThrowable(p_295826_, "Rendering section"));
                    }
                    return this.isCancelled.get() ? SectionTaskResult.CANCELLED : SectionTaskResult.SUCCESSFUL;
                });
            }

            @Override
            public void cancel() {
                this.isCancelled.set(true);
            }
        }

        abstract class CompileTask
        implements Comparable<CompileTask> {
            protected final double distAtCreation;
            protected final AtomicBoolean isCancelled = new AtomicBoolean(false);
            protected final boolean isHighPriority;

            public CompileTask(RenderSection renderSection, double p_294428_, boolean p_295051_) {
                this.distAtCreation = p_294428_;
                this.isHighPriority = p_295051_;
            }

            public abstract CompletableFuture<SectionTaskResult> doTask(SectionBufferBuilderPack var1);

            public abstract void cancel();

            protected abstract String name();

            @Override
            public int compareTo(CompileTask p_296186_) {
                return Doubles.compare((double)this.distAtCreation, (double)p_296186_.distAtCreation);
            }

            @Override
            public /* synthetic */ int compareTo(Object object) {
                return this.compareTo((CompileTask)object);
            }
        }

        class RebuildTask
        extends CompileTask {
            @Nullable
            protected RenderChunkRegion region;

            public RebuildTask(@Nullable double p_294400_, RenderChunkRegion p_294382_, boolean p_295207_) {
                super(RenderSection.this, p_294400_, p_295207_);
                this.region = p_294382_;
            }

            @Override
            protected String name() {
                return "rend_chk_rebuild";
            }

            @Override
            public CompletableFuture<SectionTaskResult> doTask(SectionBufferBuilderPack p_296138_) {
                if (this.isCancelled.get()) {
                    return CompletableFuture.completedFuture(SectionTaskResult.CANCELLED);
                }
                if (!RenderSection.this.hasAllNeighbors()) {
                    this.cancel();
                    return CompletableFuture.completedFuture(SectionTaskResult.CANCELLED);
                }
                if (this.isCancelled.get()) {
                    return CompletableFuture.completedFuture(SectionTaskResult.CANCELLED);
                }
                RenderChunkRegion $$1 = this.region;
                this.region = null;
                if ($$1 == null) {
                    RenderSection.this.setCompiled(CompiledSection.EMPTY);
                    return CompletableFuture.completedFuture(SectionTaskResult.SUCCESSFUL);
                }
                SectionPos $$2 = SectionPos.of(RenderSection.this.origin);
                SectionCompiler.Results $$3 = SectionRenderDispatcher.this.sectionCompiler.compile($$2, $$1, RenderSection.this.createVertexSorting(), p_296138_);
                RenderSection.this.updateGlobalBlockEntities($$3.globalBlockEntities);
                if (this.isCancelled.get()) {
                    $$3.release();
                    return CompletableFuture.completedFuture(SectionTaskResult.CANCELLED);
                }
                CompiledSection $$4 = new CompiledSection();
                $$4.visibilitySet = $$3.visibilitySet;
                $$4.renderableBlockEntities.addAll($$3.blockEntities);
                $$4.transparencyState = $$3.transparencyState;
                ArrayList $$5 = new ArrayList($$3.renderedLayers.size());
                $$3.renderedLayers.forEach((p_349884_, p_349885_) -> {
                    $$5.add(SectionRenderDispatcher.this.uploadSectionLayer((MeshData)p_349885_, RenderSection.this.getBuffer((RenderType)p_349884_)));
                    p_349883_.hasBlocks.add((RenderType)p_349884_);
                });
                return Util.sequenceFailFast($$5).handle((p_349887_, p_349888_) -> {
                    if (p_349888_ != null && !(p_349888_ instanceof CancellationException) && !(p_349888_ instanceof InterruptedException)) {
                        Minecraft.getInstance().delayCrash(CrashReport.forThrowable(p_349888_, "Rendering section"));
                    }
                    if (this.isCancelled.get()) {
                        return SectionTaskResult.CANCELLED;
                    }
                    RenderSection.this.setCompiled($$4);
                    return SectionTaskResult.SUCCESSFUL;
                });
            }

            @Override
            public void cancel() {
                this.region = null;
                if (this.isCancelled.compareAndSet(false, true)) {
                    RenderSection.this.setDirty(false);
                }
            }
        }
    }

    static enum SectionTaskResult {
        SUCCESSFUL,
        CANCELLED;

    }

    public static class CompiledSection {
        public static final CompiledSection UNCOMPILED = new CompiledSection(){

            @Override
            public boolean facesCanSeeEachother(Direction p_296238_, Direction p_294727_) {
                return false;
            }
        };
        public static final CompiledSection EMPTY = new CompiledSection(){

            @Override
            public boolean facesCanSeeEachother(Direction p_351039_, Direction p_350415_) {
                return true;
            }
        };
        final Set<RenderType> hasBlocks = new ObjectArraySet(RenderType.chunkBufferLayers().size());
        final List<BlockEntity> renderableBlockEntities = Lists.newArrayList();
        VisibilitySet visibilitySet = new VisibilitySet();
        @Nullable
        MeshData.SortState transparencyState;

        public boolean hasNoRenderableLayers() {
            return this.hasBlocks.isEmpty();
        }

        public boolean isEmpty(RenderType p_296192_) {
            return !this.hasBlocks.contains(p_296192_);
        }

        public List<BlockEntity> getRenderableBlockEntities() {
            return this.renderableBlockEntities;
        }

        public boolean facesCanSeeEachother(Direction p_295753_, Direction p_294424_) {
            return this.visibilitySet.visibilityBetween(p_295753_, p_294424_);
        }
    }
}

