/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.renderer.block.model;

import com.google.common.collect.Lists;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.block.model.BlockModel;
import net.minecraft.client.renderer.block.model.ItemOverride;
import net.minecraft.client.renderer.item.ItemProperties;
import net.minecraft.client.renderer.item.ItemPropertyFunction;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.BlockModelRotation;
import net.minecraft.client.resources.model.ModelBaker;
import net.minecraft.client.resources.model.UnbakedModel;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;

public class ItemOverrides {
    public static final ItemOverrides EMPTY = new ItemOverrides();
    public static final float NO_OVERRIDE = Float.NEGATIVE_INFINITY;
    private final BakedOverride[] overrides;
    private final ResourceLocation[] properties;

    private ItemOverrides() {
        this.overrides = new BakedOverride[0];
        this.properties = new ResourceLocation[0];
    }

    public ItemOverrides(ModelBaker p_251211_, BlockModel p_111741_, List<ItemOverride> p_111743_) {
        this.properties = (ResourceLocation[])p_111743_.stream().flatMap(ItemOverride::getPredicates).map(ItemOverride.Predicate::getProperty).distinct().toArray(ResourceLocation[]::new);
        Object2IntOpenHashMap $$3 = new Object2IntOpenHashMap();
        for (int $$4 = 0; $$4 < this.properties.length; ++$$4) {
            $$3.put((Object)this.properties[$$4], $$4);
        }
        ArrayList $$5 = Lists.newArrayList();
        for (int $$6 = p_111743_.size() - 1; $$6 >= 0; --$$6) {
            ItemOverride $$7 = p_111743_.get($$6);
            BakedModel $$8 = this.bakeModel(p_251211_, p_111741_, $$7);
            PropertyMatcher[] $$9 = (PropertyMatcher[])$$7.getPredicates().map(arg_0 -> ItemOverrides.lambda$new$1((Object2IntMap)$$3, arg_0)).toArray(PropertyMatcher[]::new);
            $$5.add(new BakedOverride($$9, $$8));
        }
        this.overrides = $$5.toArray(new BakedOverride[0]);
    }

    @Nullable
    private BakedModel bakeModel(ModelBaker p_249483_, BlockModel p_251965_, ItemOverride p_250816_) {
        UnbakedModel $$3 = p_249483_.getModel(p_250816_.getModel());
        if (Objects.equals($$3, p_251965_)) {
            return null;
        }
        return p_249483_.bake(p_250816_.getModel(), BlockModelRotation.X0_Y0);
    }

    @Nullable
    public BakedModel resolve(BakedModel p_173465_, ItemStack p_173466_, @Nullable ClientLevel p_173467_, @Nullable LivingEntity p_173468_, int p_173469_) {
        if (this.overrides.length != 0) {
            int $$5 = this.properties.length;
            float[] $$6 = new float[$$5];
            for (int $$7 = 0; $$7 < $$5; ++$$7) {
                ResourceLocation $$8 = this.properties[$$7];
                ItemPropertyFunction $$9 = ItemProperties.getProperty(p_173466_, $$8);
                $$6[$$7] = $$9 != null ? $$9.call(p_173466_, p_173467_, p_173468_, p_173469_) : Float.NEGATIVE_INFINITY;
            }
            for (BakedOverride $$10 : this.overrides) {
                if (!$$10.test($$6)) continue;
                BakedModel $$11 = $$10.model;
                if ($$11 == null) {
                    return p_173465_;
                }
                return $$11;
            }
        }
        return p_173465_;
    }

    private static /* synthetic */ PropertyMatcher lambda$new$1(Object2IntMap p_173476_, ItemOverride.Predicate p_173477_) {
        int $$2 = p_173476_.getInt((Object)p_173477_.getProperty());
        return new PropertyMatcher($$2, p_173477_.getValue());
    }

    static class BakedOverride {
        private final PropertyMatcher[] matchers;
        @Nullable
        final BakedModel model;

        BakedOverride(PropertyMatcher[] p_173483_, @Nullable BakedModel p_173484_) {
            this.matchers = p_173483_;
            this.model = p_173484_;
        }

        boolean test(float[] p_173486_) {
            for (PropertyMatcher $$1 : this.matchers) {
                float $$2 = p_173486_[$$1.index];
                if (!($$2 < $$1.value)) continue;
                return false;
            }
            return true;
        }
    }

    static class PropertyMatcher {
        public final int index;
        public final float value;

        PropertyMatcher(int p_173490_, float p_173491_) {
            this.index = p_173490_;
            this.value = p_173491_;
        }
    }
}

