/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.particle;

import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.Camera;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.particle.SpriteSet;
import net.minecraft.client.particle.TextureSheetParticle;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.SimpleParticleType;

public class FlyTowardsPositionParticle
extends TextureSheetParticle {
    private final double xStart;
    private final double yStart;
    private final double zStart;
    private final boolean isGlowing;
    private final Particle.LifetimeAlpha lifetimeAlpha;

    FlyTowardsPositionParticle(ClientLevel p_323658_, double p_324523_, double p_324079_, double p_324377_, double p_324144_, double p_324286_, double p_323511_) {
        this(p_323658_, p_324523_, p_324079_, p_324377_, p_324144_, p_324286_, p_323511_, false, Particle.LifetimeAlpha.ALWAYS_OPAQUE);
    }

    FlyTowardsPositionParticle(ClientLevel p_323938_, double p_323720_, double p_324407_, double p_324020_, double p_323737_, double p_323883_, double p_324615_, boolean p_323911_, Particle.LifetimeAlpha p_324427_) {
        super(p_323938_, p_323720_, p_324407_, p_324020_);
        this.isGlowing = p_323911_;
        this.lifetimeAlpha = p_324427_;
        this.setAlpha(p_324427_.startAlpha());
        this.xd = p_323737_;
        this.yd = p_323883_;
        this.zd = p_324615_;
        this.xStart = p_323720_;
        this.yStart = p_324407_;
        this.zStart = p_324020_;
        this.xo = p_323720_ + p_323737_;
        this.yo = p_324407_ + p_323883_;
        this.zo = p_324020_ + p_324615_;
        this.x = this.xo;
        this.y = this.yo;
        this.z = this.zo;
        this.quadSize = 0.1f * (this.random.nextFloat() * 0.5f + 0.2f);
        float $$9 = this.random.nextFloat() * 0.6f + 0.4f;
        this.rCol = 0.9f * $$9;
        this.gCol = 0.9f * $$9;
        this.bCol = $$9;
        this.hasPhysics = false;
        this.lifetime = (int)(Math.random() * 10.0) + 30;
    }

    @Override
    public ParticleRenderType getRenderType() {
        if (this.lifetimeAlpha.isOpaque()) {
            return ParticleRenderType.PARTICLE_SHEET_OPAQUE;
        }
        return ParticleRenderType.PARTICLE_SHEET_TRANSLUCENT;
    }

    @Override
    public void move(double p_324487_, double p_323538_, double p_324364_) {
        this.setBoundingBox(this.getBoundingBox().move(p_324487_, p_323538_, p_324364_));
        this.setLocationFromBoundingbox();
    }

    @Override
    public int getLightColor(float p_323664_) {
        if (this.isGlowing) {
            return 240;
        }
        int $$1 = super.getLightColor(p_323664_);
        float $$2 = (float)this.age / (float)this.lifetime;
        $$2 *= $$2;
        $$2 *= $$2;
        int $$3 = $$1 & 0xFF;
        int $$4 = $$1 >> 16 & 0xFF;
        if (($$4 += (int)($$2 * 15.0f * 16.0f)) > 240) {
            $$4 = 240;
        }
        return $$3 | $$4 << 16;
    }

    @Override
    public void tick() {
        this.xo = this.x;
        this.yo = this.y;
        this.zo = this.z;
        if (this.age++ >= this.lifetime) {
            this.remove();
            return;
        }
        float $$0 = (float)this.age / (float)this.lifetime;
        $$0 = 1.0f - $$0;
        float $$1 = 1.0f - $$0;
        $$1 *= $$1;
        $$1 *= $$1;
        this.x = this.xStart + this.xd * (double)$$0;
        this.y = this.yStart + this.yd * (double)$$0 - (double)($$1 * 1.2f);
        this.z = this.zStart + this.zd * (double)$$0;
    }

    @Override
    public void render(VertexConsumer p_324177_, Camera p_323683_, float p_323936_) {
        this.setAlpha(this.lifetimeAlpha.currentAlphaForAge(this.age, this.lifetime, p_323936_));
        super.render(p_324177_, p_323683_, p_323936_);
    }

    public static class VaultConnectionProvider
    implements ParticleProvider<SimpleParticleType> {
        private final SpriteSet sprite;

        public VaultConnectionProvider(SpriteSet p_324409_) {
            this.sprite = p_324409_;
        }

        @Override
        public Particle createParticle(SimpleParticleType p_324345_, ClientLevel p_324607_, double p_324458_, double p_324613_, double p_324276_, double p_323805_, double p_324556_, double p_323945_) {
            FlyTowardsPositionParticle $$8 = new FlyTowardsPositionParticle(p_324607_, p_324458_, p_324613_, p_324276_, p_323805_, p_324556_, p_323945_, true, new Particle.LifetimeAlpha(0.0f, 0.6f, 0.25f, 1.0f));
            $$8.scale(1.5f);
            $$8.pickSprite(this.sprite);
            return $$8;
        }

        @Override
        public /* synthetic */ Particle createParticle(ParticleOptions particleOptions, ClientLevel clientLevel, double d, double d2, double d3, double d4, double d5, double d6) {
            return this.createParticle((SimpleParticleType)particleOptions, clientLevel, d, d2, d3, d4, d5, d6);
        }
    }

    public static class NautilusProvider
    implements ParticleProvider<SimpleParticleType> {
        private final SpriteSet sprite;

        public NautilusProvider(SpriteSet p_323905_) {
            this.sprite = p_323905_;
        }

        @Override
        public Particle createParticle(SimpleParticleType p_323965_, ClientLevel p_324479_, double p_323514_, double p_323507_, double p_324033_, double p_323555_, double p_323611_, double p_323980_) {
            FlyTowardsPositionParticle $$8 = new FlyTowardsPositionParticle(p_324479_, p_323514_, p_323507_, p_324033_, p_323555_, p_323611_, p_323980_);
            $$8.pickSprite(this.sprite);
            return $$8;
        }

        @Override
        public /* synthetic */ Particle createParticle(ParticleOptions particleOptions, ClientLevel clientLevel, double d, double d2, double d3, double d4, double d5, double d6) {
            return this.createParticle((SimpleParticleType)particleOptions, clientLevel, d, d2, d3, d4, d5, d6);
        }
    }

    public static class EnchantProvider
    implements ParticleProvider<SimpleParticleType> {
        private final SpriteSet sprite;

        public EnchantProvider(SpriteSet p_324184_) {
            this.sprite = p_324184_;
        }

        @Override
        public Particle createParticle(SimpleParticleType p_323913_, ClientLevel p_323933_, double p_324281_, double p_323543_, double p_324051_, double p_323907_, double p_324082_, double p_323993_) {
            FlyTowardsPositionParticle $$8 = new FlyTowardsPositionParticle(p_323933_, p_324281_, p_323543_, p_324051_, p_323907_, p_324082_, p_323993_);
            $$8.pickSprite(this.sprite);
            return $$8;
        }

        @Override
        public /* synthetic */ Particle createParticle(ParticleOptions particleOptions, ClientLevel clientLevel, double d, double d2, double d3, double d4, double d5, double d6) {
            return this.createParticle((SimpleParticleType)particleOptions, clientLevel, d, d2, d3, d4, d5, d6);
        }
    }
}

