/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.collect.Queues;
import com.mojang.authlib.GameProfile;
import com.mojang.authlib.exceptions.AuthenticationException;
import com.mojang.authlib.minecraft.BanDetails;
import com.mojang.authlib.minecraft.MinecraftSessionService;
import com.mojang.authlib.minecraft.UserApiService;
import com.mojang.authlib.yggdrasil.ProfileActionType;
import com.mojang.authlib.yggdrasil.ProfileResult;
import com.mojang.authlib.yggdrasil.ServicesKeyType;
import com.mojang.authlib.yggdrasil.YggdrasilAuthenticationService;
import com.mojang.blaze3d.pipeline.MainTarget;
import com.mojang.blaze3d.pipeline.RenderTarget;
import com.mojang.blaze3d.pipeline.TextureTarget;
import com.mojang.blaze3d.platform.DisplayData;
import com.mojang.blaze3d.platform.GlDebug;
import com.mojang.blaze3d.platform.GlUtil;
import com.mojang.blaze3d.platform.IconSet;
import com.mojang.blaze3d.platform.Window;
import com.mojang.blaze3d.platform.WindowEventHandler;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.systems.TimerQuery;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.MeshData;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.mojang.blaze3d.vertex.VertexSorting;
import com.mojang.datafixers.DataFixer;
import com.mojang.logging.LogUtils;
import com.mojang.realmsclient.client.RealmsClient;
import com.mojang.realmsclient.gui.RealmsDataFetcher;
import it.unimi.dsi.fastutil.objects.Object2BooleanFunction;
import java.io.File;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.lang.management.ManagementFactory;
import java.net.Proxy;
import java.net.SocketAddress;
import java.nio.ByteBuffer;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.Queue;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.CrashReport;
import net.minecraft.CrashReportCategory;
import net.minecraft.FileUtil;
import net.minecraft.Optionull;
import net.minecraft.ReportType;
import net.minecraft.ReportedException;
import net.minecraft.SharedConstants;
import net.minecraft.SystemReport;
import net.minecraft.Util;
import net.minecraft.client.CameraType;
import net.minecraft.client.ClientBrandRetriever;
import net.minecraft.client.CloudStatus;
import net.minecraft.client.CommandHistory;
import net.minecraft.client.DeltaTracker;
import net.minecraft.client.GameNarrator;
import net.minecraft.client.GraphicsStatus;
import net.minecraft.client.HotbarManager;
import net.minecraft.client.InputType;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.KeyboardHandler;
import net.minecraft.client.MouseHandler;
import net.minecraft.client.NarratorStatus;
import net.minecraft.client.Options;
import net.minecraft.client.PeriodicNotificationManager;
import net.minecraft.client.ResourceLoadStateTracker;
import net.minecraft.client.Screenshot;
import net.minecraft.client.User;
import net.minecraft.client.color.block.BlockColors;
import net.minecraft.client.color.item.ItemColors;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.GuiSpriteManager;
import net.minecraft.client.gui.components.DebugScreenOverlay;
import net.minecraft.client.gui.components.toasts.SystemToast;
import net.minecraft.client.gui.components.toasts.ToastComponent;
import net.minecraft.client.gui.components.toasts.TutorialToast;
import net.minecraft.client.gui.font.FontManager;
import net.minecraft.client.gui.font.providers.FreeTypeUtil;
import net.minecraft.client.gui.screens.AccessibilityOnboardingScreen;
import net.minecraft.client.gui.screens.BanNoticeScreens;
import net.minecraft.client.gui.screens.ChatScreen;
import net.minecraft.client.gui.screens.ConfirmLinkScreen;
import net.minecraft.client.gui.screens.DeathScreen;
import net.minecraft.client.gui.screens.GenericMessageScreen;
import net.minecraft.client.gui.screens.InBedChatScreen;
import net.minecraft.client.gui.screens.LevelLoadingScreen;
import net.minecraft.client.gui.screens.LoadingOverlay;
import net.minecraft.client.gui.screens.MenuScreens;
import net.minecraft.client.gui.screens.OutOfMemoryScreen;
import net.minecraft.client.gui.screens.Overlay;
import net.minecraft.client.gui.screens.PauseScreen;
import net.minecraft.client.gui.screens.ProgressScreen;
import net.minecraft.client.gui.screens.ReceivingLevelScreen;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.TitleScreen;
import net.minecraft.client.gui.screens.advancements.AdvancementsScreen;
import net.minecraft.client.gui.screens.inventory.CreativeModeInventoryScreen;
import net.minecraft.client.gui.screens.inventory.InventoryScreen;
import net.minecraft.client.gui.screens.social.PlayerSocialManager;
import net.minecraft.client.gui.screens.social.SocialInteractionsScreen;
import net.minecraft.client.gui.screens.worldselection.WorldOpenFlows;
import net.minecraft.client.main.GameConfig;
import net.minecraft.client.main.SilentInitException;
import net.minecraft.client.model.geom.EntityModelSet;
import net.minecraft.client.multiplayer.ClientHandshakePacketListenerImpl;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.multiplayer.ClientPacketListener;
import net.minecraft.client.multiplayer.MultiPlayerGameMode;
import net.minecraft.client.multiplayer.ProfileKeyPairManager;
import net.minecraft.client.multiplayer.ServerData;
import net.minecraft.client.multiplayer.chat.ChatListener;
import net.minecraft.client.multiplayer.chat.report.ReportEnvironment;
import net.minecraft.client.multiplayer.chat.report.ReportingContext;
import net.minecraft.client.particle.ParticleEngine;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.profiling.ClientMetricsSamplersProvider;
import net.minecraft.client.quickplay.QuickPlay;
import net.minecraft.client.quickplay.QuickPlayLog;
import net.minecraft.client.renderer.BlockEntityWithoutLevelRenderer;
import net.minecraft.client.renderer.FogRenderer;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.GpuWarnlistManager;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.client.renderer.RenderBuffers;
import net.minecraft.client.renderer.VirtualScreen;
import net.minecraft.client.renderer.block.BlockModelShaper;
import net.minecraft.client.renderer.block.BlockRenderDispatcher;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderDispatcher;
import net.minecraft.client.renderer.debug.DebugRenderer;
import net.minecraft.client.renderer.entity.EntityRenderDispatcher;
import net.minecraft.client.renderer.entity.EntityRenderers;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.client.resources.ClientPackSource;
import net.minecraft.client.resources.FoliageColorReloadListener;
import net.minecraft.client.resources.GrassColorReloadListener;
import net.minecraft.client.resources.MapDecorationTextureManager;
import net.minecraft.client.resources.MobEffectTextureManager;
import net.minecraft.client.resources.PaintingTextureManager;
import net.minecraft.client.resources.SkinManager;
import net.minecraft.client.resources.SplashManager;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.client.resources.language.LanguageManager;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.ModelManager;
import net.minecraft.client.resources.server.DownloadedPackSource;
import net.minecraft.client.server.IntegratedServer;
import net.minecraft.client.sounds.MusicManager;
import net.minecraft.client.sounds.SoundManager;
import net.minecraft.client.telemetry.ClientTelemetryManager;
import net.minecraft.client.telemetry.TelemetryProperty;
import net.minecraft.client.telemetry.events.GameLoadTimesEvent;
import net.minecraft.client.tutorial.Tutorial;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.Connection;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.contents.KeybindResolver;
import net.minecraft.network.protocol.game.ServerboundPlayerActionPacket;
import net.minecraft.network.protocol.login.ServerboundHelloPacket;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.Bootstrap;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.Services;
import net.minecraft.server.WorldStem;
import net.minecraft.server.level.progress.ProcessorChunkProgressListener;
import net.minecraft.server.level.progress.StoringChunkProgressListener;
import net.minecraft.server.packs.PackResources;
import net.minecraft.server.packs.PackType;
import net.minecraft.server.packs.VanillaPackResources;
import net.minecraft.server.packs.repository.FolderRepositorySource;
import net.minecraft.server.packs.repository.PackRepository;
import net.minecraft.server.packs.repository.PackSource;
import net.minecraft.server.packs.resources.ReloadInstance;
import net.minecraft.server.packs.resources.ReloadableResourceManager;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.players.GameProfileCache;
import net.minecraft.sounds.Music;
import net.minecraft.sounds.Musics;
import net.minecraft.tags.BiomeTags;
import net.minecraft.util.CommonLinks;
import net.minecraft.util.FastColor;
import net.minecraft.util.FileZipper;
import net.minecraft.util.MemoryReserve;
import net.minecraft.util.ModCheck;
import net.minecraft.util.Mth;
import net.minecraft.util.SignatureValidator;
import net.minecraft.util.TimeUtil;
import net.minecraft.util.Unit;
import net.minecraft.util.datafix.DataFixers;
import net.minecraft.util.profiling.ContinuousProfiler;
import net.minecraft.util.profiling.EmptyProfileResults;
import net.minecraft.util.profiling.InactiveProfiler;
import net.minecraft.util.profiling.ProfileResults;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraft.util.profiling.ResultField;
import net.minecraft.util.profiling.SingleTickProfiler;
import net.minecraft.util.profiling.metrics.profiling.ActiveMetricsRecorder;
import net.minecraft.util.profiling.metrics.profiling.InactiveMetricsRecorder;
import net.minecraft.util.profiling.metrics.profiling.MetricsRecorder;
import net.minecraft.util.profiling.metrics.storage.MetricsPersister;
import net.minecraft.util.thread.ReentrantBlockableEventLoop;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.TickRateManager;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.ChatVisiblity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.SkullBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.storage.LevelStorageSource;
import net.minecraft.world.level.validation.DirectoryValidator;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import org.apache.commons.io.FileUtils;
import org.joml.Matrix4f;
import org.joml.Matrix4fStack;
import org.lwjgl.util.tinyfd.TinyFileDialogs;
import org.slf4j.Logger;

public class Minecraft
extends ReentrantBlockableEventLoop<Runnable>
implements WindowEventHandler {
    static Minecraft instance;
    private static final Logger LOGGER;
    public static final boolean ON_OSX;
    private static final int MAX_TICKS_PER_UPDATE = 10;
    public static final ResourceLocation DEFAULT_FONT;
    public static final ResourceLocation UNIFORM_FONT;
    public static final ResourceLocation ALT_FONT;
    private static final ResourceLocation REGIONAL_COMPLIANCIES;
    private static final CompletableFuture<Unit> RESOURCE_RELOAD_INITIAL_TASK;
    private static final Component SOCIAL_INTERACTIONS_NOT_AVAILABLE;
    public static final String UPDATE_DRIVERS_ADVICE = "Please make sure you have up-to-date drivers (see aka.ms/mcdriver for instructions).";
    private final long canary = Double.doubleToLongBits(Math.PI);
    private final Path resourcePackDirectory;
    private final CompletableFuture<ProfileResult> profileFuture;
    private final TextureManager textureManager;
    private final DataFixer fixerUpper;
    private final VirtualScreen virtualScreen;
    private final Window window;
    private final DeltaTracker.Timer timer = new DeltaTracker.Timer(20.0f, 0L, this::getTickTargetMillis);
    private final RenderBuffers renderBuffers;
    public final LevelRenderer levelRenderer;
    private final EntityRenderDispatcher entityRenderDispatcher;
    private final ItemRenderer itemRenderer;
    public final ParticleEngine particleEngine;
    private final User user;
    public final Font font;
    public final Font fontFilterFishy;
    public final GameRenderer gameRenderer;
    public final DebugRenderer debugRenderer;
    private final AtomicReference<StoringChunkProgressListener> progressListener = new AtomicReference();
    public final Gui gui;
    public final Options options;
    private final HotbarManager hotbarManager;
    public final MouseHandler mouseHandler;
    public final KeyboardHandler keyboardHandler;
    private InputType lastInputType = InputType.NONE;
    public final File gameDirectory;
    private final String launchedVersion;
    private final String versionType;
    private final Proxy proxy;
    private final LevelStorageSource levelSource;
    private final boolean demo;
    private final boolean allowsMultiplayer;
    private final boolean allowsChat;
    private final ReloadableResourceManager resourceManager;
    private final VanillaPackResources vanillaPackResources;
    private final DownloadedPackSource downloadedPackSource;
    private final PackRepository resourcePackRepository;
    private final LanguageManager languageManager;
    private final BlockColors blockColors;
    private final ItemColors itemColors;
    private final RenderTarget mainRenderTarget;
    private final SoundManager soundManager;
    private final MusicManager musicManager;
    private final FontManager fontManager;
    private final SplashManager splashManager;
    private final GpuWarnlistManager gpuWarnlistManager;
    private final PeriodicNotificationManager regionalCompliancies = new PeriodicNotificationManager(REGIONAL_COMPLIANCIES, (Object2BooleanFunction<String>)((Object2BooleanFunction)Minecraft::countryEqualsISO3));
    private final YggdrasilAuthenticationService authenticationService;
    private final MinecraftSessionService minecraftSessionService;
    private final UserApiService userApiService;
    private final CompletableFuture<UserApiService.UserProperties> userPropertiesFuture;
    private final SkinManager skinManager;
    private final ModelManager modelManager;
    private final BlockRenderDispatcher blockRenderer;
    private final PaintingTextureManager paintingTextures;
    private final MobEffectTextureManager mobEffectTextures;
    private final MapDecorationTextureManager mapDecorationTextures;
    private final GuiSpriteManager guiSprites;
    private final ToastComponent toast;
    private final Tutorial tutorial;
    private final PlayerSocialManager playerSocialManager;
    private final EntityModelSet entityModels;
    private final BlockEntityRenderDispatcher blockEntityRenderDispatcher;
    private final ClientTelemetryManager telemetryManager;
    private final ProfileKeyPairManager profileKeyPairManager;
    private final RealmsDataFetcher realmsDataFetcher;
    private final QuickPlayLog quickPlayLog;
    @Nullable
    public MultiPlayerGameMode gameMode;
    @Nullable
    public ClientLevel level;
    @Nullable
    public LocalPlayer player;
    @Nullable
    private IntegratedServer singleplayerServer;
    @Nullable
    private Connection pendingConnection;
    private boolean isLocalServer;
    @Nullable
    public Entity cameraEntity;
    @Nullable
    public Entity crosshairPickEntity;
    @Nullable
    public HitResult hitResult;
    private int rightClickDelay;
    protected int missTime;
    private volatile boolean pause;
    private long lastNanoTime = Util.getNanos();
    private long lastTime;
    private int frames;
    public boolean noRender;
    @Nullable
    public Screen screen;
    @Nullable
    private Overlay overlay;
    private boolean clientLevelTeardownInProgress;
    private Thread gameThread;
    private volatile boolean running;
    @Nullable
    private Supplier<CrashReport> delayedCrash;
    private static int fps;
    public String fpsString = "";
    private long frameTimeNs;
    public boolean wireframe;
    public boolean sectionPath;
    public boolean sectionVisibility;
    public boolean smartCull = true;
    private boolean windowActive;
    private final Queue<Runnable> progressTasks = Queues.newConcurrentLinkedQueue();
    @Nullable
    private CompletableFuture<Void> pendingReload;
    @Nullable
    private TutorialToast socialInteractionsToast;
    private ProfilerFiller profiler = InactiveProfiler.INSTANCE;
    private int fpsPieRenderTicks;
    private final ContinuousProfiler fpsPieProfiler = new ContinuousProfiler(Util.timeSource, () -> this.fpsPieRenderTicks);
    @Nullable
    private ProfileResults fpsPieResults;
    private MetricsRecorder metricsRecorder = InactiveMetricsRecorder.INSTANCE;
    private final ResourceLoadStateTracker reloadStateTracker = new ResourceLoadStateTracker();
    private long savedCpuDuration;
    private double gpuUtilization;
    @Nullable
    private TimerQuery.FrameProfile currentFrameProfile;
    private final GameNarrator narrator;
    private final ChatListener chatListener;
    private ReportingContext reportingContext;
    private final CommandHistory commandHistory;
    private final DirectoryValidator directoryValidator;
    private boolean gameLoadFinished;
    private final long clientStartTimeMs;
    private long clientTickCount;
    private String debugPath = "root";

    public Minecraft(GameConfig p_91084_) {
        super("Client");
        DisplayData $$6;
        instance = this;
        this.clientStartTimeMs = System.currentTimeMillis();
        this.gameDirectory = p_91084_.location.gameDirectory;
        File $$1 = p_91084_.location.assetDirectory;
        this.resourcePackDirectory = p_91084_.location.resourcePackDirectory.toPath();
        this.launchedVersion = p_91084_.game.launchVersion;
        this.versionType = p_91084_.game.versionType;
        Path $$2 = this.gameDirectory.toPath();
        this.directoryValidator = LevelStorageSource.parseValidator($$2.resolve("allowed_symlinks.txt"));
        ClientPackSource $$3 = new ClientPackSource(p_91084_.location.getExternalAssetSource(), this.directoryValidator);
        this.downloadedPackSource = new DownloadedPackSource(this, $$2.resolve("downloads"), p_91084_.user);
        FolderRepositorySource $$4 = new FolderRepositorySource(this.resourcePackDirectory, PackType.CLIENT_RESOURCES, PackSource.DEFAULT, this.directoryValidator);
        this.resourcePackRepository = new PackRepository($$3, this.downloadedPackSource.createRepositorySource(), $$4);
        this.vanillaPackResources = $$3.getVanillaPack();
        this.proxy = p_91084_.user.proxy;
        this.authenticationService = new YggdrasilAuthenticationService(this.proxy);
        this.minecraftSessionService = this.authenticationService.createMinecraftSessionService();
        this.user = p_91084_.user.user;
        this.profileFuture = CompletableFuture.supplyAsync(() -> this.minecraftSessionService.fetchProfile(this.user.getProfileId(), true), Util.nonCriticalIoPool());
        this.userApiService = this.createUserApiService(this.authenticationService, p_91084_);
        this.userPropertiesFuture = CompletableFuture.supplyAsync(() -> {
            try {
                return this.userApiService.fetchProperties();
            }
            catch (AuthenticationException $$0) {
                LOGGER.error("Failed to fetch user properties", (Throwable)$$0);
                return UserApiService.OFFLINE_PROPERTIES;
            }
        }, Util.nonCriticalIoPool());
        LOGGER.info("Setting user: {}", (Object)this.user.getName());
        LOGGER.debug("(Session ID is {})", (Object)this.user.getSessionId());
        this.demo = p_91084_.game.demo;
        this.allowsMultiplayer = !p_91084_.game.disableMultiplayer;
        this.allowsChat = !p_91084_.game.disableChat;
        this.singleplayerServer = null;
        KeybindResolver.setKeyResolver(KeyMapping::createNameSupplier);
        this.fixerUpper = DataFixers.getDataFixer();
        this.toast = new ToastComponent(this);
        this.gameThread = Thread.currentThread();
        this.options = new Options(this, this.gameDirectory);
        RenderSystem.setShaderGlintAlpha(this.options.glintStrength().get());
        this.running = true;
        this.tutorial = new Tutorial(this, this.options);
        this.hotbarManager = new HotbarManager($$2, this.fixerUpper);
        LOGGER.info("Backend library: {}", (Object)RenderSystem.getBackendDescription());
        if (this.options.overrideHeight > 0 && this.options.overrideWidth > 0) {
            DisplayData $$5 = new DisplayData(this.options.overrideWidth, this.options.overrideHeight, p_91084_.display.fullscreenWidth, p_91084_.display.fullscreenHeight, p_91084_.display.isFullscreen);
        } else {
            $$6 = p_91084_.display;
        }
        Util.timeSource = RenderSystem.initBackendSystem();
        this.virtualScreen = new VirtualScreen(this);
        this.window = this.virtualScreen.newWindow($$6, this.options.fullscreenVideoModeString, this.createTitle());
        this.setWindowActive(true);
        GameLoadTimesEvent.INSTANCE.endStep(TelemetryProperty.LOAD_TIME_PRE_WINDOW_MS);
        try {
            this.window.setIcon(this.vanillaPackResources, SharedConstants.getCurrentVersion().isStable() ? IconSet.RELEASE : IconSet.SNAPSHOT);
        }
        catch (IOException $$7) {
            LOGGER.error("Couldn't set icon", (Throwable)$$7);
        }
        this.window.setFramerateLimit(this.options.framerateLimit().get());
        this.mouseHandler = new MouseHandler(this);
        this.mouseHandler.setup(this.window.getWindow());
        this.keyboardHandler = new KeyboardHandler(this);
        this.keyboardHandler.setup(this.window.getWindow());
        RenderSystem.initRenderer(this.options.glDebugVerbosity, false);
        this.mainRenderTarget = new MainTarget(this.window.getWidth(), this.window.getHeight());
        this.mainRenderTarget.setClearColor(0.0f, 0.0f, 0.0f, 0.0f);
        this.mainRenderTarget.clear(ON_OSX);
        this.resourceManager = new ReloadableResourceManager(PackType.CLIENT_RESOURCES);
        this.resourcePackRepository.reload();
        this.options.loadSelectedResourcePacks(this.resourcePackRepository);
        this.languageManager = new LanguageManager(this.options.languageCode, p_344151_ -> {
            if (this.player != null) {
                this.player.connection.updateSearchTrees();
            }
        });
        this.resourceManager.registerReloadListener(this.languageManager);
        this.textureManager = new TextureManager(this.resourceManager);
        this.resourceManager.registerReloadListener(this.textureManager);
        this.skinManager = new SkinManager(this.textureManager, $$1.toPath().resolve("skins"), this.minecraftSessionService, this);
        this.levelSource = new LevelStorageSource($$2.resolve("saves"), $$2.resolve("backups"), this.directoryValidator, this.fixerUpper);
        this.commandHistory = new CommandHistory($$2);
        this.soundManager = new SoundManager(this.options);
        this.resourceManager.registerReloadListener(this.soundManager);
        this.splashManager = new SplashManager(this.user);
        this.resourceManager.registerReloadListener(this.splashManager);
        this.musicManager = new MusicManager(this);
        this.fontManager = new FontManager(this.textureManager);
        this.font = this.fontManager.createFont();
        this.fontFilterFishy = this.fontManager.createFontFilterFishy();
        this.resourceManager.registerReloadListener(this.fontManager);
        this.updateFontOptions();
        this.resourceManager.registerReloadListener(new GrassColorReloadListener());
        this.resourceManager.registerReloadListener(new FoliageColorReloadListener());
        this.window.setErrorSection("Startup");
        RenderSystem.setupDefaultState(0, 0, this.window.getWidth(), this.window.getHeight());
        this.window.setErrorSection("Post startup");
        this.blockColors = BlockColors.createDefault();
        this.itemColors = ItemColors.createDefault(this.blockColors);
        this.modelManager = new ModelManager(this.textureManager, this.blockColors, this.options.mipmapLevels().get());
        this.resourceManager.registerReloadListener(this.modelManager);
        this.entityModels = new EntityModelSet();
        this.resourceManager.registerReloadListener(this.entityModels);
        this.blockEntityRenderDispatcher = new BlockEntityRenderDispatcher(this.font, this.entityModels, this::getBlockRenderer, this::getItemRenderer, this::getEntityRenderDispatcher);
        this.resourceManager.registerReloadListener(this.blockEntityRenderDispatcher);
        BlockEntityWithoutLevelRenderer $$8 = new BlockEntityWithoutLevelRenderer(this.blockEntityRenderDispatcher, this.entityModels);
        this.resourceManager.registerReloadListener($$8);
        this.itemRenderer = new ItemRenderer(this, this.textureManager, this.modelManager, this.itemColors, $$8);
        this.resourceManager.registerReloadListener(this.itemRenderer);
        try {
            int $$9 = Runtime.getRuntime().availableProcessors();
            Tesselator.init();
            this.renderBuffers = new RenderBuffers($$9);
        }
        catch (OutOfMemoryError $$10) {
            TinyFileDialogs.tinyfd_messageBox((CharSequence)"Minecraft", (CharSequence)("Oh no! The game was unable to allocate memory off-heap while trying to start. You may try to free some memory by closing other applications on your computer, check that your system meets the minimum requirements, and try again. If the problem persists, please visit: " + String.valueOf(CommonLinks.GENERAL_HELP)), (CharSequence)"ok", (CharSequence)"error", (boolean)true);
            throw new SilentInitException("Unable to allocate render buffers", $$10);
        }
        this.playerSocialManager = new PlayerSocialManager(this, this.userApiService);
        this.blockRenderer = new BlockRenderDispatcher(this.modelManager.getBlockModelShaper(), $$8, this.blockColors);
        this.resourceManager.registerReloadListener(this.blockRenderer);
        this.entityRenderDispatcher = new EntityRenderDispatcher(this, this.textureManager, this.itemRenderer, this.blockRenderer, this.font, this.options, this.entityModels);
        this.resourceManager.registerReloadListener(this.entityRenderDispatcher);
        this.particleEngine = new ParticleEngine(this.level, this.textureManager);
        this.resourceManager.registerReloadListener(this.particleEngine);
        this.paintingTextures = new PaintingTextureManager(this.textureManager);
        this.resourceManager.registerReloadListener(this.paintingTextures);
        this.mobEffectTextures = new MobEffectTextureManager(this.textureManager);
        this.resourceManager.registerReloadListener(this.mobEffectTextures);
        this.mapDecorationTextures = new MapDecorationTextureManager(this.textureManager);
        this.resourceManager.registerReloadListener(this.mapDecorationTextures);
        this.guiSprites = new GuiSpriteManager(this.textureManager);
        this.resourceManager.registerReloadListener(this.guiSprites);
        this.gameRenderer = new GameRenderer(this, this.entityRenderDispatcher.getItemInHandRenderer(), this.resourceManager, this.renderBuffers);
        this.resourceManager.registerReloadListener(this.gameRenderer.createReloadListener());
        this.levelRenderer = new LevelRenderer(this, this.entityRenderDispatcher, this.blockEntityRenderDispatcher, this.renderBuffers);
        this.resourceManager.registerReloadListener(this.levelRenderer);
        this.gpuWarnlistManager = new GpuWarnlistManager();
        this.resourceManager.registerReloadListener(this.gpuWarnlistManager);
        this.resourceManager.registerReloadListener(this.regionalCompliancies);
        this.gui = new Gui(this);
        this.debugRenderer = new DebugRenderer(this);
        RealmsClient $$11 = RealmsClient.create(this);
        this.realmsDataFetcher = new RealmsDataFetcher($$11);
        RenderSystem.setErrorCallback(this::onFullscreenError);
        if (this.mainRenderTarget.width != this.window.getWidth() || this.mainRenderTarget.height != this.window.getHeight()) {
            StringBuilder $$12 = new StringBuilder("Recovering from unsupported resolution (" + this.window.getWidth() + "x" + this.window.getHeight() + ").\nPlease make sure you have up-to-date drivers (see aka.ms/mcdriver for instructions).");
            if (GlDebug.isDebugEnabled()) {
                $$12.append("\n\nReported GL debug messages:\n").append(String.join((CharSequence)"\n", GlDebug.getLastOpenGlDebugMessages()));
            }
            this.window.setWindowed(this.mainRenderTarget.width, this.mainRenderTarget.height);
            TinyFileDialogs.tinyfd_messageBox((CharSequence)"Minecraft", (CharSequence)$$12.toString(), (CharSequence)"ok", (CharSequence)"error", (boolean)false);
        } else if (this.options.fullscreen().get().booleanValue() && !this.window.isFullscreen()) {
            this.window.toggleFullScreen();
            this.options.fullscreen().set(this.window.isFullscreen());
        }
        this.window.updateVsync(this.options.enableVsync().get());
        this.window.updateRawMouseInput(this.options.rawMouseInput().get());
        this.window.setDefaultErrorCallback();
        this.resizeDisplay();
        this.gameRenderer.preloadUiShader(this.vanillaPackResources.asProvider());
        this.telemetryManager = new ClientTelemetryManager(this, this.userApiService, this.user);
        this.profileKeyPairManager = ProfileKeyPairManager.create(this.userApiService, this.user, $$2);
        this.narrator = new GameNarrator(this);
        this.narrator.checkStatus(this.options.narrator().get() != NarratorStatus.OFF);
        this.chatListener = new ChatListener(this);
        this.chatListener.setMessageDelay(this.options.chatDelay().get());
        this.reportingContext = ReportingContext.create(ReportEnvironment.local(), this.userApiService);
        LoadingOverlay.registerTextures(this);
        this.setScreen(new GenericMessageScreen(Component.translatable("gui.loadingMinecraft")));
        List<PackResources> $$13 = this.resourcePackRepository.openAllSelected();
        this.reloadStateTracker.startReload(ResourceLoadStateTracker.ReloadReason.INITIAL, $$13);
        ReloadInstance $$14 = this.resourceManager.createReload(Util.backgroundExecutor(), this, RESOURCE_RELOAD_INITIAL_TASK, $$13);
        GameLoadTimesEvent.INSTANCE.beginStep(TelemetryProperty.LOAD_TIME_LOADING_OVERLAY_MS);
        GameLoadCookie $$15 = new GameLoadCookie($$11, p_91084_.quickPlay);
        this.setOverlay(new LoadingOverlay(this, $$14, p_299779_ -> Util.ifElse(p_299779_, p_299772_ -> this.rollbackResourcePacks((Throwable)p_299772_, $$15), () -> {
            if (SharedConstants.IS_RUNNING_IN_IDE) {
                this.selfTest();
            }
            this.reloadStateTracker.finishReload();
            this.onResourceLoadFinished($$15);
        }), false));
        this.quickPlayLog = QuickPlayLog.of(p_91084_.quickPlay.path());
    }

    private void onResourceLoadFinished(@Nullable GameLoadCookie p_299896_) {
        if (!this.gameLoadFinished) {
            this.gameLoadFinished = true;
            this.onGameLoadFinished(p_299896_);
        }
    }

    private void onGameLoadFinished(@Nullable GameLoadCookie p_299836_) {
        Runnable $$1 = this.buildInitialScreens(p_299836_);
        GameLoadTimesEvent.INSTANCE.endStep(TelemetryProperty.LOAD_TIME_LOADING_OVERLAY_MS);
        GameLoadTimesEvent.INSTANCE.endStep(TelemetryProperty.LOAD_TIME_TOTAL_TIME_MS);
        GameLoadTimesEvent.INSTANCE.send(this.telemetryManager.getOutsideSessionSender());
        $$1.run();
    }

    public boolean isGameLoadFinished() {
        return this.gameLoadFinished;
    }

    private Runnable buildInitialScreens(@Nullable GameLoadCookie p_299894_) {
        ArrayList<Function<Runnable, Screen>> $$1 = new ArrayList<Function<Runnable, Screen>>();
        this.addInitialScreens($$1);
        Runnable $$2 = () -> {
            if (p_299894_ != null && p_299894_.quickPlayData().isEnabled()) {
                QuickPlay.connect(this, p_299894_.quickPlayData(), p_299894_.realmsClient());
            } else {
                this.setScreen(new TitleScreen(true));
            }
        };
        for (Function $$3 : Lists.reverse($$1)) {
            Screen $$4 = (Screen)$$3.apply($$2);
            $$2 = () -> this.setScreen($$4);
        }
        return $$2;
    }

    private void addInitialScreens(List<Function<Runnable, Screen>> p_300000_) {
        ProfileResult $$2;
        if (this.options.onboardAccessibility) {
            p_300000_.add(p_299781_ -> new AccessibilityOnboardingScreen(this.options, (Runnable)p_299781_));
        }
        BanDetails $$1 = this.multiplayerBan();
        if ($$1 != null) {
            p_300000_.add(p_299775_ -> BanNoticeScreens.create(p_351634_ -> {
                if (p_351634_) {
                    Util.getPlatform().openUri(CommonLinks.SUSPENSION_HELP);
                }
                p_299775_.run();
            }, $$1));
        }
        if (($$2 = this.profileFuture.join()) != null) {
            GameProfile $$3 = $$2.profile();
            Set $$4 = $$2.actions();
            if ($$4.contains(ProfileActionType.FORCED_NAME_CHANGE)) {
                p_300000_.add(p_299783_ -> BanNoticeScreens.createNameBan($$3.getName(), p_299783_));
            }
            if ($$4.contains(ProfileActionType.USING_BANNED_SKIN)) {
                p_300000_.add(BanNoticeScreens::createSkinBan);
            }
        }
    }

    private static boolean countryEqualsISO3(Object p_210783_) {
        try {
            return Locale.getDefault().getISO3Country().equals(p_210783_);
        }
        catch (MissingResourceException $$1) {
            return false;
        }
    }

    public void updateTitle() {
        this.window.setTitle(this.createTitle());
    }

    private String createTitle() {
        StringBuilder $$0 = new StringBuilder("Minecraft");
        if (Minecraft.checkModStatus().shouldReportAsModified()) {
            $$0.append("*");
        }
        $$0.append(" ");
        $$0.append(SharedConstants.getCurrentVersion().getName());
        ClientPacketListener $$1 = this.getConnection();
        if ($$1 != null && $$1.getConnection().isConnected()) {
            $$0.append(" - ");
            ServerData $$2 = this.getCurrentServer();
            if (this.singleplayerServer != null && !this.singleplayerServer.isPublished()) {
                $$0.append(I18n.get("title.singleplayer", new Object[0]));
            } else if ($$2 != null && $$2.isRealm()) {
                $$0.append(I18n.get("title.multiplayer.realms", new Object[0]));
            } else if (this.singleplayerServer != null || $$2 != null && $$2.isLan()) {
                $$0.append(I18n.get("title.multiplayer.lan", new Object[0]));
            } else {
                $$0.append(I18n.get("title.multiplayer.other", new Object[0]));
            }
        }
        return $$0.toString();
    }

    private UserApiService createUserApiService(YggdrasilAuthenticationService p_193586_, GameConfig p_193587_) {
        if (p_193587_.user.user.getType() != User.Type.MSA) {
            return UserApiService.OFFLINE;
        }
        return p_193586_.createUserApiService(p_193587_.user.user.getAccessToken());
    }

    public static ModCheck checkModStatus() {
        return ModCheck.identify("vanilla", ClientBrandRetriever::getClientModName, "Client", Minecraft.class);
    }

    private void rollbackResourcePacks(Throwable p_91240_, @Nullable GameLoadCookie p_299846_) {
        if (this.resourcePackRepository.getSelectedIds().size() > 1) {
            this.clearResourcePacksOnError(p_91240_, null, p_299846_);
        } else {
            Util.throwAsRuntime(p_91240_);
        }
    }

    public void clearResourcePacksOnError(Throwable p_91242_, @Nullable Component p_91243_, @Nullable GameLoadCookie p_299892_) {
        LOGGER.info("Caught error loading resourcepacks, removing all selected resourcepacks", p_91242_);
        this.reloadStateTracker.startRecovery(p_91242_);
        this.downloadedPackSource.onRecovery();
        this.resourcePackRepository.setSelected(Collections.emptyList());
        this.options.resourcePacks.clear();
        this.options.incompatibleResourcePacks.clear();
        this.options.save();
        this.reloadResourcePacks(true, p_299892_).thenRun(() -> this.addResourcePackLoadFailToast(p_91243_));
    }

    private void abortResourcePackRecovery() {
        this.setOverlay(null);
        if (this.level != null) {
            this.level.disconnect();
            this.disconnect();
        }
        this.setScreen(new TitleScreen());
        this.addResourcePackLoadFailToast(null);
    }

    private void addResourcePackLoadFailToast(@Nullable Component p_273566_) {
        ToastComponent $$1 = this.getToasts();
        SystemToast.addOrUpdate($$1, SystemToast.SystemToastId.PACK_LOAD_FAILURE, Component.translatable("resourcePack.load_fail"), p_273566_);
    }

    public void run() {
        this.gameThread = Thread.currentThread();
        if (Runtime.getRuntime().availableProcessors() > 4) {
            this.gameThread.setPriority(10);
        }
        try {
            boolean $$0 = false;
            while (this.running) {
                this.handleDelayedCrash();
                try {
                    SingleTickProfiler $$1 = SingleTickProfiler.createTickProfiler("Renderer");
                    boolean $$2 = this.getDebugOverlay().showProfilerChart();
                    this.profiler = this.constructProfiler($$2, $$1);
                    this.profiler.startTick();
                    this.metricsRecorder.startTick();
                    this.runTick(!$$0);
                    this.metricsRecorder.endTick();
                    this.profiler.endTick();
                    this.finishProfilers($$2, $$1);
                }
                catch (OutOfMemoryError $$3) {
                    if ($$0) {
                        throw $$3;
                    }
                    this.emergencySave();
                    this.setScreen(new OutOfMemoryScreen());
                    System.gc();
                    LOGGER.error(LogUtils.FATAL_MARKER, "Out of memory", (Throwable)$$3);
                    $$0 = true;
                }
            }
        }
        catch (ReportedException $$4) {
            LOGGER.error(LogUtils.FATAL_MARKER, "Reported exception thrown!", (Throwable)$$4);
            this.emergencySaveAndCrash($$4.getReport());
        }
        catch (Throwable $$5) {
            LOGGER.error(LogUtils.FATAL_MARKER, "Unreported exception thrown!", $$5);
            this.emergencySaveAndCrash(new CrashReport("Unexpected error", $$5));
        }
    }

    void updateFontOptions() {
        this.fontManager.updateOptions(this.options);
    }

    private void onFullscreenError(int p_91114_, long p_91115_) {
        this.options.enableVsync().set(false);
        this.options.save();
    }

    public RenderTarget getMainRenderTarget() {
        return this.mainRenderTarget;
    }

    public String getLaunchedVersion() {
        return this.launchedVersion;
    }

    public String getVersionType() {
        return this.versionType;
    }

    public void delayCrash(CrashReport p_231413_) {
        this.delayedCrash = () -> this.fillReport(p_231413_);
    }

    public void delayCrashRaw(CrashReport p_231440_) {
        this.delayedCrash = () -> p_231440_;
    }

    private void handleDelayedCrash() {
        if (this.delayedCrash != null) {
            Minecraft.crash(this, this.gameDirectory, this.delayedCrash.get());
        }
    }

    public void emergencySaveAndCrash(CrashReport p_307515_) {
        CrashReport $$1 = this.fillReport(p_307515_);
        this.emergencySave();
        Minecraft.crash(this, this.gameDirectory, $$1);
    }

    public static void crash(@Nullable Minecraft p_307414_, File p_307228_, CrashReport p_91333_) {
        Path $$3 = p_307228_.toPath().resolve("crash-reports");
        Path $$4 = $$3.resolve("crash-" + Util.getFilenameFormattedDateTime() + "-client.txt");
        Bootstrap.realStdoutPrintln(p_91333_.getFriendlyReport(ReportType.CRASH));
        if (p_307414_ != null) {
            p_307414_.soundManager.emergencyShutdown();
        }
        if (p_91333_.getSaveFile() != null) {
            Bootstrap.realStdoutPrintln("#@!@# Game crashed! Crash report saved to: #@!@# " + String.valueOf(p_91333_.getSaveFile().toAbsolutePath()));
            System.exit(-1);
        } else if (p_91333_.saveToFile($$4, ReportType.CRASH)) {
            Bootstrap.realStdoutPrintln("#@!@# Game crashed! Crash report saved to: #@!@# " + String.valueOf($$4.toAbsolutePath()));
            System.exit(-1);
        } else {
            Bootstrap.realStdoutPrintln("#@?@# Game crashed! Crash report could not be saved. #@?@#");
            System.exit(-2);
        }
    }

    public boolean isEnforceUnicode() {
        return this.options.forceUnicodeFont().get();
    }

    public CompletableFuture<Void> reloadResourcePacks() {
        return this.reloadResourcePacks(false, null);
    }

    private CompletableFuture<Void> reloadResourcePacks(boolean p_168020_, @Nullable GameLoadCookie p_299856_) {
        if (this.pendingReload != null) {
            return this.pendingReload;
        }
        CompletableFuture<Void> $$2 = new CompletableFuture<Void>();
        if (!p_168020_ && this.overlay instanceof LoadingOverlay) {
            this.pendingReload = $$2;
            return $$2;
        }
        this.resourcePackRepository.reload();
        List<PackResources> $$3 = this.resourcePackRepository.openAllSelected();
        if (!p_168020_) {
            this.reloadStateTracker.startReload(ResourceLoadStateTracker.ReloadReason.MANUAL, $$3);
        }
        this.setOverlay(new LoadingOverlay(this, this.resourceManager.createReload(Util.backgroundExecutor(), this, RESOURCE_RELOAD_INITIAL_TASK, $$3), p_299767_ -> Util.ifElse(p_299767_, p_314392_ -> {
            if (p_168020_) {
                this.downloadedPackSource.onRecoveryFailure();
                this.abortResourcePackRecovery();
            } else {
                this.rollbackResourcePacks((Throwable)p_314392_, p_299856_);
            }
        }, () -> {
            this.levelRenderer.allChanged();
            this.reloadStateTracker.finishReload();
            this.downloadedPackSource.onReloadSuccess();
            $$2.complete(null);
            this.onResourceLoadFinished(p_299856_);
        }), !p_168020_));
        return $$2;
    }

    private void selfTest() {
        boolean $$0 = false;
        BlockModelShaper $$1 = this.getBlockRenderer().getBlockModelShaper();
        BakedModel $$2 = $$1.getModelManager().getMissingModel();
        for (Block $$3 : BuiltInRegistries.BLOCK) {
            for (BlockState $$4 : $$3.getStateDefinition().getPossibleStates()) {
                BakedModel $$5;
                if ($$4.getRenderShape() != RenderShape.MODEL || ($$5 = $$1.getBlockModel($$4)) != $$2) continue;
                LOGGER.debug("Missing model for: {}", (Object)$$4);
                $$0 = true;
            }
        }
        TextureAtlasSprite $$6 = $$2.getParticleIcon();
        for (Block $$7 : BuiltInRegistries.BLOCK) {
            for (BlockState $$8 : $$7.getStateDefinition().getPossibleStates()) {
                TextureAtlasSprite $$9 = $$1.getParticleIcon($$8);
                if ($$8.isAir() || $$9 != $$6) continue;
                LOGGER.debug("Missing particle icon for: {}", (Object)$$8);
            }
        }
        for (Item $$10 : BuiltInRegistries.ITEM) {
            ItemStack $$11 = $$10.getDefaultInstance();
            String $$12 = $$11.getDescriptionId();
            String $$13 = Component.translatable($$12).getString();
            if (!$$13.toLowerCase(Locale.ROOT).equals($$10.getDescriptionId())) continue;
            LOGGER.debug("Missing translation for: {} {} {}", new Object[]{$$11, $$12, $$10});
        }
        $$0 |= MenuScreens.selfTest();
        if ($$0 |= EntityRenderers.validateRegistrations()) {
            throw new IllegalStateException("Your game data is foobar, fix the errors above!");
        }
    }

    public LevelStorageSource getLevelSource() {
        return this.levelSource;
    }

    private void openChatScreen(String p_91327_) {
        ChatStatus $$1 = this.getChatStatus();
        if (!$$1.isChatAllowed(this.isLocalServer())) {
            if (this.gui.isShowingChatDisabledByPlayer()) {
                this.gui.setChatDisabledByPlayerShown(false);
                this.setScreen(new ConfirmLinkScreen(p_351635_ -> {
                    if (p_351635_) {
                        Util.getPlatform().openUri(CommonLinks.ACCOUNT_SETTINGS);
                    }
                    this.setScreen(null);
                }, ChatStatus.INFO_DISABLED_BY_PROFILE, CommonLinks.ACCOUNT_SETTINGS, true));
            } else {
                Component $$2 = $$1.getMessage();
                this.gui.setOverlayMessage($$2, false);
                this.narrator.sayNow($$2);
                this.gui.setChatDisabledByPlayerShown($$1 == ChatStatus.DISABLED_BY_PROFILE);
            }
        } else {
            this.setScreen(new ChatScreen(p_91327_));
        }
    }

    public void setScreen(@Nullable Screen p_91153_) {
        if (SharedConstants.IS_RUNNING_IN_IDE && Thread.currentThread() != this.gameThread) {
            LOGGER.error("setScreen called from non-game thread");
        }
        if (this.screen != null) {
            this.screen.removed();
        } else {
            this.setLastInputType(InputType.NONE);
        }
        if (p_91153_ == null && this.clientLevelTeardownInProgress) {
            throw new IllegalStateException("Trying to return to in-game GUI during disconnection");
        }
        if (p_91153_ == null && this.level == null) {
            p_91153_ = new TitleScreen();
        } else if (p_91153_ == null && this.player.isDeadOrDying()) {
            if (this.player.shouldShowDeathScreen()) {
                p_91153_ = new DeathScreen(null, this.level.getLevelData().isHardcore());
            } else {
                this.player.respawn();
            }
        }
        this.screen = p_91153_;
        if (this.screen != null) {
            this.screen.added();
        }
        BufferUploader.reset();
        if (p_91153_ != null) {
            this.mouseHandler.releaseMouse();
            KeyMapping.releaseAll();
            p_91153_.init(this, this.window.getGuiScaledWidth(), this.window.getGuiScaledHeight());
            this.noRender = false;
        } else {
            this.soundManager.resume();
            this.mouseHandler.grabMouse();
        }
        this.updateTitle();
    }

    public void setOverlay(@Nullable Overlay p_91151_) {
        this.overlay = p_91151_;
    }

    public void destroy() {
        try {
            LOGGER.info("Stopping!");
            try {
                this.narrator.destroy();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            try {
                if (this.level != null) {
                    this.level.disconnect();
                }
                this.disconnect();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            if (this.screen != null) {
                this.screen.removed();
            }
            this.close();
        }
        finally {
            Util.timeSource = System::nanoTime;
            if (this.delayedCrash == null) {
                System.exit(0);
            }
        }
    }

    @Override
    public void close() {
        if (this.currentFrameProfile != null) {
            this.currentFrameProfile.cancel();
        }
        try {
            this.telemetryManager.close();
            this.regionalCompliancies.close();
            this.modelManager.close();
            this.fontManager.close();
            this.gameRenderer.close();
            this.levelRenderer.close();
            this.soundManager.destroy();
            this.particleEngine.close();
            this.mobEffectTextures.close();
            this.paintingTextures.close();
            this.mapDecorationTextures.close();
            this.guiSprites.close();
            this.textureManager.close();
            this.resourceManager.close();
            FreeTypeUtil.destroy();
            Util.shutdownExecutors();
        }
        catch (Throwable $$0) {
            LOGGER.error("Shutdown failure!", $$0);
            throw $$0;
        }
        finally {
            this.virtualScreen.close();
            this.window.close();
        }
    }

    private void runTick(boolean p_91384_) {
        boolean $$7;
        Runnable $$2;
        this.window.setErrorSection("Pre render");
        if (this.window.shouldClose()) {
            this.stop();
        }
        if (this.pendingReload != null && !(this.overlay instanceof LoadingOverlay)) {
            CompletableFuture<Void> $$1 = this.pendingReload;
            this.pendingReload = null;
            this.reloadResourcePacks().thenRun(() -> $$1.complete(null));
        }
        while (($$2 = this.progressTasks.poll()) != null) {
            $$2.run();
        }
        int $$3 = this.timer.advanceTime(Util.getMillis(), p_91384_);
        if (p_91384_) {
            this.profiler.push("scheduledExecutables");
            this.runAllTasks();
            this.profiler.pop();
            this.profiler.push("tick");
            for (int $$4 = 0; $$4 < Math.min(10, $$3); ++$$4) {
                this.profiler.incrementCounter("clientTick");
                this.tick();
            }
            this.profiler.pop();
        }
        this.window.setErrorSection("Render");
        this.profiler.push("sound");
        this.soundManager.updateSource(this.gameRenderer.getMainCamera());
        this.profiler.pop();
        this.profiler.push("render");
        long $$5 = Util.getNanos();
        if (this.getDebugOverlay().showDebugScreen() || this.metricsRecorder.isRecording()) {
            boolean $$6;
            boolean bl = $$6 = this.currentFrameProfile == null || this.currentFrameProfile.isDone();
            if ($$6) {
                TimerQuery.getInstance().ifPresent(TimerQuery::beginProfile);
            }
        } else {
            $$7 = false;
            this.gpuUtilization = 0.0;
        }
        RenderSystem.clear(16640, ON_OSX);
        this.mainRenderTarget.bindWrite(true);
        FogRenderer.setupNoFog();
        this.profiler.push("display");
        RenderSystem.enableCull();
        this.profiler.popPush("mouse");
        this.mouseHandler.handleAccumulatedMovement();
        this.profiler.pop();
        if (!this.noRender) {
            this.profiler.popPush("gameRenderer");
            this.gameRenderer.render(this.timer, p_91384_);
            this.profiler.pop();
        }
        if (this.fpsPieResults != null) {
            this.profiler.push("fpsPie");
            GuiGraphics $$8 = new GuiGraphics(this, this.renderBuffers.bufferSource());
            this.renderFpsMeter($$8, this.fpsPieResults);
            $$8.flush();
            this.profiler.pop();
        }
        this.profiler.push("blit");
        this.mainRenderTarget.unbindWrite();
        this.mainRenderTarget.blitToScreen(this.window.getWidth(), this.window.getHeight());
        this.frameTimeNs = Util.getNanos() - $$5;
        if ($$7) {
            TimerQuery.getInstance().ifPresent(p_231363_ -> {
                this.currentFrameProfile = p_231363_.endProfile();
            });
        }
        this.profiler.popPush("updateDisplay");
        this.window.updateDisplay();
        int $$9 = this.getFramerateLimit();
        if ($$9 < 260) {
            RenderSystem.limitDisplayFPS($$9);
        }
        this.profiler.popPush("yield");
        Thread.yield();
        this.profiler.pop();
        this.window.setErrorSection("Post render");
        ++this.frames;
        this.pause = this.hasSingleplayerServer() && (this.screen != null && this.screen.isPauseScreen() || this.overlay != null && this.overlay.isPauseScreen()) && !this.singleplayerServer.isPublished();
        this.timer.updatePauseState(this.pause);
        this.timer.updateFrozenState(!this.isLevelRunningNormally());
        long $$10 = Util.getNanos();
        long $$11 = $$10 - this.lastNanoTime;
        if ($$7) {
            this.savedCpuDuration = $$11;
        }
        this.getDebugOverlay().logFrameDuration($$11);
        this.lastNanoTime = $$10;
        this.profiler.push("fpsUpdate");
        if (this.currentFrameProfile != null && this.currentFrameProfile.isDone()) {
            this.gpuUtilization = (double)this.currentFrameProfile.get() * 100.0 / (double)this.savedCpuDuration;
        }
        while (Util.getMillis() >= this.lastTime + 1000L) {
            String $$13;
            if (this.gpuUtilization > 0.0) {
                String $$12 = " GPU: " + (this.gpuUtilization > 100.0 ? String.valueOf(ChatFormatting.RED) + "100%" : Math.round(this.gpuUtilization) + "%");
            } else {
                $$13 = "";
            }
            fps = this.frames;
            this.fpsString = String.format(Locale.ROOT, "%d fps T: %s%s%s%s B: %d%s", fps, $$9 == 260 ? "inf" : Integer.valueOf($$9), this.options.enableVsync().get() != false ? " vsync " : " ", this.options.graphicsMode().get(), this.options.cloudStatus().get() == CloudStatus.OFF ? "" : (this.options.cloudStatus().get() == CloudStatus.FAST ? " fast-clouds" : " fancy-clouds"), this.options.biomeBlendRadius().get(), $$13);
            this.lastTime += 1000L;
            this.frames = 0;
        }
        this.profiler.pop();
    }

    private ProfilerFiller constructProfiler(boolean p_167971_, @Nullable SingleTickProfiler p_167972_) {
        ProfilerFiller $$3;
        if (!p_167971_) {
            this.fpsPieProfiler.disable();
            if (!this.metricsRecorder.isRecording() && p_167972_ == null) {
                return InactiveProfiler.INSTANCE;
            }
        }
        if (p_167971_) {
            if (!this.fpsPieProfiler.isEnabled()) {
                this.fpsPieRenderTicks = 0;
                this.fpsPieProfiler.enable();
            }
            ++this.fpsPieRenderTicks;
            ProfilerFiller $$2 = this.fpsPieProfiler.getFiller();
        } else {
            $$3 = InactiveProfiler.INSTANCE;
        }
        if (this.metricsRecorder.isRecording()) {
            $$3 = ProfilerFiller.tee($$3, this.metricsRecorder.getProfiler());
        }
        return SingleTickProfiler.decorateFiller($$3, p_167972_);
    }

    private void finishProfilers(boolean p_91339_, @Nullable SingleTickProfiler p_91340_) {
        if (p_91340_ != null) {
            p_91340_.endTick();
        }
        this.fpsPieResults = p_91339_ ? this.fpsPieProfiler.getResults() : null;
        this.profiler = this.fpsPieProfiler.getFiller();
    }

    @Override
    public void resizeDisplay() {
        int $$0 = this.window.calculateScale(this.options.guiScale().get(), this.isEnforceUnicode());
        this.window.setGuiScale($$0);
        if (this.screen != null) {
            this.screen.resize(this, this.window.getGuiScaledWidth(), this.window.getGuiScaledHeight());
        }
        RenderTarget $$1 = this.getMainRenderTarget();
        $$1.resize(this.window.getWidth(), this.window.getHeight(), ON_OSX);
        this.gameRenderer.resize(this.window.getWidth(), this.window.getHeight());
        this.mouseHandler.setIgnoreFirstMove();
    }

    @Override
    public void cursorEntered() {
        this.mouseHandler.cursorEntered();
    }

    public int getFps() {
        return fps;
    }

    public long getFrameTimeNs() {
        return this.frameTimeNs;
    }

    private int getFramerateLimit() {
        if (this.level == null && (this.screen != null || this.overlay != null)) {
            return 60;
        }
        return this.window.getFramerateLimit();
    }

    private void emergencySave() {
        try {
            MemoryReserve.release();
            this.levelRenderer.clear();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        try {
            System.gc();
            if (this.isLocalServer && this.singleplayerServer != null) {
                this.singleplayerServer.halt(true);
            }
            this.disconnect(new GenericMessageScreen(Component.translatable("menu.savingLevel")));
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        System.gc();
    }

    public boolean debugClientMetricsStart(Consumer<Component> p_167947_) {
        Consumer<Path> $$8;
        if (this.metricsRecorder.isRecording()) {
            this.debugClientMetricsStop();
            return false;
        }
        Consumer<ProfileResults> $$1 = p_231435_ -> {
            if (p_231435_ == EmptyProfileResults.EMPTY) {
                return;
            }
            int $$2 = p_231435_.getTickDuration();
            double $$3 = (double)p_231435_.getNanoDuration() / (double)TimeUtil.NANOSECONDS_PER_SECOND;
            this.execute(() -> p_167947_.accept(Component.translatable("commands.debug.stopped", String.format(Locale.ROOT, "%.2f", $$3), $$2, String.format(Locale.ROOT, "%.2f", (double)$$2 / $$3))));
        };
        Consumer<Path> $$2 = p_231438_ -> {
            MutableComponent $$2 = Component.literal(p_231438_.toString()).withStyle(ChatFormatting.UNDERLINE).withStyle(p_231387_ -> p_231387_.withClickEvent(new ClickEvent(ClickEvent.Action.OPEN_FILE, p_231438_.toFile().getParent())));
            this.execute(() -> p_167947_.accept(Component.translatable("debug.profiling.stop", $$2)));
        };
        SystemReport $$3 = Minecraft.fillSystemReport(new SystemReport(), this, this.languageManager, this.launchedVersion, this.options);
        Consumer<List> $$4 = p_231349_ -> {
            Path $$3 = this.archiveProfilingReport($$3, (List<Path>)p_231349_);
            $$2.accept($$3);
        };
        if (this.singleplayerServer == null) {
            Consumer<Path> $$5 = p_231404_ -> $$4.accept((List)ImmutableList.of((Object)p_231404_));
        } else {
            this.singleplayerServer.fillSystemReport($$3);
            CompletableFuture $$6 = new CompletableFuture();
            CompletableFuture $$7 = new CompletableFuture();
            CompletableFuture.allOf($$6, $$7).thenRunAsync(() -> $$4.accept((List)ImmutableList.of((Object)((Path)$$6.join()), (Object)((Path)$$7.join()))), Util.ioPool());
            this.singleplayerServer.startRecordingMetrics(p_231351_ -> {}, $$7::complete);
            $$8 = $$6::complete;
        }
        this.metricsRecorder = ActiveMetricsRecorder.createStarted(new ClientMetricsSamplersProvider(Util.timeSource, this.levelRenderer), Util.timeSource, Util.ioPool(), new MetricsPersister("client"), p_231401_ -> {
            this.metricsRecorder = InactiveMetricsRecorder.INSTANCE;
            $$1.accept((ProfileResults)p_231401_);
        }, $$8);
        return true;
    }

    private void debugClientMetricsStop() {
        this.metricsRecorder.end();
        if (this.singleplayerServer != null) {
            this.singleplayerServer.finishRecordingMetrics();
        }
    }

    private void debugClientMetricsCancel() {
        this.metricsRecorder.cancel();
        if (this.singleplayerServer != null) {
            this.singleplayerServer.cancelRecordingMetrics();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private Path archiveProfilingReport(SystemReport p_167857_, List<Path> p_167858_) {
        void $$9;
        String $$4;
        if (this.isLocalServer()) {
            String $$2 = this.getSingleplayerServer().getWorldData().getLevelName();
        } else {
            ServerData $$3 = this.getCurrentServer();
            $$4 = $$3 != null ? $$3.name : "unknown";
        }
        try {
            String $$5 = String.format(Locale.ROOT, "%s-%s-%s", Util.getFilenameFormattedDateTime(), $$4, SharedConstants.getCurrentVersion().getId());
            String $$6 = FileUtil.findAvailableName(MetricsPersister.PROFILING_RESULTS_DIR, $$5, ".zip");
            Path $$7 = MetricsPersister.PROFILING_RESULTS_DIR.resolve($$6);
        }
        catch (IOException $$8) {
            throw new UncheckedIOException($$8);
        }
        try (FileZipper $$10 = new FileZipper((Path)$$9);){
            $$10.add(Paths.get("system.txt", new String[0]), p_167857_.toLineSeparatedString());
            $$10.add(Paths.get("client", new String[0]).resolve(this.options.getFile().getName()), this.options.dumpOptionsForReport());
            p_167858_.forEach($$10::add);
        }
        finally {
            for (Path $$11 : p_167858_) {
                try {
                    FileUtils.forceDelete((File)$$11.toFile());
                }
                catch (IOException $$12) {
                    LOGGER.warn("Failed to delete temporary profiling result {}", (Object)$$11, (Object)$$12);
                }
            }
        }
        return $$9;
    }

    public void debugFpsMeterKeyPress(int p_91112_) {
        if (this.fpsPieResults == null) {
            return;
        }
        List<ResultField> $$1 = this.fpsPieResults.getTimes(this.debugPath);
        if ($$1.isEmpty()) {
            return;
        }
        ResultField $$2 = $$1.remove(0);
        if (p_91112_ == 0) {
            int $$3;
            if (!$$2.name.isEmpty() && ($$3 = this.debugPath.lastIndexOf(30)) >= 0) {
                this.debugPath = this.debugPath.substring(0, $$3);
            }
        } else if (--p_91112_ < $$1.size() && !"unspecified".equals($$1.get((int)p_91112_).name)) {
            if (!this.debugPath.isEmpty()) {
                this.debugPath = this.debugPath + "\u001e";
            }
            this.debugPath = this.debugPath + $$1.get((int)p_91112_).name;
        }
    }

    private void renderFpsMeter(GuiGraphics p_281277_, ProfileResults p_281574_) {
        List<ResultField> $$2 = p_281574_.getTimes(this.debugPath);
        ResultField $$3 = $$2.removeFirst();
        RenderSystem.clear(256, ON_OSX);
        RenderSystem.setShader(GameRenderer::getPositionColorShader);
        Matrix4f $$4 = new Matrix4f().setOrtho(0.0f, (float)this.window.getWidth(), (float)this.window.getHeight(), 0.0f, 1000.0f, 3000.0f);
        RenderSystem.setProjectionMatrix($$4, VertexSorting.ORTHOGRAPHIC_Z);
        Tesselator $$5 = Tesselator.getInstance();
        Matrix4fStack $$6 = RenderSystem.getModelViewStack();
        $$6.pushMatrix();
        $$6.translation(0.0f, 0.0f, -2000.0f);
        RenderSystem.applyModelViewMatrix();
        int $$7 = 160;
        int $$8 = this.window.getWidth() - 160 - 10;
        int $$9 = this.window.getHeight() - 320;
        double $$10 = 0.0;
        for (ResultField $$11 : $$2) {
            int $$12 = Mth.floor($$11.percentage / 4.0) + 1;
            BufferBuilder $$13 = $$5.begin(VertexFormat.Mode.TRIANGLE_FAN, DefaultVertexFormat.POSITION_COLOR);
            int $$14 = FastColor.ARGB32.opaque($$11.getColor());
            int $$15 = FastColor.ARGB32.multiply($$14, -8355712);
            $$13.addVertex($$8, $$9, 0.0f).setColor($$14);
            for (int $$16 = $$12; $$16 >= 0; --$$16) {
                float $$17 = (float)(($$10 + $$11.percentage * (double)$$16 / (double)$$12) * 6.2831854820251465 / 100.0);
                float $$18 = Mth.sin($$17) * 160.0f;
                float $$19 = Mth.cos($$17) * 160.0f * 0.5f;
                $$13.addVertex((float)$$8 + $$18, (float)$$9 - $$19, 0.0f).setColor($$14);
            }
            BufferUploader.drawWithShader($$13.buildOrThrow());
            $$13 = $$5.begin(VertexFormat.Mode.TRIANGLE_STRIP, DefaultVertexFormat.POSITION_COLOR);
            for (int $$20 = $$12; $$20 >= 0; --$$20) {
                float $$21 = (float)(($$10 + $$11.percentage * (double)$$20 / (double)$$12) * 6.2831854820251465 / 100.0);
                float $$22 = Mth.sin($$21) * 160.0f;
                float $$23 = Mth.cos($$21) * 160.0f * 0.5f;
                if ($$23 > 0.0f) continue;
                $$13.addVertex((float)$$8 + $$22, (float)$$9 - $$23, 0.0f).setColor($$15);
                $$13.addVertex((float)$$8 + $$22, (float)$$9 - $$23 + 10.0f, 0.0f).setColor($$15);
            }
            MeshData $$24 = $$13.build();
            if ($$24 != null) {
                BufferUploader.drawWithShader($$24);
            }
            $$10 += $$11.percentage;
        }
        DecimalFormat $$25 = new DecimalFormat("##0.00");
        $$25.setDecimalFormatSymbols(DecimalFormatSymbols.getInstance(Locale.ROOT));
        String $$26 = ProfileResults.demanglePath($$3.name);
        Object $$27 = "";
        if (!"unspecified".equals($$26)) {
            $$27 = (String)$$27 + "[0] ";
        }
        $$27 = $$26.isEmpty() ? (String)$$27 + "ROOT " : (String)$$27 + $$26 + " ";
        int $$28 = 0xFFFFFF;
        p_281277_.drawString(this.font, (String)$$27, $$8 - 160, $$9 - 80 - 16, 0xFFFFFF);
        $$27 = $$25.format($$3.globalPercentage) + "%";
        p_281277_.drawString(this.font, (String)$$27, $$8 + 160 - this.font.width((String)$$27), $$9 - 80 - 16, 0xFFFFFF);
        for (int $$29 = 0; $$29 < $$2.size(); ++$$29) {
            ResultField $$30 = $$2.get($$29);
            StringBuilder $$31 = new StringBuilder();
            if ("unspecified".equals($$30.name)) {
                $$31.append("[?] ");
            } else {
                $$31.append("[").append($$29 + 1).append("] ");
            }
            Object $$32 = $$31.append($$30.name).toString();
            p_281277_.drawString(this.font, (String)$$32, $$8 - 160, $$9 + 80 + $$29 * 8 + 20, $$30.getColor());
            $$32 = $$25.format($$30.percentage) + "%";
            p_281277_.drawString(this.font, (String)$$32, $$8 + 160 - 50 - this.font.width((String)$$32), $$9 + 80 + $$29 * 8 + 20, $$30.getColor());
            $$32 = $$25.format($$30.globalPercentage) + "%";
            p_281277_.drawString(this.font, (String)$$32, $$8 + 160 - this.font.width((String)$$32), $$9 + 80 + $$29 * 8 + 20, $$30.getColor());
        }
        $$6.popMatrix();
        RenderSystem.applyModelViewMatrix();
    }

    public void stop() {
        this.running = false;
    }

    public boolean isRunning() {
        return this.running;
    }

    public void pauseGame(boolean p_91359_) {
        boolean $$1;
        if (this.screen != null) {
            return;
        }
        boolean bl = $$1 = this.hasSingleplayerServer() && !this.singleplayerServer.isPublished();
        if ($$1) {
            this.setScreen(new PauseScreen(!p_91359_));
            this.soundManager.pause();
        } else {
            this.setScreen(new PauseScreen(true));
        }
    }

    private void continueAttack(boolean p_91387_) {
        if (!p_91387_) {
            this.missTime = 0;
        }
        if (this.missTime > 0 || this.player.isUsingItem()) {
            return;
        }
        if (p_91387_ && this.hitResult != null && this.hitResult.getType() == HitResult.Type.BLOCK) {
            Direction $$3;
            BlockHitResult $$1 = (BlockHitResult)this.hitResult;
            BlockPos $$2 = $$1.getBlockPos();
            if (!this.level.getBlockState($$2).isAir() && this.gameMode.continueDestroyBlock($$2, $$3 = $$1.getDirection())) {
                this.particleEngine.crack($$2, $$3);
                this.player.swing(InteractionHand.MAIN_HAND);
            }
            return;
        }
        this.gameMode.stopDestroyBlock();
    }

    private boolean startAttack() {
        if (this.missTime > 0) {
            return false;
        }
        if (this.hitResult == null) {
            LOGGER.error("Null returned as 'hitResult', this shouldn't happen!");
            if (this.gameMode.hasMissTime()) {
                this.missTime = 10;
            }
            return false;
        }
        if (this.player.isHandsBusy()) {
            return false;
        }
        ItemStack $$0 = this.player.getItemInHand(InteractionHand.MAIN_HAND);
        if (!$$0.isItemEnabled(this.level.enabledFeatures())) {
            return false;
        }
        boolean $$1 = false;
        switch (this.hitResult.getType()) {
            case ENTITY: {
                this.gameMode.attack(this.player, ((EntityHitResult)this.hitResult).getEntity());
                break;
            }
            case BLOCK: {
                BlockHitResult $$2 = (BlockHitResult)this.hitResult;
                BlockPos $$3 = $$2.getBlockPos();
                if (!this.level.getBlockState($$3).isAir()) {
                    this.gameMode.startDestroyBlock($$3, $$2.getDirection());
                    if (!this.level.getBlockState($$3).isAir()) break;
                    $$1 = true;
                    break;
                }
            }
            case MISS: {
                if (this.gameMode.hasMissTime()) {
                    this.missTime = 10;
                }
                this.player.resetAttackStrengthTicker();
            }
        }
        this.player.swing(InteractionHand.MAIN_HAND);
        return $$1;
    }

    private void startUseItem() {
        if (this.gameMode.isDestroying()) {
            return;
        }
        this.rightClickDelay = 4;
        if (this.player.isHandsBusy()) {
            return;
        }
        if (this.hitResult == null) {
            LOGGER.warn("Null returned as 'hitResult', this shouldn't happen!");
        }
        for (InteractionHand $$0 : InteractionHand.values()) {
            InteractionResult $$8;
            ItemStack $$1 = this.player.getItemInHand($$0);
            if (!$$1.isItemEnabled(this.level.enabledFeatures())) {
                return;
            }
            if (this.hitResult != null) {
                switch (this.hitResult.getType()) {
                    case ENTITY: {
                        EntityHitResult $$2 = (EntityHitResult)this.hitResult;
                        Entity $$3 = $$2.getEntity();
                        if (!this.level.getWorldBorder().isWithinBounds($$3.blockPosition())) {
                            return;
                        }
                        InteractionResult $$4 = this.gameMode.interactAt(this.player, $$3, $$2, $$0);
                        if (!$$4.consumesAction()) {
                            $$4 = this.gameMode.interact(this.player, $$3, $$0);
                        }
                        if (!$$4.consumesAction()) break;
                        if ($$4.shouldSwing()) {
                            this.player.swing($$0);
                        }
                        return;
                    }
                    case BLOCK: {
                        BlockHitResult $$5 = (BlockHitResult)this.hitResult;
                        int $$6 = $$1.getCount();
                        InteractionResult $$7 = this.gameMode.useItemOn(this.player, $$0, $$5);
                        if ($$7.consumesAction()) {
                            if ($$7.shouldSwing()) {
                                this.player.swing($$0);
                                if (!$$1.isEmpty() && ($$1.getCount() != $$6 || this.gameMode.hasInfiniteItems())) {
                                    this.gameRenderer.itemInHandRenderer.itemUsed($$0);
                                }
                            }
                            return;
                        }
                        if ($$7 != InteractionResult.FAIL) break;
                        return;
                    }
                }
            }
            if ($$1.isEmpty() || !($$8 = this.gameMode.useItem(this.player, $$0)).consumesAction()) continue;
            if ($$8.shouldSwing()) {
                this.player.swing($$0);
            }
            this.gameRenderer.itemInHandRenderer.itemUsed($$0);
            return;
        }
    }

    public MusicManager getMusicManager() {
        return this.musicManager;
    }

    public void tick() {
        ++this.clientTickCount;
        if (this.level != null && !this.pause) {
            this.level.tickRateManager().tick();
        }
        if (this.rightClickDelay > 0) {
            --this.rightClickDelay;
        }
        this.profiler.push("gui");
        this.chatListener.tick();
        this.gui.tick(this.pause);
        this.profiler.pop();
        this.gameRenderer.pick(1.0f);
        this.tutorial.onLookAt(this.level, this.hitResult);
        this.profiler.push("gameMode");
        if (!this.pause && this.level != null) {
            this.gameMode.tick();
        }
        this.profiler.popPush("textures");
        if (this.isLevelRunningNormally()) {
            this.textureManager.tick();
        }
        if (this.screen == null && this.player != null) {
            if (this.player.isDeadOrDying() && !(this.screen instanceof DeathScreen)) {
                this.setScreen(null);
            } else if (this.player.isSleeping() && this.level != null) {
                this.setScreen(new InBedChatScreen());
            }
        } else {
            Screen screen = this.screen;
            if (screen instanceof InBedChatScreen) {
                InBedChatScreen $$0 = (InBedChatScreen)screen;
                if (!this.player.isSleeping()) {
                    $$0.onPlayerWokeUp();
                }
            }
        }
        if (this.screen != null) {
            this.missTime = 10000;
        }
        if (this.screen != null) {
            Screen.wrapScreenError(() -> this.screen.tick(), "Ticking screen", this.screen.getClass().getCanonicalName());
        }
        if (!this.getDebugOverlay().showDebugScreen()) {
            this.gui.clearCache();
        }
        if (this.overlay == null && this.screen == null) {
            this.profiler.popPush("Keybindings");
            this.handleKeybinds();
            if (this.missTime > 0) {
                --this.missTime;
            }
        }
        if (this.level != null) {
            this.profiler.popPush("gameRenderer");
            if (!this.pause) {
                this.gameRenderer.tick();
            }
            this.profiler.popPush("levelRenderer");
            if (!this.pause) {
                this.levelRenderer.tick();
            }
            this.profiler.popPush("level");
            if (!this.pause) {
                this.level.tickEntities();
            }
        } else if (this.gameRenderer.currentEffect() != null) {
            this.gameRenderer.shutdownEffect();
        }
        if (!this.pause) {
            this.musicManager.tick();
        }
        this.soundManager.tick(this.pause);
        if (this.level != null) {
            if (!this.pause) {
                if (!this.options.joinedFirstServer && this.isMultiplayerServer()) {
                    MutableComponent $$1 = Component.translatable("tutorial.socialInteractions.title");
                    MutableComponent $$2 = Component.translatable("tutorial.socialInteractions.description", Tutorial.key("socialInteractions"));
                    this.socialInteractionsToast = new TutorialToast(TutorialToast.Icons.SOCIAL_INTERACTIONS, $$1, $$2, true);
                    this.tutorial.addTimedToast(this.socialInteractionsToast, 160);
                    this.options.joinedFirstServer = true;
                    this.options.save();
                }
                this.tutorial.tick();
                try {
                    this.level.tick(() -> true);
                }
                catch (Throwable $$3) {
                    CrashReport $$4 = CrashReport.forThrowable($$3, "Exception in world tick");
                    if (this.level == null) {
                        CrashReportCategory $$5 = $$4.addCategory("Affected level");
                        $$5.setDetail("Problem", "Level is null!");
                    } else {
                        this.level.fillReportDetails($$4);
                    }
                    throw new ReportedException($$4);
                }
            }
            this.profiler.popPush("animateTick");
            if (!this.pause && this.isLevelRunningNormally()) {
                this.level.animateTick(this.player.getBlockX(), this.player.getBlockY(), this.player.getBlockZ());
            }
            this.profiler.popPush("particles");
            if (!this.pause && this.isLevelRunningNormally()) {
                this.particleEngine.tick();
            }
        } else if (this.pendingConnection != null) {
            this.profiler.popPush("pendingConnection");
            this.pendingConnection.tick();
        }
        this.profiler.popPush("keyboard");
        this.keyboardHandler.tick();
        this.profiler.pop();
    }

    private boolean isLevelRunningNormally() {
        return this.level == null || this.level.tickRateManager().runsNormally();
    }

    private boolean isMultiplayerServer() {
        return !this.isLocalServer || this.singleplayerServer != null && this.singleplayerServer.isPublished();
    }

    private void handleKeybinds() {
        while (this.options.keyTogglePerspective.consumeClick()) {
            CameraType $$0 = this.options.getCameraType();
            this.options.setCameraType(this.options.getCameraType().cycle());
            if ($$0.isFirstPerson() != this.options.getCameraType().isFirstPerson()) {
                this.gameRenderer.checkEntityPostEffect(this.options.getCameraType().isFirstPerson() ? this.getCameraEntity() : null);
            }
            this.levelRenderer.needsUpdate();
        }
        while (this.options.keySmoothCamera.consumeClick()) {
            this.options.smoothCamera = !this.options.smoothCamera;
        }
        for (int $$1 = 0; $$1 < 9; ++$$1) {
            boolean $$2 = this.options.keySaveHotbarActivator.isDown();
            boolean $$3 = this.options.keyLoadHotbarActivator.isDown();
            if (!this.options.keyHotbarSlots[$$1].consumeClick()) continue;
            if (this.player.isSpectator()) {
                this.gui.getSpectatorGui().onHotbarSelected($$1);
                continue;
            }
            if (this.player.isCreative() && this.screen == null && ($$3 || $$2)) {
                CreativeModeInventoryScreen.handleHotbarLoadOrSave(this, $$1, $$3, $$2);
                continue;
            }
            this.player.getInventory().selected = $$1;
        }
        while (this.options.keySocialInteractions.consumeClick()) {
            if (!this.isMultiplayerServer()) {
                this.player.displayClientMessage(SOCIAL_INTERACTIONS_NOT_AVAILABLE, true);
                this.narrator.sayNow(SOCIAL_INTERACTIONS_NOT_AVAILABLE);
                continue;
            }
            if (this.socialInteractionsToast != null) {
                this.tutorial.removeTimedToast(this.socialInteractionsToast);
                this.socialInteractionsToast = null;
            }
            this.setScreen(new SocialInteractionsScreen());
        }
        while (this.options.keyInventory.consumeClick()) {
            if (this.gameMode.isServerControlledInventory()) {
                this.player.sendOpenInventory();
                continue;
            }
            this.tutorial.onOpenInventory();
            this.setScreen(new InventoryScreen(this.player));
        }
        while (this.options.keyAdvancements.consumeClick()) {
            this.setScreen(new AdvancementsScreen(this.player.connection.getAdvancements()));
        }
        while (this.options.keySwapOffhand.consumeClick()) {
            if (this.player.isSpectator()) continue;
            this.getConnection().send(new ServerboundPlayerActionPacket(ServerboundPlayerActionPacket.Action.SWAP_ITEM_WITH_OFFHAND, BlockPos.ZERO, Direction.DOWN));
        }
        while (this.options.keyDrop.consumeClick()) {
            if (this.player.isSpectator() || !this.player.drop(Screen.hasControlDown())) continue;
            this.player.swing(InteractionHand.MAIN_HAND);
        }
        while (this.options.keyChat.consumeClick()) {
            this.openChatScreen("");
        }
        if (this.screen == null && this.overlay == null && this.options.keyCommand.consumeClick()) {
            this.openChatScreen("/");
        }
        boolean $$4 = false;
        if (this.player.isUsingItem()) {
            if (!this.options.keyUse.isDown()) {
                this.gameMode.releaseUsingItem(this.player);
            }
            while (this.options.keyAttack.consumeClick()) {
            }
            while (this.options.keyUse.consumeClick()) {
            }
            while (this.options.keyPickItem.consumeClick()) {
            }
        } else {
            while (this.options.keyAttack.consumeClick()) {
                $$4 |= this.startAttack();
            }
            while (this.options.keyUse.consumeClick()) {
                this.startUseItem();
            }
            while (this.options.keyPickItem.consumeClick()) {
                this.pickBlock();
            }
        }
        if (this.options.keyUse.isDown() && this.rightClickDelay == 0 && !this.player.isUsingItem()) {
            this.startUseItem();
        }
        this.continueAttack(this.screen == null && !$$4 && this.options.keyAttack.isDown() && this.mouseHandler.isMouseGrabbed());
    }

    public ClientTelemetryManager getTelemetryManager() {
        return this.telemetryManager;
    }

    public double getGpuUtilization() {
        return this.gpuUtilization;
    }

    public ProfileKeyPairManager getProfileKeyPairManager() {
        return this.profileKeyPairManager;
    }

    public WorldOpenFlows createWorldOpenFlows() {
        return new WorldOpenFlows(this, this.levelSource);
    }

    public void doWorldLoad(LevelStorageSource.LevelStorageAccess p_261564_, PackRepository p_261826_, WorldStem p_261470_, boolean p_261465_) {
        this.disconnect();
        this.progressListener.set(null);
        Instant $$4 = Instant.now();
        try {
            p_261564_.saveDataTag(p_261470_.registries().compositeAccess(), p_261470_.worldData());
            Services $$5 = Services.create(this.authenticationService, this.gameDirectory);
            $$5.profileCache().setExecutor(this);
            SkullBlockEntity.setup($$5, this);
            GameProfileCache.setUsesAuthentication(false);
            this.singleplayerServer = MinecraftServer.spin(p_231361_ -> new IntegratedServer((Thread)p_231361_, this, p_261564_, p_261826_, p_261470_, $$5, p_319374_ -> {
                StoringChunkProgressListener $$1 = StoringChunkProgressListener.createFromGameruleRadius(p_319374_ + 0);
                this.progressListener.set($$1);
                return ProcessorChunkProgressListener.createStarted($$1, this.progressTasks::add);
            }));
            this.isLocalServer = true;
            this.updateReportEnvironment(ReportEnvironment.local());
            this.quickPlayLog.setWorldData(QuickPlayLog.Type.SINGLEPLAYER, p_261564_.getLevelId(), p_261470_.worldData().getLevelName());
        }
        catch (Throwable $$6) {
            CrashReport $$7 = CrashReport.forThrowable($$6, "Starting integrated server");
            CrashReportCategory $$8 = $$7.addCategory("Starting integrated server");
            $$8.setDetail("Level ID", p_261564_.getLevelId());
            $$8.setDetail("Level Name", () -> p_261470_.worldData().getLevelName());
            throw new ReportedException($$7);
        }
        while (this.progressListener.get() == null) {
            Thread.yield();
        }
        LevelLoadingScreen $$9 = new LevelLoadingScreen(this.progressListener.get());
        this.setScreen($$9);
        this.profiler.push("waitForServer");
        while (!this.singleplayerServer.isReady() || this.overlay != null) {
            $$9.tick();
            this.runTick(false);
            try {
                Thread.sleep(16L);
            }
            catch (InterruptedException $$7) {
                // empty catch block
            }
            this.handleDelayedCrash();
        }
        this.profiler.pop();
        Duration $$10 = Duration.between($$4, Instant.now());
        SocketAddress $$11 = this.singleplayerServer.getConnection().startMemoryChannel();
        Connection $$12 = Connection.connectToLocalServer($$11);
        $$12.initiateServerboundPlayConnection($$11.toString(), 0, new ClientHandshakePacketListenerImpl($$12, this, null, null, p_261465_, $$10, p_231442_ -> {}, null));
        $$12.send(new ServerboundHelloPacket(this.getUser().getName(), this.getUser().getProfileId()));
        this.pendingConnection = $$12;
    }

    public void setLevel(ClientLevel p_91157_, ReceivingLevelScreen.Reason p_341652_) {
        this.updateScreenAndTick(new ReceivingLevelScreen(() -> false, p_341652_));
        this.level = p_91157_;
        this.updateLevelInEngines(p_91157_);
        if (!this.isLocalServer) {
            Services $$2 = Services.create(this.authenticationService, this.gameDirectory);
            $$2.profileCache().setExecutor(this);
            SkullBlockEntity.setup($$2, this);
            GameProfileCache.setUsesAuthentication(false);
        }
    }

    public void disconnect() {
        this.disconnect(new ProgressScreen(true), false);
    }

    public void disconnect(Screen p_91321_) {
        this.disconnect(p_91321_, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void disconnect(Screen p_320248_, boolean p_319814_) {
        ClientPacketListener $$2 = this.getConnection();
        if ($$2 != null) {
            this.dropAllTasks();
            $$2.close();
            if (!p_319814_) {
                this.clearDownloadedResourcePacks();
            }
        }
        this.playerSocialManager.stopOnlineMode();
        if (this.metricsRecorder.isRecording()) {
            this.debugClientMetricsCancel();
        }
        IntegratedServer $$3 = this.singleplayerServer;
        this.singleplayerServer = null;
        this.gameRenderer.resetData();
        this.gameMode = null;
        this.narrator.clear();
        this.clientLevelTeardownInProgress = true;
        try {
            this.updateScreenAndTick(p_320248_);
            if (this.level != null) {
                if ($$3 != null) {
                    this.profiler.push("waitForServer");
                    while (!$$3.isShutdown()) {
                        this.runTick(false);
                    }
                    this.profiler.pop();
                }
                this.gui.onDisconnected();
                this.isLocalServer = false;
            }
            this.level = null;
            this.updateLevelInEngines(null);
            this.player = null;
        }
        finally {
            this.clientLevelTeardownInProgress = false;
        }
        SkullBlockEntity.clear();
    }

    public void clearDownloadedResourcePacks() {
        this.downloadedPackSource.cleanupAfterDisconnect();
        this.runAllTasks();
    }

    public void clearClientLevel(Screen p_294558_) {
        ClientPacketListener $$1 = this.getConnection();
        if ($$1 != null) {
            $$1.clearLevel();
        }
        if (this.metricsRecorder.isRecording()) {
            this.debugClientMetricsCancel();
        }
        this.gameRenderer.resetData();
        this.gameMode = null;
        this.narrator.clear();
        this.clientLevelTeardownInProgress = true;
        try {
            this.updateScreenAndTick(p_294558_);
            this.gui.onDisconnected();
            this.level = null;
            this.updateLevelInEngines(null);
            this.player = null;
        }
        finally {
            this.clientLevelTeardownInProgress = false;
        }
        SkullBlockEntity.clear();
    }

    private void updateScreenAndTick(Screen p_91363_) {
        this.profiler.push("forcedTick");
        this.soundManager.stop();
        this.cameraEntity = null;
        this.pendingConnection = null;
        this.setScreen(p_91363_);
        this.runTick(false);
        this.profiler.pop();
    }

    public void forceSetScreen(Screen p_91347_) {
        this.profiler.push("forcedTick");
        this.setScreen(p_91347_);
        this.runTick(false);
        this.profiler.pop();
    }

    private void updateLevelInEngines(@Nullable ClientLevel p_91325_) {
        this.levelRenderer.setLevel(p_91325_);
        this.particleEngine.setLevel(p_91325_);
        this.blockEntityRenderDispatcher.setLevel(p_91325_);
        this.updateTitle();
    }

    private UserApiService.UserProperties userProperties() {
        return this.userPropertiesFuture.join();
    }

    public boolean telemetryOptInExtra() {
        return this.extraTelemetryAvailable() && this.options.telemetryOptInExtra().get() != false;
    }

    public boolean extraTelemetryAvailable() {
        return this.allowsTelemetry() && this.userProperties().flag(UserApiService.UserFlag.OPTIONAL_TELEMETRY_AVAILABLE);
    }

    public boolean allowsTelemetry() {
        if (SharedConstants.IS_RUNNING_IN_IDE) {
            return false;
        }
        return this.userProperties().flag(UserApiService.UserFlag.TELEMETRY_ENABLED);
    }

    public boolean allowsMultiplayer() {
        return this.allowsMultiplayer && this.userProperties().flag(UserApiService.UserFlag.SERVERS_ALLOWED) && this.multiplayerBan() == null && !this.isNameBanned();
    }

    public boolean allowsRealms() {
        return this.userProperties().flag(UserApiService.UserFlag.REALMS_ALLOWED) && this.multiplayerBan() == null;
    }

    @Nullable
    public BanDetails multiplayerBan() {
        return (BanDetails)this.userProperties().bannedScopes().get("MULTIPLAYER");
    }

    public boolean isNameBanned() {
        ProfileResult $$0 = this.profileFuture.getNow(null);
        return $$0 != null && $$0.actions().contains(ProfileActionType.FORCED_NAME_CHANGE);
    }

    public boolean isBlocked(UUID p_91247_) {
        if (!this.getChatStatus().isChatAllowed(false)) {
            return (this.player == null || !p_91247_.equals(this.player.getUUID())) && !p_91247_.equals(Util.NIL_UUID);
        }
        return this.playerSocialManager.shouldHideMessageFrom(p_91247_);
    }

    public ChatStatus getChatStatus() {
        if (this.options.chatVisibility().get() == ChatVisiblity.HIDDEN) {
            return ChatStatus.DISABLED_BY_OPTIONS;
        }
        if (!this.allowsChat) {
            return ChatStatus.DISABLED_BY_LAUNCHER;
        }
        if (!this.userProperties().flag(UserApiService.UserFlag.CHAT_ALLOWED)) {
            return ChatStatus.DISABLED_BY_PROFILE;
        }
        return ChatStatus.ENABLED;
    }

    public final boolean isDemo() {
        return this.demo;
    }

    @Nullable
    public ClientPacketListener getConnection() {
        return this.player == null ? null : this.player.connection;
    }

    public static boolean renderNames() {
        return !Minecraft.instance.options.hideGui;
    }

    public static boolean useFancyGraphics() {
        return Minecraft.instance.options.graphicsMode().get().getId() >= GraphicsStatus.FANCY.getId();
    }

    public static boolean useShaderTransparency() {
        return !Minecraft.instance.gameRenderer.isPanoramicMode() && Minecraft.instance.options.graphicsMode().get().getId() >= GraphicsStatus.FABULOUS.getId();
    }

    public static boolean useAmbientOcclusion() {
        return Minecraft.instance.options.ambientOcclusion().get();
    }

    /*
     * WARNING - void declaration
     */
    private void pickBlock() {
        void $$9;
        if (this.hitResult == null || this.hitResult.getType() == HitResult.Type.MISS) {
            return;
        }
        boolean $$0 = this.player.getAbilities().instabuild;
        BlockEntity $$1 = null;
        HitResult.Type $$2 = this.hitResult.getType();
        if ($$2 == HitResult.Type.BLOCK) {
            BlockPos $$3 = ((BlockHitResult)this.hitResult).getBlockPos();
            BlockState $$4 = this.level.getBlockState($$3);
            if ($$4.isAir()) {
                return;
            }
            Block $$5 = $$4.getBlock();
            ItemStack $$6 = $$5.getCloneItemStack(this.level, $$3, $$4);
            if ($$6.isEmpty()) {
                return;
            }
            if ($$0 && Screen.hasControlDown() && $$4.hasBlockEntity()) {
                $$1 = this.level.getBlockEntity($$3);
            }
        } else if ($$2 == HitResult.Type.ENTITY && $$0) {
            Entity $$7 = ((EntityHitResult)this.hitResult).getEntity();
            ItemStack $$8 = $$7.getPickResult();
            if ($$8 == null) {
                return;
            }
        } else {
            return;
        }
        if ($$9.isEmpty()) {
            String $$10 = "";
            if ($$2 == HitResult.Type.BLOCK) {
                $$10 = BuiltInRegistries.BLOCK.getKey(this.level.getBlockState(((BlockHitResult)this.hitResult).getBlockPos()).getBlock()).toString();
            } else if ($$2 == HitResult.Type.ENTITY) {
                $$10 = BuiltInRegistries.ENTITY_TYPE.getKey(((EntityHitResult)this.hitResult).getEntity().getType()).toString();
            }
            LOGGER.warn("Picking on: [{}] {} gave null item", (Object)$$2, (Object)$$10);
            return;
        }
        Inventory $$11 = this.player.getInventory();
        if ($$1 != null) {
            this.addCustomNbtData((ItemStack)$$9, $$1, this.level.registryAccess());
        }
        int $$12 = $$11.findSlotMatchingItem((ItemStack)$$9);
        if ($$0) {
            $$11.setPickedItem((ItemStack)$$9);
            this.gameMode.handleCreativeModeItemAdd(this.player.getItemInHand(InteractionHand.MAIN_HAND), 36 + $$11.selected);
        } else if ($$12 != -1) {
            if (Inventory.isHotbarSlot($$12)) {
                $$11.selected = $$12;
            } else {
                this.gameMode.handlePickItem($$12);
            }
        }
    }

    private void addCustomNbtData(ItemStack p_263370_, BlockEntity p_263368_, RegistryAccess p_323897_) {
        CompoundTag $$3 = p_263368_.saveCustomAndMetadata(p_323897_);
        p_263368_.removeComponentsFromTag($$3);
        BlockItem.setBlockEntityData(p_263370_, p_263368_.getType(), $$3);
        p_263370_.applyComponents(p_263368_.collectComponents());
    }

    public CrashReport fillReport(CrashReport p_91355_) {
        SystemReport $$1 = p_91355_.getSystemReport();
        Minecraft.fillSystemReport($$1, this, this.languageManager, this.launchedVersion, this.options);
        this.fillUptime(p_91355_.addCategory("Uptime"));
        if (this.level != null) {
            this.level.fillReportDetails(p_91355_);
        }
        if (this.singleplayerServer != null) {
            this.singleplayerServer.fillSystemReport($$1);
        }
        this.reloadStateTracker.fillCrashReport(p_91355_);
        return p_91355_;
    }

    public static void fillReport(@Nullable Minecraft p_167873_, @Nullable LanguageManager p_167874_, String p_167875_, @Nullable Options p_167876_, CrashReport p_167877_) {
        SystemReport $$5 = p_167877_.getSystemReport();
        Minecraft.fillSystemReport($$5, p_167873_, p_167874_, p_167875_, p_167876_);
    }

    private static String formatSeconds(double p_304493_) {
        return String.format(Locale.ROOT, "%.3fs", p_304493_);
    }

    private void fillUptime(CrashReportCategory p_304858_) {
        p_304858_.setDetail("JVM uptime", () -> Minecraft.formatSeconds((double)ManagementFactory.getRuntimeMXBean().getUptime() / 1000.0));
        p_304858_.setDetail("Wall uptime", () -> Minecraft.formatSeconds((double)(System.currentTimeMillis() - this.clientStartTimeMs) / 1000.0));
        p_304858_.setDetail("High-res time", () -> Minecraft.formatSeconds((double)Util.getMillis() / 1000.0));
        p_304858_.setDetail("Client ticks", () -> String.format(Locale.ROOT, "%d ticks / %.3fs", this.clientTickCount, (double)this.clientTickCount / 20.0));
    }

    private static SystemReport fillSystemReport(SystemReport p_167851_, @Nullable Minecraft p_167852_, @Nullable LanguageManager p_167853_, String p_167854_, @Nullable Options p_167855_) {
        p_167851_.setDetail("Launched Version", () -> p_167854_);
        String $$5 = Minecraft.getLauncherBrand();
        if ($$5 != null) {
            p_167851_.setDetail("Launcher name", $$5);
        }
        p_167851_.setDetail("Backend library", RenderSystem::getBackendDescription);
        p_167851_.setDetail("Backend API", RenderSystem::getApiDescription);
        p_167851_.setDetail("Window size", () -> p_167852_ != null ? p_231365_.window.getWidth() + "x" + p_231365_.window.getHeight() : "<not initialized>");
        p_167851_.setDetail("GFLW Platform", Window::getPlatform);
        p_167851_.setDetail("GL Caps", RenderSystem::getCapsString);
        p_167851_.setDetail("GL debug messages", () -> GlDebug.isDebugEnabled() ? String.join((CharSequence)"\n", GlDebug.getLastOpenGlDebugMessages()) : "<disabled>");
        p_167851_.setDetail("Is Modded", () -> Minecraft.checkModStatus().fullDescription());
        p_167851_.setDetail("Universe", () -> p_167852_ != null ? Long.toHexString(p_307033_.canary) : "404");
        p_167851_.setDetail("Type", "Client (map_client.txt)");
        if (p_167855_ != null) {
            String $$6;
            if (p_167852_ != null && ($$6 = p_167852_.getGpuWarnlistManager().getAllWarnings()) != null) {
                p_167851_.setDetail("GPU Warnings", $$6);
            }
            p_167851_.setDetail("Graphics mode", p_167855_.graphicsMode().get().toString());
            p_167851_.setDetail("Render Distance", p_167855_.getEffectiveRenderDistance() + "/" + String.valueOf(p_167855_.renderDistance().get()) + " chunks");
        }
        if (p_167852_ != null) {
            p_167851_.setDetail("Resource Packs", () -> PackRepository.displayPackList(p_167852_.getResourcePackRepository().getSelectedPacks()));
        }
        if (p_167853_ != null) {
            p_167851_.setDetail("Current Language", () -> p_167853_.getSelected());
        }
        p_167851_.setDetail("Locale", String.valueOf(Locale.getDefault()));
        p_167851_.setDetail("System encoding", () -> System.getProperty("sun.jnu.encoding", "<not set>"));
        p_167851_.setDetail("File encoding", () -> System.getProperty("file.encoding", "<not set>"));
        p_167851_.setDetail("CPU", GlUtil::getCpuInfo);
        return p_167851_;
    }

    public static Minecraft getInstance() {
        return instance;
    }

    public CompletableFuture<Void> delayTextureReload() {
        return this.submit(this::reloadResourcePacks).thenCompose(p_231391_ -> p_231391_);
    }

    public void updateReportEnvironment(ReportEnvironment p_239477_) {
        if (!this.reportingContext.matches(p_239477_)) {
            this.reportingContext = ReportingContext.create(p_239477_, this.userApiService);
        }
    }

    @Nullable
    public ServerData getCurrentServer() {
        return Optionull.map(this.getConnection(), ClientPacketListener::getServerData);
    }

    public boolean isLocalServer() {
        return this.isLocalServer;
    }

    public boolean hasSingleplayerServer() {
        return this.isLocalServer && this.singleplayerServer != null;
    }

    @Nullable
    public IntegratedServer getSingleplayerServer() {
        return this.singleplayerServer;
    }

    public boolean isSingleplayer() {
        IntegratedServer $$0 = this.getSingleplayerServer();
        return $$0 != null && !$$0.isPublished();
    }

    public boolean isLocalPlayer(UUID p_295141_) {
        return p_295141_.equals(this.getUser().getProfileId());
    }

    public User getUser() {
        return this.user;
    }

    public GameProfile getGameProfile() {
        ProfileResult $$0 = this.profileFuture.join();
        if ($$0 != null) {
            return $$0.profile();
        }
        return new GameProfile(this.user.getProfileId(), this.user.getName());
    }

    public Proxy getProxy() {
        return this.proxy;
    }

    public TextureManager getTextureManager() {
        return this.textureManager;
    }

    public ResourceManager getResourceManager() {
        return this.resourceManager;
    }

    public PackRepository getResourcePackRepository() {
        return this.resourcePackRepository;
    }

    public VanillaPackResources getVanillaPackResources() {
        return this.vanillaPackResources;
    }

    public DownloadedPackSource getDownloadedPackSource() {
        return this.downloadedPackSource;
    }

    public Path getResourcePackDirectory() {
        return this.resourcePackDirectory;
    }

    public LanguageManager getLanguageManager() {
        return this.languageManager;
    }

    public Function<ResourceLocation, TextureAtlasSprite> getTextureAtlas(ResourceLocation p_91259_) {
        return this.modelManager.getAtlas(p_91259_)::getSprite;
    }

    public boolean isPaused() {
        return this.pause;
    }

    public GpuWarnlistManager getGpuWarnlistManager() {
        return this.gpuWarnlistManager;
    }

    public SoundManager getSoundManager() {
        return this.soundManager;
    }

    public Music getSituationalMusic() {
        Music $$0 = Optionull.map(this.screen, Screen::getBackgroundMusic);
        if ($$0 != null) {
            return $$0;
        }
        if (this.player != null) {
            if (this.player.level().dimension() == Level.END) {
                if (this.gui.getBossOverlay().shouldPlayMusic()) {
                    return Musics.END_BOSS;
                }
                return Musics.END;
            }
            Holder<Biome> $$1 = this.player.level().getBiome(this.player.blockPosition());
            if (this.musicManager.isPlayingMusic(Musics.UNDER_WATER) || this.player.isUnderWater() && $$1.is(BiomeTags.PLAYS_UNDERWATER_MUSIC)) {
                return Musics.UNDER_WATER;
            }
            if (this.player.level().dimension() != Level.NETHER && this.player.getAbilities().instabuild && this.player.getAbilities().mayfly) {
                return Musics.CREATIVE;
            }
            return $$1.value().getBackgroundMusic().orElse(Musics.GAME);
        }
        return Musics.MENU;
    }

    public MinecraftSessionService getMinecraftSessionService() {
        return this.minecraftSessionService;
    }

    public SkinManager getSkinManager() {
        return this.skinManager;
    }

    @Nullable
    public Entity getCameraEntity() {
        return this.cameraEntity;
    }

    public void setCameraEntity(Entity p_91119_) {
        this.cameraEntity = p_91119_;
        this.gameRenderer.checkEntityPostEffect(p_91119_);
    }

    public boolean shouldEntityAppearGlowing(Entity p_91315_) {
        return p_91315_.isCurrentlyGlowing() || this.player != null && this.player.isSpectator() && this.options.keySpectatorOutlines.isDown() && p_91315_.getType() == EntityType.PLAYER;
    }

    @Override
    protected Thread getRunningThread() {
        return this.gameThread;
    }

    @Override
    protected Runnable wrapRunnable(Runnable p_91376_) {
        return p_91376_;
    }

    @Override
    protected boolean shouldRun(Runnable p_91365_) {
        return true;
    }

    public BlockRenderDispatcher getBlockRenderer() {
        return this.blockRenderer;
    }

    public EntityRenderDispatcher getEntityRenderDispatcher() {
        return this.entityRenderDispatcher;
    }

    public BlockEntityRenderDispatcher getBlockEntityRenderDispatcher() {
        return this.blockEntityRenderDispatcher;
    }

    public ItemRenderer getItemRenderer() {
        return this.itemRenderer;
    }

    public DataFixer getFixerUpper() {
        return this.fixerUpper;
    }

    public DeltaTracker getTimer() {
        return this.timer;
    }

    public BlockColors getBlockColors() {
        return this.blockColors;
    }

    public boolean showOnlyReducedInfo() {
        return this.player != null && this.player.isReducedDebugInfo() || this.options.reducedDebugInfo().get() != false;
    }

    public ToastComponent getToasts() {
        return this.toast;
    }

    public Tutorial getTutorial() {
        return this.tutorial;
    }

    public boolean isWindowActive() {
        return this.windowActive;
    }

    public HotbarManager getHotbarManager() {
        return this.hotbarManager;
    }

    public ModelManager getModelManager() {
        return this.modelManager;
    }

    public PaintingTextureManager getPaintingTextures() {
        return this.paintingTextures;
    }

    public MobEffectTextureManager getMobEffectTextures() {
        return this.mobEffectTextures;
    }

    public MapDecorationTextureManager getMapDecorationTextures() {
        return this.mapDecorationTextures;
    }

    public GuiSpriteManager getGuiSprites() {
        return this.guiSprites;
    }

    @Override
    public void setWindowActive(boolean p_91261_) {
        this.windowActive = p_91261_;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Component grabPanoramixScreenshot(File p_167900_, int p_167901_, int p_167902_) {
        int $$3 = this.window.getWidth();
        int $$4 = this.window.getHeight();
        TextureTarget $$5 = new TextureTarget(p_167901_, p_167902_, true, ON_OSX);
        float $$6 = this.player.getXRot();
        float $$7 = this.player.getYRot();
        float $$8 = this.player.xRotO;
        float $$9 = this.player.yRotO;
        this.gameRenderer.setRenderBlockOutline(false);
        try {
            this.gameRenderer.setPanoramicMode(true);
            this.levelRenderer.graphicsChanged();
            this.window.setWidth(p_167901_);
            this.window.setHeight(p_167902_);
            for (int $$10 = 0; $$10 < 6; ++$$10) {
                switch ($$10) {
                    case 0: {
                        this.player.setYRot($$7);
                        this.player.setXRot(0.0f);
                        break;
                    }
                    case 1: {
                        this.player.setYRot(($$7 + 90.0f) % 360.0f);
                        this.player.setXRot(0.0f);
                        break;
                    }
                    case 2: {
                        this.player.setYRot(($$7 + 180.0f) % 360.0f);
                        this.player.setXRot(0.0f);
                        break;
                    }
                    case 3: {
                        this.player.setYRot(($$7 - 90.0f) % 360.0f);
                        this.player.setXRot(0.0f);
                        break;
                    }
                    case 4: {
                        this.player.setYRot($$7);
                        this.player.setXRot(-90.0f);
                        break;
                    }
                    default: {
                        this.player.setYRot($$7);
                        this.player.setXRot(90.0f);
                    }
                }
                this.player.yRotO = this.player.getYRot();
                this.player.xRotO = this.player.getXRot();
                $$5.bindWrite(true);
                this.gameRenderer.renderLevel(DeltaTracker.ONE);
                try {
                    Thread.sleep(10L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                Screenshot.grab(p_167900_, "panorama_" + $$10 + ".png", $$5, p_231415_ -> {});
            }
            MutableComponent $$11 = Component.literal(p_167900_.getName()).withStyle(ChatFormatting.UNDERLINE).withStyle(p_231426_ -> p_231426_.withClickEvent(new ClickEvent(ClickEvent.Action.OPEN_FILE, p_167900_.getAbsolutePath())));
            MutableComponent mutableComponent = Component.translatable("screenshot.success", $$11);
            return mutableComponent;
        }
        catch (Exception $$12) {
            LOGGER.error("Couldn't save image", (Throwable)$$12);
            MutableComponent mutableComponent = Component.translatable("screenshot.failure", $$12.getMessage());
            return mutableComponent;
        }
        finally {
            this.player.setXRot($$6);
            this.player.setYRot($$7);
            this.player.xRotO = $$8;
            this.player.yRotO = $$9;
            this.gameRenderer.setRenderBlockOutline(true);
            this.window.setWidth($$3);
            this.window.setHeight($$4);
            $$5.destroyBuffers();
            this.gameRenderer.setPanoramicMode(false);
            this.levelRenderer.graphicsChanged();
            this.getMainRenderTarget().bindWrite(true);
        }
    }

    private Component grabHugeScreenshot(File p_167904_, int p_167905_, int p_167906_, int p_167907_, int p_167908_) {
        try {
            ByteBuffer $$5 = GlUtil.allocateMemory(p_167905_ * p_167906_ * 3);
            Screenshot $$6 = new Screenshot(p_167904_, p_167907_, p_167908_, p_167906_);
            float $$7 = (float)p_167907_ / (float)p_167905_;
            float $$8 = (float)p_167908_ / (float)p_167906_;
            float $$9 = $$7 > $$8 ? $$7 : $$8;
            for (int $$10 = (p_167908_ - 1) / p_167906_ * p_167906_; $$10 >= 0; $$10 -= p_167906_) {
                for (int $$11 = 0; $$11 < p_167907_; $$11 += p_167905_) {
                    RenderSystem.setShaderTexture(0, TextureAtlas.LOCATION_BLOCKS);
                    float $$12 = (float)(p_167907_ - p_167905_) / 2.0f * 2.0f - (float)($$11 * 2);
                    float $$13 = (float)(p_167908_ - p_167906_) / 2.0f * 2.0f - (float)($$10 * 2);
                    this.gameRenderer.renderZoomed($$9, $$12 /= (float)p_167905_, $$13 /= (float)p_167906_);
                    $$5.clear();
                    RenderSystem.pixelStore(3333, 1);
                    RenderSystem.pixelStore(3317, 1);
                    RenderSystem.readPixels(0, 0, p_167905_, p_167906_, 32992, 5121, $$5);
                    $$6.addRegion($$5, $$11, $$10, p_167905_, p_167906_);
                }
                $$6.saveRow();
            }
            File $$14 = $$6.close();
            GlUtil.freeMemory($$5);
            MutableComponent $$15 = Component.literal($$14.getName()).withStyle(ChatFormatting.UNDERLINE).withStyle(p_231379_ -> p_231379_.withClickEvent(new ClickEvent(ClickEvent.Action.OPEN_FILE, $$14.getAbsolutePath())));
            return Component.translatable("screenshot.success", $$15);
        }
        catch (Exception $$16) {
            LOGGER.warn("Couldn't save screenshot", (Throwable)$$16);
            return Component.translatable("screenshot.failure", $$16.getMessage());
        }
    }

    public ProfilerFiller getProfiler() {
        return this.profiler;
    }

    @Nullable
    public StoringChunkProgressListener getProgressListener() {
        return this.progressListener.get();
    }

    public SplashManager getSplashManager() {
        return this.splashManager;
    }

    @Nullable
    public Overlay getOverlay() {
        return this.overlay;
    }

    public PlayerSocialManager getPlayerSocialManager() {
        return this.playerSocialManager;
    }

    public Window getWindow() {
        return this.window;
    }

    public DebugScreenOverlay getDebugOverlay() {
        return this.gui.getDebugOverlay();
    }

    public RenderBuffers renderBuffers() {
        return this.renderBuffers;
    }

    public void updateMaxMipLevel(int p_91313_) {
        this.modelManager.updateMaxMipLevel(p_91313_);
    }

    public EntityModelSet getEntityModels() {
        return this.entityModels;
    }

    public boolean isTextFilteringEnabled() {
        return this.userProperties().flag(UserApiService.UserFlag.PROFANITY_FILTER_ENABLED);
    }

    public void prepareForMultiplayer() {
        this.playerSocialManager.startOnlineMode();
        this.getProfileKeyPairManager().prepareKeyPair();
    }

    @Nullable
    public SignatureValidator getProfileKeySignatureValidator() {
        return SignatureValidator.from(this.authenticationService.getServicesKeySet(), ServicesKeyType.PROFILE_KEY);
    }

    public boolean canValidateProfileKeys() {
        return !this.authenticationService.getServicesKeySet().keys(ServicesKeyType.PROFILE_KEY).isEmpty();
    }

    public InputType getLastInputType() {
        return this.lastInputType;
    }

    public void setLastInputType(InputType p_265509_) {
        this.lastInputType = p_265509_;
    }

    public GameNarrator getNarrator() {
        return this.narrator;
    }

    public ChatListener getChatListener() {
        return this.chatListener;
    }

    public ReportingContext getReportingContext() {
        return this.reportingContext;
    }

    public RealmsDataFetcher realmsDataFetcher() {
        return this.realmsDataFetcher;
    }

    public QuickPlayLog quickPlayLog() {
        return this.quickPlayLog;
    }

    public CommandHistory commandHistory() {
        return this.commandHistory;
    }

    public DirectoryValidator directoryValidator() {
        return this.directoryValidator;
    }

    private float getTickTargetMillis(float p_308953_) {
        TickRateManager $$1;
        if (this.level != null && ($$1 = this.level.tickRateManager()).runsNormally()) {
            return Math.max(p_308953_, $$1.millisecondsPerTick());
        }
        return p_308953_;
    }

    @Nullable
    public static String getLauncherBrand() {
        return System.getProperty("minecraft.launcher.brand");
    }

    static {
        LOGGER = LogUtils.getLogger();
        ON_OSX = Util.getPlatform() == Util.OS.OSX;
        DEFAULT_FONT = ResourceLocation.withDefaultNamespace("default");
        UNIFORM_FONT = ResourceLocation.withDefaultNamespace("uniform");
        ALT_FONT = ResourceLocation.withDefaultNamespace("alt");
        REGIONAL_COMPLIANCIES = ResourceLocation.withDefaultNamespace("regional_compliancies.json");
        RESOURCE_RELOAD_INITIAL_TASK = CompletableFuture.completedFuture(Unit.INSTANCE);
        SOCIAL_INTERACTIONS_NOT_AVAILABLE = Component.translatable("multiplayer.socialInteractions.not_available");
    }

    record GameLoadCookie(RealmsClient realmsClient, GameConfig.QuickPlayData quickPlayData) {
    }

    public static enum ChatStatus {
        ENABLED(CommonComponents.EMPTY){

            @Override
            public boolean isChatAllowed(boolean p_168045_) {
                return true;
            }
        }
        ,
        DISABLED_BY_OPTIONS(Component.translatable("chat.disabled.options").withStyle(ChatFormatting.RED)){

            @Override
            public boolean isChatAllowed(boolean p_168051_) {
                return false;
            }
        }
        ,
        DISABLED_BY_LAUNCHER(Component.translatable("chat.disabled.launcher").withStyle(ChatFormatting.RED)){

            @Override
            public boolean isChatAllowed(boolean p_168057_) {
                return p_168057_;
            }
        }
        ,
        DISABLED_BY_PROFILE(Component.translatable("chat.disabled.profile", Component.keybind(Minecraft.instance.options.keyChat.getName())).withStyle(ChatFormatting.RED)){

            @Override
            public boolean isChatAllowed(boolean p_168063_) {
                return p_168063_;
            }
        };

        static final Component INFO_DISABLED_BY_PROFILE;
        private final Component message;

        ChatStatus(Component p_168033_) {
            this.message = p_168033_;
        }

        public Component getMessage() {
            return this.message;
        }

        public abstract boolean isChatAllowed(boolean var1);

        static {
            INFO_DISABLED_BY_PROFILE = Component.translatable("chat.disabled.profile.moreInfo");
        }
    }
}

