/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.advancements.critereon;

import com.mojang.brigadier.ImmutableStringReader;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.BuiltInExceptionProvider;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.DynamicCommandExceptionType;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Either;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.network.chat.Component;

public interface MinMaxBounds<T extends Number> {
    public static final SimpleCommandExceptionType ERROR_EMPTY = new SimpleCommandExceptionType((Message)Component.translatable("argument.range.empty"));
    public static final SimpleCommandExceptionType ERROR_SWAPPED = new SimpleCommandExceptionType((Message)Component.translatable("argument.range.swapped"));

    public Optional<T> min();

    public Optional<T> max();

    default public boolean isAny() {
        return this.min().isEmpty() && this.max().isEmpty();
    }

    default public Optional<T> unwrapPoint() {
        Optional<T> $$1;
        Optional<T> $$0 = this.min();
        return $$0.equals($$1 = this.max()) ? $$0 : Optional.empty();
    }

    public static <T extends Number, R extends MinMaxBounds<T>> Codec<R> createCodec(Codec<T> p_298521_, BoundsFactory<T, R> p_298688_) {
        Codec $$2 = RecordCodecBuilder.create(p_337383_ -> p_337383_.group((App)p_298521_.optionalFieldOf("min").forGetter(MinMaxBounds::min), (App)p_298521_.optionalFieldOf("max").forGetter(MinMaxBounds::max)).apply((Applicative)p_337383_, p_298688_::create));
        return Codec.either((Codec)$$2, p_298521_).xmap(p_298558_ -> (MinMaxBounds)p_298558_.map(p_299210_ -> p_299210_, p_298935_ -> p_298688_.create(Optional.of(p_298935_), Optional.of(p_298935_))), p_298447_ -> {
            Optional $$1 = p_298447_.unwrapPoint();
            return $$1.isPresent() ? Either.right((Object)((Number)$$1.get())) : Either.left((Object)p_298447_);
        });
    }

    public static <T extends Number, R extends MinMaxBounds<T>> R fromReader(StringReader p_55314_, BoundsFromReaderFactory<T, R> p_55315_, Function<String, T> p_55316_, Supplier<DynamicCommandExceptionType> p_55317_, Function<T, T> p_55318_) throws CommandSyntaxException {
        if (!p_55314_.canRead()) {
            throw ERROR_EMPTY.createWithContext((ImmutableStringReader)p_55314_);
        }
        int $$5 = p_55314_.getCursor();
        try {
            Optional<T> $$8;
            Optional<T> $$6 = MinMaxBounds.readNumber(p_55314_, p_55316_, p_55317_).map(p_55318_);
            if (p_55314_.canRead(2) && p_55314_.peek() == '.' && p_55314_.peek(1) == '.') {
                p_55314_.skip();
                p_55314_.skip();
                Optional<T> $$7 = MinMaxBounds.readNumber(p_55314_, p_55316_, p_55317_).map(p_55318_);
                if ($$6.isEmpty() && $$7.isEmpty()) {
                    throw ERROR_EMPTY.createWithContext((ImmutableStringReader)p_55314_);
                }
            } else {
                $$8 = $$6;
            }
            if ($$6.isEmpty() && $$8.isEmpty()) {
                throw ERROR_EMPTY.createWithContext((ImmutableStringReader)p_55314_);
            }
            return p_55315_.create(p_55314_, $$6, $$8);
        }
        catch (CommandSyntaxException $$9) {
            p_55314_.setCursor($$5);
            throw new CommandSyntaxException($$9.getType(), $$9.getRawMessage(), $$9.getInput(), $$5);
        }
    }

    private static <T extends Number> Optional<T> readNumber(StringReader p_55320_, Function<String, T> p_55321_, Supplier<DynamicCommandExceptionType> p_55322_) throws CommandSyntaxException {
        int $$3 = p_55320_.getCursor();
        while (p_55320_.canRead() && MinMaxBounds.isAllowedInputChat(p_55320_)) {
            p_55320_.skip();
        }
        String $$4 = p_55320_.getString().substring($$3, p_55320_.getCursor());
        if ($$4.isEmpty()) {
            return Optional.empty();
        }
        try {
            return Optional.of((Number)p_55321_.apply($$4));
        }
        catch (NumberFormatException $$5) {
            throw p_55322_.get().createWithContext((ImmutableStringReader)p_55320_, (Object)$$4);
        }
    }

    private static boolean isAllowedInputChat(StringReader p_55312_) {
        char $$1 = p_55312_.peek();
        if ($$1 >= '0' && $$1 <= '9' || $$1 == '-') {
            return true;
        }
        if ($$1 == '.') {
            return !p_55312_.canRead(2) || p_55312_.peek(1) != '.';
        }
        return false;
    }

    @FunctionalInterface
    public static interface BoundsFactory<T extends Number, R extends MinMaxBounds<T>> {
        public R create(Optional<T> var1, Optional<T> var2);
    }

    @FunctionalInterface
    public static interface BoundsFromReaderFactory<T extends Number, R extends MinMaxBounds<T>> {
        public R create(StringReader var1, Optional<T> var2, Optional<T> var3) throws CommandSyntaxException;
    }

    public record Doubles(Optional<Double> min, Optional<Double> max, Optional<Double> minSq, Optional<Double> maxSq) implements MinMaxBounds<Double>
    {
        public static final Doubles ANY = new Doubles(Optional.empty(), Optional.empty());
        public static final Codec<Doubles> CODEC = MinMaxBounds.createCodec(Codec.DOUBLE, Doubles::new);

        private Doubles(Optional<Double> p_298243_, Optional<Double> p_299159_) {
            this(p_298243_, p_299159_, Doubles.squareOpt(p_298243_), Doubles.squareOpt(p_299159_));
        }

        private static Doubles create(StringReader p_154796_, Optional<Double> p_298478_, Optional<Double> p_298476_) throws CommandSyntaxException {
            if (p_298478_.isPresent() && p_298476_.isPresent() && p_298478_.get() > p_298476_.get()) {
                throw ERROR_SWAPPED.createWithContext((ImmutableStringReader)p_154796_);
            }
            return new Doubles(p_298478_, p_298476_);
        }

        private static Optional<Double> squareOpt(Optional<Double> p_298534_) {
            return p_298534_.map(p_297908_ -> p_297908_ * p_297908_);
        }

        public static Doubles exactly(double p_154787_) {
            return new Doubles(Optional.of(p_154787_), Optional.of(p_154787_));
        }

        public static Doubles between(double p_154789_, double p_154790_) {
            return new Doubles(Optional.of(p_154789_), Optional.of(p_154790_));
        }

        public static Doubles atLeast(double p_154805_) {
            return new Doubles(Optional.of(p_154805_), Optional.empty());
        }

        public static Doubles atMost(double p_154809_) {
            return new Doubles(Optional.empty(), Optional.of(p_154809_));
        }

        public boolean matches(double p_154811_) {
            if (this.min.isPresent() && this.min.get() > p_154811_) {
                return false;
            }
            return this.max.isEmpty() || !(this.max.get() < p_154811_);
        }

        public boolean matchesSqr(double p_154813_) {
            if (this.minSq.isPresent() && this.minSq.get() > p_154813_) {
                return false;
            }
            return this.maxSq.isEmpty() || !(this.maxSq.get() < p_154813_);
        }

        public static Doubles fromReader(StringReader p_154794_) throws CommandSyntaxException {
            return Doubles.fromReader(p_154794_, p_154807_ -> p_154807_);
        }

        public static Doubles fromReader(StringReader p_154800_, Function<Double, Double> p_154801_) throws CommandSyntaxException {
            return MinMaxBounds.fromReader(p_154800_, Doubles::create, Double::parseDouble, () -> ((BuiltInExceptionProvider)CommandSyntaxException.BUILT_IN_EXCEPTIONS).readerInvalidDouble(), p_154801_);
        }
    }

    public record Ints(Optional<Integer> min, Optional<Integer> max, Optional<Long> minSq, Optional<Long> maxSq) implements MinMaxBounds<Integer>
    {
        public static final Ints ANY = new Ints(Optional.empty(), Optional.empty());
        public static final Codec<Ints> CODEC = MinMaxBounds.createCodec(Codec.INT, Ints::new);

        private Ints(Optional<Integer> p_298275_, Optional<Integer> p_298272_) {
            this(p_298275_, p_298272_, p_298275_.map(p_297910_ -> p_297910_.longValue() * p_297910_.longValue()), Ints.squareOpt(p_298272_));
        }

        private static Ints create(StringReader p_55378_, Optional<Integer> p_298250_, Optional<Integer> p_298579_) throws CommandSyntaxException {
            if (p_298250_.isPresent() && p_298579_.isPresent() && p_298250_.get() > p_298579_.get()) {
                throw ERROR_SWAPPED.createWithContext((ImmutableStringReader)p_55378_);
            }
            return new Ints(p_298250_, p_298579_);
        }

        private static Optional<Long> squareOpt(Optional<Integer> p_298733_) {
            return p_298733_.map(p_297909_ -> p_297909_.longValue() * p_297909_.longValue());
        }

        public static Ints exactly(int p_55372_) {
            return new Ints(Optional.of(p_55372_), Optional.of(p_55372_));
        }

        public static Ints between(int p_154815_, int p_154816_) {
            return new Ints(Optional.of(p_154815_), Optional.of(p_154816_));
        }

        public static Ints atLeast(int p_55387_) {
            return new Ints(Optional.of(p_55387_), Optional.empty());
        }

        public static Ints atMost(int p_154820_) {
            return new Ints(Optional.empty(), Optional.of(p_154820_));
        }

        public boolean matches(int p_55391_) {
            if (this.min.isPresent() && this.min.get() > p_55391_) {
                return false;
            }
            return this.max.isEmpty() || this.max.get() >= p_55391_;
        }

        public boolean matchesSqr(long p_154818_) {
            if (this.minSq.isPresent() && this.minSq.get() > p_154818_) {
                return false;
            }
            return this.maxSq.isEmpty() || this.maxSq.get() >= p_154818_;
        }

        public static Ints fromReader(StringReader p_55376_) throws CommandSyntaxException {
            return Ints.fromReader(p_55376_, p_55389_ -> p_55389_);
        }

        public static Ints fromReader(StringReader p_55382_, Function<Integer, Integer> p_55383_) throws CommandSyntaxException {
            return MinMaxBounds.fromReader(p_55382_, Ints::create, Integer::parseInt, () -> ((BuiltInExceptionProvider)CommandSyntaxException.BUILT_IN_EXCEPTIONS).readerInvalidInt(), p_55383_);
        }
    }
}

