/*
 * Decompiled with CFR 0.152.
 */
package com.mojang.authlib.yggdrasil;

import com.mojang.authlib.Environment;
import com.mojang.authlib.GameProfile;
import com.mojang.authlib.exceptions.AuthenticationException;
import com.mojang.authlib.exceptions.AuthenticationUnavailableException;
import com.mojang.authlib.launcher.Authlib1Utils;
import com.mojang.authlib.launcher.Authlib6Utils;
import com.mojang.authlib.launcher.GenericGameProfile;
import com.mojang.authlib.launcher.LauncherUtils;
import com.mojang.authlib.minecraft.InsecurePublicKeyException;
import com.mojang.authlib.minecraft.MinecraftProfileTextures;
import com.mojang.authlib.minecraft.MinecraftSessionService;
import com.mojang.authlib.properties.Property;
import com.mojang.authlib.yggdrasil.ProfileResult;
import com.mojang.authlib.yggdrasil.ServicesKeySet;
import com.mojang.authlib.yggdrasil.YggdrasilAuthenticationService;
import java.net.InetAddress;
import java.net.Proxy;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.CompletionException;
import java.util.concurrent.ExecutionException;
import javax.annotation.Nullable;

public class YggdrasilMinecraftSessionService
implements MinecraftSessionService {
    public YggdrasilMinecraftSessionService(YggdrasilAuthenticationService authenticationService, Environment environment) {
    }

    protected YggdrasilMinecraftSessionService(ServicesKeySet servicesKeySet, Proxy proxy, Environment env) {
    }

    @Override
    public void joinServer(UUID profileId, String token, String serverId) throws AuthenticationException {
        try {
            Boolean ok = LauncherUtils.joinServerAsync(profileId, token, serverId).get();
            if (!ok.booleanValue()) {
                throw new RuntimeException("You can't join to this server");
            }
        }
        catch (Throwable e) {
            Throwable exc = e;
            if (exc instanceof CompletionException) {
                CompletionException ce = (CompletionException)exc;
                exc = ce.getCause();
            }
            throw new AuthenticationException(exc.getMessage(), exc);
        }
    }

    @Override
    public ProfileResult hasJoinedServer(String profileName, String serverId, @Nullable InetAddress inetAddress) throws AuthenticationUnavailableException {
        try {
            GenericGameProfile profile = LauncherUtils.checkServerAsync(profileName, serverId, inetAddress == null ? null : inetAddress.toString()).get();
            return new ProfileResult(Authlib1Utils.createGameProfile(profile), Set.of());
        }
        catch (Throwable e) {
            Throwable exc = e;
            if (exc instanceof CompletionException) {
                CompletionException ce = (CompletionException)exc;
                exc = ce.getCause();
            }
            LauncherUtils.error(e);
            throw new AuthenticationUnavailableException(exc.getMessage(), exc);
        }
    }

    @Override
    @Nullable
    public Property getPackedTextures(GameProfile profile) {
        if (profile.getProperties() == null) {
            return null;
        }
        return profile.getProperties().get("textures").stream().findFirst().orElse(null);
    }

    @Override
    public MinecraftProfileTextures unpackTextures(Property packedTextures) {
        return Authlib6Utils.parseTexturesProperty(packedTextures);
    }

    @Override
    @Nullable
    public ProfileResult fetchProfile(UUID profileId, boolean requireSecure) {
        if (profileId == null) {
            return null;
        }
        try {
            GenericGameProfile genericGameProfile = LauncherUtils.findByUUID(profileId).get();
            return new ProfileResult(Authlib1Utils.createGameProfile(genericGameProfile), Set.of());
        }
        catch (InterruptedException | ExecutionException ignored) {
            return null;
        }
    }

    @Override
    public String getSecurePropertyValue(Property property) throws InsecurePublicKeyException {
        if (property == null) {
            return null;
        }
        return property.value();
    }
}

