/*
 * Decompiled with CFR 0.152.
 */
package com.b1n_ry.yigd.data;

import com.b1n_ry.yigd.block.entity.GraveBlockEntity;
import com.b1n_ry.yigd.components.GraveComponent;
import com.b1n_ry.yigd.components.RespawnComponent;
import com.b1n_ry.yigd.config.ExtraFeaturesConfig;
import com.b1n_ry.yigd.config.YigdConfig;
import com.b1n_ry.yigd.data.GraveStatus;
import com.b1n_ry.yigd.data.ListMode;
import com.b1n_ry.yigd.util.GraveCompassHelper;
import com.mojang.authlib.GameProfile;
import com.mojang.serialization.DynamicOps;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.Tag;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.item.component.ResolvableProfile;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.saveddata.SavedData;
import org.jetbrains.annotations.NotNull;

public class DeathInfoManager
extends SavedData {
    public static DeathInfoManager INSTANCE = new DeathInfoManager();
    private final Map<GameProfile, RespawnComponent> respawnEffects = new HashMap<GameProfile, RespawnComponent>();
    private final Map<GameProfile, List<GraveComponent>> graveBackups = new HashMap<GameProfile, List<GraveComponent>>();
    private final Map<UUID, GraveComponent> graveMap = new HashMap<UUID, GraveComponent>();
    private ListMode graveListMode = ListMode.BLACKLIST;
    private final Set<GameProfile> affectedPlayers = new HashSet<GameProfile>();

    public void clear() {
        this.respawnEffects.clear();
        this.graveBackups.clear();
        this.graveMap.clear();
        this.affectedPlayers.clear();
    }

    public Set<GameProfile> getAffectedPlayers() {
        return this.affectedPlayers;
    }

    public static SavedData.Factory<DeathInfoManager> getPersistentStateType(MinecraftServer server) {
        return new SavedData.Factory(DeathInfoManager::new, (nbt, lookupRegistry) -> DeathInfoManager.load(nbt, lookupRegistry, server), null);
    }

    public InteractionResult delete(UUID graveId) {
        GraveComponent component = this.graveMap.get(graveId);
        if (component == null) {
            return InteractionResult.FAIL;
        }
        GameProfile profile = component.getOwner().gameProfile();
        this.graveMap.remove(graveId);
        if (!this.graveBackups.containsKey(profile)) {
            return InteractionResult.PASS;
        }
        this.graveBackups.get(profile).remove(component);
        if (component.getStatus() != GraveStatus.UNCLAIMED) {
            return InteractionResult.SUCCESS;
        }
        return component.removeGraveBlock() ? InteractionResult.SUCCESS : InteractionResult.PASS;
    }

    public void addRespawnComponent(ResolvableProfile profile, RespawnComponent component) {
        this.respawnEffects.put(profile.gameProfile(), component);
    }

    public Optional<RespawnComponent> getRespawnComponent(ResolvableProfile profile) {
        return Optional.ofNullable(this.respawnEffects.get(profile.gameProfile()));
    }

    public Map<GameProfile, List<GraveComponent>> getPlayerGraves() {
        return this.graveBackups;
    }

    public void removeRespawnComponent(ResolvableProfile profile) {
        this.respawnEffects.remove(profile.gameProfile());
    }

    public void addBackup(ResolvableProfile p, GraveComponent component) {
        YigdConfig config = YigdConfig.getConfig();
        GameProfile profile = p.gameProfile();
        if (!this.graveBackups.containsKey(profile)) {
            this.graveBackups.put(profile, new ArrayList());
        }
        List<GraveComponent> playerGraves = this.graveBackups.get(profile);
        playerGraves.add(component);
        this.graveMap.put(component.getGraveId(), component);
        if (playerGraves.size() > config.graveConfig.maxBackupsPerPerson) {
            GraveComponent toBeRemoved = playerGraves.getFirst();
            this.delete(toBeRemoved.getGraveId());
            if (toBeRemoved.getStatus() == GraveStatus.UNCLAIMED && config.graveConfig.dropFromOldestWhenDeleted) {
                toBeRemoved.dropAll();
            }
        }
        if (config.extraFeatures.graveCompass.pointToClosest != ExtraFeaturesConfig.GraveCompassConfig.CompassGraveTarget.DISABLED && component.getStatus() == GraveStatus.UNCLAIMED) {
            GraveCompassHelper.addGravePosition(component.getWorldRegistryKey(), component.getPos(), profile.getId());
        }
    }

    @NotNull
    public List<GraveComponent> getBackupData(ResolvableProfile profile) {
        return this.graveBackups.computeIfAbsent(profile.gameProfile(), k -> new ArrayList());
    }

    public Optional<GraveComponent> getGrave(UUID graveId) {
        return Optional.ofNullable(this.graveMap.get(graveId));
    }

    public ListMode getGraveListMode() {
        return this.graveListMode;
    }

    public void setGraveListMode(ListMode listMode) {
        this.graveListMode = listMode;
    }

    public void addToList(ResolvableProfile profile) {
        this.affectedPlayers.add(profile.gameProfile());
    }

    public boolean removeFromList(ResolvableProfile profile) {
        return this.affectedPlayers.remove(profile.gameProfile());
    }

    public boolean isInList(ResolvableProfile profile) {
        return this.affectedPlayers.contains(profile.gameProfile());
    }

    @NotNull
    public CompoundTag save(@NotNull CompoundTag nbt, // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull HolderLookup.Provider registryLookup) {
        ListTag respawnNbt = new ListTag();
        ListTag graveNbt = new ListTag();
        CompoundTag graveListNbt = new CompoundTag();
        for (Map.Entry<GameProfile, RespawnComponent> entry : this.respawnEffects.entrySet()) {
            CompoundTag respawnCompound = new CompoundTag();
            ResolvableProfile.CODEC.encodeStart((DynamicOps)NbtOps.INSTANCE, (Object)new ResolvableProfile(entry.getKey())).result().ifPresent(nbtElement -> respawnCompound.put("user", nbtElement));
            respawnCompound.put("component", (Tag)entry.getValue().toNbt(registryLookup));
            respawnNbt.add((Object)respawnCompound);
        }
        for (Map.Entry<GameProfile, Object> entry : this.graveBackups.entrySet()) {
            CompoundTag graveCompound = new CompoundTag();
            ResolvableProfile.CODEC.encodeStart((DynamicOps)NbtOps.INSTANCE, (Object)new ResolvableProfile(entry.getKey())).result().ifPresent(nbtElement -> graveCompound.put("user", nbtElement));
            ListTag graveNbtList = new ListTag();
            for (GraveComponent graveComponent : (List)entry.getValue()) {
                graveNbtList.add((Object)graveComponent.toNbt(registryLookup));
            }
            graveCompound.put("graves", (Tag)graveNbtList);
            graveNbt.add((Object)graveCompound);
        }
        graveListNbt.putString("listMode", this.graveListMode.name());
        ListTag affectedPlayersNbt = new ListTag();
        for (GameProfile profile : this.affectedPlayers) {
            Tag profileNbt = (Tag)ResolvableProfile.CODEC.encodeStart((DynamicOps)NbtOps.INSTANCE, (Object)new ResolvableProfile(profile)).result().orElseThrow();
            affectedPlayersNbt.add((Object)profileNbt);
        }
        graveListNbt.put("affectedPlayers", (Tag)affectedPlayersNbt);
        nbt.put("respawns", (Tag)respawnNbt);
        nbt.put("graves", (Tag)graveNbt);
        nbt.put("whitelist", (Tag)graveListNbt);
        return nbt;
    }

    public static DeathInfoManager load(CompoundTag nbt, HolderLookup.Provider lookupRegistry, MinecraftServer server) {
        INSTANCE.clear();
        ListTag respawnNbt = nbt.getList("respawns", 10);
        ListTag graveNbt = nbt.getList("graves", 10);
        for (Tag respawnElement : respawnNbt) {
            CompoundTag respawnCompound = (CompoundTag)respawnElement;
            INSTANCE.addRespawnComponent((ResolvableProfile)ResolvableProfile.CODEC.parse((DynamicOps)NbtOps.INSTANCE, (Object)respawnCompound.get("user")).result().orElseThrow(), RespawnComponent.fromNbt(respawnCompound.getCompound("component"), lookupRegistry));
        }
        for (Tag graveElement : graveNbt) {
            CompoundTag graveCompound = (CompoundTag)graveElement;
            ResolvableProfile user = (ResolvableProfile)ResolvableProfile.CODEC.parse((DynamicOps)NbtOps.INSTANCE, (Object)graveCompound.get("user")).result().orElseThrow();
            ListTag gravesList = graveCompound.getList("graves", 10);
            for (Tag grave : gravesList) {
                GraveBlockEntity be;
                BlockEntity blockEntity;
                GraveComponent component = GraveComponent.fromNbt((CompoundTag)grave, lookupRegistry, server);
                INSTANCE.addBackup(user, component);
                ServerLevel world = component.getWorld();
                if (world == null || !world.areEntitiesLoaded(new ChunkPos(component.getPos()).toLong()) || !((blockEntity = world.getBlockEntity(component.getPos())) instanceof GraveBlockEntity) || (be = (GraveBlockEntity)blockEntity).getGraveId() == null || !be.getGraveId().equals(component.getGraveId())) continue;
                be.setComponent(component);
            }
        }
        CompoundTag graveListNbt = nbt.getCompound("whitelist");
        ListMode listMode = ListMode.valueOf(graveListNbt.getString("listMode"));
        INSTANCE.setGraveListMode(listMode);
        ListTag affectedPlayersNbt = graveListNbt.getList("affectedPlayers", 9);
        for (Tag e : affectedPlayersNbt) {
            ResolvableProfile profile = (ResolvableProfile)ResolvableProfile.CODEC.parse((DynamicOps)NbtOps.INSTANCE, (Object)e).result().orElseThrow();
            INSTANCE.addToList(profile);
        }
        return INSTANCE;
    }
}

