/*
 * Decompiled with CFR 0.152.
 */
package com.b1n_ry.yigd.components;

import com.b1n_ry.yigd.config.ExpDropBehaviour;
import com.b1n_ry.yigd.config.YigdConfig;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.ExperienceOrb;
import net.minecraft.world.phys.Vec3;

public class ExpComponent {
    private final double originalXp;
    private int storedXp;

    public ExpComponent(ServerPlayer player) {
        this.originalXp = this.getTotalExperience(player);
        this.storedXp = this.getXpDropAmount(player);
    }

    private ExpComponent(int storedXp, double originalXp) {
        this.storedXp = storedXp;
        this.originalXp = originalXp;
    }

    public void setStoredXp(int storedXp) {
        this.storedXp = storedXp;
    }

    public int getStoredXp() {
        return this.storedXp;
    }

    public double getOriginalXp() {
        return this.originalXp;
    }

    public int getXpDropAmount(ServerPlayer player) {
        YigdConfig config = YigdConfig.getConfig();
        double totalExperience = this.getTotalExperience(player);
        int percentageDrop = (int)((double)((float)config.expConfig.dropPercentage / 100.0f) * totalExperience);
        int vanillaDrop = player.getExperienceReward(player.serverLevel(), null);
        return switch (config.expConfig.dropBehaviour) {
            default -> throw new MatchException(null, null);
            case ExpDropBehaviour.BEST_OF_BOTH -> Math.max(vanillaDrop, percentageDrop);
            case ExpDropBehaviour.WORST_OF_BOTH -> Math.min(vanillaDrop, percentageDrop);
            case ExpDropBehaviour.PERCENTAGE -> percentageDrop;
            case ExpDropBehaviour.VANILLA -> vanillaDrop;
        };
    }

    private double getTotalExperience(ServerPlayer player) {
        int currentLevel = player.experienceLevel;
        double totalExperience = currentLevel >= 32 ? 4.5 * Math.pow(currentLevel, 2.0) - 162.5 * (double)currentLevel + 2220.0 : (currentLevel >= 17 ? 2.5 * Math.pow(currentLevel, 2.0) - 40.5 * (double)currentLevel + 360.0 : Math.pow(currentLevel, 2.0) + (double)(6 * currentLevel));
        return totalExperience += (double)((float)player.getXpNeededForNextLevel() * player.experienceProgress);
    }

    public int getXpLevel() {
        return ExpComponent.xpToLevels(this.storedXp);
    }

    public boolean isEmpty() {
        return this.storedXp == 0;
    }

    public ExpComponent getSoulboundExp() {
        YigdConfig config = YigdConfig.getConfig();
        float soulboundFactor = (float)config.expConfig.keepPercentage / 100.0f;
        int keepXp = (int)((float)this.storedXp * soulboundFactor);
        this.storedXp -= keepXp;
        if (this.storedXp < 0) {
            this.storedXp = 0;
        }
        return new ExpComponent(keepXp, this.originalXp);
    }

    public void dropAll(ServerLevel world, Vec3 pos) {
        ExperienceOrb.award((ServerLevel)world, (Vec3)pos, (int)this.storedXp);
    }

    public void applyToPlayer(ServerPlayer player) {
        player.giveExperiencePoints(this.storedXp);
    }

    public void clear() {
        this.storedXp = 0;
    }

    public CompoundTag toNbt() {
        CompoundTag nbt = new CompoundTag();
        nbt.putInt("value", this.storedXp);
        nbt.putDouble("original", this.originalXp);
        return nbt;
    }

    public static ExpComponent fromNbt(CompoundTag nbt) {
        int xpToDrop = nbt.getInt("value");
        double originalXp = nbt.contains("original") ? nbt.getDouble("original") : (double)xpToDrop;
        return new ExpComponent(xpToDrop, originalXp);
    }

    public static void clearXp(ServerPlayer player) {
        player.totalExperience = 0;
        player.experienceLevel = 0;
        player.experienceProgress = 0.0f;
    }

    public static int xpToLevels(int totalXp) {
        int i = 0;
        while (totalXp >= 0) {
            totalXp = i < 16 ? (totalXp -= 2 * i + 7) : (i < 31 ? (totalXp -= 5 * i - 38) : (totalXp -= 9 * i - 158));
            ++i;
        }
        return i - 1;
    }

    public ExpComponent copy() {
        return new ExpComponent(this.storedXp, this.originalXp);
    }
}

