/*
 * Decompiled with CFR 0.152.
 */
package com.b1n_ry.yigd.compat;

import com.b1n_ry.yigd.compat.CompatComponent;
import com.b1n_ry.yigd.compat.InvModCompat;
import com.b1n_ry.yigd.components.InventoryComponent;
import com.b1n_ry.yigd.config.YigdConfig;
import com.b1n_ry.yigd.data.DeathContext;
import com.b1n_ry.yigd.events.YigdEvents;
import io.wispforest.accessories.api.AccessoriesAPI;
import io.wispforest.accessories.api.AccessoriesCapability;
import io.wispforest.accessories.api.AccessoriesContainer;
import io.wispforest.accessories.api.DropRule;
import io.wispforest.accessories.api.slot.SlotReference;
import io.wispforest.accessories.impl.ExpandedSimpleContainer;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Predicate;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Tuple;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.neoforged.bus.api.Event;
import net.neoforged.neoforge.common.NeoForge;

public class AccessoriesCompat
implements InvModCompat<Map<String, AccessoriesInventoryGroup>> {
    @Override
    public String getModName() {
        return "accessories";
    }

    @Override
    public void clear(ServerPlayer player) {
        AccessoriesCapability.getOptionally((LivingEntity)player).ifPresent(inv -> inv.reset(false));
    }

    @Override
    public CompatComponent<Map<String, AccessoriesInventoryGroup>> readNbt(CompoundTag nbt, HolderLookup.Provider registryLookup) {
        HashMap<String, AccessoriesInventoryGroup> inventory = new HashMap<String, AccessoriesInventoryGroup>();
        for (String key : nbt.getAllKeys()) {
            CompoundTag slotNbt = nbt.getCompound(key);
            NonNullList<AccessoriesInventorySlot> normalSlot = InventoryComponent.listFromNbt(slotNbt.getCompound("normal"), itemNbt -> {
                String dropRuleString;
                ItemStack stack = ItemStack.parse((HolderLookup.Provider)registryLookup, (Tag)itemNbt).orElse(ItemStack.EMPTY);
                com.b1n_ry.yigd.util.DropRule dropRule = itemNbt.contains("dropRule") ? ((dropRuleString = itemNbt.getString("dropRule")).equals("DEFAULT") ? YigdConfig.getConfig().compatConfig.defaultAccessoriesDropRule : com.b1n_ry.yigd.util.DropRule.valueOf(dropRuleString)) : YigdConfig.getConfig().compatConfig.defaultAccessoriesDropRule;
                boolean visible = !itemNbt.contains("visible") || itemNbt.getBoolean("visible");
                return new AccessoriesInventorySlot(stack, dropRule, visible);
            }, AccessoriesInventorySlot.EMPTY);
            NonNullList<AccessoriesInventorySlot> cosmeticSlot = InventoryComponent.listFromNbt(slotNbt.getCompound("cosmetic"), itemNbt -> {
                String dropRuleString;
                ItemStack stack = ItemStack.parse((HolderLookup.Provider)registryLookup, (Tag)itemNbt).orElse(ItemStack.EMPTY);
                com.b1n_ry.yigd.util.DropRule dropRule = itemNbt.contains("dropRule") ? ((dropRuleString = itemNbt.getString("dropRule")).equals("DEFAULT") ? YigdConfig.getConfig().compatConfig.defaultAccessoriesDropRule : com.b1n_ry.yigd.util.DropRule.valueOf(dropRuleString)) : YigdConfig.getConfig().compatConfig.defaultAccessoriesDropRule;
                boolean visible = !itemNbt.contains("visible") || itemNbt.getBoolean("visible");
                return new AccessoriesInventorySlot(stack, dropRule, visible);
            }, AccessoriesInventorySlot.EMPTY);
            inventory.put(key, new AccessoriesInventoryGroup(normalSlot, cosmeticSlot));
        }
        return new AccessoriesCompatComponent((Map<String, AccessoriesInventoryGroup>)inventory);
    }

    @Override
    public CompatComponent<Map<String, AccessoriesInventoryGroup>> getNewComponent(ServerPlayer player) {
        return new AccessoriesCompatComponent(player);
    }

    public static class AccessoriesInventorySlot {
        public ItemStack stack;
        public com.b1n_ry.yigd.util.DropRule dropRule;
        public boolean visible;
        public static AccessoriesInventorySlot EMPTY = new AccessoriesInventorySlot(ItemStack.EMPTY, com.b1n_ry.yigd.util.DropRule.PUT_IN_GRAVE, true);

        public AccessoriesInventorySlot(ItemStack stack, com.b1n_ry.yigd.util.DropRule dropRule, boolean visible) {
            this.stack = stack;
            this.dropRule = dropRule;
            this.visible = visible;
        }
    }

    public record AccessoriesInventoryGroup(NonNullList<AccessoriesInventorySlot> normal, NonNullList<AccessoriesInventorySlot> cosmetic) {
        private void addAllNonEmptyToList(Collection<ItemStack> list) {
            for (AccessoriesInventorySlot slot : this.normal) {
                if (slot.stack.isEmpty()) continue;
                list.add(slot.stack.copy());
            }
            for (AccessoriesInventorySlot slot : this.cosmetic) {
                if (slot.stack.isEmpty()) continue;
                list.add(slot.stack.copy());
            }
        }
    }

    private static class AccessoriesCompatComponent
    extends CompatComponent<Map<String, AccessoriesInventoryGroup>> {
        public AccessoriesCompatComponent(ServerPlayer player) {
            super(player);
        }

        public AccessoriesCompatComponent(Map<String, AccessoriesInventoryGroup> inventory) {
            super(inventory);
        }

        @Override
        public Map<String, AccessoriesInventoryGroup> getInventory(ServerPlayer player) {
            HashMap<String, AccessoriesInventoryGroup> inventory = new HashMap<String, AccessoriesInventoryGroup>();
            AccessoriesCapability capability = AccessoriesCapability.get((LivingEntity)player);
            if (capability == null) {
                return inventory;
            }
            Map containers = capability.getContainers();
            for (Map.Entry entry : containers.entrySet()) {
                int i;
                NonNullList normalSlot = NonNullList.create();
                NonNullList cosmeticSlot = NonNullList.create();
                AccessoriesContainer container = (AccessoriesContainer)entry.getValue();
                ExpandedSimpleContainer normal = container.getAccessories();
                ExpandedSimpleContainer cosmetic = container.getCosmeticAccessories();
                for (i = 0; i < normal.getContainerSize(); ++i) {
                    normalSlot.add((Object)new AccessoriesInventorySlot(normal.getItem(i).copy(), com.b1n_ry.yigd.util.DropRule.PUT_IN_GRAVE, true));
                }
                for (i = 0; i < cosmetic.getContainerSize(); ++i) {
                    boolean shouldRender = container.shouldRender(i);
                    cosmeticSlot.add((Object)new AccessoriesInventorySlot(cosmetic.getItem(i).copy(), com.b1n_ry.yigd.util.DropRule.PUT_IN_GRAVE, shouldRender));
                }
                inventory.put((String)entry.getKey(), new AccessoriesInventoryGroup((NonNullList<AccessoriesInventorySlot>)normalSlot, (NonNullList<AccessoriesInventorySlot>)cosmeticSlot));
            }
            return inventory;
        }

        @Override
        public NonNullList<ItemStack> merge(CompatComponent<?> mergingComponent, ServerPlayer merger) {
            NonNullList extraItems = NonNullList.create();
            Map mergingInventory = (Map)mergingComponent.inventory;
            for (Map.Entry mergeEntry : mergingInventory.entrySet()) {
                ItemStack thisStack;
                AccessoriesInventorySlot currentSlot;
                ItemStack mergingStack;
                AccessoriesInventorySlot mergingSlot;
                int i;
                String key = (String)mergeEntry.getKey();
                if (!((Map)this.inventory).containsKey(key)) {
                    ((AccessoriesInventoryGroup)mergeEntry.getValue()).addAllNonEmptyToList((Collection<ItemStack>)extraItems);
                    continue;
                }
                AccessoriesInventoryGroup mergingGroup = (AccessoriesInventoryGroup)mergeEntry.getValue();
                AccessoriesInventoryGroup thisGroup = (AccessoriesInventoryGroup)((Map)this.inventory).get(key);
                for (i = 0; i < mergingGroup.normal.size(); ++i) {
                    mergingSlot = (AccessoriesInventorySlot)mergingGroup.normal.get(i);
                    mergingStack = mergingSlot.stack.copy();
                    if (mergingStack.isEmpty()) continue;
                    if (thisGroup.normal.size() <= i) {
                        extraItems.add((Object)mergingStack);
                        continue;
                    }
                    currentSlot = (AccessoriesInventorySlot)thisGroup.normal.get(i);
                    thisStack = currentSlot.stack;
                    if (YigdConfig.getConfig().graveConfig.treatBindingCurse && !AccessoriesAPI.canUnequip((ItemStack)mergingStack, (SlotReference)SlotReference.of((LivingEntity)merger, (String)key, (int)i))) {
                        extraItems.add((Object)currentSlot.stack);
                        thisGroup.normal.set(i, (Object)new AccessoriesInventorySlot(mergingStack, mergingSlot.dropRule, mergingSlot.visible));
                        continue;
                    }
                    if (!thisStack.isEmpty()) {
                        extraItems.add((Object)mergingStack);
                        continue;
                    }
                    thisGroup.normal.set(i, (Object)mergingSlot);
                }
                for (i = 0; i < mergingGroup.cosmetic.size(); ++i) {
                    mergingSlot = (AccessoriesInventorySlot)mergingGroup.cosmetic.get(i);
                    mergingStack = mergingSlot.stack.copy();
                    if (mergingStack.isEmpty()) continue;
                    if (thisGroup.cosmetic.size() <= i) {
                        extraItems.add((Object)mergingStack);
                        continue;
                    }
                    currentSlot = (AccessoriesInventorySlot)thisGroup.cosmetic.get(i);
                    thisStack = currentSlot.stack;
                    if (YigdConfig.getConfig().graveConfig.treatBindingCurse && !AccessoriesAPI.canUnequip((ItemStack)mergingStack, (SlotReference)SlotReference.of((LivingEntity)merger, (String)key, (int)i))) {
                        extraItems.add((Object)currentSlot.stack);
                        thisGroup.cosmetic.set(i, (Object)new AccessoriesInventorySlot(mergingStack, mergingSlot.dropRule, mergingSlot.visible));
                        continue;
                    }
                    if (!thisStack.isEmpty()) {
                        extraItems.add((Object)mergingStack);
                        continue;
                    }
                    thisGroup.cosmetic.set(i, (Object)mergingSlot);
                }
            }
            return extraItems;
        }

        @Override
        public NonNullList<ItemStack> pullBindingCurseItems(ServerPlayer playerRef) {
            NonNullList noUnequipItems = NonNullList.create();
            if (!YigdConfig.getConfig().graveConfig.treatBindingCurse) {
                return noUnequipItems;
            }
            for (Map.Entry entry : ((Map)this.inventory).entrySet()) {
                boolean isBound;
                ItemStack stack;
                AccessoriesInventorySlot slot;
                int i;
                AccessoriesInventoryGroup inventoryGroup = (AccessoriesInventoryGroup)entry.getValue();
                for (i = 0; i < inventoryGroup.normal.size(); ++i) {
                    slot = (AccessoriesInventorySlot)inventoryGroup.normal.get(i);
                    stack = slot.stack;
                    boolean bl = isBound = !AccessoriesAPI.canUnequip((ItemStack)stack, (SlotReference)SlotReference.of((LivingEntity)playerRef, (String)((String)entry.getKey()), (int)i));
                    if (!isBound) continue;
                    noUnequipItems.add((Object)stack);
                    slot.stack = ItemStack.EMPTY;
                }
                for (i = 0; i < inventoryGroup.cosmetic.size(); ++i) {
                    slot = (AccessoriesInventorySlot)inventoryGroup.cosmetic.get(i);
                    stack = slot.stack;
                    boolean bl = isBound = !AccessoriesAPI.canUnequip((ItemStack)stack, (SlotReference)SlotReference.of((LivingEntity)playerRef, (String)((String)entry.getKey()), (int)i));
                    if (!isBound) continue;
                    noUnequipItems.add((Object)stack);
                    slot.stack = ItemStack.EMPTY;
                }
            }
            return noUnequipItems;
        }

        @Override
        public NonNullList<ItemStack> storeToPlayer(ServerPlayer player) {
            NonNullList extraItems = NonNullList.create();
            AccessoriesCapability capability = AccessoriesCapability.get((LivingEntity)player);
            if (capability == null) {
                return extraItems;
            }
            Map containers = capability.getContainers();
            for (Map.Entry entry : ((Map)this.inventory).entrySet()) {
                AccessoriesInventorySlot slot;
                int i;
                String key = (String)entry.getKey();
                if (!containers.containsKey(key)) {
                    ((AccessoriesInventoryGroup)entry.getValue()).addAllNonEmptyToList((Collection<ItemStack>)extraItems);
                    continue;
                }
                AccessoriesContainer container = (AccessoriesContainer)containers.get(key);
                AccessoriesInventoryGroup inventorySlot = (AccessoriesInventoryGroup)entry.getValue();
                ExpandedSimpleContainer normalAccessories = container.getAccessories();
                ExpandedSimpleContainer cosmeticAccessories = container.getCosmeticAccessories();
                for (i = 0; i < inventorySlot.normal.size(); ++i) {
                    slot = (AccessoriesInventorySlot)inventorySlot.normal.get(i);
                    if (slot.stack.isEmpty()) continue;
                    if (i >= normalAccessories.getContainerSize()) {
                        extraItems.add((Object)slot.stack.copy());
                        continue;
                    }
                    normalAccessories.setItem(i, slot.stack.copy());
                }
                for (i = 0; i < inventorySlot.cosmetic.size(); ++i) {
                    slot = (AccessoriesInventorySlot)inventorySlot.cosmetic.get(i);
                    if (slot.stack.isEmpty()) continue;
                    if (i >= cosmeticAccessories.getContainerSize()) {
                        extraItems.add((Object)slot.stack.copy());
                        continue;
                    }
                    cosmeticAccessories.setItem(i, slot.stack.copy());
                    container.renderOptions().set(i, slot.visible);
                    container.markChanged(false);
                }
            }
            return extraItems;
        }

        @Override
        public void handleDropRules(DeathContext context) {
            for (Map.Entry entry : ((Map)this.inventory).entrySet()) {
                com.b1n_ry.yigd.util.DropRule defaultDropRule;
                ItemStack stack;
                int i;
                String key = (String)entry.getKey();
                AccessoriesInventoryGroup inventorySlot = (AccessoriesInventoryGroup)entry.getValue();
                for (i = 0; i < inventorySlot.normal.size(); ++i) {
                    AccessoriesInventorySlot slot = (AccessoriesInventorySlot)inventorySlot.normal.get(i);
                    stack = slot.stack;
                    slot.dropRule = switch (AccessoriesAPI.getOrDefaultAccessory((ItemStack)stack).getDropRule(stack, SlotReference.of((LivingEntity)context.player(), (String)key, (int)i), context.deathSource())) {
                        case DropRule.DESTROY -> com.b1n_ry.yigd.util.DropRule.DESTROY;
                        case DropRule.KEEP -> com.b1n_ry.yigd.util.DropRule.KEEP;
                        default -> {
                            defaultDropRule = YigdConfig.getConfig().compatConfig.defaultAccessoriesDropRule;
                            if (defaultDropRule == com.b1n_ry.yigd.util.DropRule.PUT_IN_GRAVE) {
                                yield ((YigdEvents.DropRuleEvent)NeoForge.EVENT_BUS.post((Event)new YigdEvents.DropRuleEvent(stack, -1, context, true))).getDropRule();
                            }
                            yield defaultDropRule;
                        }
                    };
                }
                for (i = 0; i < inventorySlot.cosmetic.size(); ++i) {
                    AccessoriesInventorySlot pair = (AccessoriesInventorySlot)inventorySlot.cosmetic.get(i);
                    stack = pair.stack;
                    pair.dropRule = switch (AccessoriesAPI.getOrDefaultAccessory((ItemStack)stack).getDropRule(stack, SlotReference.of((LivingEntity)context.player(), (String)key, (int)i), context.deathSource())) {
                        case DropRule.DESTROY -> com.b1n_ry.yigd.util.DropRule.DESTROY;
                        case DropRule.KEEP -> com.b1n_ry.yigd.util.DropRule.KEEP;
                        default -> {
                            defaultDropRule = YigdConfig.getConfig().compatConfig.defaultAccessoriesDropRule;
                            if (defaultDropRule == com.b1n_ry.yigd.util.DropRule.PUT_IN_GRAVE) {
                                yield ((YigdEvents.DropRuleEvent)NeoForge.EVENT_BUS.post((Event)new YigdEvents.DropRuleEvent(stack, -1, context, true))).getDropRule();
                            }
                            yield defaultDropRule;
                        }
                    };
                }
            }
        }

        @Override
        public NonNullList<Tuple<ItemStack, com.b1n_ry.yigd.util.DropRule>> getAsStackDropList() {
            NonNullList allItems = NonNullList.create();
            for (AccessoriesInventoryGroup group : ((Map)this.inventory).values()) {
                for (AccessoriesInventorySlot slot : group.normal) {
                    allItems.add((Object)new Tuple((Object)slot.stack, (Object)slot.dropRule));
                }
                for (AccessoriesInventorySlot slot : group.cosmetic) {
                    allItems.add((Object)new Tuple((Object)slot.stack, (Object)slot.dropRule));
                }
            }
            return allItems;
        }

        @Override
        public CompatComponent<Map<String, AccessoriesInventoryGroup>> filterInv(Predicate<com.b1n_ry.yigd.util.DropRule> predicate) {
            HashMap<String, AccessoriesInventoryGroup> filtered = new HashMap<String, AccessoriesInventoryGroup>();
            for (Map.Entry entry : ((Map)this.inventory).entrySet()) {
                AccessoriesInventoryGroup inventorySlot = (AccessoriesInventoryGroup)entry.getValue();
                NonNullList normalSlot = NonNullList.create();
                NonNullList cosmeticSlot = NonNullList.create();
                for (AccessoriesInventorySlot slot : inventorySlot.normal) {
                    if (predicate.test(slot.dropRule)) {
                        normalSlot.add((Object)slot);
                        continue;
                    }
                    normalSlot.add((Object)AccessoriesInventorySlot.EMPTY);
                }
                for (AccessoriesInventorySlot slot : inventorySlot.cosmetic) {
                    if (predicate.test(slot.dropRule)) {
                        cosmeticSlot.add((Object)slot);
                        continue;
                    }
                    cosmeticSlot.add((Object)AccessoriesInventorySlot.EMPTY);
                }
                filtered.put((String)entry.getKey(), new AccessoriesInventoryGroup((NonNullList<AccessoriesInventorySlot>)normalSlot, (NonNullList<AccessoriesInventorySlot>)cosmeticSlot));
            }
            return new AccessoriesCompatComponent((Map<String, AccessoriesInventoryGroup>)filtered);
        }

        @Override
        public boolean removeItem(Predicate<ItemStack> predicate, int itemCount) {
            for (AccessoriesInventoryGroup inventorySlot : ((Map)this.inventory).values()) {
                for (AccessoriesInventorySlot slot : inventorySlot.normal) {
                    ItemStack stack = slot.stack;
                    if (!predicate.test(stack)) continue;
                    stack.shrink(itemCount);
                    return true;
                }
            }
            return false;
        }

        @Override
        public void clear() {
            for (AccessoriesInventoryGroup inventorySlot : ((Map)this.inventory).values()) {
                Collections.fill(inventorySlot.normal, AccessoriesInventorySlot.EMPTY);
                Collections.fill(inventorySlot.cosmetic, AccessoriesInventorySlot.EMPTY);
            }
        }

        @Override
        public CompoundTag writeNbt(HolderLookup.Provider registryLookup) {
            CompoundTag nbt = new CompoundTag();
            for (Map.Entry entry : ((Map)this.inventory).entrySet()) {
                AccessoriesInventoryGroup inventorySlot = (AccessoriesInventoryGroup)entry.getValue();
                CompoundTag slotNbt = new CompoundTag();
                CompoundTag normalNbt = InventoryComponent.listToNbt(inventorySlot.normal, slot -> {
                    CompoundTag itemNbt = (CompoundTag)slot.stack.save(registryLookup);
                    itemNbt.putString("dropRule", slot.dropRule.name());
                    itemNbt.putBoolean("visible", slot.visible);
                    return itemNbt;
                }, slot -> slot.stack.isEmpty());
                CompoundTag cosmeticNbt = InventoryComponent.listToNbt(inventorySlot.cosmetic, slot -> {
                    CompoundTag itemNbt = (CompoundTag)slot.stack.save(registryLookup);
                    itemNbt.putString("dropRule", slot.dropRule.name());
                    itemNbt.putBoolean("visible", slot.visible);
                    return itemNbt;
                }, slot -> slot.stack.isEmpty());
                slotNbt.put("normal", (Tag)normalNbt);
                slotNbt.put("cosmetic", (Tag)cosmeticNbt);
                nbt.put((String)entry.getKey(), (Tag)slotNbt);
            }
            return nbt;
        }
    }
}

