/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.waystones.item;

import java.util.List;
import net.blay09.mods.waystones.api.Waystone;
import net.blay09.mods.waystones.api.WaystonesAPI;
import net.blay09.mods.waystones.block.entity.WaystoneBlockEntityBase;
import net.blay09.mods.waystones.item.ModItems;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.entity.BlockEntity;

public class BlankScrollItem
extends Item {
    public BlankScrollItem(Item.Properties properties) {
        super(properties.stacksTo(64));
    }

    public InteractionResult useOn(UseOnContext context) {
        BlockEntity blockEntity = context.getLevel().getBlockEntity(context.getClickedPos());
        if (blockEntity instanceof WaystoneBlockEntityBase) {
            WaystoneBlockEntityBase waystoneBlockEntityBase = (WaystoneBlockEntityBase)blockEntity;
            Waystone waystone = waystoneBlockEntityBase.getWaystone();
            ItemStack boundScrollStack = new ItemStack((ItemLike)ModItems.boundScroll);
            WaystonesAPI.setBoundWaystone(boundScrollStack, waystone);
            Player player = context.getPlayer();
            int emptySlot = player.getInventory().getFreeSlot();
            int stackableSlot = player.getInventory().getSlotWithRemainingSpace(boundScrollStack);
            if (emptySlot != -1 || stackableSlot != -1 || !player.hasInfiniteMaterials() && context.getItemInHand().getCount() == 1) {
                context.getItemInHand().consume(1, (LivingEntity)player);
                if (!player.addItem(boundScrollStack)) {
                    player.drop(boundScrollStack, false);
                }
                return InteractionResult.SUCCESS;
            }
            return InteractionResult.FAIL;
        }
        return super.useOn(context);
    }

    public void appendHoverText(ItemStack itemStack, Item.TooltipContext context, List<Component> list, TooltipFlag flag) {
        list.add((Component)Component.translatable((String)"tooltip.waystones.blank_scroll").withStyle(ChatFormatting.GRAY));
    }
}

