/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.waystones.compat;

import java.util.ArrayList;
import java.util.List;
import net.blay09.mods.balm.api.Balm;
import net.blay09.mods.waystones.api.Waystone;
import net.blay09.mods.waystones.api.WaystoneTypes;
import net.blay09.mods.waystones.api.event.WaystoneInitializedEvent;
import net.blay09.mods.waystones.api.event.WaystoneRemovedEvent;
import net.blay09.mods.waystones.api.event.WaystoneUpdatedEvent;
import net.blay09.mods.waystones.api.event.WaystonesLoadedEvent;
import net.minecraft.resources.ResourceLocation;
import org.dynmap.DynmapCommonAPI;
import org.dynmap.DynmapCommonAPIListener;
import org.dynmap.markers.Marker;
import org.dynmap.markers.MarkerSet;

public class DynmapIntegration
extends DynmapCommonAPIListener {
    private final List<Runnable> scheduledJobsWhenReady = new ArrayList<Runnable>();
    private DynmapCommonAPI api;
    private MarkerSet waystoneMarkers;
    private MarkerSet sharestoneMarkers;

    private void prepareMarkerSets() {
        if (this.waystoneMarkers == null) {
            this.waystoneMarkers = this.api.getMarkerAPI().createMarkerSet("waystones:waystones", "Waystones", null, false);
        }
        if (this.sharestoneMarkers == null) {
            this.sharestoneMarkers = this.api.getMarkerAPI().createMarkerSet("waystones:sharestones", "Sharestones", null, false);
        }
    }

    public void createFromWaystones(List<Waystone> waystones) {
        if (this.waystoneMarkers != null) {
            this.waystoneMarkers.deleteMarkerSet();
        }
        if (this.sharestoneMarkers != null) {
            this.sharestoneMarkers.deleteMarkerSet();
        }
        this.prepareMarkerSets();
        for (Waystone waystone : waystones) {
            this.addWaystoneMarker(waystone);
        }
    }

    public void addWaystoneMarker(Waystone waystone) {
        this.prepareMarkerSets();
        MarkerSet markerSet = WaystoneTypes.isSharestone(waystone.getWaystoneType()) ? this.sharestoneMarkers : this.waystoneMarkers;
        DynmapIntegration.createWaystoneMarker(markerSet, waystone);
    }

    public void removeWaystoneMarker(Waystone waystone) {
        if (this.waystoneMarkers != null) {
            return;
        }
        String markerId = DynmapIntegration.getMarkerId(waystone);
        Marker marker = this.waystoneMarkers.findMarker(markerId);
        if (marker != null) {
            marker.deleteMarker();
        }
    }

    public DynmapIntegration() {
        DynmapCommonAPIListener.register((DynmapCommonAPIListener)this);
        Balm.getEvents().onEvent(WaystonesLoadedEvent.class, this::onWaystonesLoaded);
        Balm.getEvents().onEvent(WaystoneInitializedEvent.class, this::onWaystoneInitialized);
        Balm.getEvents().onEvent(WaystoneUpdatedEvent.class, this::onWaystoneUpdated);
        Balm.getEvents().onEvent(WaystoneRemovedEvent.class, this::onWaystoneRemoved);
    }

    public void apiEnabled(DynmapCommonAPI api) {
        this.api = api;
        for (Runnable scheduledJob : this.scheduledJobsWhenReady) {
            scheduledJob.run();
        }
        this.scheduledJobsWhenReady.clear();
    }

    public void apiDisabled(DynmapCommonAPI api) {
        this.api = null;
    }

    private void onWaystoneInitialized(WaystoneInitializedEvent event) {
        this.runWhenDynmapIsReady(() -> this.addWaystoneMarker(event.getWaystone()));
    }

    private void onWaystoneUpdated(WaystoneUpdatedEvent event) {
        this.runWhenDynmapIsReady(() -> this.addWaystoneMarker(event.getWaystone()));
    }

    private void onWaystoneRemoved(WaystoneRemovedEvent event) {
        this.runWhenDynmapIsReady(() -> this.removeWaystoneMarker(event.getWaystone()));
    }

    private void onWaystonesLoaded(WaystonesLoadedEvent event) {
        List<Waystone> waystones = event.getWaystoneManager().getWaystones().filter(DynmapIntegration::isSupportedWaystoneType).toList();
        this.runWhenDynmapIsReady(() -> this.createFromWaystones(waystones));
    }

    public static String getMarkerId(Waystone waystone) {
        return waystone.getWaystoneUid().toString();
    }

    public static Marker createWaystoneMarker(MarkerSet markerSet, Waystone waystone) {
        return markerSet.createMarker(DynmapIntegration.getMarkerId(waystone), waystone.getName().getString(), false, DynmapIntegration.getDynmapWorldName(waystone.getDimension().location()), (double)waystone.getPos().getX(), (double)waystone.getPos().getY(), (double)waystone.getPos().getZ(), markerSet.getDefaultMarkerIcon(), false);
    }

    private static String getDynmapWorldName(ResourceLocation id) {
        return switch (id.toString()) {
            case "minecraft:overworld" -> Balm.getHooks().getServer().getWorldData().getLevelName();
            case "minecraft:the_nether" -> "DIM-1";
            case "minecraft:the_end" -> "DIM1";
            default -> id.getNamespace() + "_" + id.getPath();
        };
    }

    private static boolean isSupportedWaystoneType(Waystone waystone) {
        return DynmapIntegration.isSupportedWaystoneType(waystone.getWaystoneType());
    }

    private static boolean isSupportedWaystoneType(ResourceLocation waystoneType) {
        return waystoneType.equals((Object)WaystoneTypes.WAYSTONE) || WaystoneTypes.isSharestone(waystoneType);
    }

    private void runWhenDynmapIsReady(Runnable runnable) {
        if (this.api != null) {
            runnable.run();
        } else {
            this.scheduledJobsWhenReady.add(runnable);
        }
    }
}

