/*
 * Decompiled with CFR 0.152.
 */
package net.swedz.tesseract.neoforge.helper.guigraphics;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.texture.MissingTextureAtlasSprite;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FormattedCharSequence;
import net.swedz.tesseract.neoforge.api.Assert;
import net.swedz.tesseract.neoforge.helper.guigraphics.BlitGuiGraphics;
import net.swedz.tesseract.neoforge.helper.guigraphics.DrawAction;
import net.swedz.tesseract.neoforge.helper.guigraphics.FillGuiGraphics;
import net.swedz.tesseract.neoforge.helper.guigraphics.GuiGraphicsBatch;
import net.swedz.tesseract.neoforge.helper.guigraphics.ItemGuiGraphics;
import net.swedz.tesseract.neoforge.helper.guigraphics.StringGuiGraphics;
import net.swedz.tesseract.neoforge.helper.guigraphics.TextureShaderConfiguration;
import net.swedz.tesseract.neoforge.helper.guigraphics.TooltipGuiGraphics;
import org.jetbrains.annotations.ApiStatus;

public final class TesseractGuiGraphics
implements BlitGuiGraphics,
FillGuiGraphics,
StringGuiGraphics,
TooltipGuiGraphics,
ItemGuiGraphics {
    private final TesseractGuiGraphics parent;
    private final GuiGraphics internal;
    private boolean batching;
    private List<Integer> batchOrder = Lists.newArrayList();
    private Map<Integer, Batch> batches = Maps.newHashMap();
    private List<Runnable> delayedRenders = Lists.newArrayList();
    private int[] color = new int[]{255, 255, 255, 255};
    private int[] lastColor = new int[]{255, 255, 255, 255};
    private TextureShaderConfiguration textureShader = TextureShaderConfiguration.DEFAULT;
    private ResourceLocation[] textures = new ResourceLocation[]{MissingTextureAtlasSprite.getLocation()};
    private List<DrawAction> textureBatch;
    private Font font;
    private boolean textDropShadow;
    private boolean tooltipFirstLinePadded;
    private TooltipGuiGraphics.BackgroundPadding tooltipBackgroundPadding;

    private TesseractGuiGraphics(TesseractGuiGraphics parent, GuiGraphics internal) {
        this.font = Minecraft.getInstance().font;
        this.textDropShadow = true;
        this.tooltipFirstLinePadded = true;
        this.tooltipBackgroundPadding = new TooltipGuiGraphics.BackgroundPadding();
        this.parent = parent;
        this.internal = internal;
    }

    public TesseractGuiGraphics(GuiGraphics internal) {
        this(null, internal);
    }

    @Override
    @Deprecated
    public GuiGraphics internal() {
        return this.internal;
    }

    @Override
    public int guiWidth() {
        return this.internal.guiWidth();
    }

    @Override
    public int guiHeight() {
        return this.internal.guiHeight();
    }

    public PoseStack pose() {
        return this.internal.pose();
    }

    public MultiBufferSource.BufferSource bufferSource() {
        return this.internal.bufferSource();
    }

    public void reset() {
        this.resetColor();
        this.resetTextureShader();
        this.resetTooltipBackgroundPadding();
    }

    public TesseractGuiGraphics inner() {
        return new TesseractGuiGraphics(this, this.internal);
    }

    public TesseractGuiGraphics end() {
        Assert.notNull((Object)this.parent, "Cannot close outermost graphic instance");
        if (this.batching) {
            this.parent.delayed(this::drawBatches);
        }
        return this.parent;
    }

    public void enableBatching() {
        this.batching = true;
    }

    private void disableBatching() {
        this.batching = false;
        this.batchOrder = Lists.newArrayList();
        this.batches = Maps.newHashMap();
        this.delayedRenders = Lists.newArrayList();
    }

    public void drawBatches() {
        Assert.that(this.batching, "Batching has not been enabled");
        this.batching = false;
        for (Integer texture : this.batchOrder) {
            Batch batchInstance = this.batches.get(texture);
            List<DrawAction> draws = batchInstance.draws();
            if (draws.isEmpty()) continue;
            TextureShaderConfiguration shader = batchInstance.shader();
            GuiGraphicsBatch batch = GuiGraphicsBatch.start(this.internal, batchInstance.textures(), shader.shader(), shader.mode(), shader.format(), shader.extraSetup());
            for (DrawAction draw : draws) {
                draw.addVertexes(batch);
            }
            batch.end();
        }
        for (Runnable render : this.delayedRenders) {
            render.run();
        }
        this.disableBatching();
    }

    @Override
    public int[] getColor() {
        return this.color;
    }

    @Override
    public void setColorInt(int red, int green, int blue, int alpha) {
        this.lastColor = this.color;
        this.color = new int[]{red, green, blue, alpha};
    }

    @Override
    public void revertColor() {
        this.color = this.lastColor;
        this.lastColor = new int[]{255, 255, 255, 255};
    }

    @Override
    public TextureShaderConfiguration getTextureShader() {
        return this.textureShader;
    }

    @Override
    public void setTextureShader(TextureShaderConfiguration textureShader) {
        if (textureShader == null) {
            textureShader = TextureShaderConfiguration.DEFAULT;
        }
        this.textureShader = textureShader;
    }

    @Override
    public ResourceLocation[] getTextures() {
        return this.textures;
    }

    @Override
    public void setTextures(ResourceLocation ... textures) {
        if (textures == null) {
            textures = new ResourceLocation[]{MissingTextureAtlasSprite.getLocation()};
        } else {
            for (int i = 0; i < textures.length; ++i) {
                if (textures[i] != null) continue;
                textures[i] = MissingTextureAtlasSprite.getLocation();
            }
        }
        this.textures = textures;
        this.textureBatch = null;
    }

    private void addToTextureBatch(DrawAction draw) {
        Assert.that(this.batching, "Batching has not been enabled");
        if (this.textureBatch == null) {
            List<Object> draws;
            int textureIndex = Arrays.hashCode(this.textures);
            Batch batchInstance = this.batches.get(textureIndex);
            if (batchInstance == null) {
                draws = Lists.newArrayList();
                this.batchOrder.add(textureIndex);
                this.batches.put(textureIndex, new Batch(this.textures, this.textureShader, draws));
            } else {
                draws = batchInstance.draws();
            }
            this.textureBatch = draws;
        }
        this.textureBatch.add(draw);
    }

    @Override
    public Font getFont() {
        return this.font;
    }

    @Override
    public void setFont(Font font) {
        if (font == null) {
            font = Minecraft.getInstance().font;
        }
        this.font = font;
    }

    @Override
    public boolean isStringDropShadow() {
        return this.textDropShadow;
    }

    @Override
    public void setStringDropShadow(boolean textDropShadow) {
        this.textDropShadow = textDropShadow;
    }

    @Override
    public boolean isTooltipFirstLinePadded() {
        return this.tooltipFirstLinePadded;
    }

    @Override
    public void setTooltipFirstLinePadded(boolean padded) {
        this.tooltipFirstLinePadded = padded;
    }

    @Override
    public TooltipGuiGraphics.BackgroundPadding getTooltipBackgroundPadding() {
        return this.tooltipBackgroundPadding;
    }

    @Override
    public void setTooltipBackgroundPadding(TooltipGuiGraphics.BackgroundPadding padding) {
        this.tooltipBackgroundPadding = padding;
    }

    public void delayed(Runnable runnable) {
        if (this.batching) {
            this.delayedRenders.add(runnable);
        } else {
            runnable.run();
        }
    }

    @Override
    @ApiStatus.Internal
    public void innerBlit(int x1, int x2, int y1, int y2, int blitOffset, float minU, float maxU, float minV, float maxV) {
        int red = this.color[0];
        int green = this.color[1];
        int blue = this.color[2];
        int alpha = this.color[3];
        DrawAction draw = (pose, buffer) -> {
            buffer.addVertex(pose, (float)x1, (float)y1, (float)blitOffset).setUv(minU, minV).setColor(red, green, blue, alpha);
            buffer.addVertex(pose, (float)x1, (float)y2, (float)blitOffset).setUv(minU, maxV).setColor(red, green, blue, alpha);
            buffer.addVertex(pose, (float)x2, (float)y2, (float)blitOffset).setUv(maxU, maxV).setColor(red, green, blue, alpha);
            buffer.addVertex(pose, (float)x2, (float)y1, (float)blitOffset).setUv(maxU, minV).setColor(red, green, blue, alpha);
        };
        if (this.batching) {
            this.addToTextureBatch(draw);
        } else {
            GuiGraphicsBatch batch = GuiGraphicsBatch.start(this.internal, this.textures, this.textureShader.shader(), this.textureShader.mode(), this.textureShader.format(), this.textureShader.extraSetup());
            draw.addVertexes(batch);
            batch.end();
        }
    }

    @Override
    public void fill(RenderType renderType, int minX, int minY, int maxX, int maxY, int z) {
        int color = this.getColorARGB();
        this.delayed(() -> this.internal.fill(renderType, minX, minY, maxX, maxY, z, color));
    }

    @Override
    public int drawString(String text, float x, float y) {
        return this.internal.drawString(this.font, text, x, y, this.getColorARGB(), this.isStringDropShadow());
    }

    @Override
    public int drawString(FormattedCharSequence text, float x, float y) {
        return this.internal.drawString(this.font, text, x, y, this.getColorARGB(), this.isStringDropShadow());
    }

    private record Batch(ResourceLocation[] textures, TextureShaderConfiguration shader, List<DrawAction> draws) {
    }
}

