/*
 * Decompiled with CFR 0.152.
 */
package net.swedz.tesseract.neoforge.api;

import java.util.Objects;

public final class Assert {
    public static void that(boolean bool, String message, ThrowableSupplier throwable) {
        if (!bool) {
            throw throwable.apply(message);
        }
    }

    public static void that(boolean bool, String message) {
        Assert.that(bool, message, IllegalArgumentException::new);
    }

    public static void that(boolean bool, ThrowableSupplier throwable) {
        Assert.that(bool, null, throwable);
    }

    public static void that(boolean bool) {
        Assert.that(bool, (String)null);
    }

    public static void notNull(Object object, String message, ThrowableSupplier throwable) {
        Assert.that(object != null, message, throwable);
    }

    public static void notNull(Object object, String message) {
        Assert.notNull(object != null, message, NullPointerException::new);
    }

    public static void notNull(Object object, ThrowableSupplier throwable) {
        Assert.notNull(object, null, throwable);
    }

    public static void notNull(Object object) {
        Assert.notNull(object, (String)null);
    }

    public static void noneNull(Object ... objects) {
        for (Object object : objects) {
            Assert.that(object != null, null, NullPointerException::new);
        }
    }

    public static void equals(Object a, Object b, String message, ThrowableSupplier throwable) {
        Assert.that(Objects.equals(a, b), message, throwable);
    }

    public static void equals(Object a, Object b, String message) {
        Assert.equals(a, b, message, IllegalArgumentException::new);
    }

    public static void equals(Object a, Object b, ThrowableSupplier throwable) {
        Assert.equals(a, b, null, throwable);
    }

    public static void equals(Object a, Object b) {
        Assert.equals(a, b, (String)null);
    }

    public static interface ThrowableSupplier {
        public RuntimeException apply(String var1);
    }
}

