/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.tesseract.manager;

import com.supermartijn642.core.ClientUtils;
import com.supermartijn642.core.CommonUtils;
import com.supermartijn642.tesseract.EnumChannelType;
import com.supermartijn642.tesseract.Tesseract;
import com.supermartijn642.tesseract.TesseractBlockEntity;
import com.supermartijn642.tesseract.manager.Channel;
import com.supermartijn642.tesseract.manager.TesseractChannelManager;
import com.supermartijn642.tesseract.manager.TesseractTracker;
import java.lang.ref.WeakReference;
import java.util.EnumMap;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;

public class TesseractReference {
    private final long index;
    private final String dimension;
    private final BlockPos pos;
    private final boolean isClientSide;
    private final EnumMap<EnumChannelType, Integer> channels = new EnumMap(EnumChannelType.class);
    private final EnumMap<EnumChannelType, Boolean> canSend = new EnumMap(EnumChannelType.class);
    private final EnumMap<EnumChannelType, Boolean> canReceive = new EnumMap(EnumChannelType.class);
    private WeakReference<TesseractBlockEntity> entity;

    TesseractReference(long index, TesseractBlockEntity entity) {
        this.index = index;
        this.dimension = entity.getLevel().dimension().location().toString();
        this.pos = entity.getBlockPos();
        this.isClientSide = entity.getLevel().isClientSide;
        for (EnumChannelType type : EnumChannelType.values()) {
            this.channels.put(type, -1);
            this.canSend.put(type, entity.canSend(type));
            this.canReceive.put(type, entity.canReceive(type));
        }
    }

    public TesseractReference(long index, CompoundTag tag, boolean isClientSide) {
        this.index = index;
        this.dimension = tag.getString("dim");
        this.pos = new BlockPos(tag.getInt("posx"), tag.getInt("posy"), tag.getInt("posz"));
        this.isClientSide = isClientSide;
        for (EnumChannelType type : EnumChannelType.values()) {
            this.channels.put(type, tag.getInt(String.valueOf((Object)type) + "_channel"));
            this.canSend.put(type, tag.getBoolean(String.valueOf((Object)type) + "_canSend"));
            this.canReceive.put(type, tag.getBoolean(String.valueOf((Object)type) + "_canReceive"));
        }
    }

    public long getSaveIndex() {
        return this.index;
    }

    public String getDimension() {
        return this.dimension;
    }

    public Level getLevel() {
        if (this.isClientSide) {
            return ClientUtils.getWorld().dimension().location().toString().equals(this.dimension) ? ClientUtils.getWorld() : null;
        }
        ResourceKey key = ResourceKey.create((ResourceKey)Registries.DIMENSION, (ResourceLocation)ResourceLocation.parse((String)this.dimension));
        return CommonUtils.getLevel((ResourceKey)key);
    }

    public BlockPos getPos() {
        return this.pos;
    }

    public boolean isValid() {
        boolean isValid;
        Level level = this.getLevel();
        boolean bl = isValid = level != null && level.getBlockState(this.pos).getBlock() == Tesseract.tesseract && level.getBlockEntity(this.pos) instanceof TesseractBlockEntity;
        if (!isValid && !this.isClientSide) {
            TesseractTracker.SERVER.remove(this.dimension, this.pos);
        }
        return isValid;
    }

    public boolean canBeAccessed() {
        Level level = this.getLevel();
        return level != null && this.getLevel().isLoaded(this.pos) && this.isValid();
    }

    public TesseractBlockEntity getTesseract() {
        if (this.entity == null || this.entity.get() == null || ((TesseractBlockEntity)((Object)this.entity.get())).isRemoved() || !((TesseractBlockEntity)((Object)this.entity.get())).getBlockPos().equals((Object)this.pos)) {
            BlockEntity entity = this.getLevel().getBlockEntity(this.pos);
            this.entity = entity instanceof TesseractBlockEntity ? new WeakReference<TesseractBlockEntity>((TesseractBlockEntity)entity) : null;
        }
        return this.entity == null ? null : (TesseractBlockEntity)((Object)this.entity.get());
    }

    public CompoundTag write() {
        CompoundTag compound = new CompoundTag();
        compound.putString("dim", this.dimension);
        compound.putInt("posx", this.pos.getX());
        compound.putInt("posy", this.pos.getY());
        compound.putInt("posz", this.pos.getZ());
        for (EnumChannelType type : EnumChannelType.values()) {
            compound.putInt(String.valueOf((Object)type) + "_channel", this.channels.get((Object)type).intValue());
            compound.putBoolean(String.valueOf((Object)type) + "_canSend", this.canSend.get((Object)type).booleanValue());
            compound.putBoolean(String.valueOf((Object)type) + "_canReceive", this.canReceive(type));
        }
        return compound;
    }

    public boolean canSend(EnumChannelType type) {
        return this.canSend.get((Object)type);
    }

    public boolean canReceive(EnumChannelType type) {
        return this.canReceive.get((Object)type);
    }

    public int getChannelId(EnumChannelType type) {
        return this.channels.get((Object)type);
    }

    public Channel getChannel(EnumChannelType type) {
        if (this.channels.get((Object)type) < 0) {
            return null;
        }
        Channel channel = TesseractChannelManager.getInstance(this.isClientSide).getChannelById(type, this.channels.get((Object)type));
        if (channel == null && !this.isClientSide) {
            this.channels.put(type, -1);
            this.markDirty();
            if (this.canBeAccessed()) {
                this.getTesseract().channelChanged(type);
            }
        }
        return channel;
    }

    public void setChannel(EnumChannelType type, int channel) {
        Channel newChannel;
        if (channel == this.channels.get((Object)type)) {
            return;
        }
        Channel oldChannel = this.getChannel(type);
        this.channels.put(type, channel);
        if (oldChannel != null) {
            oldChannel.removeTesseract(this);
        }
        if ((newChannel = this.getChannel(type)) != null) {
            newChannel.addTesseract(this);
        }
        this.markDirty();
        if (this.canBeAccessed()) {
            this.getTesseract().channelChanged(type);
        }
    }

    public void update(TesseractBlockEntity entity) {
        for (EnumChannelType type : EnumChannelType.values()) {
            boolean canReceive;
            boolean changed = false;
            boolean canSend = entity.canSend(type);
            if (canSend != this.canSend.put(type, canSend)) {
                changed = true;
            }
            if ((canReceive = entity.canReceive(type)) != this.canReceive.put(type, canReceive)) {
                changed = true;
            }
            if (!changed) continue;
            Channel channel = this.getChannel(type);
            if (channel != null) {
                channel.updateTesseract(this);
            }
            this.markDirty();
        }
    }

    private void markDirty() {
        if (!this.isClientSide) {
            TesseractTracker.SERVER.markDirty(this);
        }
    }

    void delete() {
        for (EnumChannelType type : EnumChannelType.values()) {
            Channel channel = this.getChannel(type);
            if (channel == null) continue;
            channel.removeTesseract(this);
        }
    }

    public boolean equals(Object o) {
        return this == o;
    }

    public int hashCode() {
        int result = this.dimension.hashCode();
        result = 31 * result + (this.pos != null ? this.pos.hashCode() : 0);
        return result;
    }
}

