/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.tesseract;

import com.supermartijn642.core.block.BaseBlockEntity;
import com.supermartijn642.tesseract.EnumChannelType;
import com.supermartijn642.tesseract.RedstoneState;
import com.supermartijn642.tesseract.Tesseract;
import com.supermartijn642.tesseract.TransferState;
import com.supermartijn642.tesseract.manager.Channel;
import com.supermartijn642.tesseract.manager.TesseractReference;
import com.supermartijn642.tesseract.manager.TesseractTracker;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.capabilities.BlockCapability;
import net.neoforged.neoforge.capabilities.BlockCapabilityCache;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.energy.IEnergyStorage;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;
import net.neoforged.neoforge.items.IItemHandler;

public class TesseractBlockEntity
extends BaseBlockEntity {
    private TesseractReference reference;
    private final EnumMap<EnumChannelType, TransferState> transferState = new EnumMap(EnumChannelType.class);
    private final EnumMap<EnumChannelType, Object> capabilities = new EnumMap(EnumChannelType.class);
    private RedstoneState redstoneState = RedstoneState.DISABLED;
    private boolean redstone;
    public int recurrentCalls = 0;
    private final Map<Direction, Map<EnumChannelType, BlockCapabilityCache<?, Direction>>> surroundingCapabilities = new HashMap();

    public TesseractBlockEntity(BlockPos pos, BlockState state) {
        super(Tesseract.tesseract_tile, pos, state);
        for (EnumChannelType enumChannelType : EnumChannelType.values()) {
            this.transferState.put(enumChannelType, TransferState.BOTH);
        }
        for (EnumChannelType enumChannelType : Direction.values()) {
            this.surroundingCapabilities.put((Direction)enumChannelType, new EnumMap(EnumChannelType.class));
        }
    }

    public TesseractReference getReference() {
        if (this.reference == null) {
            this.reference = TesseractTracker.getInstance(this.level).add(this);
        }
        return this.reference;
    }

    public void invalidateReference() {
        this.reference = null;
    }

    public void channelChanged(EnumChannelType type) {
        this.capabilities.remove((Object)type);
        this.invalidateCapabilities();
        this.notifyNeighbors();
    }

    public boolean renderOn() {
        return !this.isBlockedByRedstone();
    }

    public IItemHandler getItemCapability() {
        return (IItemHandler)this.capabilities.computeIfAbsent(EnumChannelType.ITEMS, o -> {
            Channel channel = this.getChannel(EnumChannelType.ITEMS);
            return channel == null ? null : channel.getItemHandler(this);
        });
    }

    public IFluidHandler getFluidCapability() {
        return (IFluidHandler)this.capabilities.computeIfAbsent(EnumChannelType.FLUID, o -> {
            Channel channel = this.getChannel(EnumChannelType.FLUID);
            return channel == null ? null : channel.getFluidHandler(this);
        });
    }

    public IEnergyStorage getEnergyCapability() {
        return (IEnergyStorage)this.capabilities.computeIfAbsent(EnumChannelType.ENERGY, o -> {
            Channel channel = this.getChannel(EnumChannelType.ENERGY);
            return channel == null ? null : channel.getEnergyStorage(this);
        });
    }

    public List<IItemHandler> getSurroundingItemCapabilities() {
        return this.getSurroundingCapabilities(EnumChannelType.ITEMS);
    }

    public List<IFluidHandler> getSurroundingFluidCapabilities() {
        return this.getSurroundingCapabilities(EnumChannelType.FLUID);
    }

    public List<IEnergyStorage> getSurroundingEnergyCapabilities() {
        return this.getSurroundingCapabilities(EnumChannelType.ENERGY);
    }

    private <T> List<T> getSurroundingCapabilities(EnumChannelType type) {
        if (this.level == null) {
            return Collections.emptyList();
        }
        BlockCapability capability = switch (type) {
            default -> throw new MatchException(null, null);
            case EnumChannelType.ITEMS -> Capabilities.ItemHandler.BLOCK;
            case EnumChannelType.FLUID -> Capabilities.FluidHandler.BLOCK;
            case EnumChannelType.ENERGY -> Capabilities.EnergyStorage.BLOCK;
        };
        return Arrays.stream(Direction.values()).map(side -> this.surroundingCapabilities.get(side).computeIfAbsent(type, t -> BlockCapabilityCache.create((BlockCapability)capability, (ServerLevel)((ServerLevel)this.level), (BlockPos)this.worldPosition.relative(side), (Object)side.getOpposite(), () -> !this.remove, () -> {}))).map(BlockCapabilityCache::getCapability).filter(Objects::nonNull).collect(Collectors.toList());
    }

    public boolean canSend(EnumChannelType type) {
        return this.transferState.get((Object)type).canSend() && !this.isBlockedByRedstone();
    }

    public boolean canReceive(EnumChannelType type) {
        return this.transferState.get((Object)type).canReceive() && !this.isBlockedByRedstone();
    }

    public boolean isBlockedByRedstone() {
        return this.redstoneState != RedstoneState.DISABLED && this.redstoneState == (this.redstone ? RedstoneState.LOW : RedstoneState.HIGH);
    }

    public int getChannelId(EnumChannelType type) {
        return this.getReference().getChannelId(type);
    }

    public TransferState getTransferState(EnumChannelType type) {
        return this.transferState.get((Object)type);
    }

    public void cycleTransferState(EnumChannelType type) {
        TransferState transferState = this.transferState.get((Object)type);
        this.transferState.put(type, transferState == TransferState.BOTH ? TransferState.SEND : (transferState == TransferState.SEND ? TransferState.RECEIVE : TransferState.BOTH));
        this.updateReference();
        this.dataChanged();
    }

    public RedstoneState getRedstoneState() {
        return this.redstoneState;
    }

    public void cycleRedstoneState() {
        this.redstoneState = this.redstoneState == RedstoneState.DISABLED ? RedstoneState.HIGH : (this.redstoneState == RedstoneState.HIGH ? RedstoneState.LOW : RedstoneState.DISABLED);
        this.updateReference();
        this.dataChanged();
    }

    public void setPowered(boolean powered) {
        if (this.redstone != powered) {
            this.redstone = powered;
            this.updateReference();
            this.dataChanged();
        }
    }

    private Channel getChannel(EnumChannelType type) {
        return this.getReference().getChannel(type);
    }

    public void onNeighborChanged(BlockPos neighbor) {
        Direction facing = Direction.getNearest((float)(neighbor.getX() - this.worldPosition.getX()), (float)(neighbor.getY() - this.worldPosition.getY()), (float)(neighbor.getZ() - this.worldPosition.getZ()));
        this.surroundingCapabilities.get(facing).clear();
    }

    private void notifyNeighbors() {
        this.level.blockUpdated(this.worldPosition, this.getBlockState().getBlock());
    }

    private void updateReference() {
        TesseractReference reference = this.getReference();
        if (reference != null) {
            reference.update(this);
        }
    }

    protected CompoundTag writeData() {
        CompoundTag compound = new CompoundTag();
        for (EnumChannelType type : EnumChannelType.values()) {
            compound.putString("transferState" + type.name(), this.transferState.get((Object)type).name());
        }
        compound.putString("redstoneState", this.redstoneState.name());
        compound.putBoolean("powered", this.redstone);
        return compound;
    }

    protected void readData(CompoundTag compound) {
        for (EnumChannelType type : EnumChannelType.values()) {
            if (!compound.contains("transferState" + type.name())) continue;
            this.transferState.put(type, TransferState.valueOf(compound.getString("transferState" + type.name())));
        }
        if (compound.contains("redstoneState")) {
            this.redstoneState = RedstoneState.valueOf(compound.getString("redstoneState"));
        }
        if (compound.contains("powered")) {
            this.redstone = compound.getBoolean("powered");
        }
    }

    public void onReplaced() {
        if (!this.level.isClientSide) {
            TesseractTracker.SERVER.remove(this.level, this.worldPosition);
        }
    }
}

