/*
 * Decompiled with CFR 0.152.
 */
package velizarbg.suggestion_tweaker.mixins;

import java.util.Locale;
import java.util.function.Consumer;
import java.util.function.Function;
import net.minecraft.commands.SharedSuggestionProvider;
import net.minecraft.resources.ResourceLocation;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Redirect;
import velizarbg.suggestion_tweaker.Constants;

@Mixin(value={SharedSuggestionProvider.class})
public interface CommandSourceMixin {
    @Overwrite
    public static <T> void filterResources(Iterable<T> candidates, String remaining, Function<T, ResourceLocation> getIdentifier, Consumer<T> action) {
        for (T candidate : candidates) {
            ResourceLocation identifier = getIdentifier.apply(candidate);
            if (!SharedSuggestionProvider.matchesSubStr((String)remaining, (String)identifier.toString())) continue;
            action.accept(candidate);
        }
    }

    @Overwrite
    public static boolean matchesSubStr(String remaining, String candidate) {
        String[] candidateId;
        String[] remainingId = remaining.split(":", 2);
        if (remainingId.length == 2) {
            if (candidate.startsWith(remainingId[0])) {
                remaining = remainingId[1];
            } else {
                return false;
            }
        }
        if ((candidateId = candidate.split(":", 2)).length == 2) {
            candidate = candidateId[1];
        }
        if (Constants.config.shouldHideSuggestionsWithPrefix) {
            for (String substring : candidate.split("/")) {
                if (!substring.startsWith(Constants.config.hidePrefix)) continue;
                return false;
            }
        }
        return Constants.config.filteringMode.test(remaining, candidate);
    }

    @Redirect(method={"suggestResource(Ljava/lang/Iterable;Lcom/mojang/brigadier/suggestion/SuggestionsBuilder;Ljava/lang/String;)Ljava/util/concurrent/CompletableFuture;", "suggestResource(Ljava/lang/Iterable;Lcom/mojang/brigadier/suggestion/SuggestionsBuilder;)Ljava/util/concurrent/CompletableFuture;", "suggestResource(Ljava/lang/Iterable;Lcom/mojang/brigadier/suggestion/SuggestionsBuilder;Ljava/util/function/Function;Ljava/util/function/Function;)Ljava/util/concurrent/CompletableFuture;", "suggest(Ljava/lang/Iterable;Lcom/mojang/brigadier/suggestion/SuggestionsBuilder;)Ljava/util/concurrent/CompletableFuture;", "suggest(Ljava/util/stream/Stream;Lcom/mojang/brigadier/suggestion/SuggestionsBuilder;)Ljava/util/concurrent/CompletableFuture;", "lambda$suggest$5(Ljava/lang/String;Ljava/lang/String;)Z", "suggest([Ljava/lang/String;Lcom/mojang/brigadier/suggestion/SuggestionsBuilder;)Ljava/util/concurrent/CompletableFuture;", "suggest(Ljava/lang/Iterable;Lcom/mojang/brigadier/suggestion/SuggestionsBuilder;Ljava/util/function/Function;Ljava/util/function/Function;)Ljava/util/concurrent/CompletableFuture;"}, at=@At(value="INVOKE", target="Ljava/lang/String;toLowerCase(Ljava/util/Locale;)Ljava/lang/String;"))
    private static String handleCaseSensitivity(String string, Locale locale) {
        return Constants.config.isCaseSensitive ? string : string.toLowerCase(locale);
    }
}

