/*
 * Decompiled with CFR 0.152.
 */
package com.ldtteam.structurize.placement.handlers.placement;

import com.ldtteam.structurize.api.RotationMirror;
import com.ldtteam.structurize.blueprints.v1.Blueprint;
import com.ldtteam.structurize.placement.structure.IStructureHandler;
import com.ldtteam.structurize.util.BlockUtils;
import com.ldtteam.structurize.util.InventoryUtils;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.Nullable;

public interface IPlacementHandler {
    public boolean canHandle(Level var1, BlockPos var2, BlockState var3);

    default public ActionProcessingResult handle(Level world, BlockPos pos, BlockState blockState, @Nullable CompoundTag tileEntityData, boolean complete, BlockPos centerPos) {
        return ActionProcessingResult.PASS;
    }

    default public ActionProcessingResult handle(Level world, BlockPos pos, BlockState blockState, @Nullable CompoundTag tileEntityData, boolean complete, BlockPos centerPos, RotationMirror settings) {
        return this.handle(world, pos, blockState, tileEntityData, complete, centerPos);
    }

    default public ActionProcessingResult handle(Blueprint blueprint, Level world, BlockPos pos, BlockState blockState, @Nullable CompoundTag tileEntityData, boolean complete, BlockPos centerPos, RotationMirror settings) {
        return this.handle(world, pos, blockState, tileEntityData, complete, centerPos, settings);
    }

    default public void handleRemoval(IStructureHandler handler, Level world, BlockPos pos, CompoundTag tileEntityData) {
        this.handleRemoval(handler, world, pos);
    }

    default public void handleRemoval(IStructureHandler handler, Level world, BlockPos pos) {
        if (!handler.isCreative()) {
            List<ItemStack> items = BlockUtils.getBlockDrops(world, pos, 0, handler.getHeldItem());
            for (ItemStack item : items) {
                InventoryUtils.transferIntoNextBestSlot(item, handler.getInventory());
            }
        }
        world.removeBlock(pos, false);
    }

    public List<ItemStack> getRequiredItems(Level var1, BlockPos var2, BlockState var3, @Nullable CompoundTag var4, boolean var5);

    public static enum ActionProcessingResult {
        PASS,
        DENY,
        SUCCESS;

    }
}

