/*
 * Decompiled with CFR 0.152.
 */
package com.ldtteam.structurize.network.messages;

import com.ldtteam.common.network.AbstractClientPlayMessage;
import com.ldtteam.common.network.PlayMessageType;
import com.ldtteam.structurize.storage.ClientStructurePackLoader;
import com.ldtteam.structurize.storage.StructurePackMeta;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.world.entity.player.Player;
import net.neoforged.neoforge.network.handling.IPayloadContext;

public class NotifyClientAboutStructurePacksMessage
extends AbstractClientPlayMessage {
    public static final PlayMessageType<?> TYPE = PlayMessageType.forClient((String)"structurize", (String)"notify_client_about_structure_packs", NotifyClientAboutStructurePacksMessage::new);
    private final Map<String, Double> serverStructurePacks = new HashMap<String, Double>();

    protected NotifyClientAboutStructurePacksMessage(RegistryFriendlyByteBuf buf, PlayMessageType<?> type) {
        super(buf, type);
        int length = buf.readInt();
        for (int i = 0; i < length; ++i) {
            this.serverStructurePacks.put(buf.readUtf(Short.MAX_VALUE), buf.readDouble());
        }
    }

    public NotifyClientAboutStructurePacksMessage(Map<String, StructurePackMeta> clientStructurePacks) {
        super(TYPE);
        for (StructurePackMeta pack : clientStructurePacks.values()) {
            if (pack.isImmutable()) continue;
            this.serverStructurePacks.put(pack.getName(), pack.getVersion());
        }
    }

    protected void toBytes(RegistryFriendlyByteBuf buf) {
        buf.writeInt(this.serverStructurePacks.size());
        for (Map.Entry<String, Double> packInfo : this.serverStructurePacks.entrySet()) {
            buf.writeUtf(packInfo.getKey());
            buf.writeDouble(packInfo.getValue().doubleValue());
        }
    }

    protected void onExecute(IPayloadContext context, Player player) {
        ClientStructurePackLoader.onServerSyncAttempt(this.serverStructurePacks);
    }
}

