/*
 * Decompiled with CFR 0.152.
 */
package com.ldtteam.structurize.items;

import com.ldtteam.structurize.Structurize;
import com.ldtteam.structurize.api.BlockPosUtil;
import com.ldtteam.structurize.api.IScrollableItem;
import com.ldtteam.structurize.api.ISpecialBlockPickItem;
import com.ldtteam.structurize.api.Log;
import com.ldtteam.structurize.blockentities.interfaces.IBlueprintDataProviderBE;
import com.ldtteam.structurize.blueprints.v1.Blueprint;
import com.ldtteam.structurize.blueprints.v1.BlueprintUtil;
import com.ldtteam.structurize.client.gui.WindowScan;
import com.ldtteam.structurize.commands.ScanCommand;
import com.ldtteam.structurize.component.ModDataComponents;
import com.ldtteam.structurize.config.ServerConfiguration;
import com.ldtteam.structurize.items.AbstractItemWithPosSelector;
import com.ldtteam.structurize.items.ModItems;
import com.ldtteam.structurize.network.messages.SaveScanMessage;
import com.ldtteam.structurize.network.messages.ShowScanMessage;
import com.ldtteam.structurize.storage.rendering.RenderingCache;
import com.ldtteam.structurize.storage.rendering.types.BoxPreviewData;
import com.ldtteam.structurize.util.ScanToolData;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.ParseResults;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.context.ParsedCommandNode;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.sql.Date;
import java.text.SimpleDateFormat;
import java.time.Instant;
import java.util.List;
import java.util.Optional;
import java.util.function.UnaryOperator;
import java.util.stream.Collectors;
import net.minecraft.ChatFormatting;
import net.minecraft.commands.CommandSource;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.arguments.coordinates.BlockPosArgument;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Position;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.CommandBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec2;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ItemScanTool
extends AbstractItemWithPosSelector
implements IScrollableItem,
ISpecialBlockPickItem {
    private static final String ANCHOR_POS_TKEY = "item.possetter.anchorpos";

    public ItemScanTool() {
        this(new Item.Properties().durability(0).setNoRepair().rarity(Rarity.UNCOMMON).component(ModDataComponents.SCAN_TOOL, (Object)ScanToolData.EMPTY));
    }

    public ItemScanTool(Item.Properties properties) {
        super(properties);
    }

    @Override
    public InteractionResult onAirRightClick(BlockPos start, BlockPos end, Level worldIn, Player playerIn, ItemStack itemStack) {
        ScanToolData data = ScanToolData.updateItemStack(itemStack, d -> this.saveSlot((ScanToolData)d, itemStack, playerIn));
        if (!worldIn.isClientSide) {
            if (playerIn.isShiftKeyDown()) {
                ItemScanTool.saveStructure(worldIn, playerIn, data.currentSlot(), true);
            }
        } else if (!playerIn.isShiftKeyDown()) {
            WindowScan window = new WindowScan(data);
            window.open();
        }
        return InteractionResult.SUCCESS;
    }

    @Override
    public AbstractItemWithPosSelector getRegisteredItemInstance() {
        return (AbstractItemWithPosSelector)((Object)ModItems.scanTool.get());
    }

    public static void saveStructure(Level world, Player player, ScanToolData.Slot slot, boolean saveEntities) {
        List list;
        if (slot.box().anchor().isPresent() && !BlockPosUtil.isInbetween(slot.box().anchor().get(), slot.box().pos1(), slot.box().pos2())) {
            player.displayClientMessage((Component)Component.translatable((String)"item.sceptersteel.badanchorpos"), false);
            return;
        }
        BoundingBox box = BoundingBox.fromCorners((Vec3i)slot.box().pos1(), (Vec3i)slot.box().pos2());
        if (box.getXSpan() * box.getYSpan() * box.getZSpan() > (Integer)((ServerConfiguration)Structurize.getConfig().getServer()).schematicBlockLimit.get()) {
            player.displayClientMessage((Component)Component.translatable((String)"item.sceptersteel.toobig", (Object[])new Object[]{((ServerConfiguration)Structurize.getConfig().getServer()).schematicBlockLimit.get()}), false);
            return;
        }
        Object fileName = slot.name().isEmpty() ? Component.translatable((String)"item.sceptersteel.scanformat", (Object[])new Object[]{new SimpleDateFormat("yyyy-MM-dd_HH-mm-ss").format(Date.from(Instant.now()))}).getString() : slot.name();
        if (!((String)fileName).contains(".blueprint")) {
            fileName = (String)fileName + ".blueprint";
        }
        BlockPos zero = new BlockPos(box.minX(), box.minY(), box.minZ());
        Blueprint bp = BlueprintUtil.createBlueprint(world, zero, saveEntities, (short)box.getXSpan(), (short)box.getYSpan(), (short)box.getZSpan(), (String)fileName, slot.box().anchor());
        if (slot.box().anchor().isEmpty() && bp.getPrimaryBlockOffset().equals((Object)new BlockPos(bp.getSizeX() / 2, 0, bp.getSizeZ() / 2)) && (list = bp.getBlockInfoAsList().stream().filter(blockInfo -> blockInfo.hasTileEntityData() && blockInfo.getTileEntityData().contains("blueprintDataProvider")).collect(Collectors.toList())).size() > 1) {
            player.displayClientMessage((Component)Component.translatable((String)"com.ldtteam.structurize.gui.scantool.scanbadanchor", (Object[])new Object[]{fileName}), false);
        }
        new SaveScanMessage(BlueprintUtil.writeBlueprintToNBT(bp), (String)fileName).sendToPlayer((ServerPlayer)player);
    }

    @Override
    public boolean canAttackBlock(BlockState state, Level worldIn, BlockPos pos, Player player) {
        IBlueprintDataProviderBE bpProvider;
        BlockEntity te;
        ItemStack itemstack;
        if (!player.isShiftKeyDown()) {
            return super.canAttackBlock(state, worldIn, pos, player);
        }
        if (worldIn.isClientSide()) {
            player.displayClientMessage((Component)Component.translatable((String)ANCHOR_POS_TKEY, (Object[])new Object[]{pos.getX(), pos.getY(), pos.getZ()}), false);
        }
        if (!(itemstack = player.getMainHandItem()).getItem().equals((Object)this.getRegisteredItemInstance())) {
            itemstack = player.getOffhandItem();
        }
        if ((te = worldIn.getBlockEntity(pos)) instanceof IBlueprintDataProviderBE && !(bpProvider = (IBlueprintDataProviderBE)te).getSchematicName().isEmpty()) {
            BlockPos start = (BlockPos)bpProvider.getInWorldCorners().getA();
            BlockPos end = (BlockPos)bpProvider.getInWorldCorners().getB();
            if (!start.equals((Object)pos) && !end.equals((Object)pos)) {
                if (worldIn.isClientSide) {
                    RenderingCache.queue("scan", new BoxPreviewData((BlockPos)bpProvider.getInWorldCorners().getA(), (BlockPos)bpProvider.getInWorldCorners().getB(), Optional.of(pos)));
                }
                AbstractItemWithPosSelector.PosSelection.updateItemStack(itemstack, data -> data.setSelection(start, end));
            } else if (worldIn.isClientSide && RenderingCache.getBoxPreviewData("scan") != null) {
                RenderingCache.queue("scan", RenderingCache.getBoxPreviewData("scan").withAnchor(Optional.of(pos)));
            }
        }
        ItemScanTool.setAnchorPos(itemstack, pos);
        return false;
    }

    public void appendHoverText(@NotNull ItemStack stack, @Nullable Item.TooltipContext world, @NotNull List<Component> tooltip, @NotNull TooltipFlag flags) {
        super.appendHoverText(stack, world, tooltip, flags);
        if (stack.has(ModDataComponents.SCAN_TOOL)) {
            tooltip.add(this.getCurrentSlotDescription(stack));
        }
    }

    public Component getHighlightTip(@NotNull ItemStack stack, @NotNull Component displayName) {
        return Component.empty().append(super.getHighlightTip(stack, displayName)).append((Component)Component.literal((String)" - ").withStyle(ChatFormatting.GRAY)).append(this.getCurrentSlotDescription(stack));
    }

    private Component getCurrentSlotDescription(@NotNull ItemStack stack) {
        ScanToolData data = ScanToolData.readFromItemStack(stack);
        MutableComponent desc = Component.empty().append((Component)Component.literal((String)Integer.toString(data.currentSlotId())).withStyle(ChatFormatting.GRAY));
        String name = data.currentSlot().name();
        if (!name.isEmpty()) {
            desc = desc.append((Component)Component.literal((String)": ").withStyle(ChatFormatting.GRAY)).append((Component)Component.literal((String)name));
        }
        return desc;
    }

    @Override
    @NotNull
    public InteractionResult onBlockPick(@NotNull Player player, @NotNull ItemStack stack, @Nullable BlockPos pos, boolean ctrlKey) {
        if (pos == null) {
            double delta = player.isShiftKeyDown() ? -1.0 : 1.0;
            return this.onMouseScroll(player, stack, 0.0, delta, ctrlKey);
        }
        BlockEntity blockEntity = player.level().getBlockEntity(pos);
        if (blockEntity instanceof CommandBlockEntity) {
            CommandBlockEntity command = (CommandBlockEntity)blockEntity;
            return this.onCommandBlockPick(player, stack, command, ctrlKey);
        }
        return InteractionResult.PASS;
    }

    @Override
    @NotNull
    public InteractionResult onMouseScroll(@NotNull Player player, @NotNull ItemStack stack, double deltaX, double deltaY, boolean ctrlKey) {
        if (player.level().isClientSide()) {
            return InteractionResult.SUCCESS;
        }
        this.switchSlot((ServerPlayer)player, stack, deltaY < 0.0 ? ScanToolData::prevSlot : ScanToolData::nextSlot);
        return InteractionResult.SUCCESS;
    }

    private void switchSlot(@NotNull ServerPlayer player, @NotNull ItemStack stack, @NotNull UnaryOperator<ScanToolData> action) {
        ScanToolData data = ScanToolData.updateItemStack(stack, d -> (ScanToolData)action.apply(this.saveSlot((ScanToolData)d, stack, (Player)player)));
        ScanToolData.Slot slot = this.loadSlot(data, stack);
        new ShowScanMessage(slot.box()).sendToPlayer(player);
    }

    private ScanToolData saveSlot(@NotNull ScanToolData data, @NotNull ItemStack stack, @NotNull Player player) {
        BoxPreviewData box = ItemScanTool.getBox(stack, player);
        return data.withCurrentSlot(box == null ? null : data.currentSlot().withBox(box));
    }

    public ScanToolData.Slot loadSlot(@NotNull ScanToolData data, @NotNull ItemStack stack) {
        ScanToolData.Slot slot = data.currentSlot();
        AbstractItemWithPosSelector.PosSelection.updateItemStack(stack, data1 -> data1.setSelection(slot.box().pos1(), slot.box().pos2()));
        return slot;
    }

    private InteractionResult onCommandBlockPick(@NotNull Player player, @NotNull ItemStack stack, @NotNull CommandBlockEntity command, boolean ctrlKey) {
        if (!player.isCreative()) {
            return InteractionResult.PASS;
        }
        if (player.level().isClientSide()) {
            return InteractionResult.SUCCESS;
        }
        if (player.isShiftKeyDown()) {
            this.onCommandBlockPaste((ServerPlayer)player, stack, command, ctrlKey);
        } else {
            this.onCommandBlockCopy((ServerPlayer)player, stack, command, ctrlKey);
        }
        return InteractionResult.SUCCESS;
    }

    private void onCommandBlockCopy(@NotNull ServerPlayer player, @NotNull ItemStack stack, @NotNull CommandBlockEntity command, boolean ctrlKey) {
        CommandDispatcher dispatcher;
        ParseResults parsed;
        StringReader reader = new StringReader(command.getCommandBlock().getCommand());
        if (reader.canRead() && reader.peek() == '/') {
            reader.read();
        }
        if ((parsed = (dispatcher = player.level().getServer().getCommands().getDispatcher()).parse(reader, (Object)command.getCommandBlock().createCommandSourceStack())).getReader().canRead() || parsed.getContext().getNodes().size() < 4 || !((ParsedCommandNode)parsed.getContext().getNodes().get(0)).getNode().getName().equals("structurize") || !((ParsedCommandNode)parsed.getContext().getNodes().get(1)).getNode().getName().equals("scan")) {
            player.sendSystemMessage((Component)Component.translatable((String)"com.ldtteam.structurize.gui.scantool.copy.notscan"));
            return;
        }
        CommandContext cmdContext = parsed.getContext().build(parsed.getReader().getString());
        try {
            BlockPos from = BlockPosArgument.getSpawnablePos((CommandContext)cmdContext, (String)"pos1");
            BlockPos to = BlockPosArgument.getSpawnablePos((CommandContext)cmdContext, (String)"pos2");
            Optional<Object> anchor = parsed.getContext().getArguments().containsKey("anchor_pos") ? Optional.of(BlockPosArgument.getSpawnablePos((CommandContext)cmdContext, (String)"anchor_pos")) : Optional.empty();
            String name = parsed.getContext().getArguments().containsKey("filename") ? StringArgumentType.getString((CommandContext)cmdContext, (String)"filename") : "";
            ScanToolData data = ScanToolData.updateItemStack(stack, d -> d.withCommandBlock(command).withCurrentSlot(new ScanToolData.Slot(name, new BoxPreviewData(from, to, anchor))));
            ScanToolData.Slot slot = this.loadSlot(data, stack);
            new ShowScanMessage(slot.box()).sendToPlayer(player);
            player.displayClientMessage((Component)Component.translatable((String)"com.ldtteam.structurize.gui.scantool.copy.ok", (Object[])new Object[]{name}), false);
            player.playNotifySound((SoundEvent)SoundEvents.NOTE_BLOCK_CHIME.value(), SoundSource.PLAYERS, 1.0f, 1.0f);
        }
        catch (CommandSyntaxException e) {
            player.displayClientMessage((Component)Component.translatable((String)"com.ldtteam.structurize.gui.scantool.copy.notscan"), false);
        }
    }

    private void onCommandBlockPaste(@NotNull ServerPlayer player, @NotNull ItemStack stack, @NotNull CommandBlockEntity command, boolean ctrlKey) {
        ScanToolData data = ScanToolData.updateItemStack(stack, d -> this.saveSlot((ScanToolData)d, stack, (Player)player));
        ScanToolData.Slot slot = data.currentSlot();
        if (slot.name().isBlank() || slot.name().contains(" ")) {
            player.sendSystemMessage((Component)Component.translatable((String)"com.ldtteam.structurize.gui.scantool.paste.badname"));
            player.playNotifySound((SoundEvent)SoundEvents.NOTE_BLOCK_BIT.value(), SoundSource.PLAYERS, 1.0f, 1.0f);
            return;
        }
        if (!command.getCommandBlock().getCommand().isBlank()) {
            if (!command.getCommandBlock().getCommand().contains("structurize scan ")) {
                player.displayClientMessage((Component)Component.translatable((String)"com.ldtteam.structurize.gui.scantool.paste.badcommand"), false);
                player.playNotifySound((SoundEvent)SoundEvents.NOTE_BLOCK_BIT.value(), SoundSource.PLAYERS, 1.0f, 1.0f);
                return;
            }
            if (!ctrlKey) {
                CommandContext cmdContext;
                String currentName;
                CommandDispatcher dispatcher;
                ParseResults parsed;
                StringReader reader = new StringReader(command.getCommandBlock().getCommand());
                if (reader.canRead() && reader.peek() == '/') {
                    reader.read();
                }
                if ((parsed = (dispatcher = player.getServer().getCommands().getDispatcher()).parse(reader, (Object)command.getCommandBlock().createCommandSourceStack())).getContext().getArguments().containsKey("filename") && !(currentName = StringArgumentType.getString((CommandContext)(cmdContext = parsed.getContext().build(parsed.getReader().getString())), (String)"filename")).equals(slot.name())) {
                    player.displayClientMessage((Component)Component.translatable((String)"com.ldtteam.structurize.gui.scantool.paste.different", (Object[])new Object[]{slot.name(), currentName}), false);
                    player.playNotifySound((SoundEvent)SoundEvents.NOTE_BLOCK_XYLOPHONE.value(), SoundSource.PLAYERS, 1.0f, 1.0f);
                    return;
                }
            }
        }
        String cmd = ScanCommand.format(slot);
        command.getCommandBlock().setCommand(cmd);
        ScanToolData.updateItemStack(stack, d -> d.withCommandBlock(command));
        player.displayClientMessage((Component)Component.translatable((String)"com.ldtteam.structurize.gui.scantool.paste.ok", (Object[])new Object[]{slot.name()}), false);
        player.playNotifySound((SoundEvent)SoundEvents.NOTE_BLOCK_CHIME.value(), SoundSource.PLAYERS, 1.0f, 1.0f);
    }

    public boolean onTeleport(@NotNull Player player, @NotNull ItemStack stack) {
        long buildDistance;
        BlockPos target;
        if (!player.isCreative() || !((Boolean)((ServerConfiguration)Structurize.getConfig().getServer()).teleportAllowed.get()).booleanValue()) {
            return false;
        }
        ScanToolData data = ScanToolData.readFromItemStack(stack);
        if (data.commandPos() == null) {
            if (player.level().isClientSide()) {
                player.displayClientMessage((Component)Component.translatable((String)"com.ldtteam.structurize.gui.scantool.teleport.nocmd"), false);
                player.playSound((SoundEvent)SoundEvents.NOTE_BLOCK_BIT.value(), 1.0f, 1.0f);
            }
            return false;
        }
        if (!player.level().dimension().equals(data.dimension())) {
            if (player.level().isClientSide()) {
                player.displayClientMessage((Component)Component.translatable((String)"com.ldtteam.structurize.gui.scantool.teleport.dimension"), false);
                player.playSound((SoundEvent)SoundEvents.NOTE_BLOCK_BIT.value(), 1.0f, 1.0f);
            }
            return false;
        }
        ScanToolData.Slot slot = data.currentSlot();
        if (slot == null) {
            if (player.level().isClientSide()) {
                player.displayClientMessage((Component)Component.translatable((String)"com.ldtteam.structurize.gui.scantool.teleport.noscan"), false);
                player.playSound((SoundEvent)SoundEvents.NOTE_BLOCK_BIT.value(), 1.0f, 1.0f);
            }
            return false;
        }
        BlockPos commandPos = data.commandPos().above();
        BlockPos buildPos = this.getTeleportPos(slot.box());
        Level level = player.level();
        long commandDistance = BlockPosUtil.getDistanceSquared(commandPos, player.blockPosition());
        BlockPos blockPos = target = commandDistance < (buildDistance = BlockPosUtil.getDistanceSquared(buildPos, player.blockPosition())) ? buildPos : commandPos;
        if (((Boolean)((ServerConfiguration)Structurize.getConfig().getServer()).teleportSafety.get()).booleanValue()) {
            level.getChunk(target);
            @Nullable BlockPos safeTarget = BlockPosUtil.findSafeTeleportPos(level, target, false);
            if (safeTarget == null) {
                Log.getLogger().warn("No safe landing for scan-teleport " + player.getName().getString() + " to " + target.toShortString());
                return false;
            }
            target = safeTarget;
        }
        if (target.getY() < level.getMinBuildHeight() + 2) {
            Log.getLogger().warn("Aborting attempt to scan-teleport " + player.getName().getString() + " to " + target.toShortString());
            return false;
        }
        for (int i = 0; i < 32; ++i) {
            level.addParticle((ParticleOptions)ParticleTypes.PORTAL, (double)player.blockPosition().getX(), (double)player.blockPosition().getY() + level.getRandom().nextDouble() * 2.0, (double)player.blockPosition().getZ(), level.getRandom().nextGaussian(), 0.0, level.getRandom().nextGaussian());
            level.addParticle((ParticleOptions)ParticleTypes.PORTAL, (double)target.getX(), (double)target.getY() + level.getRandom().nextDouble() * 2.0, (double)target.getZ(), level.getRandom().nextGaussian(), 0.0, level.getRandom().nextGaussian());
        }
        Level level2 = player.level();
        if (level2 instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level2;
            player.playSound(SoundEvents.ENDERMAN_TELEPORT, 1.0f, 1.0f);
            CommandSourceStack source = new CommandSourceStack(CommandSource.NULL, player.position(), Vec2.ZERO, serverLevel, 2, player.getName().getString(), stack.getDisplayName(), serverLevel.getServer(), (Entity)player);
            CommandDispatcher dispatcher = serverLevel.getServer().getCommands().getDispatcher();
            try {
                dispatcher.execute(String.format("teleport %s %f %f %f", player.getUUID(), (double)target.getX() + 0.5, (double)target.getY() + 0.0, (double)target.getZ() + 0.5), (Object)source);
            }
            catch (Exception e) {
                Log.getLogger().error("Command tool teleport failed", (Throwable)e);
            }
            player.playSound(SoundEvents.ENDERMAN_TELEPORT, 1.0f, 1.0f);
            player.playNotifySound(SoundEvents.ENDERMAN_TELEPORT, SoundSource.PLAYERS, 1.0f, 1.0f);
        }
        return true;
    }

    @NotNull
    private BlockPos getTeleportPos(@NotNull BoxPreviewData box) {
        Direction direction = (Direction)((ServerConfiguration)Structurize.getConfig().getServer()).teleportBuildDirection.get();
        int offset = (Integer)((ServerConfiguration)Structurize.getConfig().getServer()).teleportBuildDistance.get();
        AABB bounds = AABB.encapsulatingFullBlocks((BlockPos)box.pos1(), (BlockPos)box.pos2());
        int size = (int)Math.round(bounds.max(direction.getAxis()) - bounds.min(direction.getAxis()));
        return BlockPos.containing((Position)bounds.getCenter()).atY((int)bounds.minY).relative(direction, offset + size / 2);
    }

    @Nullable
    public static BoxPreviewData getBox(@NotNull ItemStack tool, @NotNull Player player) {
        AbstractItemWithPosSelector.PosSelection tag = AbstractItemWithPosSelector.PosSelection.readFromItemStack(tool);
        if (!tag.hasSelection()) {
            return null;
        }
        Optional<Object> anchor = ScanToolData.readFromItemStack(tool).currentSlot().box().anchor();
        if (anchor.isPresent() && !BlockPosUtil.isInbetween(anchor.get(), tag.startPos().get(), tag.endPos().get())) {
            if (player.level().isClientSide()) {
                player.displayClientMessage((Component)Component.translatable((String)"com.ldtteam.structurize.gui.scantool.outsideanchor"), false);
            }
            anchor = Optional.empty();
        }
        return new BoxPreviewData(tag.startPos().get(), tag.endPos().get(), anchor);
    }

    @Deprecated(forRemoval=true, since="1.21")
    public static void setAnchorPos(@NotNull ItemStack tool, @Nullable BlockPos anchor) {
        ScanToolData.updateItemStack(tool, data -> {
            BoxPreviewData oldBox = data.currentSlot().box();
            BoxPreviewData newBox = oldBox.withAnchor(Optional.ofNullable(anchor));
            return data.withCurrentSlot(data.currentSlot().withBox(newBox));
        });
    }

    @Deprecated(forRemoval=true, since="1.21")
    @Nullable
    public static BlockPos getAnchorPos(@NotNull ItemStack tool) {
        return ScanToolData.readFromItemStack(tool).currentSlot().box().anchor().orElse(null);
    }

    @Deprecated(forRemoval=true, since="1.21")
    public static void setStructureName(@NotNull ItemStack tool, @Nullable String name) {
        ScanToolData.updateItemStack(tool, data -> data.withCurrentSlot(data.currentSlot().withName(name == null ? "" : name)));
    }

    @Deprecated(forRemoval=true, since="1.21")
    public static String getStructureName(@NotNull ItemStack tool) {
        return ScanToolData.readFromItemStack(tool).currentSlot().name();
    }
}

