/*
 * Decompiled with CFR 0.152.
 */
package com.ldtteam.structurize.event;

import com.ldtteam.common.language.LanguageHandler;
import com.ldtteam.structurize.datagen.BlockEntityTagProvider;
import com.ldtteam.structurize.datagen.BlockTagProvider;
import com.ldtteam.structurize.datagen.EntityTagProvider;
import com.ldtteam.structurize.network.messages.AbsorbBlockMessage;
import com.ldtteam.structurize.network.messages.AddRemoveTagMessage;
import com.ldtteam.structurize.network.messages.BlueprintSyncMessage;
import com.ldtteam.structurize.network.messages.BuildToolPlacementMessage;
import com.ldtteam.structurize.network.messages.ClientBlueprintRequestMessage;
import com.ldtteam.structurize.network.messages.FillTopPlaceholderMessage;
import com.ldtteam.structurize.network.messages.ItemMiddleMouseMessage;
import com.ldtteam.structurize.network.messages.NotifyClientAboutStructurePacksMessage;
import com.ldtteam.structurize.network.messages.NotifyServerAboutStructurePacksMessage;
import com.ldtteam.structurize.network.messages.OperationHistoryMessage;
import com.ldtteam.structurize.network.messages.RemoveBlockMessage;
import com.ldtteam.structurize.network.messages.RemoveEntityMessage;
import com.ldtteam.structurize.network.messages.ReplaceBlockMessage;
import com.ldtteam.structurize.network.messages.SaveScanMessage;
import com.ldtteam.structurize.network.messages.ScanOnServerMessage;
import com.ldtteam.structurize.network.messages.ScanToolTeleportMessage;
import com.ldtteam.structurize.network.messages.SetTagInTool;
import com.ldtteam.structurize.network.messages.ShowScanMessage;
import com.ldtteam.structurize.network.messages.SyncPreviewCacheToClient;
import com.ldtteam.structurize.network.messages.SyncPreviewCacheToServer;
import com.ldtteam.structurize.network.messages.SyncSettingsToServer;
import com.ldtteam.structurize.network.messages.TransferStructurePackToClient;
import com.ldtteam.structurize.network.messages.UndoRedoMessage;
import com.ldtteam.structurize.network.messages.UpdateClientRender;
import com.ldtteam.structurize.network.messages.UpdateScanToolMessage;
import com.ldtteam.structurize.storage.ServerStructurePackLoader;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.block.Block;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.ModContainer;
import net.neoforged.fml.ModList;
import net.neoforged.fml.event.lifecycle.FMLDedicatedServerSetupEvent;
import net.neoforged.fml.event.lifecycle.FMLLoadCompleteEvent;
import net.neoforged.neoforge.data.event.GatherDataEvent;
import net.neoforged.neoforge.network.event.RegisterPayloadHandlersEvent;
import net.neoforged.neoforge.network.registration.PayloadRegistrar;
import org.jetbrains.annotations.NotNull;

public class LifecycleSubscriber {
    @SubscribeEvent
    public static void onNetworkRegistry(RegisterPayloadHandlersEvent event) {
        String modVersion = ((ModContainer)ModList.get().getModContainerById("structurize").get()).getModInfo().getVersion().toString();
        PayloadRegistrar registry = event.registrar("structurize").versioned(modVersion);
        AbsorbBlockMessage.TYPE.register(registry);
        AddRemoveTagMessage.TYPE.register(registry);
        BlueprintSyncMessage.TYPE.register(registry);
        BuildToolPlacementMessage.TYPE.register(registry);
        ClientBlueprintRequestMessage.TYPE.register(registry);
        FillTopPlaceholderMessage.TYPE.register(registry);
        ItemMiddleMouseMessage.TYPE.register(registry);
        NotifyClientAboutStructurePacksMessage.TYPE.register(registry);
        NotifyServerAboutStructurePacksMessage.TYPE.register(registry);
        OperationHistoryMessage.TYPE.register(registry);
        RemoveBlockMessage.TYPE.register(registry);
        RemoveEntityMessage.TYPE.register(registry);
        ReplaceBlockMessage.TYPE.register(registry);
        SaveScanMessage.TYPE.register(registry);
        ScanOnServerMessage.TYPE.register(registry);
        ScanToolTeleportMessage.TYPE.register(registry);
        SetTagInTool.TYPE.register(registry);
        ShowScanMessage.TYPE.register(registry);
        SyncPreviewCacheToClient.TYPE.register(registry);
        SyncPreviewCacheToServer.TYPE.register(registry);
        SyncSettingsToServer.TYPE.register(registry);
        TransferStructurePackToClient.TYPE.register(registry);
        UndoRedoMessage.TYPE.register(registry);
        UpdateClientRender.TYPE.register(registry);
        UpdateScanToolMessage.TYPE.register(registry);
    }

    @SubscribeEvent
    public static void onLoadComplete(FMLLoadCompleteEvent event) {
        LanguageHandler.setMClanguageLoaded();
    }

    @SubscribeEvent
    public static void onDedicatedServerInit(FMLDedicatedServerSetupEvent event) {
        ServerStructurePackLoader.onServerStarting();
    }

    @SubscribeEvent
    public static void onDatagen(@NotNull GatherDataEvent event) {
        DataGenerator generator = event.getGenerator();
        generator.addProvider(event.includeServer(), (DataProvider)new BlockEntityTagProvider(event.getGenerator().getPackOutput(), Registries.BLOCK_ENTITY_TYPE, event.getLookupProvider(), event.getExistingFileHelper()));
        generator.addProvider(event.includeServer(), (DataProvider)new BlockTagProvider(event.getGenerator().getPackOutput(), (ResourceKey<? extends Registry<Block>>)Registries.BLOCK, event.getLookupProvider(), event.getExistingFileHelper()));
        generator.addProvider(event.includeClient(), (DataProvider)new EntityTagProvider(event.getGenerator().getPackOutput(), Registries.ENTITY_TYPE, event.getLookupProvider(), event.getExistingFileHelper()));
    }
}

