/*
 * Decompiled with CFR 0.152.
 */
package com.talhanation.smallships.world.item.neoforge;

import com.talhanation.smallships.world.item.BriggItem;
import com.talhanation.smallships.world.item.CannonBallItem;
import com.talhanation.smallships.world.item.CannonItem;
import com.talhanation.smallships.world.item.CogItem;
import com.talhanation.smallships.world.item.DrakkarItem;
import com.talhanation.smallships.world.item.GalleyItem;
import com.talhanation.smallships.world.item.ModItems;
import com.talhanation.smallships.world.item.SailItem;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.vehicle.Boat;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.neoforged.neoforge.registries.DeferredHolder;
import net.neoforged.neoforge.registries.DeferredRegister;

public class ModItemsImpl {
    private static final Map<String, Supplier<Item>> entries = new HashMap<String, Supplier<Item>>();
    public static final DeferredRegister.Items ITEMS = DeferredRegister.createItems((String)"smallships");
    public static final DeferredRegister<CreativeModeTab> CREATIVE_MODE_TABS = DeferredRegister.create((ResourceKey)Registries.CREATIVE_MODE_TAB, (String)"smallships");
    public static final DeferredHolder<CreativeModeTab, CreativeModeTab> customCreativeModeTab = CREATIVE_MODE_TABS.register(ResourceLocation.fromNamespaceAndPath((String)"smallships", (String)"creative_mode_tab").toString().replace(":", "."), () -> CreativeModeTab.builder().title((Component)Component.translatable((String)ResourceLocation.fromNamespaceAndPath((String)"smallships", (String)"creative_mode_tab").toString().replace(":", "."))).icon(() -> new ItemStack((ItemLike)ModItems.CANNON)).build());

    public static Item getItem(String id) {
        return entries.get(id).get();
    }

    private static void register(String id, Supplier<Item> itemSupplier) {
        entries.put(id, (Supplier<Item>)ITEMS.register(id, itemSupplier));
    }

    static {
        ModItemsImpl.register("sail", () -> new SailItem(new Item.Properties().stacksTo(16)));
        ModItemsImpl.register("cannon", () -> new CannonItem(new Item.Properties().stacksTo(1)));
        ModItemsImpl.register("cannon_ball", () -> new CannonBallItem(new Item.Properties().stacksTo(16)));
        for (Boat.Type type : Boat.Type.values()) {
            ModItemsImpl.register(type.getName() + "_cog", () -> new CogItem(type, new Item.Properties().stacksTo(1)));
            ModItemsImpl.register(type.getName() + "_brigg", () -> new BriggItem(type, new Item.Properties().stacksTo(1)));
            ModItemsImpl.register(type.getName() + "_galley", () -> new GalleyItem(type, new Item.Properties().stacksTo(1)));
            ModItemsImpl.register(type.getName() + "_drakkar", () -> new DrakkarItem(type, new Item.Properties().stacksTo(1)));
        }
    }
}

