/*
 * Decompiled with CFR 0.152.
 */
package com.talhanation.smallships.world.entity.ship;

import com.talhanation.smallships.config.SmallShipsConfig;
import com.talhanation.smallships.world.entity.ModEntityTypes;
import com.talhanation.smallships.world.entity.ship.Attributes;
import com.talhanation.smallships.world.entity.ship.ContainerShip;
import com.talhanation.smallships.world.entity.ship.Ship;
import com.talhanation.smallships.world.entity.ship.abilities.Ability;
import com.talhanation.smallships.world.entity.ship.abilities.Bannerable;
import com.talhanation.smallships.world.entity.ship.abilities.IceBreakable;
import com.talhanation.smallships.world.entity.ship.abilities.Paddleable;
import com.talhanation.smallships.world.entity.ship.abilities.Sailable;
import com.talhanation.smallships.world.entity.ship.abilities.Shieldable;
import com.talhanation.smallships.world.item.ModItems;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.vehicle.Boat;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;

public class DrakkarEntity
extends ContainerShip
implements Bannerable,
Sailable,
Shieldable,
Paddleable,
IceBreakable,
Ability {
    public static final String ID = "drakkar";
    private static final int ORIGINAL_CONTAINER_SIZE = (Integer)SmallShipsConfig.Common.shipContainerDrakkarContainerSize.get();
    private static final List<Shieldable.ShieldPosition> SHIELD_POSITIONS = new ArrayList<Shieldable.ShieldPosition>();

    public DrakkarEntity(EntityType<? extends Boat> entityType, Level level) {
        super(entityType, level, ORIGINAL_CONTAINER_SIZE);
    }

    private DrakkarEntity(Level level, double d, double e, double f) {
        this(ModEntityTypes.DRAKKAR, level);
        this.setPos(d, e, f);
        this.xo = d;
        this.yo = e;
        this.zo = f;
    }

    public static DrakkarEntity summon(Level level, double d, double e, double f) {
        return new DrakkarEntity(level, d, e, f);
    }

    @Override
    public CompoundTag createDefaultAttributes() {
        Attributes attributes = new Attributes();
        attributes.maxHealth = ((Double)SmallShipsConfig.Common.shipAttributeDrakkarMaxHealth.get()).floatValue();
        attributes.maxSpeed = ((Double)SmallShipsConfig.Common.shipAttributeDrakkarMaxSpeed.get()).floatValue();
        attributes.maxReverseSpeed = ((Double)SmallShipsConfig.Common.shipAttributeDrakkarMaxReverseSpeed.get()).floatValue();
        attributes.maxRotationSpeed = ((Double)SmallShipsConfig.Common.shipAttributeDrakkarMaxRotationSpeed.get()).floatValue();
        attributes.acceleration = ((Double)SmallShipsConfig.Common.shipAttributeDrakkarAcceleration.get()).floatValue();
        attributes.rotationAcceleration = ((Double)SmallShipsConfig.Common.shipAttributeDrakkarRotationAcceleration.get()).floatValue();
        CompoundTag tag = new CompoundTag();
        attributes.addSaveData(tag);
        return tag;
    }

    @Override
    public int getMaxPassengers() {
        return 11;
    }

    @Override
    @NotNull
    public Item getDropItem() {
        if (!((Boolean)SmallShipsConfig.Common.shipGeneralDoItemDrop.get()).booleanValue()) {
            return ItemStack.EMPTY.getItem();
        }
        return ModItems.DRAKKAR_ITEMS.get(this.getVariant());
    }

    @Override
    public Ship.BiomeModifierType getBiomeModifierType() {
        return (Ship.BiomeModifierType)((Object)SmallShipsConfig.Common.shipModifierDrakkarBiome.get());
    }

    @NotNull
    public Vec3 getPassengerAttachmentPoint(Entity entity, EntityDimensions dimensions, float partialTick) {
        float v = 1.0f;
        float h = 0.0f;
        if (!this.getPassengers().isEmpty()) {
            int i = this.getPassengers().indexOf(entity);
            switch (i) {
                case 0: {
                    v += -4.0f;
                    h = 0.0f;
                    break;
                }
                case 1: {
                    v += -2.5f;
                    h = 0.75f;
                    break;
                }
                case 2: {
                    v += -2.5f;
                    h = -0.75f;
                    break;
                }
                case 3: {
                    v += -1.5f;
                    h = -0.75f;
                    break;
                }
                case 4: {
                    v += -1.5f;
                    h = 0.75f;
                    break;
                }
                case 5: {
                    v += -0.5f;
                    h = -0.75f;
                    break;
                }
                case 6: {
                    v += -0.5f;
                    h = 0.75f;
                    break;
                }
                case 7: {
                    v += 0.5f;
                    h = -0.75f;
                    break;
                }
                case 8: {
                    v += 0.5f;
                    h = 0.75f;
                    break;
                }
                case 9: {
                    v += 1.5f;
                    h = 0.5f;
                    break;
                }
                case 10: {
                    v += 1.5f;
                    h = -0.5f;
                    break;
                }
                default: {
                    v += 2.0f;
                    h = 0.0f;
                }
            }
        }
        return new Vec3((double)v, (double)dimensions.height() - 0.1, (double)h).yRot(-this.getYRot() * ((float)Math.PI / 180) - 1.5707964f);
    }

    @Override
    public Bannerable.BannerPosition getBannerPosition() {
        return new Bannerable.BannerPosition(-180.0f, 90.0f, -4.5, -0.15, 0.05);
    }

    @Override
    public void waterSplash() {
        Vec3 vector3d = this.getViewVector(0.0f);
        float f0 = Mth.cos((float)(this.getYRot() * ((float)Math.PI / 180))) * 1.2f;
        float f1 = Mth.sin((float)(this.getYRot() * ((float)Math.PI / 180))) * 1.2f;
        float f2 = 4.0f - this.random.nextFloat() * 0.7f;
        float f2_ = -2.3f - this.random.nextFloat() * 0.7f;
        float x = 0.0f;
        for (int i = 0; i < 2; ++i) {
            this.getCommandSenderWorld().addParticle((ParticleOptions)ParticleTypes.DOLPHIN, this.getX() - vector3d.x * (double)f2 + (double)f0, this.getY() - vector3d.y + 0.5, this.getZ() - vector3d.z * (double)f2 + (double)f1, 0.0, 0.0, 0.0);
            this.getCommandSenderWorld().addParticle((ParticleOptions)ParticleTypes.DOLPHIN, this.getX() - vector3d.x * (double)f2 - (double)f0, this.getY() - vector3d.y + 0.5, this.getZ() - vector3d.z * (double)f2 - (double)f1, 0.0, 0.0, 0.0);
            this.getCommandSenderWorld().addParticle((ParticleOptions)ParticleTypes.DOLPHIN, this.getX() - vector3d.x * (double)f2 + (double)f0, this.getY() - vector3d.y + 0.5, this.getZ() - vector3d.z * (double)f2 + (double)f1 * 5.1, 0.0, 0.0, 0.0);
            this.getCommandSenderWorld().addParticle((ParticleOptions)ParticleTypes.DOLPHIN, this.getX() - vector3d.x * (double)f2 - (double)f0, this.getY() - vector3d.y + 0.5, this.getZ() - vector3d.z * (double)f2 - (double)f1 * 5.1, 0.0, 0.0, 0.0);
            this.getCommandSenderWorld().addParticle((ParticleOptions)ParticleTypes.SPLASH, this.getX() - vector3d.x * (double)f2 + (double)f0, this.getY() - vector3d.y + 0.8, this.getZ() - vector3d.z * (double)f2 + (double)f1, 0.0, 0.0, 0.0);
            this.getCommandSenderWorld().addParticle((ParticleOptions)ParticleTypes.SPLASH, this.getX() - vector3d.x * (double)f2 - (double)f0, this.getY() - vector3d.y + 0.8, this.getZ() - vector3d.z * (double)f2 - (double)f1, 0.0, 0.0, 0.0);
            this.getCommandSenderWorld().addParticle((ParticleOptions)ParticleTypes.SPLASH, this.getX() - vector3d.x * (double)f2 + (double)f0, this.getY() - vector3d.y + 0.8, this.getZ() - vector3d.z * (double)f2 + (double)f1 * 1.1, 0.0, 0.0, 0.0);
            this.getCommandSenderWorld().addParticle((ParticleOptions)ParticleTypes.SPLASH, this.getX() - vector3d.x * (double)f2 - (double)f0, this.getY() - vector3d.y + 0.8, this.getZ() - vector3d.z * (double)f2 - (double)f1 * 1.1, 0.0, 0.0, 0.0);
            this.getCommandSenderWorld().addParticle((ParticleOptions)ParticleTypes.SPLASH, this.getX() - vector3d.x * (double)f2_ + (double)f0, this.getY() - vector3d.y + 0.8, this.getZ() - vector3d.z * (double)(f2_ - x) + (double)f1, 0.0, 0.0, 0.0);
            this.getCommandSenderWorld().addParticle((ParticleOptions)ParticleTypes.SPLASH, this.getX() - vector3d.x * (double)f2_ - (double)f0, this.getY() - vector3d.y + 0.8, this.getZ() - vector3d.z * (double)(f2_ - x) - (double)f1, 0.0, 0.0, 0.0);
            this.getCommandSenderWorld().addParticle((ParticleOptions)ParticleTypes.SPLASH, this.getX() - vector3d.x * (double)f2_ + (double)f0, this.getY() - vector3d.y + 0.8, this.getZ() - vector3d.z * (double)(f2_ - x) + (double)f1 * 1.1, 0.0, 0.0, 0.0);
            this.getCommandSenderWorld().addParticle((ParticleOptions)ParticleTypes.SPLASH, this.getX() - vector3d.x * (double)f2_ - (double)f0, this.getY() - vector3d.y + 0.8, this.getZ() - vector3d.z * (double)(f2_ - x) - (double)f1 * 1.1, 0.0, 0.0, 0.0);
            this.getCommandSenderWorld().addParticle((ParticleOptions)ParticleTypes.BUBBLE, this.getX() - vector3d.x * (double)f2_ + (double)f0, this.getY() - vector3d.y + 0.8, this.getZ() - vector3d.z * (double)(f2_ - x) + (double)f1, 0.0, 0.0, 0.0);
            this.getCommandSenderWorld().addParticle((ParticleOptions)ParticleTypes.BUBBLE, this.getX() - vector3d.x * (double)f2_ - (double)f0, this.getY() - vector3d.y + 0.8, this.getZ() - vector3d.z * (double)(f2_ - x) - (double)f1, 0.0, 0.0, 0.0);
            this.getCommandSenderWorld().addParticle((ParticleOptions)ParticleTypes.BUBBLE, this.getX() - vector3d.x * (double)f2_ + (double)f0, this.getY() - vector3d.y + 0.8, this.getZ() - vector3d.z * (double)(f2_ - x) + (double)f1 * 1.1, 0.0, 0.0, 0.0);
            this.getCommandSenderWorld().addParticle((ParticleOptions)ParticleTypes.BUBBLE, this.getX() - vector3d.x * (double)f2_ - (double)f0, this.getY() - vector3d.y + 0.8, this.getZ() - vector3d.z * (double)(f2_ - x) - (double)f1 * 1.1, 0.0, 0.0, 0.0);
        }
    }

    @Override
    public Shieldable.ShieldPosition getShieldPosition(int index) {
        return SHIELD_POSITIONS.get(index);
    }

    @Override
    public byte getMaxShieldsPerSide() {
        return 5;
    }

    static {
        SHIELD_POSITIONS.add(new Shieldable.ShieldPosition(2.1, 0.8, -1.0, true));
        SHIELD_POSITIONS.add(new Shieldable.ShieldPosition(2.1, 0.8, 1.0, false));
        SHIELD_POSITIONS.add(new Shieldable.ShieldPosition(0.9, 0.8, -1.2, true));
        SHIELD_POSITIONS.add(new Shieldable.ShieldPosition(0.9, 0.8, 1.2, false));
        SHIELD_POSITIONS.add(new Shieldable.ShieldPosition(-0.3, 0.8, -1.2, true));
        SHIELD_POSITIONS.add(new Shieldable.ShieldPosition(-0.3, 0.8, 1.2, false));
        SHIELD_POSITIONS.add(new Shieldable.ShieldPosition(-1.5, 0.8, -1.2, true));
        SHIELD_POSITIONS.add(new Shieldable.ShieldPosition(-1.5, 0.8, 1.2, false));
        SHIELD_POSITIONS.add(new Shieldable.ShieldPosition(-3.0, 0.8, -1.0, true));
        SHIELD_POSITIONS.add(new Shieldable.ShieldPosition(-3.0, 0.8, 1.0, false));
    }
}

