/*
 * Decompiled with CFR 0.152.
 */
package com.talhanation.smallships.world.entity.projectile;

import com.talhanation.smallships.config.SmallShipsConfig;
import com.talhanation.smallships.world.entity.ship.Ship;
import com.talhanation.smallships.world.sound.ModSoundTypes;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.AbstractHurtingProjectile;
import net.minecraft.world.entity.projectile.ProjectileUtil;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.scores.Team;
import org.jetbrains.annotations.NotNull;

public abstract class AbstractCannonBall
extends AbstractHurtingProjectile {
    public boolean inWater = false;
    public boolean wasShot = false;
    public int counter = 0;

    protected AbstractCannonBall(EntityType<? extends AbstractCannonBall> type, Level world) {
        super(type, world);
    }

    public AbstractCannonBall(EntityType<? extends AbstractCannonBall> type, LivingEntity owner, double d1, double d2, double d3, Level world) {
        super(type, owner, new Vec3(d1, d2, d3), world);
        this.moveTo(d1, d2, d3, this.getYRot(), this.getXRot());
    }

    public void tick() {
        this.baseTick();
        Vec3 vector3d = this.getDeltaMovement();
        HitResult raytraceresult = ProjectileUtil.getHitResultOnMoveVector((Entity)this, x$0 -> this.canHitEntity((Entity)x$0));
        if (raytraceresult.getType() != HitResult.Type.MISS) {
            this.onHit(raytraceresult);
        }
        double d0 = this.getX() + vector3d.x;
        double d1 = this.getY() + vector3d.y;
        double d2 = this.getZ() + vector3d.z;
        this.updateRotation();
        float f = 0.99f;
        float f1 = 0.06f;
        float f2 = -0.05f;
        this.setDeltaMovement(vector3d.scale((double)f));
        if (!this.isNoGravity()) {
            this.setDeltaMovement(this.getDeltaMovement().add(0.0, (double)(-f1), 0.0));
        }
        this.setPos(d0, d1, d2);
        if (this.isAlive()) {
            this.setWasShot(true);
        }
        if (this.isInWater()) {
            if (this.level().isClientSide() && !this.isUnderWater()) {
                this.waterParticles();
            }
            this.setDeltaMovement(this.getDeltaMovement().add(0.0, (double)(-f2), 0.0));
            this.setInWater(true);
        }
        if (this.wasShot) {
            ++this.counter;
        }
        if (this.counter < 4 && this.level().isClientSide()) {
            this.tailParticles();
        }
        if (this.isInWater() && this.counter > 200) {
            this.discard();
        }
    }

    public void setWasShot(boolean bool) {
        if (bool != this.wasShot) {
            this.wasShot = true;
            if (this.level().isClientSide()) {
                this.shootParticles();
            }
        }
    }

    public void setInWater(boolean bool) {
        if (bool != this.inWater) {
            this.level().playSound(null, this.getX(), this.getY(), this.getZ(), SoundEvents.GENERIC_SPLASH, SoundSource.BLOCKS, 3.3f, 0.8f + 0.4f * this.random.nextFloat());
            this.inWater = true;
        }
    }

    protected void onHitBlock(BlockHitResult blockHitResult) {
        super.onHitBlock(blockHitResult);
        if (!this.level().isClientSide()) {
            boolean doesSpreadFire = false;
            if (!this.isInWater()) {
                this.level().explode(this.getOwner(), this.getX(), this.getY(), this.getZ(), ((Double)SmallShipsConfig.Common.shipGeneralCannonDestruction.get()).floatValue(), doesSpreadFire, Level.ExplosionInteraction.MOB);
            }
            this.remove(Entity.RemovalReason.KILLED);
        }
    }

    protected void onHit(HitResult hitResult) {
        super.onHit(hitResult);
        this.hitParticles();
    }

    protected void onHitEntity(EntityHitResult hitResult) {
        super.onHitEntity(hitResult);
        if (!this.level().isClientSide()) {
            Entity hitEntity = hitResult.getEntity();
            Entity ownerEntity = this.getOwner();
            if (hitEntity instanceof Ship) {
                Ship shipHitEntity = (Ship)hitEntity;
                shipHitEntity.hurt(this.damageSources().thrown((Entity)this, ownerEntity), this.random.nextInt(7) + 7);
                this.level().playSound(null, this.getX(), this.getY() + 4.0, this.getZ(), ModSoundTypes.SHIP_HIT, this.getSoundSource(), 3.3f, 0.8f + 0.4f * this.random.nextFloat());
            } else if (ownerEntity instanceof LivingEntity) {
                LivingEntity livingOwnerEntity = (LivingEntity)ownerEntity;
                if (ownerEntity.getTeam() != null && ownerEntity.getTeam().isAlliedTo((Team)hitEntity.getTeam()) && !ownerEntity.getTeam().isAllowFriendlyFire()) {
                    return;
                }
                this.level().playSound(null, this.getX(), this.getY() + 4.0, this.getZ(), (SoundEvent)SoundEvents.GENERIC_EXPLODE.value(), this.getSoundSource(), 3.3f, 0.8f + 0.4f * this.random.nextFloat());
            }
            hitEntity.hurt(this.damageSources().thrown((Entity)this, ownerEntity), ((Double)SmallShipsConfig.Common.shipGeneralCannonDamage.get()).floatValue());
        }
    }

    public void hitParticles() {
        for (int i = 0; i < 300; ++i) {
            double d0 = this.random.nextGaussian() * 0.03;
            double d1 = this.random.nextGaussian() * 0.03;
            double d2 = this.random.nextGaussian() * 0.03;
            double d3 = 20.0;
            this.level().addParticle((ParticleOptions)ParticleTypes.POOF, this.getX(1.0) - d0 * d3, this.getRandomY() - d1 * d3, this.getRandomZ(2.0) - d2 * d3, d0, d1, d2);
            this.level().addParticle((ParticleOptions)ParticleTypes.LARGE_SMOKE, this.getX(1.0) - d0 * d3, this.getRandomY() - d1 * d3, this.getRandomZ(2.0) - d2 * d3, d0, d1, d2);
        }
    }

    public void waterParticles() {
        for (int i = 0; i < 200; ++i) {
            double d0 = this.random.nextGaussian() * 0.03;
            double d1 = this.random.nextGaussian() * 0.03;
            double d2 = this.random.nextGaussian() * 0.03;
            double d3 = 20.0;
            this.level().addParticle((ParticleOptions)ParticleTypes.POOF, this.getX(1.0) - d0 * d3, this.getRandomY() - d1 * d3 + (double)i * 0.012, this.getRandomZ(2.0) - d2 * d3, d0, d1, d2);
        }
    }

    public void shootParticles() {
        int i;
        for (i = 0; i < 100; ++i) {
            double d0 = this.random.nextGaussian() * 0.03;
            double d1 = this.random.nextGaussian() * 0.03;
            double d2 = this.random.nextGaussian() * 0.03;
            double d3 = 20.0;
            this.level().addParticle((ParticleOptions)ParticleTypes.POOF, this.getX(1.0) - d0 * d3, this.getRandomY() - d1 * d3, this.getRandomZ(2.0) - d2 * d3, d0, d1, d2);
        }
        for (i = 0; i < 50; ++i) {
            double d00 = this.random.nextGaussian() * 0.03;
            double d11 = this.random.nextGaussian() * 0.03;
            double d22 = this.random.nextGaussian() * 0.03;
            double d44 = 10.0;
            this.level().addParticle((ParticleOptions)ParticleTypes.LARGE_SMOKE, this.getX(1.0) - d00 * d44, this.getRandomY() - d11 * d44, this.getRandomZ(2.0) - d22 * d44, d00, d11, d22);
            this.level().addParticle((ParticleOptions)ParticleTypes.FLAME, this.getX(1.0) - d00 * d44, this.getRandomY() - d11 * d44, this.getRandomZ(2.0) - d22 * d44, 0.0, 0.0, 0.0);
        }
    }

    public void tailParticles() {
        int i;
        for (i = 0; i < 100; ++i) {
            this.level().addParticle((ParticleOptions)ParticleTypes.POOF, this.getX(), this.getY(), this.getZ(), 0.0, 0.0, 0.0);
        }
        for (i = 0; i < 50; ++i) {
            this.level().addParticle((ParticleOptions)ParticleTypes.FLAME, this.getX(), this.getY(), this.getZ(), 0.0, 0.0, 0.0);
        }
    }

    public boolean isPickable() {
        return false;
    }

    public boolean hurt(DamageSource p_70097_1_, float p_70097_2_) {
        return false;
    }

    protected boolean shouldBurn() {
        return false;
    }

    @NotNull
    protected ParticleOptions getTrailParticle() {
        return ParticleTypes.SMOKE;
    }
}

